/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements;

import com.ibm.icu.util.ULocale;
import java.util.List;
import org.eclipse.birt.report.model.api.DesignFileException;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.ModuleOption;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class ReportDesignUserDefinedMessagesTest
extends BaseTestCase {
    public void testGetMessage() throws DesignFileException {
        this.openDesign("ReportDesignUserDefinedMessagesTest.xml", ULocale.ENGLISH);
        String titleID = this.design.getStringProperty((Module)this.design, "titleID");
        ReportDesignUserDefinedMessagesTest.assertEquals((String)"ResourceKey.ReportDesign.Title", (String)titleID);
        String title = this.design.getMessage(titleID);
        ReportDesignUserDefinedMessagesTest.assertEquals((String)"EN: My Sample design.", (String)title);
        String descriptionID = this.design.getStringProperty((Module)this.design, "descriptionID");
        String description = this.design.getMessage(descriptionID);
        ReportDesignUserDefinedMessagesTest.assertEquals((String)"Sample report(en)", (String)description);
        this.openDesign("ReportDesignUserDefinedMessagesTest.xml", TEST_LOCALE);
        title = this.design.getMessage(titleID);
        ReportDesignUserDefinedMessagesTest.assertEquals((String)"ja_JP:\u7b80\u5355\u62a5\u8868.", (String)title);
        description = this.design.getMessage(descriptionID);
        ReportDesignUserDefinedMessagesTest.assertEquals((String)"\u5b9e\u4f8b\u62a5\u8868", (String)description);
        this.openDesign("ReportDesignUserDefinedMessagesTest.xml", TEST_LOCALE);
        title = this.design.getMessage("ResourceKey.testKey1");
        ReportDesignUserDefinedMessagesTest.assertEquals((String)"default translation1", (String)title);
        this.designHandle.setIncludeResource("message");
        ModuleOption options = new ModuleOption();
        this.design.setOptions(options);
        options.setLocale(ULocale.US);
        ReportDesignUserDefinedMessagesTest.assertEquals((String)"en_US for A", (String)this.designHandle.getMessage("A"));
        ReportDesignUserDefinedMessagesTest.assertEquals((String)"en_US for D", (String)this.designHandle.getMessage("D"));
        ReportDesignUserDefinedMessagesTest.assertEquals((String)"en for C", (String)this.designHandle.getMessage("C"));
        ReportDesignUserDefinedMessagesTest.assertEquals((String)"default for B", (String)this.designHandle.getMessage("B"));
        ReportDesignUserDefinedMessagesTest.assertNull((Object)this.designHandle.getMessage("non-exsit-key"));
    }

    public void testGetMessage2() throws DesignFileException {
        this.openDesign("ReportDesignUserDefinedMessagesTest.xml", ULocale.ENGLISH);
        String text = this.design.getMessage("ResourceKey.testKey2", new ULocale("en", "AU"));
        ReportDesignUserDefinedMessagesTest.assertEquals((String)"text en_AU", (String)text);
        text = this.design.getMessage("ResourceKey.testKey2", new ULocale("en", "US"));
        ReportDesignUserDefinedMessagesTest.assertEquals((String)"text en_US", (String)text);
        text = this.design.getMessage("ResourceKey.testKey2", new ULocale("en", "GB"));
        ReportDesignUserDefinedMessagesTest.assertEquals((String)"text en", (String)text);
        text = this.design.getMessage("ResourceKey.testKey2", new ULocale("fr", "CA"));
        ReportDesignUserDefinedMessagesTest.assertEquals((String)"text default", (String)text);
        ReportDesignUserDefinedMessagesTest.assertNull((Object)this.design.getMessage(""));
        ReportDesignUserDefinedMessagesTest.assertNull((Object)this.design.getMessage(null));
    }

    public void testGetMessageKeys() throws DesignFileException {
        this.openDesign("ReportDesignUserDefinedMessagesTest2.xml", ULocale.ENGLISH);
        this.designHandle.setIncludeResource("message");
        ModuleOption options = new ModuleOption();
        this.design.setOptions(options);
        options.setLocale(ULocale.US);
        List keys = this.design.getMessageKeys();
        ReportDesignUserDefinedMessagesTest.assertEquals((int)6, (int)keys.size());
        ReportDesignUserDefinedMessagesTest.assertTrue((boolean)keys.contains("ResourceKey.ReportDesign.Title"));
        ReportDesignUserDefinedMessagesTest.assertTrue((boolean)keys.contains("ResourceKey.ReportDesign.Description"));
        ReportDesignUserDefinedMessagesTest.assertTrue((boolean)keys.contains("A"));
        ReportDesignUserDefinedMessagesTest.assertTrue((boolean)keys.contains("B"));
        ReportDesignUserDefinedMessagesTest.assertTrue((boolean)keys.contains("C"));
        ReportDesignUserDefinedMessagesTest.assertTrue((boolean)keys.contains("D"));
        this.designHandle.setIncludeResource("none-exsit");
        keys = this.designHandle.getMessageKeys();
        ReportDesignUserDefinedMessagesTest.assertEquals((int)2, (int)keys.size());
    }

    public void testTranslationSemanticCheck() throws Exception {
        try {
            this.openDesign("ReportDesignUserDefinedMessagesTest3.xml");
            ReportDesignUserDefinedMessagesTest.fail();
        }
        catch (DesignFileException e) {
            List list = e.getErrorList();
            ReportDesignUserDefinedMessagesTest.assertEquals((int)2, (int)list.size());
            ErrorDetail detail = (ErrorDetail)list.get(0);
            ReportDesignUserDefinedMessagesTest.assertEquals((String)"Error.DesignParserException.DUPLICATE_TRANSLATION_LOCALE", (String)detail.getErrorCode());
            detail = (ErrorDetail)list.get(1);
            ReportDesignUserDefinedMessagesTest.assertEquals((String)"Error.DesignParserException.MESSAGE_KEY_REQUIRED", (String)detail.getErrorCode());
        }
    }
}

