/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective;

import java.util.Vector;
import org.eclipse.wst.ws.internal.datamodel.Element;
import org.eclipse.wst.ws.internal.datamodel.ElementAdapter;
import org.eclipse.wst.ws.internal.datamodel.ElementListener;
import org.eclipse.wst.ws.internal.datamodel.RelAddEvent;
import org.eclipse.wst.ws.internal.datamodel.RelRemoveEvent;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.TreeElement;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.PublishedItemsElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.QueryElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.QueryParentElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.datamodel.RegistryElement;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.AddToFavoritesTool;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.LoginTool;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.PublishedItemsNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.QueryNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.QueryParentNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.RegFindTool;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.RegPublishTool;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.RegistryDetailsTool;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDINavigatorNode;
import org.eclipse.wst.ws.internal.explorer.platform.uddi.perspective.UDDIPerspective;

public class RegistryNode
extends UDDINavigatorNode {
    private RegistryDetailsTool regDetailsTool_;
    private RegPublishTool regPublishTool_;
    private LoginTool loginTool_;
    public static final String IMAGE_PATH_STANDARD = "uddi/images/registry.gif";
    public static final String IMAGE_PATH_WITH_USER_DEFINED_CATEGORIES = "uddi/images/regstrycat_obj.gif";

    public RegistryNode(TreeElement element, NodeManager nodeManager, int nodeDepth, String imagePath) {
        super(element, nodeManager, nodeDepth, imagePath);
        element.addListener((ElementListener)new ElementAdapter(){

            public void relAdded(RelAddEvent event) {
                String rel = event.getOutBoundRelName();
                if (rel.equals("queriesParent")) {
                    QueryParentElement queryParentElement = (QueryParentElement)event.getParentElement();
                    RegistryNode.this.createChildNode(queryParentElement);
                } else if (RegistryNode.this.isPublishedItemsRel(rel)) {
                    PublishedItemsElement publishedItemsElement = (PublishedItemsElement)event.getParentElement();
                    RegistryNode.this.createChildNode(publishedItemsElement);
                }
            }

            public void relRemoved(RelRemoveEvent event) {
                TreeElement childElement = null;
                String inBoundRelName = event.getInBoundRelName();
                String outBoundRelName = event.getOutBoundRelName();
                if (inBoundRelName.equals("queriesParent") || RegistryNode.this.isPublishedItemsRel(inBoundRelName)) {
                    childElement = (TreeElement)event.getInboundElement();
                } else if (outBoundRelName.equals("queriesParent") || RegistryNode.this.isPublishedItemsRel(outBoundRelName)) {
                    childElement = (TreeElement)event.getOutBoundElement();
                }
                if (childElement != null) {
                    RegistryNode.this.removeChildNode(childElement);
                }
            }
        });
        UDDIPerspective uddiPerspective = this.nodeManager_.getController().getUDDIPerspective();
        element.connect((Element)new QueryParentElement(uddiPerspective.getMessage("NODE_NAME_QUERIES_FOLDER"), this.element_.getModel()), "queriesParent", "owner");
        element.connect((Element)new PublishedItemsElement(0, uddiPerspective.getMessage("NODE_NAME_PUBLISHED_BUSINESSES_FOLDER"), this.element_.getModel()), "publishedBusinessesParent", "owner");
        element.connect((Element)new PublishedItemsElement(1, uddiPerspective.getMessage("NODE_NAME_PUBLISHED_SERVICES_FOLDER"), this.element_.getModel()), "publishedServicesParent", "owner");
        element.connect((Element)new PublishedItemsElement(2, uddiPerspective.getMessage("NODE_NAME_PUBLISHED_SERVICE_INTERFACES_FOLDER"), this.element_.getModel()), "publishedServiceInterfacesParent", "owner");
        this.setVisibilityOfChildren(false);
    }

    private final boolean isPublishedItemsRel(String rel) {
        return rel.equals("publishedBusinessesParent") || rel.equals("publishedServicesParent") || rel.equals("publishedServiceInterfacesParent");
    }

    private final void createChildNode(QueryParentElement queryParentElement) {
        QueryParentNode queryParentNode = new QueryParentNode(queryParentElement, this.nodeManager_, this.nodeDepth_ + 1);
        this.addChild(queryParentNode);
    }

    private final void createChildNode(PublishedItemsElement publishedItemsElement) {
        PublishedItemsNode publishedItemsNode = new PublishedItemsNode(publishedItemsElement, this.nodeManager_, this.nodeDepth_ + 1);
        this.addChild(publishedItemsNode);
    }

    @Override
    protected final void initTools() {
        this.nodeManager_.getController();
        UDDIPerspective uddiPerspective = this.nodeManager_.getController().getUDDIPerspective();
        this.regDetailsTool_ = new RegistryDetailsTool(this.toolManager_, uddiPerspective.getMessage("ALT_REGISTRY_DETAILS"));
        RegFindTool regFindTool = new RegFindTool(this.toolManager_, uddiPerspective.getMessage("ALT_FIND"));
        this.regPublishTool_ = new RegPublishTool(this.toolManager_, uddiPerspective.getMessage("ALT_PUBLISH"));
        this.loginTool_ = new LoginTool(this.toolManager_, uddiPerspective.getMessage("ALT_LOGIN"));
        new AddToFavoritesTool(this.toolManager_, uddiPerspective.getMessage("ALT_ADD_TO_FAVORITES"));
        regFindTool.addAuthenticationProperties((RegistryElement)this.element_);
        this.regPublishTool_.addAuthenticationProperties((RegistryElement)this.element_);
    }

    public final RegistryDetailsTool getRegDetailsTool() {
        return this.regDetailsTool_;
    }

    public final RegPublishTool getRegPublishTool() {
        return this.regPublishTool_;
    }

    public final LoginTool getLoginTool() {
        return this.loginTool_;
    }

    private final void addDiscoveredNodes(Vector allNodes, Node queryParentNode, int queryType) {
        Vector queryNodes = queryParentNode.getChildNodes();
        int i = 0;
        while (i < queryNodes.size()) {
            QueryNode queryNode = (QueryNode)queryNodes.elementAt(i);
            QueryElement queryElement = (QueryElement)queryNode.getTreeElement();
            if (queryType == -1) {
                allNodes.addElement(queryNode);
            } else if (queryElement.getQueryType() == queryType) {
                Vector discoveredNodes = queryNode.getChildNodes();
                int j = 0;
                while (j < discoveredNodes.size()) {
                    allNodes.addElement(discoveredNodes.elementAt(j));
                    ++j;
                }
            }
            ++i;
        }
    }

    private final void addPublishedNodes(Vector allNodes, Node publishedItemsNode) {
        Vector itemNodes = publishedItemsNode.getChildNodes();
        int i = 0;
        while (i < itemNodes.size()) {
            allNodes.addElement(itemNodes.elementAt(i));
            ++i;
        }
    }

    public final void getAllBusinessNodes(Vector allBusinessNodes) {
        RegistryElement regElement = (RegistryElement)this.element_;
        Node queryParentNode = this.getChildNode(regElement.getQueryParentElement());
        Node publishedBusinessesNode = this.getChildNode(regElement.getPublishedBusinessesElement());
        this.addDiscoveredNodes(allBusinessNodes, queryParentNode, 0);
        this.addPublishedNodes(allBusinessNodes, publishedBusinessesNode);
    }

    public final void getAllServiceNodes(Vector allServicesNodes) {
        RegistryElement regElement = (RegistryElement)this.element_;
        Node queryParentNode = this.getChildNode(regElement.getQueryParentElement());
        Node publishedServicesNode = this.getChildNode(regElement.getPublishedServicesElement());
        this.addDiscoveredNodes(allServicesNodes, queryParentNode, 1);
        this.addPublishedNodes(allServicesNodes, publishedServicesNode);
    }

    public final void getAllServiceInterfaceNodes(Vector allServiceInterfaceNodes) {
        RegistryElement regElement = (RegistryElement)this.element_;
        Node queryParentNode = this.getChildNode(regElement.getQueryParentElement());
        Node publishedServiceInterfacesNode = this.getChildNode(regElement.getPublishedServiceInterfacesElement());
        this.addDiscoveredNodes(allServiceInterfaceNodes, queryParentNode, 2);
        this.addPublishedNodes(allServiceInterfaceNodes, publishedServiceInterfacesNode);
    }

    public final void getPublishedBusinessNodes(Vector publishedBusinessNodes) {
        RegistryElement regElement = (RegistryElement)this.element_;
        Node publishedBusinessesNode = this.getChildNode(regElement.getPublishedBusinessesElement());
        this.addPublishedNodes(publishedBusinessNodes, publishedBusinessesNode);
    }

    public final void getPublishedServiceNodes(Vector publishedServiceNodes) {
        RegistryElement regElement = (RegistryElement)this.element_;
        Node publishedServicesNode = this.getChildNode(regElement.getPublishedServicesElement());
        this.addPublishedNodes(publishedServiceNodes, publishedServicesNode);
    }

    public final void getPublishedServiceInterfaceNodes(Vector publishedServiceInterfaceNodes) {
        RegistryElement regElement = (RegistryElement)this.element_;
        Node publishedServiceInterfacesNode = this.getChildNode(regElement.getPublishedServiceInterfacesElement());
        this.addPublishedNodes(publishedServiceInterfaceNodes, publishedServiceInterfacesNode);
    }

    public final void getDiscoveredNodes(Vector discoveredNodes, int queryItem) {
        RegistryElement regElement = (RegistryElement)this.element_;
        Node queryParentNode = this.getChildNode(regElement.getQueryParentElement());
        this.addDiscoveredNodes(discoveredNodes, queryParentNode, queryItem);
    }

    private final boolean hasQueryResults(Node queryParentNode, int queryType) {
        Vector queries = queryParentNode.getChildNodes();
        int i = 0;
        while (i < queries.size()) {
            QueryElement queryElement;
            QueryNode queryNode = (QueryNode)queries.elementAt(i);
            if (queryNode.getChildNodes().size() > 0 && (queryElement = (QueryElement)queryNode.getTreeElement()).getQueryType() == queryType) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public final boolean hasBusiness() {
        RegistryElement regElement = (RegistryElement)this.element_;
        Node publishedBusinessesNode = this.getChildNode(regElement.getPublishedBusinessesElement());
        if (publishedBusinessesNode.getChildNodes().size() > 0) {
            return true;
        }
        return this.hasQueryResults(this.getChildNode(regElement.getQueryParentElement()), 0);
    }

    public final boolean hasService() {
        RegistryElement regElement = (RegistryElement)this.element_;
        Node publishedServicesNode = this.getChildNode(regElement.getPublishedServicesElement());
        if (publishedServicesNode.getChildNodes().size() > 0) {
            return true;
        }
        return this.hasQueryResults(this.getChildNode(regElement.getQueryParentElement()), 1);
    }

    public final boolean hasServiceInterface() {
        RegistryElement regElement = (RegistryElement)this.element_;
        Node publishedServiceInterfacesNode = this.getChildNode(regElement.getPublishedServiceInterfacesElement());
        if (publishedServiceInterfacesNode.getChildNodes().size() > 0) {
            return true;
        }
        return this.hasQueryResults(this.getChildNode(regElement.getQueryParentElement()), 2);
    }
}

