/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jst.j2ee.ejb.annotation.internal.model.IEnterpriseBean;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.IXDocletRuntimeAnnotation;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.Logger;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.XDocletPreferenceStore;
import org.eclipse.jst.j2ee.ejb.annotations.internal.xdoclet.XDocletRuntime;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.osgi.framework.Bundle;

public class XDocletExtensionUtil {
    public static XDocletRuntime[] getRuntimes() {
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jst.j2ee.ejb.annotations.xdoclet.xdocletRuntime").getExtensions();
        XDocletRuntime[] runtimes = new XDocletRuntime[extensions.length];
        int i = 0;
        while (i < extensions.length) {
            runtimes[i] = new XDocletRuntime();
            IExtension extension = extensions[i];
            IConfigurationElement configurationElement = XDocletExtensionUtil.getRuntimeElement(extension);
            if (configurationElement != null) {
                runtimes[i].setVersion(configurationElement.getAttribute("xdoclet"));
                IConfigurationElement[] libs = XDocletExtensionUtil.getRuntimeLibraries(extension);
                String[] libsArray = new String[libs.length];
                int j = 0;
                while (j < libs.length) {
                    IConfigurationElement aLibrary = libs[j];
                    libsArray[j] = aLibrary.getAttribute("location");
                    ++j;
                }
                runtimes[i].setLibs(libsArray);
            }
            ++i;
        }
        return runtimes;
    }

    public static XDocletRuntime getRuntime(String versionID) {
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jst.j2ee.ejb.annotations.xdoclet.xdocletRuntime").getExtensions();
        int i = 0;
        while (i < extensions.length) {
            XDocletRuntime runtime = new XDocletRuntime();
            IExtension extension = extensions[i];
            IConfigurationElement configurationElement = XDocletExtensionUtil.getRuntimeElement(extension);
            if (configurationElement != null && versionID.equals(configurationElement.getAttribute("xdoclet"))) {
                runtime.setVersion(configurationElement.getAttribute("xdoclet"));
                IConfigurationElement[] libs = XDocletExtensionUtil.getRuntimeLibraries(extension);
                String[] libsArray = new String[libs.length];
                int j = 0;
                while (j < libs.length) {
                    IConfigurationElement aLibrary = libs[j];
                    libsArray[j] = aLibrary.getAttribute("location");
                    ++j;
                }
                runtime.setLibs(libsArray);
                return runtime;
            }
            ++i;
        }
        return null;
    }

    public static IConfigurationElement getRuntimeElement(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        if (elements != null) {
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement element = elements[j];
                if ("RuntimeVersion".equals(element.getName())) {
                    return element;
                }
                ++j;
            }
        }
        return null;
    }

    public static IConfigurationElement[] getRuntimeLibraries(IExtension extension) {
        ArrayList<IConfigurationElement> arrayList = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] elements = extension.getConfigurationElements();
        if (elements != null) {
            int j = 0;
            while (j < elements.length) {
                IConfigurationElement element = elements[j];
                if ("RuntimeLib".equals(element.getName())) {
                    arrayList.add(element);
                }
                ++j;
            }
        }
        return arrayList.toArray(new IConfigurationElement[arrayList.size()]);
    }

    public static String getRuntimeTypeAnnotations(IEnterpriseBean beanModel) {
        IProject project = (IProject)beanModel.getDataModel().getProperty("NewJavaClassDataModel.PROJECT");
        if (!J2EEProjectUtilities.isEJBProject((IProject)project)) {
            return "";
        }
        IExtension[] extensions = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.jst.j2ee.ejb.annotations.xdoclet.ejbDocletTaskProvider").getExtensions();
        StringBuffer annotations = new StringBuffer(512);
        int i = 0;
        while (extensions != null && i < extensions.length) {
            IExtension extension = extensions[i];
            IConfigurationElement[] elements = extension.getConfigurationElements();
            if (elements != null) {
                try {
                    XDocletPreferenceStore preferenceStore = new XDocletPreferenceStore(project);
                    if (preferenceStore.getBooleanProperty(String.valueOf(elements[0].getAttribute("id")) + ".defaultSelection")) {
                        int j = 0;
                        while (j < elements.length) {
                            IConfigurationElement element = elements[j];
                            if ("AnnotationProvider".equals(element.getName())) {
                                Class c;
                                String pluginDescriptor = element.getDeclaringExtension().getContributor().getName();
                                Bundle bundle = Platform.getBundle((String)pluginDescriptor);
                                if (XDocletExtensionUtil.isRuntimeAnnotationApplicable(beanModel, element) && (c = bundle.loadClass(element.getAttribute("class"))) != null) {
                                    IXDocletRuntimeAnnotation annotationProvider = (IXDocletRuntimeAnnotation)c.newInstance();
                                    annotationProvider.setPreferenceStore(preferenceStore);
                                    annotations.append(annotationProvider.getTypeAnnotations(project, beanModel));
                                    annotations.append("\n");
                                }
                            }
                            ++j;
                        }
                    }
                }
                catch (Exception e) {
                    Logger.logException(e);
                }
            }
            ++i;
        }
        return annotations.toString();
    }

    private static boolean isRuntimeAnnotationApplicable(IEnterpriseBean beanModel, IConfigurationElement element) {
        boolean include = Boolean.valueOf(element.getAttribute("include"));
        if (!include) {
            return false;
        }
        String type = element.getAttribute("type");
        boolean generate = false;
        if ("entity".equals(type) && beanModel.getEnterpriseBean().isEntity()) {
            generate = true;
        }
        if ("session".equals(type) && beanModel.getEnterpriseBean().isSession()) {
            generate = true;
        }
        if ("mdb".equals(type) && beanModel.getEnterpriseBean().isMessageDriven()) {
            generate = true;
        }
        return generate;
    }
}

