/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder.views.select;

import org.eclipse.datatools.modelbase.sql.query.QuerySelect;
import org.eclipse.datatools.modelbase.sql.query.QuerySelectStatement;
import org.eclipse.datatools.modelbase.sql.query.QueryStatement;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SQLDomainModel;
import org.eclipse.datatools.sqltools.sqlbuilder.model.SelectHelper;
import org.eclipse.datatools.sqltools.sqlbuilder.util.ViewUtility;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class SelectStatementDistinctViewer
extends ContentViewer
implements SelectionListener {
    protected QueryStatement currentStatement;
    protected SQLDomainModel domainModel;
    protected Composite mainUIComponent;
    private Button checkBox;

    public SelectStatementDistinctViewer(SQLDomainModel sqlDomainModel) {
        this.domainModel = sqlDomainModel;
        this.currentStatement = sqlDomainModel.getSQLStatement();
        this.setContentProvider((IContentProvider)sqlDomainModel.createContentProvider());
    }

    public void setInput(Object input) {
        this.setDistinct(input);
        if (input instanceof QueryStatement) {
            this.currentStatement = (QueryStatement)input;
        }
        super.setInput(input);
    }

    public void refresh() {
        this.setDistinct(this.getInput());
    }

    public void setDistinct(Object input) {
        if (input instanceof QuerySelectStatement || input instanceof QuerySelect) {
            QuerySelect qSelect = null;
            if (input instanceof QuerySelectStatement) {
                QuerySelectStatement select = (QuerySelectStatement)input;
                qSelect = SelectHelper.getQuerySelect(select);
            } else {
                qSelect = (QuerySelect)input;
            }
            if (qSelect != null && qSelect.isDistinct()) {
                this.checkBox.setSelection(true);
            } else {
                this.checkBox.setSelection(false);
            }
        }
    }

    public Control createControl(Composite parent) {
        this.mainUIComponent = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        layout.horizontalSpacing = 5;
        layout.verticalSpacing = 5;
        layout.numColumns = 3;
        this.mainUIComponent.setLayout((Layout)layout);
        this.mainUIComponent.setLayoutData((Object)ViewUtility.createHorizontalFill());
        this.checkBox = ViewUtility.createCheckBox(this.mainUIComponent, "DISTINCT");
        this.checkBox.addSelectionListener((SelectionListener)this);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.checkBox, "org.eclipse.datatools.sqltools.sqlbuilder.sqlb0300");
        this.hookControl(this.getControl());
        return this.getControl();
    }

    public Control getControl() {
        return this.mainUIComponent;
    }

    public void widgetSelected(SelectionEvent event) {
        QuerySelect qSelect;
        if (event.widget != null && event.widget == this.checkBox && (qSelect = SelectHelper.getQuerySelect((QuerySelectStatement)this.currentStatement)) != null) {
            qSelect.setDistinct(this.checkBox.getSelection());
            SelectHelper.refresh((QuerySelectStatement)this.currentStatement);
        }
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void setEnabled(boolean enable) {
        this.checkBox.setEnabled(enable);
    }

    public ISelection getSelection() {
        return null;
    }

    public void setSelection(ISelection selection, boolean reveal) {
    }
}

