/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.sqm.server.internal.ui.explorer.providers.bookmark;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.datatools.connectivity.sqm.core.ui.services.IDataToolsUIServiceManager;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.services.IServicesManager;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.util.ServerUIDebugOptions;
import org.eclipse.datatools.connectivity.sqm.server.internal.ui.util.logging.Logger;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class BookmarkSelectionProvider {
    private static final String BOOKMARKVIEW = "org.eclipse.ui.views.BookmarkView";
    private static final String BLANK_ID = "";
    private ISelectionListener listener = null;

    public BookmarkSelectionProvider() {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page != null) {
            this.listener = new ISelectionListener(){

                public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                    if (selection instanceof IStructuredSelection) {
                        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                        Object obj = structuredSelection.getFirstElement();
                        if (obj == null || !(obj instanceof IAdaptable)) {
                            return;
                        }
                        IMarker marker = (IMarker)((IAdaptable)obj).getAdapter(IMarker.class);
                        try {
                            if (marker.getType().equals("org.eclipse.datatools.connectivity.sqm.core.ui.transientBookmark")) {
                                String attribute = marker.getAttribute("elementId", BookmarkSelectionProvider.BLANK_ID);
                                if (!attribute.equals(BookmarkSelectionProvider.BLANK_ID)) {
                                    IServicesManager.INSTANCE.getServerExplorerContentService().expandNode(attribute);
                                }
                            } else {
                                IDataToolsUIServiceManager.INSTANCE.getMarkerNavigationService().gotoMarker(null, marker);
                            }
                        }
                        catch (CoreException e) {
                            Logger.log(this, e, ServerUIDebugOptions.SERVER_EXPLORER_LOG);
                        }
                    }
                }
            };
            page.addSelectionListener(BOOKMARKVIEW, this.listener);
        }
    }

    public void removeListener() {
        IWorkbenchPage page;
        IWorkbenchWindow window;
        if (this.listener != null && (window = PlatformUI.getWorkbench().getActiveWorkbenchWindow()) != null && (page = window.getActivePage()) != null) {
            page.removeSelectionListener(BOOKMARKVIEW, this.listener);
        }
    }
}

