/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.cubebuilder.provider;

import java.util.Arrays;
import java.util.List;
import org.eclipse.birt.report.designer.ui.dialogs.ExpressionProvider;
import org.eclipse.birt.report.designer.ui.expressions.ExpressionFilter;
import org.eclipse.birt.report.designer.ui.views.ElementAdapterManager;
import org.eclipse.birt.report.designer.ui.views.INodeProvider;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.olap.CubeHandle;
import org.eclipse.birt.report.model.api.olap.DimensionHandle;
import org.eclipse.birt.report.model.api.olap.HierarchyHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.api.olap.MeasureGroupHandle;
import org.eclipse.birt.report.model.api.olap.MeasureHandle;

public class LinkToCubeExpressionProvider
extends ExpressionProvider {
    public LinkToCubeExpressionProvider(DesignElementHandle handle) {
        super(handle);
        this.addFilterToProvider();
    }

    protected void addFilterToProvider() {
        this.addFilter(new ExpressionFilter(){

            public boolean select(Object parentElement, Object element) {
                return !"Category".equals(parentElement) || !ExpressionProvider.DATASETS.equals(element);
            }
        });
    }

    private CubeHandle getCubeHandle(Object input) {
        DesignElementHandle parent = null;
        if (input instanceof LevelHandle) {
            parent = ((LevelHandle)input).getContainer().getContainer().getContainer();
        } else if (input instanceof HierarchyHandle) {
            parent = ((HierarchyHandle)input).getContainer().getContainer();
        } else if (input instanceof DimensionHandle) {
            parent = ((DimensionHandle)input).getContainer();
        } else if (input instanceof MeasureHandle) {
            parent = ((MeasureHandle)input).getContainer().getContainer();
        } else if (input instanceof MeasureGroupHandle) {
            parent = ((MeasureGroupHandle)input).getContainer();
        }
        if (parent instanceof CubeHandle) {
            return (CubeHandle)parent;
        }
        return null;
    }

    protected List<Object> getCategoryList() {
        List list = super.getCategoryList();
        if (!list.contains(CURRENT_CUBE) && this.getCubeHandle(this.elementHandle) != null) {
            list.add(CURRENT_CUBE);
        }
        return list;
    }

    protected List<Object> getChildrenList(Object parent) {
        CubeHandle cube;
        Object nodeProviderAdapter;
        if (CURRENT_CUBE.equals(parent) && this.getCubeHandle(this.elementHandle) != null && (nodeProviderAdapter = ElementAdapterManager.getAdapter((Object)(cube = this.getCubeHandle(this.elementHandle)), INodeProvider.class)) != null) {
            return Arrays.asList(((INodeProvider)nodeProviderAdapter).getChildren((Object)cube));
        }
        return super.getChildrenList(parent);
    }
}

