/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.impl;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.xtext.ui.refactoring.IRenameStrategy;
import org.eclipse.xtext.ui.refactoring.impl.RefactoringStatusException;
import org.eclipse.xtext.util.SimpleAttributeResolver;
import org.eclipse.xtext.util.Strings;

public abstract class AbstractRenameStrategy
implements IRenameStrategy {
    protected String originalName;
    protected URI targetElementOriginalURI;
    protected URI targetElementNewURI;

    protected AbstractRenameStrategy(EObject targetElement) {
        this.targetElementOriginalURI = EcoreUtil.getURI((EObject)targetElement);
        EAttribute nameAttribute = this.getNameAttribute(targetElement);
        this.originalName = targetElement.eGet((EStructuralFeature)nameAttribute).toString();
        if (Strings.isEmpty((String)this.originalName)) {
            throw new RefactoringStatusException("Target element does not have a name", false);
        }
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public RefactoringStatus validateNewName(String newName) {
        RefactoringStatus newRefactoringStatus = new RefactoringStatus();
        if (Strings.equal((String)newName, (String)this.originalName)) {
            newRefactoringStatus.addWarning("Name should be different");
        }
        return newRefactoringStatus;
    }

    public void applyDeclarationChange(String newName, ResourceSet resourceSet) {
        EObject renamedElement = this.setName(this.targetElementOriginalURI, newName, resourceSet);
        this.targetElementNewURI = EcoreUtil.getURI((EObject)renamedElement);
    }

    public void revertDeclarationChange(ResourceSet resourceSet) {
        if (this.targetElementNewURI == null) {
            return;
        }
        this.setName(this.targetElementNewURI, this.originalName, resourceSet);
    }

    protected EObject setName(URI targetElementURI, String newName, ResourceSet resourceSet) {
        EObject targetElement = resourceSet.getEObject(targetElementURI, false);
        if (targetElement == null) {
            throw new RefactoringStatusException("Target element not loaded.", true);
        }
        EAttribute nameAttribute = this.getNameAttribute(targetElement);
        targetElement.eSet((EStructuralFeature)nameAttribute, (Object)newName);
        return targetElement;
    }

    protected EAttribute getNameAttribute(EObject eObject) {
        return SimpleAttributeResolver.NAME_RESOLVER.getAttribute(eObject);
    }
}

