/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.shapes;

import java.util.Map;
import org.eclipse.draw3d.IFigure3D;
import org.eclipse.draw3d.RenderContext;
import org.eclipse.draw3d.RenderFragment;
import org.eclipse.draw3d.geometry.IPosition3D;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.ParaxialBoundingBox;
import org.eclipse.draw3d.geometry.Position3D;
import org.eclipse.draw3d.geometry.Position3DUtil;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.shapes.CuboidShape;
import org.eclipse.draw3d.shapes.Shape;
import org.eclipse.draw3d.util.Draw3DCache;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParaxialBoundsFigureShape
implements Shape {
    private IFigure3D m_figure;
    private Position3D m_position;
    private CuboidShape m_shape;

    public ParaxialBoundsFigureShape(IFigure3D i_figure) {
        this.m_figure = i_figure;
        this.m_position = Position3DUtil.createAbsolutePosition();
        this.m_shape = new CuboidShape((IPosition3D)this.m_position, false);
        this.m_shape.setFill(false);
        this.m_shape.setOutlineColor(Display.getCurrent().getSystemColor(3));
        this.m_shape.setAlpha(100);
    }

    @Override
    public float getDistance(IVector3f i_rayOrigin, IVector3f i_rayDirection, Map<Object, Object> i_context) {
        return Float.NaN;
    }

    @Override
    public float getDistanceMeasure(RenderContext i_renderContext) {
        ParaxialBoundingBox pBounds;
        Vector3f diff;
        Vector3f center;
        Vector3f viewPoint;
        block2: {
            float f;
            viewPoint = Draw3DCache.getVector3f();
            center = Draw3DCache.getVector3f();
            diff = Draw3DCache.getVector3f();
            pBounds = Draw3DCache.getParaxialBoundingBox();
            try {
                ParaxialBoundingBox figureBounds = this.m_figure.getParaxialBoundingBox(pBounds);
                if (figureBounds == null) break block2;
                i_renderContext.getScene().getCamera().getPosition(viewPoint);
                figureBounds.getCenter(center);
                Math3D.sub((IVector3f)center, (IVector3f)viewPoint, (Vector3f)diff);
                f = diff.lengthSquared();
            }
            catch (Throwable throwable) {
                Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{viewPoint, center, diff});
                Draw3DCache.returnParaxialBoundingBox((ParaxialBoundingBox[])new ParaxialBoundingBox[]{pBounds});
                throw throwable;
            }
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{viewPoint, center, diff});
            Draw3DCache.returnParaxialBoundingBox((ParaxialBoundingBox[])new ParaxialBoundingBox[]{pBounds});
            return f;
        }
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{viewPoint, center, diff});
        Draw3DCache.returnParaxialBoundingBox((ParaxialBoundingBox[])new ParaxialBoundingBox[]{pBounds});
        return 0.0f;
    }

    @Override
    public ParaxialBoundingBox getParaxialBoundingBox(ParaxialBoundingBox o_result) {
        return this.m_shape.getParaxialBoundingBox(o_result);
    }

    @Override
    public RenderFragment.RenderType getRenderType() {
        return RenderFragment.RenderType.TRANSPARENT;
    }

    @Override
    public void render(RenderContext i_renderContext) {
        Vector3f position = Draw3DCache.getVector3f();
        Vector3f size = Draw3DCache.getVector3f();
        ParaxialBoundingBox pBounds = Draw3DCache.getParaxialBoundingBox();
        try {
            ParaxialBoundingBox figureBounds = this.m_figure.getParaxialBoundingBox(pBounds);
            if (figureBounds != null) {
                figureBounds.getLocation(position);
                figureBounds.getSize(size);
                this.m_position.setLocation3D((IVector3f)position);
                this.m_position.setSize3D((IVector3f)size);
                this.m_shape.render(i_renderContext);
            }
        }
        catch (Throwable throwable) {
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{position, size});
            Draw3DCache.returnParaxialBoundingBox((ParaxialBoundingBox[])new ParaxialBoundingBox[]{pBounds});
            throw throwable;
        }
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{position, size});
        Draw3DCache.returnParaxialBoundingBox((ParaxialBoundingBox[])new ParaxialBoundingBox[]{pBounds});
    }
}

