/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.graphics.optimizer.primitive;

import org.eclipse.draw3d.graphics.GraphicsState;
import org.eclipse.draw3d.graphics.optimizer.primitive.AbstractRenderRule;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

public class TextRenderRule
extends AbstractRenderRule {
    private int m_alpha;
    private Font m_font;
    private boolean m_fontAntialias;
    private Color m_textColor;

    public TextRenderRule(GraphicsState i_state) {
        this.m_font = i_state.getFont();
        this.m_textColor = i_state.getForegroundColor();
        this.m_alpha = i_state.getAlpha();
        this.m_fontAntialias = i_state.getAntialias() == 1;
    }

    public TextRenderRule asText() {
        return this;
    }

    public int getAlpha() {
        return this.m_alpha;
    }

    public Font getFont() {
        return this.m_font;
    }

    public Color getTextColor() {
        return this.m_textColor;
    }

    public boolean isFontAntialias() {
        return this.m_fontAntialias;
    }

    public boolean isText() {
        return true;
    }

    public String toString() {
        return "TextRenderRule [m_alpha=" + this.m_alpha + ", m_font=" + this.m_font + ", m_fontAntialias=" + this.m_fontAntialias + ", m_textColor=" + this.m_textColor + "]";
    }
}

