/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d;

import java.util.Iterator;
import java.util.logging.Logger;
import org.eclipse.draw2d.FreeformFigure;
import org.eclipse.draw2d.FreeformListener;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw3d.Figure3D;
import org.eclipse.draw3d.draw2dports.FreeformHelper;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Vector3fImpl;

public class FreeformLayer3D
extends Figure3D
implements FreeformFigure {
    private static final Logger log = Logger.getLogger(FreeformLayer3D.class.getName());
    private final FreeformHelper freeformHelper = new FreeformHelper(this);

    public FreeformLayer3D() {
        this.initSize();
    }

    protected void initSize() {
        this.getPosition3D().setSize3D((IVector3f)new Vector3fImpl(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE));
        this.setBounds(new Rectangle(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE));
    }

    public void add(IFigure child, Object constraint, int index) {
        super.add(child, constraint, index);
        this.freeformHelper.hookChild(child);
    }

    public void addFreeformListener(FreeformListener listener) {
        this.addListener(FreeformListener.class, listener);
    }

    public void fireExtentChanged() {
        Iterator iter = this.getListeners(FreeformListener.class);
        while (iter.hasNext()) {
            ((FreeformListener)iter.next()).notifyFreeformExtentChanged();
        }
    }

    protected void fireMoved() {
    }

    public Rectangle getFreeformExtent() {
        return this.freeformHelper.getFreeformExtent();
    }

    public void primTranslate(int dx, int dy) {
        this.bounds.x += dx;
        this.bounds.y += dy;
    }

    public void remove(IFigure child) {
        this.freeformHelper.unhookChild(child);
        super.remove(child);
    }

    public void removeFreeformListener(FreeformListener listener) {
        this.removeListener(FreeformListener.class, listener);
    }

    public void setFreeformBounds(Rectangle bounds) {
        this.freeformHelper.setFreeformBounds(bounds);
    }
}

