/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d;

import java.util.logging.Logger;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.draw3d.AbstractConnectionAnchor3D;
import org.eclipse.draw3d.Figure3DHelper;
import org.eclipse.draw3d.IFigure3D;
import org.eclipse.draw3d.ISurface;
import org.eclipse.draw3d.geometry.BoundingBoxImpl;
import org.eclipse.draw3d.geometry.IBoundingBox;
import org.eclipse.draw3d.geometry.IVector3f;
import org.eclipse.draw3d.geometry.Math3D;
import org.eclipse.draw3d.geometry.Transformable;
import org.eclipse.draw3d.geometry.Vector3f;
import org.eclipse.draw3d.geometry.Vector3fImpl;
import org.eclipse.draw3d.util.Draw3DCache;

public class ChopboxAnchor3D
extends AbstractConnectionAnchor3D {
    private static final Logger log = Logger.getLogger(ChopboxAnchor3D.class.getName());

    protected ChopboxAnchor3D() {
    }

    public ChopboxAnchor3D(IFigure owner) {
        super(owner);
    }

    private Point doGetLocation(Point reference, boolean absoluteMode) {
        Rectangle r = Rectangle.SINGLETON;
        r.setBounds(this.getBox());
        r.translate(-1, -1);
        r.resize(1, 1);
        if (absoluteMode) {
            this.getOwner().translateToAbsolute((Translatable)r);
        }
        float centerX = (float)r.x + 0.5f * (float)r.width;
        float centerY = (float)r.y + 0.5f * (float)r.height;
        if (r.isEmpty() || reference == null || reference.x == (int)centerX && reference.y == (int)centerY) {
            return new Point((int)centerX, (int)centerY);
        }
        float dx = (float)reference.x - centerX;
        float dy = (float)reference.y - centerY;
        float scale = 0.5f / Math.max(Math.abs(dx) / (float)r.width, Math.abs(dy) / (float)r.height);
        return new Point(Math.round(centerX += (dx *= scale)), Math.round(centerY += (dy *= scale)));
    }

    protected IBoundingBox getBounds3D() {
        BoundingBoxImpl boundingBoxImpl;
        IFigure owner = this.getOwner();
        if (owner instanceof IFigure3D) {
            IFigure3D owner3D = (IFigure3D)owner;
            return owner3D.getBounds3D();
        }
        Vector3f origin3D = Draw3DCache.getVector3f();
        Vector3f tmp = Draw3DCache.getVector3f();
        Vector3f size3D = Draw3DCache.getVector3f();
        try {
            IFigure3D host = Figure3DHelper.getAncestor3D(owner);
            if (host == null) {
                throw new IllegalStateException("no 3D host found");
            }
            ISurface surface = host.getSurface();
            Rectangle bounds = owner.getBounds();
            Point bl = bounds.getBottomLeft();
            Point tr = bounds.getTopRight();
            surface.getWorldLocation(bl, origin3D);
            surface.getWorldLocation(tr, tmp);
            Math3D.sub((IVector3f)tmp, (IVector3f)origin3D, (Vector3f)size3D);
            boundingBoxImpl = new BoundingBoxImpl((IVector3f)origin3D, (IVector3f)size3D);
        }
        catch (Throwable throwable) {
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{origin3D, tmp, size3D});
            throw throwable;
        }
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{origin3D, tmp, size3D});
        return boundingBoxImpl;
    }

    protected Rectangle getBox() {
        return this.getOwner().getBounds();
    }

    public Point getLocation(Point reference) {
        return this.doGetLocation(reference, true);
    }

    public IVector3f getLocation3D(IVector3f i_reference, Vector3f io_result) {
        Vector3f tmp;
        Vector3f center;
        Point surfaceRef;
        Vector3f result;
        block6: {
            Vector3f size;
            IFigure3D owner3D;
            block7: {
                Vector3f vector3f;
                result = io_result;
                if (result == null) {
                    result = new Vector3fImpl();
                }
                surfaceRef = Draw3DCache.getPoint();
                center = Draw3DCache.getVector3f();
                tmp = Draw3DCache.getVector3f();
                try {
                    if (!(this.getOwner() instanceof IFigure3D)) break block6;
                    owner3D = (IFigure3D)this.getOwner();
                    IBoundingBox boundingBox = this.getBounds3D();
                    size = boundingBox.getSize(null);
                    boundingBox.getCenter(center);
                    if (size.lengthSquared() != 0.0f && i_reference != null) break block7;
                    result.set((IVector3f)center);
                    vector3f = result;
                }
                catch (Throwable throwable) {
                    Draw3DCache.returnPoint(surfaceRef);
                    Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{center, tmp});
                    throw throwable;
                }
                Draw3DCache.returnPoint(surfaceRef);
                Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{center, tmp});
                return vector3f;
            }
            tmp.set(i_reference);
            owner3D.transformToRelative((Transformable)tmp);
            Math3D.sub((IVector3f)tmp, (IVector3f)center, (Vector3f)tmp);
            float lambdaX = Math.abs(size.getX() / (2.0f * tmp.getX()));
            float lambdaY = Math.abs(size.getY() / (2.0f * tmp.getY()));
            float lambdaZ = Math.abs(size.getZ() / (2.0f * tmp.getZ()));
            float lambda = Math.min(lambdaX, lambdaY);
            lambda = Math.min(lambda, lambdaZ);
            tmp.scale(lambda);
            Math3D.add((IVector3f)center, (IVector3f)tmp, (Vector3f)tmp);
            owner3D.transformToAbsolute((Transformable)tmp);
            result.set((IVector3f)tmp);
            Vector3f vector3f = result;
            Draw3DCache.returnPoint(surfaceRef);
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{center, tmp});
            return vector3f;
        }
        IFigure3D host = Figure3DHelper.getAncestor3D(this.getOwner());
        if (host == null) {
            throw new IllegalStateException("no 3D host found");
        }
        ISurface surface = host.getSurface();
        Rectangle bounds = this.getOwner().getBounds();
        Point sCenter = bounds.getCenter();
        surface.getWorldLocation(sCenter, center);
        result.set((IVector3f)center);
        Vector3f vector3f = result;
        Draw3DCache.returnPoint(surfaceRef);
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{center, tmp});
        return vector3f;
    }

    public Point getReferencePoint() {
        Point ref = this.getBox().getCenter();
        this.getOwner().translateToAbsolute((Translatable)ref);
        return ref;
    }

    public Vector3f getReferencePoint3D(Vector3f io_result) {
        Vector3f ref3D;
        Vector3f result;
        IFigure owner;
        block5: {
            Vector3f vector3f;
            owner = this.getOwner();
            if (owner == null) {
                return null;
            }
            result = io_result;
            if (result == null) {
                result = new Vector3fImpl();
            }
            ref3D = Draw3DCache.getVector3f();
            try {
                if (!(owner instanceof IFigure3D)) break block5;
                this.getBounds3D().getCenter(ref3D);
                IFigure3D owner3D = (IFigure3D)owner;
                owner3D.transformToAbsolute((Transformable)ref3D);
                result.set((IVector3f)ref3D);
                vector3f = result;
            }
            catch (Throwable throwable) {
                Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{ref3D});
                throw throwable;
            }
            Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{ref3D});
            return vector3f;
        }
        Point ref2D = this.getReferencePoint();
        IFigure3D host = Figure3DHelper.getAncestor3D(owner);
        ISurface surface = host.getSurface();
        Vector3f vector3f = surface.getWorldLocation(ref2D, result);
        Draw3DCache.returnVector3f((Vector3f[])new Vector3f[]{ref3D});
        return vector3f;
    }
}

