/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.client;

import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.HashedWheelTimer;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import org.eclipse.milo.opcua.stack.client.UaStackClientConfigBuilder;
import org.eclipse.milo.opcua.stack.client.security.ClientCertificateValidator;
import org.eclipse.milo.opcua.stack.core.channel.EncodingLimits;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;

public interface UaStackClientConfig {
    public EndpointDescription getEndpoint();

    public Optional<KeyPair> getKeyPair();

    public Optional<X509Certificate> getCertificate();

    public Optional<X509Certificate[]> getCertificateChain();

    public ClientCertificateValidator getCertificateValidator();

    public EncodingLimits getEncodingLimits();

    public ExecutorService getExecutor();

    public ScheduledExecutorService getScheduledExecutor();

    public NioEventLoopGroup getEventLoop();

    public HashedWheelTimer getWheelTimer();

    public UInteger getConnectTimeout();

    public UInteger getAcknowledgeTimeout();

    public UInteger getRequestTimeout();

    public UInteger getChannelLifetime();

    public static UaStackClientConfigBuilder builder() {
        return new UaStackClientConfigBuilder();
    }

    public static UaStackClientConfigBuilder copy(UaStackClientConfig config) {
        UaStackClientConfigBuilder builder = new UaStackClientConfigBuilder();
        builder.setEndpoint(config.getEndpoint());
        config.getKeyPair().ifPresent(builder::setKeyPair);
        config.getCertificate().ifPresent(builder::setCertificate);
        config.getCertificateChain().ifPresent(builder::setCertificateChain);
        builder.setCertificateValidator(config.getCertificateValidator());
        builder.setEncodingLimits(config.getEncodingLimits());
        builder.setChannelLifetime(config.getChannelLifetime());
        builder.setExecutor(config.getExecutor());
        builder.setScheduledExecutor(config.getScheduledExecutor());
        builder.setEventLoop(config.getEventLoop());
        builder.setWheelTimer(config.getWheelTimer());
        builder.setConnectTimeout(config.getConnectTimeout());
        builder.setAcknowledgeTimeout(config.getAcknowledgeTimeout());
        builder.setRequestTimeout(config.getRequestTimeout());
        return builder;
    }

    public static UaStackClientConfig copy(UaStackClientConfig config, Consumer<UaStackClientConfigBuilder> consumer) {
        UaStackClientConfigBuilder builder = UaStackClientConfig.copy(config);
        consumer.accept(builder);
        return builder.build();
    }
}

