/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.ui.widgets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.CFBInstance;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.libraryElement.SystemConfiguration;
import org.eclipse.fordiac.ide.model.ui.widgets.BreadcrumbItem;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;

public class BreadcrumbWidget
implements ISelectionProvider {
    private static final String SEPARATOR = "/";
    private AdapterFactoryContentProvider contentProvider;
    private AdapterFactoryLabelProvider labelProvider;
    private final ToolBar toolbar;
    private final List<BreadcrumbItem> items = new ArrayList<BreadcrumbItem>();
    private final ListenerList<ISelectionChangedListener> selectionChangedListeners = new ListenerList();

    public BreadcrumbWidget(Composite parent) {
        this.toolbar = new ToolBar(parent, 8519744);
        this.toolbar.addDisposeListener(e -> this.items.forEach(BreadcrumbItem::dispose));
    }

    public void setInput(Object input) {
        this.setInput(input, new SelectionChangedEvent((ISelectionProvider)this, (ISelection)new StructuredSelection(input)));
    }

    public void setInput(Object input, SelectionChangedEvent event) {
        if (!this.items.isEmpty() && this.getActiveItem().getModel().equals(input)) {
            return;
        }
        if (BreadcrumbWidget.isValidBreadcrumbInput(input)) {
            this.items.forEach(BreadcrumbItem::dispose);
            this.items.clear();
            this.toolbar.requestLayout();
            this.createBreadcrumbItems(input);
            this.toolbar.pack();
        }
        if (event != null) {
            this.fireSelectionChanged(event);
        }
    }

    private void createBreadcrumbItems(Object input) {
        ArrayList<Object> parentObjects = new ArrayList<Object>();
        this.createItems(input, parentObjects);
        Collections.reverse(parentObjects);
        parentObjects.forEach(obj -> {
            boolean bl = this.items.add(new BreadcrumbItem(this, obj, this.labelProvider, this.contentProvider));
        });
    }

    public void setContentProvider(AdapterFactoryContentProvider contentProvider) {
        this.contentProvider = contentProvider;
    }

    public void setLabelProvider(AdapterFactoryLabelProvider labelProvider) {
        this.labelProvider = labelProvider;
    }

    public AdapterFactoryContentProvider getContentProvider() {
        return this.contentProvider;
    }

    public AdapterFactoryLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    private static boolean isValidBreadcrumbInput(Object input) {
        return input instanceof IFile || input instanceof AutomationSystem || input instanceof SystemConfiguration || input instanceof Application || input instanceof Device || input instanceof Resource || input instanceof SubApp || input instanceof SubAppType || BreadcrumbWidget.isCompositeType(input);
    }

    ToolBar getToolBar() {
        return this.toolbar;
    }

    public BreadcrumbItem getActiveItem() {
        return this.items.get(this.items.size() - 1);
    }

    public String serializePath() {
        return this.items.stream().map(item -> SEPARATOR + item.getText()).collect(Collectors.joining());
    }

    public boolean openPath(String path, AutomationSystem system) {
        return this.validateAndOpenPath(path, (INamedElement)system);
    }

    public boolean openPath(String path, SubAppType type) {
        return this.validateAndOpenPath(path, (INamedElement)type);
    }

    public boolean validateAndOpenPath(String path, INamedElement parent) {
        if (path.isBlank()) {
            return false;
        }
        String[] tokens = path.substring(1).split(SEPARATOR);
        if (tokens.length == 0) {
            return false;
        }
        if (parent.getName().equals(tokens[0])) {
            if (tokens.length == 1) {
                this.setInput(parent);
                return true;
            }
            Object current = parent;
            int i = 1;
            while (i < tokens.length) {
                Object child = this.getMatchingPathChild(current, tokens[i]);
                if (child == null) {
                    return false;
                }
                if (i == tokens.length - 1) {
                    if (this.getActiveItem().getModel() != child) {
                        this.setInput(child);
                    }
                    return true;
                }
                current = child;
                ++i;
            }
        }
        return false;
    }

    private Object getMatchingPathChild(Object current, String token) {
        Object[] children;
        Object[] objectArray = children = this.contentProvider.getChildren(current);
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (this.labelProvider.getText(child).equals(token)) {
                return child;
            }
            ++n2;
        }
        return null;
    }

    private void createItems(Object input, ArrayList<Object> parentObjects) {
        if (input == null || input instanceof org.eclipse.emf.ecore.resource.Resource) {
            return;
        }
        if (!(input instanceof FBNetwork)) {
            parentObjects.add(input);
        }
        if (input instanceof AutomationSystem) {
            return;
        }
        this.createItems(this.contentProvider.getParent(input), parentObjects);
    }

    public ISelection getSelection() {
        return null;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    protected void fireSelectionChanged(SelectionChangedEvent event) {
        for (ISelectionChangedListener l : this.selectionChangedListeners) {
            SafeRunnable.run(() -> l.selectionChanged(event));
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
        if (!selection.isEmpty() && selection instanceof StructuredSelection) {
            StructuredSelection structSel = (StructuredSelection)selection;
            this.setInput(structSel.getFirstElement());
        }
    }

    private static boolean isCompositeType(Object input) {
        return input instanceof CFBInstance;
    }
}

