/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.nat;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.ListDataProvider;
import org.eclipse.nebula.widgets.nattable.tree.ITreeData;

public class VariableTreeData
extends ListDataProvider<Variable<?>>
implements ITreeData<Variable<?>> {
    private static final Integer ZERO = 0;
    private Map<Variable<?>, Integer> depthMap;
    private Map<Variable<?>, Integer> indexMap;

    public VariableTreeData(IColumnAccessor<Variable<?>> columnAccessor) {
        super(Collections.emptyList(), columnAccessor);
    }

    public VariableTreeData(List<Variable<?>> roots, IColumnAccessor<Variable<?>> columnAccessor) {
        super(Collections.emptyList(), columnAccessor);
        this.setInput(roots);
    }

    public int getDepthOfData(Variable<?> object) {
        return this.depthMap.getOrDefault(object, ZERO);
    }

    public int getDepthOfData(int index) {
        return this.getDepthOfData(this.getDataAtIndex(index));
    }

    public Variable<?> getDataAtIndex(int index) {
        return (Variable)this.getList().get(index);
    }

    public int indexOf(Variable<?> child) {
        Integer index = this.indexMap.get(child);
        return index != null ? index : -1;
    }

    public boolean hasChildren(Variable<?> object) {
        return object.getChildren().findAny().isPresent();
    }

    public boolean hasChildren(int index) {
        return this.hasChildren(this.getDataAtIndex(index));
    }

    public List<Variable<?>> getChildren(Variable<?> object) {
        return object.getChildren().toList();
    }

    public List<Variable<?>> getChildren(Variable<?> object, boolean fullDepth) {
        return fullDepth ? VariableTreeData.flatten(object).skip(1L).toList() : this.getChildren(object);
    }

    public List<Variable<?>> getChildren(int index) {
        return this.getChildren(this.getDataAtIndex(index));
    }

    public int getElementCount() {
        return this.getList().size();
    }

    public boolean isValidIndex(int index) {
        return index >= 0 && index < this.getElementCount();
    }

    public void setInput(List<Variable<?>> variables) {
        this.list = variables.stream().flatMap(VariableTreeData::flatten).toList();
        this.depthMap = variables.stream().flatMap(variable -> VariableTreeData.flattenDepth(variable, 0)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        this.indexMap = IntStream.range(0, this.list.size()).mapToObj(Integer::valueOf).collect(Collectors.toUnmodifiableMap(this.list::get, Function.identity()));
    }

    private static Stream<Variable<?>> flatten(Variable<?> object) {
        return Stream.concat(Stream.of(object), object.getChildren().flatMap(VariableTreeData::flatten));
    }

    private static Stream<Map.Entry<Variable<?>, Integer>> flattenDepth(Variable<?> object, int depth) {
        return Stream.concat(Stream.of(Map.entry(object, depth)), object.getChildren().flatMap(child -> VariableTreeData.flattenDepth(child, depth + 1)));
    }
}

