/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.forte_ng.cmake;

import java.nio.file.Path;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.fordiac.ide.export.ExportException;
import org.eclipse.fordiac.ide.export.forte_ng.cmake.CMakeListsTemplate;
import org.eclipse.fordiac.ide.library.model.library.Required;

public class ProjectCMakeListsTemplate
extends CMakeListsTemplate {
    private static final List<String> SUBDIRS = List.of("include", "src");

    public ProjectCMakeListsTemplate(IProject project, Path output) {
        super(project, output, Path.of("", new String[0]));
    }

    public CharSequence generate() throws ExportException {
        StringBuilder builder = new StringBuilder();
        builder.append(ProjectCMakeListsTemplate.generateHeader());
        builder.append(ProjectCMakeListsTemplate.generateCMakeMimumumRequired());
        builder.append(ProjectCMakeListsTemplate.generateProject(this.generateTargetName(), this.getProjectVersion(), this.getProjectVersion()));
        builder.append(System.lineSeparator());
        builder.append(ProjectCMakeListsTemplate.generateFindPackage("forte", "3.0", true));
        for (Required dep : this.getExternalDependencies()) {
            builder.append(ProjectCMakeListsTemplate.generateFindPackage(ProjectCMakeListsTemplate.generateTargetName(dep.getSymbolicName()), dep.getVersion(), true));
        }
        builder.append(System.lineSeparator());
        builder.append(ProjectCMakeListsTemplate.generateAddLibrary(this.generateTargetName()));
        builder.append(ProjectCMakeListsTemplate.generateTargetLinkLibraries(this.generateTargetName(), CMakeListsTemplate.Access.PUBLIC, this.getDependencies()));
        builder.append(ProjectCMakeListsTemplate.generateTargetLinkLibrariesWholeArchive("forte", CMakeListsTemplate.Access.PUBLIC, List.of(this.generateModuleNamePlain())));
        builder.append(System.lineSeparator());
        builder.append(ProjectCMakeListsTemplate.generateAddSubdirectories(SUBDIRS));
        builder.append(System.lineSeparator());
        builder.append(ProjectCMakeListsTemplate.generateInstallPreamble(this.generateTargetName()));
        builder.append(System.lineSeparator());
        builder.append(ProjectCMakeListsTemplate.generateConfigurePackageConfigFile(this.generateTargetName()));
        builder.append(System.lineSeparator());
        builder.append(ProjectCMakeListsTemplate.generateWriteBasicPackageVersionFile(this.generateTargetName()));
        builder.append(System.lineSeparator());
        builder.append(ProjectCMakeListsTemplate.generateInstallTargets(this.generateTargetName(), this.generateExportName()));
        builder.append(System.lineSeparator());
        builder.append(ProjectCMakeListsTemplate.generateInstallFiles(this.generateTargetName()));
        builder.append(System.lineSeparator());
        builder.append(ProjectCMakeListsTemplate.generateInstallExport(this.generateExportName()));
        return builder;
    }
}

