/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.ui.st.breakpoint;

import java.util.Collections;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.fordiac.ide.debug.st.breakpoint.STLineBreakpoint;
import org.eclipse.fordiac.ide.debug.ui.st.Messages;
import org.eclipse.fordiac.ide.debug.ui.st.util.STDebugUIUtil;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.structuredtextalgorithm.ui.editor.embedded.STAlgorithmConditionEditedResourceProvider;
import org.eclipse.fordiac.ide.structuredtextalgorithm.ui.editor.embedded.STAlgorithmEmbeddedEditorUtil;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.fordiac.ide.ui.providers.SourceViewerColorProvider;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditor;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorModelAccess;
import org.eclipse.xtext.ui.editor.embedded.IEditedResourceProvider;

public class STBreakpointConditionEditor {
    public static final int PROP_CONDITION = 1;
    public static final int PROP_CONDITION_ENABLED = 2;
    private final ListenerList<IPropertyListener> listeners = new ListenerList();
    private STLineBreakpoint input;
    private Button conditional;
    private EmbeddedEditor conditionEditor;
    private EmbeddedEditorModelAccess conditionEditorModelAccess;
    private boolean dirty;
    private boolean suppressPropertyChanges;

    public Control createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().applyTo(comp);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)comp);
        this.conditional = new Button(comp, 32);
        this.conditional.setText(Messages.STBreakpointConditionEditor_Conditional);
        this.conditional.setEnabled(false);
        this.conditional.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (this.conditionEditor != null) {
                this.conditionEditor.getViewer().setEditable(this.input != null && this.conditional.getSelection());
            }
            this.firePropertyChange(2);
            this.setDirty(true);
        }));
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.conditional);
        this.createConditionEditor(comp);
        GridDataFactory.fillDefaults().grab(true, true).applyTo(this.conditionEditor.getViewer().getControl());
        return comp;
    }

    protected void createConditionEditor(Composite parent) {
        STAlgorithmConditionEditedResourceProvider editedResourceProvider = new STAlgorithmConditionEditedResourceProvider(null, Collections.emptyList(), (LibraryElement)IecTypes.ElementaryTypes.BOOL);
        this.conditionEditor = STAlgorithmEmbeddedEditorUtil.getEmbeddedEditorFactory().newEditor((IEditedResourceProvider)editedResourceProvider).withParent(parent);
        this.conditionEditorModelAccess = this.conditionEditor.createPartialEditor();
        this.conditionEditor.getViewer().setEditable(false);
        this.conditionEditor.getDocument().addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                STBreakpointConditionEditor.this.firePropertyChange(1);
                STBreakpointConditionEditor.this.setDirty(true);
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
        SourceViewerColorProvider.initializeSourceViewerColors((ISourceViewer)this.conditionEditor.getViewer());
    }

    protected void updateConditionEditor() {
        if (this.input != null) {
            try {
                STAlgorithmEmbeddedEditorUtil.updateEditor((EmbeddedEditor)this.conditionEditor, (URI)this.input.getFBType().eResource().getURI(), (LibraryElement)this.input.getFBType(), STDebugUIUtil.getAdditionalScope(this.input.getMarker().getResource(), this.input.getLineNumber()), (LibraryElement)IecTypes.ElementaryTypes.BOOL);
            }
            catch (CoreException e) {
                FordiacLogHelper.logError((String)"Couldn't get breakpoint attributes", (Throwable)e);
                STAlgorithmEmbeddedEditorUtil.updateEditor((EmbeddedEditor)this.conditionEditor, null, null, null, (LibraryElement)IecTypes.ElementaryTypes.BOOL);
            }
            this.conditionEditorModelAccess.updateModel(this.input.getCondition());
        } else {
            STAlgorithmEmbeddedEditorUtil.updateEditor((EmbeddedEditor)this.conditionEditor, null, null, null, (LibraryElement)IecTypes.ElementaryTypes.BOOL);
            this.conditionEditorModelAccess.updateModel("");
        }
    }

    public void setInput(STLineBreakpoint input) {
        try {
            this.suppressPropertyChanges = true;
            this.input = input;
            this.conditional.setEnabled(input != null);
            this.conditional.setSelection(input != null && input.isConditionEnabled());
            this.conditionEditor.getViewer().setEditable(input != null && input.isConditionEnabled());
            this.updateConditionEditor();
            this.setDirty(false);
        }
        finally {
            this.suppressPropertyChanges = false;
        }
    }

    public void doSave() {
        try {
            if (this.input != null && this.input.getMarker() != null && this.input.getMarker().exists()) {
                this.input.setCondition(this.conditionEditorModelAccess.getEditablePart());
                this.input.setConditionEnabled(this.conditional.getSelection());
            }
            this.setDirty(false);
        }
        catch (CoreException e) {
            FordiacLogHelper.logError((String)("Couldn't set breakpoint condition on " + String.valueOf(this.input)), (Throwable)e);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        if (dirty != this.dirty) {
            this.dirty = dirty;
            this.firePropertyChange(257);
        }
    }

    public boolean setFocus() {
        return this.conditionEditor.getViewer().getControl().setFocus();
    }

    public void dispose() {
        this.listeners.clear();
    }

    public void addPropertyListener(IPropertyListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removePropertyListener(IPropertyListener listener) {
        this.listeners.remove((Object)listener);
    }

    protected void firePropertyChange(int property) {
        if (!this.suppressPropertyChanges) {
            for (IPropertyListener listener : this.listeners) {
                listener.propertyChanged((Object)this, property);
            }
        }
    }
}

