/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.replaydebugging.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.fordiac.ide.debug.replaydebugging.IReplayNavigatorRegistrationListener;
import org.eclipse.fordiac.ide.debug.replaydebugging.ReplayNavigator;
import org.eclipse.fordiac.ide.debug.replaydebugging.ReplayNavigatorManager;
import org.eclipse.fordiac.ide.debug.replaydebugging.ui.CollapsableComposite;
import org.eclipse.fordiac.ide.debug.replaydebugging.ui.TimelineWidget;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class ReplayDebuggingView
extends ViewPart
implements IReplayNavigatorRegistrationListener {
    private final Map<String, CollapsableComposite> devices = new HashMap<String, CollapsableComposite>();
    private final Map<ReplayNavigator.Identifier, TimelineWidget> widgets = new HashMap<ReplayNavigator.Identifier, TimelineWidget>();
    private Composite generalContainer;

    public void createPartControl(Composite parent) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 768);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setExpandVertical(true);
        this.generalContainer = new Composite((Composite)scrolledComposite, 0);
        this.generalContainer.setLayout((Layout)new GridLayout(1, false));
        scrolledComposite.setContent((Control)this.generalContainer);
        scrolledComposite.setMinSize(this.generalContainer.computeSize(-1, -1));
        this.generalContainer.addListener(11, e -> scrolledComposite.setMinSize(this.generalContainer.computeSize(-1, -1)));
        ReplayNavigatorManager.getDefault().addListener((IReplayNavigatorRegistrationListener)this);
        this.generalContainer.addDisposeListener(e -> ReplayNavigatorManager.getDefault().removeListener((IReplayNavigatorRegistrationListener)this));
    }

    public void replayNavigatorRegistered(ReplayNavigator replayNavigator) {
        Display.getDefault().asyncExec(() -> {
            Composite deviceGroup = this.devices.computeIfAbsent(replayNavigator.getIdentifier().deviceName(), deviceName -> new CollapsableComposite(this.generalContainer, (String)deviceName, collapsed -> {
                this.generalContainer.layout(true, true);
                this.generalContainer.getParent().layout(true, true);
            })).getContentsParent();
            TimelineWidget widgetToAdd = new TimelineWidget(replayNavigator.getIdentifier().resourceName(), replayNavigator, deviceGroup, 262144, collapsed -> {
                this.generalContainer.layout(true, true);
                this.generalContainer.getParent().layout(true, true);
            });
            widgetToAdd.setLayoutData(new GridData(4, 128, true, false));
            this.widgets.put(replayNavigator.getIdentifier(), widgetToAdd);
            this.generalContainer.layout(true, true);
        });
    }

    public void replayNavigatorUnregistered(ReplayNavigator replayNavigator) {
        Display.getDefault().asyncExec(() -> {
            String deviceName = replayNavigator.getIdentifier().deviceName();
            TimelineWidget widgetToRemove = this.widgets.remove(replayNavigator.getIdentifier());
            if (widgetToRemove != null) {
                widgetToRemove.dispose();
            }
            if (this.devices.containsKey(deviceName) && this.devices.get(deviceName).isEmpty()) {
                this.devices.get(deviceName).dispose();
                this.devices.remove(deviceName);
            }
            this.generalContainer.layout(true, true);
        });
    }

    public void setFocus() {
    }
}

