/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.rectpacking.util;

import java.util.List;
import org.eclipse.elk.alg.rectpacking.util.RectRow;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.graph.ElkNode;

public final class DrawingUtil {
    private DrawingUtil() {
    }

    public static double computeScaleMeasure(double width, double height, double dar) {
        return Math.min(dar / width, 1.0 / height);
    }

    public static void resetCoordinates(List<ElkNode> graph) {
        for (ElkNode node : graph) {
            node.setLocation(0.0, 0.0);
        }
    }

    public static KVector calculateDimensions(List<RectRow> rows, double nodeNodeSpacing) {
        double maxWidth = 0.0;
        double newHeight = 0.0;
        int index = 0;
        for (RectRow row : rows) {
            maxWidth = Math.max(maxWidth, row.getWidth());
            newHeight += row.getHeight() + (index > 0 ? nodeNodeSpacing : 0.0);
            ++index;
        }
        return new KVector(maxWidth, newHeight);
    }

    public static KVector calculateDimensions(List<ElkNode> rectangles) {
        double maxWidth = 0.0;
        double maxHeight = 0.0;
        for (ElkNode node : rectangles) {
            maxWidth = Math.max(node.getWidth() + node.getX(), maxWidth);
            maxHeight = Math.max(node.getHeight() + node.getY(), maxHeight);
        }
        return new KVector(maxWidth, maxHeight);
    }
}

