/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class NotificationMessage
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=803");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=805");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=804");
    private final UInteger sequenceNumber;
    private final DateTime publishTime;
    private final ExtensionObject[] notificationData;

    public NotificationMessage(UInteger sequenceNumber, DateTime publishTime, ExtensionObject[] notificationData) {
        this.sequenceNumber = sequenceNumber;
        this.publishTime = publishTime;
        this.notificationData = notificationData;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public UInteger getSequenceNumber() {
        return this.sequenceNumber;
    }

    public DateTime getPublishTime() {
        return this.publishTime;
    }

    public ExtensionObject[] getNotificationData() {
        return this.notificationData;
    }

    protected NotificationMessage(NotificationMessageBuilder<?, ?> b) {
        super(b);
        this.sequenceNumber = ((NotificationMessageBuilder)b).sequenceNumber;
        this.publishTime = ((NotificationMessageBuilder)b).publishTime;
        this.notificationData = ((NotificationMessageBuilder)b).notificationData;
    }

    public static NotificationMessageBuilder<?, ?> builder() {
        return new NotificationMessageBuilderImpl();
    }

    public NotificationMessageBuilder<?, ?> toBuilder() {
        return new NotificationMessageBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NotificationMessage)) {
            return false;
        }
        NotificationMessage other = (NotificationMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        UInteger this$sequenceNumber = this.getSequenceNumber();
        UInteger other$sequenceNumber = other.getSequenceNumber();
        if (this$sequenceNumber == null ? other$sequenceNumber != null : !((Object)this$sequenceNumber).equals(other$sequenceNumber)) {
            return false;
        }
        DateTime this$publishTime = this.getPublishTime();
        DateTime other$publishTime = other.getPublishTime();
        if (this$publishTime == null ? other$publishTime != null : !((Object)this$publishTime).equals(other$publishTime)) {
            return false;
        }
        return Arrays.deepEquals(this.getNotificationData(), other.getNotificationData());
    }

    protected boolean canEqual(Object other) {
        return other instanceof NotificationMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        UInteger $sequenceNumber = this.getSequenceNumber();
        result = result * 59 + ($sequenceNumber == null ? 43 : ((Object)$sequenceNumber).hashCode());
        DateTime $publishTime = this.getPublishTime();
        result = result * 59 + ($publishTime == null ? 43 : ((Object)$publishTime).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getNotificationData());
        return result;
    }

    @Override
    public String toString() {
        return "NotificationMessage(sequenceNumber=" + this.getSequenceNumber() + ", publishTime=" + this.getPublishTime() + ", notificationData=" + Arrays.deepToString(this.getNotificationData()) + ")";
    }

    private static final class NotificationMessageBuilderImpl
    extends NotificationMessageBuilder<NotificationMessage, NotificationMessageBuilderImpl> {
        private NotificationMessageBuilderImpl() {
        }

        @Override
        protected NotificationMessageBuilderImpl self() {
            return this;
        }

        @Override
        public NotificationMessage build() {
            return new NotificationMessage(this);
        }
    }

    public static abstract class NotificationMessageBuilder<C extends NotificationMessage, B extends NotificationMessageBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private UInteger sequenceNumber;
        private DateTime publishTime;
        private ExtensionObject[] notificationData;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            NotificationMessageBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(NotificationMessage instance, NotificationMessageBuilder<?, ?> b) {
            b.sequenceNumber(instance.sequenceNumber);
            b.publishTime(instance.publishTime);
            b.notificationData(instance.notificationData);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B sequenceNumber(UInteger sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
            return (B)this.self();
        }

        public B publishTime(DateTime publishTime) {
            this.publishTime = publishTime;
            return (B)this.self();
        }

        public B notificationData(ExtensionObject[] notificationData) {
            this.notificationData = notificationData;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "NotificationMessage.NotificationMessageBuilder(super=" + super.toString() + ", sequenceNumber=" + this.sequenceNumber + ", publishTime=" + this.publishTime + ", notificationData=" + Arrays.deepToString(this.notificationData) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<NotificationMessage> {
        @Override
        public Class<NotificationMessage> getType() {
            return NotificationMessage.class;
        }

        @Override
        public NotificationMessage decode(SerializationContext context, UaDecoder decoder) {
            UInteger sequenceNumber = decoder.readUInt32("SequenceNumber");
            DateTime publishTime = decoder.readDateTime("PublishTime");
            ExtensionObject[] notificationData = decoder.readExtensionObjectArray("NotificationData");
            return new NotificationMessage(sequenceNumber, publishTime, notificationData);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, NotificationMessage value) {
            encoder.writeUInt32("SequenceNumber", value.getSequenceNumber());
            encoder.writeDateTime("PublishTime", value.getPublishTime());
            encoder.writeExtensionObjectArray("NotificationData", value.getNotificationData());
        }
    }
}

