/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class HistoryEventFieldList
extends Structure
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=920");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=921");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=922");
    private final Variant[] eventFields;

    public HistoryEventFieldList(Variant[] eventFields) {
        this.eventFields = eventFields;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    public Variant[] getEventFields() {
        return this.eventFields;
    }

    protected HistoryEventFieldList(HistoryEventFieldListBuilder<?, ?> b) {
        super(b);
        this.eventFields = ((HistoryEventFieldListBuilder)b).eventFields;
    }

    public static HistoryEventFieldListBuilder<?, ?> builder() {
        return new HistoryEventFieldListBuilderImpl();
    }

    public HistoryEventFieldListBuilder<?, ?> toBuilder() {
        return new HistoryEventFieldListBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HistoryEventFieldList)) {
            return false;
        }
        HistoryEventFieldList other = (HistoryEventFieldList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Arrays.deepEquals(this.getEventFields(), other.getEventFields());
    }

    protected boolean canEqual(Object other) {
        return other instanceof HistoryEventFieldList;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getEventFields());
        return result;
    }

    @Override
    public String toString() {
        return "HistoryEventFieldList(eventFields=" + Arrays.deepToString(this.getEventFields()) + ")";
    }

    private static final class HistoryEventFieldListBuilderImpl
    extends HistoryEventFieldListBuilder<HistoryEventFieldList, HistoryEventFieldListBuilderImpl> {
        private HistoryEventFieldListBuilderImpl() {
        }

        @Override
        protected HistoryEventFieldListBuilderImpl self() {
            return this;
        }

        @Override
        public HistoryEventFieldList build() {
            return new HistoryEventFieldList(this);
        }
    }

    public static abstract class HistoryEventFieldListBuilder<C extends HistoryEventFieldList, B extends HistoryEventFieldListBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private Variant[] eventFields;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            HistoryEventFieldListBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(HistoryEventFieldList instance, HistoryEventFieldListBuilder<?, ?> b) {
            b.eventFields(instance.eventFields);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B eventFields(Variant[] eventFields) {
            this.eventFields = eventFields;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "HistoryEventFieldList.HistoryEventFieldListBuilder(super=" + super.toString() + ", eventFields=" + Arrays.deepToString(this.eventFields) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<HistoryEventFieldList> {
        @Override
        public Class<HistoryEventFieldList> getType() {
            return HistoryEventFieldList.class;
        }

        @Override
        public HistoryEventFieldList decode(SerializationContext context, UaDecoder decoder) {
            Variant[] eventFields = decoder.readVariantArray("EventFields");
            return new HistoryEventFieldList(eventFields);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, HistoryEventFieldList value) {
            encoder.writeVariantArray("EventFields", value.getEventFields());
        }
    }
}

