/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.variables;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.BaseDataVariableTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.types.variables.SessionDiagnosticsVariableType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.ApplicationDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.ServiceCounterDataType;

public class SessionDiagnosticsVariableTypeNode
extends BaseDataVariableTypeNode
implements SessionDiagnosticsVariableType {
    public SessionDiagnosticsVariableTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, UByte accessLevel, UByte userAccessLevel, Double minimumSamplingInterval, Boolean historizing) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing);
    }

    @Override
    public NodeId getSessionId() throws UaException {
        BaseDataVariableTypeNode node = this.getSessionIdNode();
        return (NodeId)node.getValue().getValue().getValue();
    }

    @Override
    public void setSessionId(NodeId sessionId) throws UaException {
        BaseDataVariableTypeNode node = this.getSessionIdNode();
        node.setValue(new Variant((Object)sessionId));
    }

    @Override
    public NodeId readSessionId() throws UaException {
        try {
            return this.readSessionIdAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSessionId(NodeId sessionId) throws UaException {
        try {
            this.writeSessionIdAsync(sessionId).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends NodeId> readSessionIdAsync() {
        return ((CompletableFuture)this.getSessionIdNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (NodeId)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSessionIdAsync(NodeId sessionId) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)sessionId));
        return this.getSessionIdNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getSessionIdNode() throws UaException {
        try {
            return this.getSessionIdNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getSessionIdNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SessionId", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public String getSessionName() throws UaException {
        BaseDataVariableTypeNode node = this.getSessionNameNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setSessionName(String sessionName) throws UaException {
        BaseDataVariableTypeNode node = this.getSessionNameNode();
        node.setValue(new Variant((Object)sessionName));
    }

    @Override
    public String readSessionName() throws UaException {
        try {
            return this.readSessionNameAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSessionName(String sessionName) throws UaException {
        try {
            this.writeSessionNameAsync(sessionName).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readSessionNameAsync() {
        return ((CompletableFuture)this.getSessionNameNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeSessionNameAsync(String sessionName) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)sessionName));
        return this.getSessionNameNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getSessionNameNode() throws UaException {
        try {
            return this.getSessionNameNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getSessionNameNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SessionName", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public ApplicationDescription getClientDescription() throws UaException {
        BaseDataVariableTypeNode node = this.getClientDescriptionNode();
        return this.cast(node.getValue().getValue().getValue(), ApplicationDescription.class);
    }

    @Override
    public void setClientDescription(ApplicationDescription clientDescription) throws UaException {
        BaseDataVariableTypeNode node = this.getClientDescriptionNode();
        ExtensionObject value = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)clientDescription);
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ApplicationDescription readClientDescription() throws UaException {
        try {
            return this.readClientDescriptionAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeClientDescription(ApplicationDescription clientDescription) throws UaException {
        try {
            this.writeClientDescriptionAsync(clientDescription).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ApplicationDescription> readClientDescriptionAsync() {
        return ((CompletableFuture)this.getClientDescriptionNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), ApplicationDescription.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeClientDescriptionAsync(ApplicationDescription clientDescription) {
        ExtensionObject encoded = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)clientDescription);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getClientDescriptionNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getClientDescriptionNode() throws UaException {
        try {
            return this.getClientDescriptionNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getClientDescriptionNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ClientDescription", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public String getServerUri() throws UaException {
        BaseDataVariableTypeNode node = this.getServerUriNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setServerUri(String serverUri) throws UaException {
        BaseDataVariableTypeNode node = this.getServerUriNode();
        node.setValue(new Variant((Object)serverUri));
    }

    @Override
    public String readServerUri() throws UaException {
        try {
            return this.readServerUriAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeServerUri(String serverUri) throws UaException {
        try {
            this.writeServerUriAsync(serverUri).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readServerUriAsync() {
        return ((CompletableFuture)this.getServerUriNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeServerUriAsync(String serverUri) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)serverUri));
        return this.getServerUriNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getServerUriNode() throws UaException {
        try {
            return this.getServerUriNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getServerUriNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ServerUri", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public String getEndpointUrl() throws UaException {
        BaseDataVariableTypeNode node = this.getEndpointUrlNode();
        return (String)node.getValue().getValue().getValue();
    }

    @Override
    public void setEndpointUrl(String endpointUrl) throws UaException {
        BaseDataVariableTypeNode node = this.getEndpointUrlNode();
        node.setValue(new Variant((Object)endpointUrl));
    }

    @Override
    public String readEndpointUrl() throws UaException {
        try {
            return this.readEndpointUrlAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeEndpointUrl(String endpointUrl) throws UaException {
        try {
            this.writeEndpointUrlAsync(endpointUrl).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String> readEndpointUrlAsync() {
        return ((CompletableFuture)this.getEndpointUrlNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeEndpointUrlAsync(String endpointUrl) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)endpointUrl));
        return this.getEndpointUrlNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getEndpointUrlNode() throws UaException {
        try {
            return this.getEndpointUrlNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getEndpointUrlNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "EndpointUrl", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public String[] getLocaleIds() throws UaException {
        BaseDataVariableTypeNode node = this.getLocaleIdsNode();
        return (String[])node.getValue().getValue().getValue();
    }

    @Override
    public void setLocaleIds(String[] localeIds) throws UaException {
        BaseDataVariableTypeNode node = this.getLocaleIdsNode();
        node.setValue(new Variant((Object)localeIds));
    }

    @Override
    public String[] readLocaleIds() throws UaException {
        try {
            return this.readLocaleIdsAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeLocaleIds(String[] localeIds) throws UaException {
        try {
            this.writeLocaleIdsAsync(localeIds).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends String[]> readLocaleIdsAsync() {
        return ((CompletableFuture)this.getLocaleIdsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (String[])v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeLocaleIdsAsync(String[] localeIds) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)localeIds));
        return this.getLocaleIdsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getLocaleIdsNode() throws UaException {
        try {
            return this.getLocaleIdsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getLocaleIdsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "LocaleIds", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public Double getActualSessionTimeout() throws UaException {
        BaseDataVariableTypeNode node = this.getActualSessionTimeoutNode();
        return (Double)node.getValue().getValue().getValue();
    }

    @Override
    public void setActualSessionTimeout(Double actualSessionTimeout) throws UaException {
        BaseDataVariableTypeNode node = this.getActualSessionTimeoutNode();
        node.setValue(new Variant((Object)actualSessionTimeout));
    }

    @Override
    public Double readActualSessionTimeout() throws UaException {
        try {
            return this.readActualSessionTimeoutAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeActualSessionTimeout(Double actualSessionTimeout) throws UaException {
        try {
            this.writeActualSessionTimeoutAsync(actualSessionTimeout).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Double> readActualSessionTimeoutAsync() {
        return ((CompletableFuture)this.getActualSessionTimeoutNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (Double)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeActualSessionTimeoutAsync(Double actualSessionTimeout) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)actualSessionTimeout));
        return this.getActualSessionTimeoutNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getActualSessionTimeoutNode() throws UaException {
        try {
            return this.getActualSessionTimeoutNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getActualSessionTimeoutNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ActualSessionTimeout", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getMaxResponseMessageSize() throws UaException {
        BaseDataVariableTypeNode node = this.getMaxResponseMessageSizeNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setMaxResponseMessageSize(UInteger maxResponseMessageSize) throws UaException {
        BaseDataVariableTypeNode node = this.getMaxResponseMessageSizeNode();
        node.setValue(new Variant((Object)maxResponseMessageSize));
    }

    @Override
    public UInteger readMaxResponseMessageSize() throws UaException {
        try {
            return this.readMaxResponseMessageSizeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeMaxResponseMessageSize(UInteger maxResponseMessageSize) throws UaException {
        try {
            this.writeMaxResponseMessageSizeAsync(maxResponseMessageSize).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readMaxResponseMessageSizeAsync() {
        return ((CompletableFuture)this.getMaxResponseMessageSizeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeMaxResponseMessageSizeAsync(UInteger maxResponseMessageSize) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)maxResponseMessageSize));
        return this.getMaxResponseMessageSizeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getMaxResponseMessageSizeNode() throws UaException {
        try {
            return this.getMaxResponseMessageSizeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getMaxResponseMessageSizeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "MaxResponseMessageSize", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public DateTime getClientConnectionTime() throws UaException {
        BaseDataVariableTypeNode node = this.getClientConnectionTimeNode();
        return (DateTime)node.getValue().getValue().getValue();
    }

    @Override
    public void setClientConnectionTime(DateTime clientConnectionTime) throws UaException {
        BaseDataVariableTypeNode node = this.getClientConnectionTimeNode();
        node.setValue(new Variant((Object)clientConnectionTime));
    }

    @Override
    public DateTime readClientConnectionTime() throws UaException {
        try {
            return this.readClientConnectionTimeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeClientConnectionTime(DateTime clientConnectionTime) throws UaException {
        try {
            this.writeClientConnectionTimeAsync(clientConnectionTime).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends DateTime> readClientConnectionTimeAsync() {
        return ((CompletableFuture)this.getClientConnectionTimeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (DateTime)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeClientConnectionTimeAsync(DateTime clientConnectionTime) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)clientConnectionTime));
        return this.getClientConnectionTimeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getClientConnectionTimeNode() throws UaException {
        try {
            return this.getClientConnectionTimeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getClientConnectionTimeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ClientConnectionTime", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public DateTime getClientLastContactTime() throws UaException {
        BaseDataVariableTypeNode node = this.getClientLastContactTimeNode();
        return (DateTime)node.getValue().getValue().getValue();
    }

    @Override
    public void setClientLastContactTime(DateTime clientLastContactTime) throws UaException {
        BaseDataVariableTypeNode node = this.getClientLastContactTimeNode();
        node.setValue(new Variant((Object)clientLastContactTime));
    }

    @Override
    public DateTime readClientLastContactTime() throws UaException {
        try {
            return this.readClientLastContactTimeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeClientLastContactTime(DateTime clientLastContactTime) throws UaException {
        try {
            this.writeClientLastContactTimeAsync(clientLastContactTime).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends DateTime> readClientLastContactTimeAsync() {
        return ((CompletableFuture)this.getClientLastContactTimeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (DateTime)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeClientLastContactTimeAsync(DateTime clientLastContactTime) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)clientLastContactTime));
        return this.getClientLastContactTimeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getClientLastContactTimeNode() throws UaException {
        try {
            return this.getClientLastContactTimeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getClientLastContactTimeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ClientLastContactTime", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getCurrentSubscriptionsCount() throws UaException {
        BaseDataVariableTypeNode node = this.getCurrentSubscriptionsCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setCurrentSubscriptionsCount(UInteger currentSubscriptionsCount) throws UaException {
        BaseDataVariableTypeNode node = this.getCurrentSubscriptionsCountNode();
        node.setValue(new Variant((Object)currentSubscriptionsCount));
    }

    @Override
    public UInteger readCurrentSubscriptionsCount() throws UaException {
        try {
            return this.readCurrentSubscriptionsCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeCurrentSubscriptionsCount(UInteger currentSubscriptionsCount) throws UaException {
        try {
            this.writeCurrentSubscriptionsCountAsync(currentSubscriptionsCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readCurrentSubscriptionsCountAsync() {
        return ((CompletableFuture)this.getCurrentSubscriptionsCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeCurrentSubscriptionsCountAsync(UInteger currentSubscriptionsCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)currentSubscriptionsCount));
        return this.getCurrentSubscriptionsCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getCurrentSubscriptionsCountNode() throws UaException {
        try {
            return this.getCurrentSubscriptionsCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getCurrentSubscriptionsCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "CurrentSubscriptionsCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getCurrentMonitoredItemsCount() throws UaException {
        BaseDataVariableTypeNode node = this.getCurrentMonitoredItemsCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setCurrentMonitoredItemsCount(UInteger currentMonitoredItemsCount) throws UaException {
        BaseDataVariableTypeNode node = this.getCurrentMonitoredItemsCountNode();
        node.setValue(new Variant((Object)currentMonitoredItemsCount));
    }

    @Override
    public UInteger readCurrentMonitoredItemsCount() throws UaException {
        try {
            return this.readCurrentMonitoredItemsCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeCurrentMonitoredItemsCount(UInteger currentMonitoredItemsCount) throws UaException {
        try {
            this.writeCurrentMonitoredItemsCountAsync(currentMonitoredItemsCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readCurrentMonitoredItemsCountAsync() {
        return ((CompletableFuture)this.getCurrentMonitoredItemsCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeCurrentMonitoredItemsCountAsync(UInteger currentMonitoredItemsCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)currentMonitoredItemsCount));
        return this.getCurrentMonitoredItemsCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getCurrentMonitoredItemsCountNode() throws UaException {
        try {
            return this.getCurrentMonitoredItemsCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getCurrentMonitoredItemsCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "CurrentMonitoredItemsCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getCurrentPublishRequestsInQueue() throws UaException {
        BaseDataVariableTypeNode node = this.getCurrentPublishRequestsInQueueNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setCurrentPublishRequestsInQueue(UInteger currentPublishRequestsInQueue) throws UaException {
        BaseDataVariableTypeNode node = this.getCurrentPublishRequestsInQueueNode();
        node.setValue(new Variant((Object)currentPublishRequestsInQueue));
    }

    @Override
    public UInteger readCurrentPublishRequestsInQueue() throws UaException {
        try {
            return this.readCurrentPublishRequestsInQueueAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeCurrentPublishRequestsInQueue(UInteger currentPublishRequestsInQueue) throws UaException {
        try {
            this.writeCurrentPublishRequestsInQueueAsync(currentPublishRequestsInQueue).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readCurrentPublishRequestsInQueueAsync() {
        return ((CompletableFuture)this.getCurrentPublishRequestsInQueueNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeCurrentPublishRequestsInQueueAsync(UInteger currentPublishRequestsInQueue) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)currentPublishRequestsInQueue));
        return this.getCurrentPublishRequestsInQueueNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getCurrentPublishRequestsInQueueNode() throws UaException {
        try {
            return this.getCurrentPublishRequestsInQueueNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getCurrentPublishRequestsInQueueNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "CurrentPublishRequestsInQueue", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public ServiceCounterDataType getTotalRequestCount() throws UaException {
        BaseDataVariableTypeNode node = this.getTotalRequestCountNode();
        return this.cast(node.getValue().getValue().getValue(), ServiceCounterDataType.class);
    }

    @Override
    public void setTotalRequestCount(ServiceCounterDataType totalRequestCount) throws UaException {
        BaseDataVariableTypeNode node = this.getTotalRequestCountNode();
        ExtensionObject value = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)totalRequestCount);
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ServiceCounterDataType readTotalRequestCount() throws UaException {
        try {
            return this.readTotalRequestCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeTotalRequestCount(ServiceCounterDataType totalRequestCount) throws UaException {
        try {
            this.writeTotalRequestCountAsync(totalRequestCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ServiceCounterDataType> readTotalRequestCountAsync() {
        return ((CompletableFuture)this.getTotalRequestCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), ServiceCounterDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeTotalRequestCountAsync(ServiceCounterDataType totalRequestCount) {
        ExtensionObject encoded = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)totalRequestCount);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getTotalRequestCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getTotalRequestCountNode() throws UaException {
        try {
            return this.getTotalRequestCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getTotalRequestCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "TotalRequestCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public UInteger getUnauthorizedRequestCount() throws UaException {
        BaseDataVariableTypeNode node = this.getUnauthorizedRequestCountNode();
        return (UInteger)node.getValue().getValue().getValue();
    }

    @Override
    public void setUnauthorizedRequestCount(UInteger unauthorizedRequestCount) throws UaException {
        BaseDataVariableTypeNode node = this.getUnauthorizedRequestCountNode();
        node.setValue(new Variant((Object)unauthorizedRequestCount));
    }

    @Override
    public UInteger readUnauthorizedRequestCount() throws UaException {
        try {
            return this.readUnauthorizedRequestCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeUnauthorizedRequestCount(UInteger unauthorizedRequestCount) throws UaException {
        try {
            this.writeUnauthorizedRequestCountAsync(unauthorizedRequestCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends UInteger> readUnauthorizedRequestCountAsync() {
        return ((CompletableFuture)this.getUnauthorizedRequestCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> (UInteger)v.getValue().getValue());
    }

    @Override
    public CompletableFuture<StatusCode> writeUnauthorizedRequestCountAsync(UInteger unauthorizedRequestCount) {
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)unauthorizedRequestCount));
        return this.getUnauthorizedRequestCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getUnauthorizedRequestCountNode() throws UaException {
        try {
            return this.getUnauthorizedRequestCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getUnauthorizedRequestCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "UnauthorizedRequestCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public ServiceCounterDataType getReadCount() throws UaException {
        BaseDataVariableTypeNode node = this.getReadCountNode();
        return this.cast(node.getValue().getValue().getValue(), ServiceCounterDataType.class);
    }

    @Override
    public void setReadCount(ServiceCounterDataType readCount) throws UaException {
        BaseDataVariableTypeNode node = this.getReadCountNode();
        ExtensionObject value = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)readCount);
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ServiceCounterDataType readReadCount() throws UaException {
        try {
            return this.readReadCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeReadCount(ServiceCounterDataType readCount) throws UaException {
        try {
            this.writeReadCountAsync(readCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ServiceCounterDataType> readReadCountAsync() {
        return ((CompletableFuture)this.getReadCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), ServiceCounterDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeReadCountAsync(ServiceCounterDataType readCount) {
        ExtensionObject encoded = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)readCount);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getReadCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getReadCountNode() throws UaException {
        try {
            return this.getReadCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getReadCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ReadCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public ServiceCounterDataType getHistoryReadCount() throws UaException {
        BaseDataVariableTypeNode node = this.getHistoryReadCountNode();
        return this.cast(node.getValue().getValue().getValue(), ServiceCounterDataType.class);
    }

    @Override
    public void setHistoryReadCount(ServiceCounterDataType historyReadCount) throws UaException {
        BaseDataVariableTypeNode node = this.getHistoryReadCountNode();
        ExtensionObject value = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)historyReadCount);
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ServiceCounterDataType readHistoryReadCount() throws UaException {
        try {
            return this.readHistoryReadCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeHistoryReadCount(ServiceCounterDataType historyReadCount) throws UaException {
        try {
            this.writeHistoryReadCountAsync(historyReadCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ServiceCounterDataType> readHistoryReadCountAsync() {
        return ((CompletableFuture)this.getHistoryReadCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), ServiceCounterDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeHistoryReadCountAsync(ServiceCounterDataType historyReadCount) {
        ExtensionObject encoded = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)historyReadCount);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getHistoryReadCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getHistoryReadCountNode() throws UaException {
        try {
            return this.getHistoryReadCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getHistoryReadCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "HistoryReadCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public ServiceCounterDataType getWriteCount() throws UaException {
        BaseDataVariableTypeNode node = this.getWriteCountNode();
        return this.cast(node.getValue().getValue().getValue(), ServiceCounterDataType.class);
    }

    @Override
    public void setWriteCount(ServiceCounterDataType writeCount) throws UaException {
        BaseDataVariableTypeNode node = this.getWriteCountNode();
        ExtensionObject value = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)writeCount);
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ServiceCounterDataType readWriteCount() throws UaException {
        try {
            return this.readWriteCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeWriteCount(ServiceCounterDataType writeCount) throws UaException {
        try {
            this.writeWriteCountAsync(writeCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ServiceCounterDataType> readWriteCountAsync() {
        return ((CompletableFuture)this.getWriteCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), ServiceCounterDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeWriteCountAsync(ServiceCounterDataType writeCount) {
        ExtensionObject encoded = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)writeCount);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getWriteCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getWriteCountNode() throws UaException {
        try {
            return this.getWriteCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getWriteCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "WriteCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public ServiceCounterDataType getHistoryUpdateCount() throws UaException {
        BaseDataVariableTypeNode node = this.getHistoryUpdateCountNode();
        return this.cast(node.getValue().getValue().getValue(), ServiceCounterDataType.class);
    }

    @Override
    public void setHistoryUpdateCount(ServiceCounterDataType historyUpdateCount) throws UaException {
        BaseDataVariableTypeNode node = this.getHistoryUpdateCountNode();
        ExtensionObject value = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)historyUpdateCount);
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ServiceCounterDataType readHistoryUpdateCount() throws UaException {
        try {
            return this.readHistoryUpdateCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeHistoryUpdateCount(ServiceCounterDataType historyUpdateCount) throws UaException {
        try {
            this.writeHistoryUpdateCountAsync(historyUpdateCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ServiceCounterDataType> readHistoryUpdateCountAsync() {
        return ((CompletableFuture)this.getHistoryUpdateCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), ServiceCounterDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeHistoryUpdateCountAsync(ServiceCounterDataType historyUpdateCount) {
        ExtensionObject encoded = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)historyUpdateCount);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getHistoryUpdateCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getHistoryUpdateCountNode() throws UaException {
        try {
            return this.getHistoryUpdateCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getHistoryUpdateCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "HistoryUpdateCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public ServiceCounterDataType getCallCount() throws UaException {
        BaseDataVariableTypeNode node = this.getCallCountNode();
        return this.cast(node.getValue().getValue().getValue(), ServiceCounterDataType.class);
    }

    @Override
    public void setCallCount(ServiceCounterDataType callCount) throws UaException {
        BaseDataVariableTypeNode node = this.getCallCountNode();
        ExtensionObject value = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)callCount);
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ServiceCounterDataType readCallCount() throws UaException {
        try {
            return this.readCallCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeCallCount(ServiceCounterDataType callCount) throws UaException {
        try {
            this.writeCallCountAsync(callCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ServiceCounterDataType> readCallCountAsync() {
        return ((CompletableFuture)this.getCallCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), ServiceCounterDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeCallCountAsync(ServiceCounterDataType callCount) {
        ExtensionObject encoded = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)callCount);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getCallCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getCallCountNode() throws UaException {
        try {
            return this.getCallCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getCallCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "CallCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public ServiceCounterDataType getCreateMonitoredItemsCount() throws UaException {
        BaseDataVariableTypeNode node = this.getCreateMonitoredItemsCountNode();
        return this.cast(node.getValue().getValue().getValue(), ServiceCounterDataType.class);
    }

    @Override
    public void setCreateMonitoredItemsCount(ServiceCounterDataType createMonitoredItemsCount) throws UaException {
        BaseDataVariableTypeNode node = this.getCreateMonitoredItemsCountNode();
        ExtensionObject value = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)createMonitoredItemsCount);
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ServiceCounterDataType readCreateMonitoredItemsCount() throws UaException {
        try {
            return this.readCreateMonitoredItemsCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeCreateMonitoredItemsCount(ServiceCounterDataType createMonitoredItemsCount) throws UaException {
        try {
            this.writeCreateMonitoredItemsCountAsync(createMonitoredItemsCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ServiceCounterDataType> readCreateMonitoredItemsCountAsync() {
        return ((CompletableFuture)this.getCreateMonitoredItemsCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), ServiceCounterDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeCreateMonitoredItemsCountAsync(ServiceCounterDataType createMonitoredItemsCount) {
        ExtensionObject encoded = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)createMonitoredItemsCount);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getCreateMonitoredItemsCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getCreateMonitoredItemsCountNode() throws UaException {
        try {
            return this.getCreateMonitoredItemsCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getCreateMonitoredItemsCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "CreateMonitoredItemsCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public ServiceCounterDataType getModifyMonitoredItemsCount() throws UaException {
        BaseDataVariableTypeNode node = this.getModifyMonitoredItemsCountNode();
        return this.cast(node.getValue().getValue().getValue(), ServiceCounterDataType.class);
    }

    @Override
    public void setModifyMonitoredItemsCount(ServiceCounterDataType modifyMonitoredItemsCount) throws UaException {
        BaseDataVariableTypeNode node = this.getModifyMonitoredItemsCountNode();
        ExtensionObject value = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)modifyMonitoredItemsCount);
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ServiceCounterDataType readModifyMonitoredItemsCount() throws UaException {
        try {
            return this.readModifyMonitoredItemsCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeModifyMonitoredItemsCount(ServiceCounterDataType modifyMonitoredItemsCount) throws UaException {
        try {
            this.writeModifyMonitoredItemsCountAsync(modifyMonitoredItemsCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ServiceCounterDataType> readModifyMonitoredItemsCountAsync() {
        return ((CompletableFuture)this.getModifyMonitoredItemsCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), ServiceCounterDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeModifyMonitoredItemsCountAsync(ServiceCounterDataType modifyMonitoredItemsCount) {
        ExtensionObject encoded = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)modifyMonitoredItemsCount);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getModifyMonitoredItemsCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getModifyMonitoredItemsCountNode() throws UaException {
        try {
            return this.getModifyMonitoredItemsCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getModifyMonitoredItemsCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ModifyMonitoredItemsCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public ServiceCounterDataType getSetMonitoringModeCount() throws UaException {
        BaseDataVariableTypeNode node = this.getSetMonitoringModeCountNode();
        return this.cast(node.getValue().getValue().getValue(), ServiceCounterDataType.class);
    }

    @Override
    public void setSetMonitoringModeCount(ServiceCounterDataType setMonitoringModeCount) throws UaException {
        BaseDataVariableTypeNode node = this.getSetMonitoringModeCountNode();
        ExtensionObject value = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)setMonitoringModeCount);
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ServiceCounterDataType readSetMonitoringModeCount() throws UaException {
        try {
            return this.readSetMonitoringModeCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSetMonitoringModeCount(ServiceCounterDataType setMonitoringModeCount) throws UaException {
        try {
            this.writeSetMonitoringModeCountAsync(setMonitoringModeCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ServiceCounterDataType> readSetMonitoringModeCountAsync() {
        return ((CompletableFuture)this.getSetMonitoringModeCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), ServiceCounterDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeSetMonitoringModeCountAsync(ServiceCounterDataType setMonitoringModeCount) {
        ExtensionObject encoded = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)setMonitoringModeCount);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getSetMonitoringModeCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getSetMonitoringModeCountNode() throws UaException {
        try {
            return this.getSetMonitoringModeCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getSetMonitoringModeCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SetMonitoringModeCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public ServiceCounterDataType getSetTriggeringCount() throws UaException {
        BaseDataVariableTypeNode node = this.getSetTriggeringCountNode();
        return this.cast(node.getValue().getValue().getValue(), ServiceCounterDataType.class);
    }

    @Override
    public void setSetTriggeringCount(ServiceCounterDataType setTriggeringCount) throws UaException {
        BaseDataVariableTypeNode node = this.getSetTriggeringCountNode();
        ExtensionObject value = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)setTriggeringCount);
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ServiceCounterDataType readSetTriggeringCount() throws UaException {
        try {
            return this.readSetTriggeringCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSetTriggeringCount(ServiceCounterDataType setTriggeringCount) throws UaException {
        try {
            this.writeSetTriggeringCountAsync(setTriggeringCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ServiceCounterDataType> readSetTriggeringCountAsync() {
        return ((CompletableFuture)this.getSetTriggeringCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), ServiceCounterDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeSetTriggeringCountAsync(ServiceCounterDataType setTriggeringCount) {
        ExtensionObject encoded = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)setTriggeringCount);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getSetTriggeringCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getSetTriggeringCountNode() throws UaException {
        try {
            return this.getSetTriggeringCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getSetTriggeringCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SetTriggeringCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public ServiceCounterDataType getDeleteMonitoredItemsCount() throws UaException {
        BaseDataVariableTypeNode node = this.getDeleteMonitoredItemsCountNode();
        return this.cast(node.getValue().getValue().getValue(), ServiceCounterDataType.class);
    }

    @Override
    public void setDeleteMonitoredItemsCount(ServiceCounterDataType deleteMonitoredItemsCount) throws UaException {
        BaseDataVariableTypeNode node = this.getDeleteMonitoredItemsCountNode();
        ExtensionObject value = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)deleteMonitoredItemsCount);
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ServiceCounterDataType readDeleteMonitoredItemsCount() throws UaException {
        try {
            return this.readDeleteMonitoredItemsCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeDeleteMonitoredItemsCount(ServiceCounterDataType deleteMonitoredItemsCount) throws UaException {
        try {
            this.writeDeleteMonitoredItemsCountAsync(deleteMonitoredItemsCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ServiceCounterDataType> readDeleteMonitoredItemsCountAsync() {
        return ((CompletableFuture)this.getDeleteMonitoredItemsCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), ServiceCounterDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeDeleteMonitoredItemsCountAsync(ServiceCounterDataType deleteMonitoredItemsCount) {
        ExtensionObject encoded = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)deleteMonitoredItemsCount);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getDeleteMonitoredItemsCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getDeleteMonitoredItemsCountNode() throws UaException {
        try {
            return this.getDeleteMonitoredItemsCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getDeleteMonitoredItemsCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DeleteMonitoredItemsCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public ServiceCounterDataType getCreateSubscriptionCount() throws UaException {
        BaseDataVariableTypeNode node = this.getCreateSubscriptionCountNode();
        return this.cast(node.getValue().getValue().getValue(), ServiceCounterDataType.class);
    }

    @Override
    public void setCreateSubscriptionCount(ServiceCounterDataType createSubscriptionCount) throws UaException {
        BaseDataVariableTypeNode node = this.getCreateSubscriptionCountNode();
        ExtensionObject value = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)createSubscriptionCount);
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ServiceCounterDataType readCreateSubscriptionCount() throws UaException {
        try {
            return this.readCreateSubscriptionCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeCreateSubscriptionCount(ServiceCounterDataType createSubscriptionCount) throws UaException {
        try {
            this.writeCreateSubscriptionCountAsync(createSubscriptionCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ServiceCounterDataType> readCreateSubscriptionCountAsync() {
        return ((CompletableFuture)this.getCreateSubscriptionCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), ServiceCounterDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeCreateSubscriptionCountAsync(ServiceCounterDataType createSubscriptionCount) {
        ExtensionObject encoded = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)createSubscriptionCount);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getCreateSubscriptionCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getCreateSubscriptionCountNode() throws UaException {
        try {
            return this.getCreateSubscriptionCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getCreateSubscriptionCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "CreateSubscriptionCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public ServiceCounterDataType getModifySubscriptionCount() throws UaException {
        BaseDataVariableTypeNode node = this.getModifySubscriptionCountNode();
        return this.cast(node.getValue().getValue().getValue(), ServiceCounterDataType.class);
    }

    @Override
    public void setModifySubscriptionCount(ServiceCounterDataType modifySubscriptionCount) throws UaException {
        BaseDataVariableTypeNode node = this.getModifySubscriptionCountNode();
        ExtensionObject value = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)modifySubscriptionCount);
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ServiceCounterDataType readModifySubscriptionCount() throws UaException {
        try {
            return this.readModifySubscriptionCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeModifySubscriptionCount(ServiceCounterDataType modifySubscriptionCount) throws UaException {
        try {
            this.writeModifySubscriptionCountAsync(modifySubscriptionCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ServiceCounterDataType> readModifySubscriptionCountAsync() {
        return ((CompletableFuture)this.getModifySubscriptionCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), ServiceCounterDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeModifySubscriptionCountAsync(ServiceCounterDataType modifySubscriptionCount) {
        ExtensionObject encoded = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)modifySubscriptionCount);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getModifySubscriptionCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getModifySubscriptionCountNode() throws UaException {
        try {
            return this.getModifySubscriptionCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getModifySubscriptionCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "ModifySubscriptionCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public ServiceCounterDataType getSetPublishingModeCount() throws UaException {
        BaseDataVariableTypeNode node = this.getSetPublishingModeCountNode();
        return this.cast(node.getValue().getValue().getValue(), ServiceCounterDataType.class);
    }

    @Override
    public void setSetPublishingModeCount(ServiceCounterDataType setPublishingModeCount) throws UaException {
        BaseDataVariableTypeNode node = this.getSetPublishingModeCountNode();
        ExtensionObject value = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)setPublishingModeCount);
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ServiceCounterDataType readSetPublishingModeCount() throws UaException {
        try {
            return this.readSetPublishingModeCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeSetPublishingModeCount(ServiceCounterDataType setPublishingModeCount) throws UaException {
        try {
            this.writeSetPublishingModeCountAsync(setPublishingModeCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ServiceCounterDataType> readSetPublishingModeCountAsync() {
        return ((CompletableFuture)this.getSetPublishingModeCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), ServiceCounterDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeSetPublishingModeCountAsync(ServiceCounterDataType setPublishingModeCount) {
        ExtensionObject encoded = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)setPublishingModeCount);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getSetPublishingModeCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getSetPublishingModeCountNode() throws UaException {
        try {
            return this.getSetPublishingModeCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getSetPublishingModeCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "SetPublishingModeCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public ServiceCounterDataType getPublishCount() throws UaException {
        BaseDataVariableTypeNode node = this.getPublishCountNode();
        return this.cast(node.getValue().getValue().getValue(), ServiceCounterDataType.class);
    }

    @Override
    public void setPublishCount(ServiceCounterDataType publishCount) throws UaException {
        BaseDataVariableTypeNode node = this.getPublishCountNode();
        ExtensionObject value = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)publishCount);
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ServiceCounterDataType readPublishCount() throws UaException {
        try {
            return this.readPublishCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writePublishCount(ServiceCounterDataType publishCount) throws UaException {
        try {
            this.writePublishCountAsync(publishCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ServiceCounterDataType> readPublishCountAsync() {
        return ((CompletableFuture)this.getPublishCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), ServiceCounterDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> writePublishCountAsync(ServiceCounterDataType publishCount) {
        ExtensionObject encoded = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)publishCount);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getPublishCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getPublishCountNode() throws UaException {
        try {
            return this.getPublishCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getPublishCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "PublishCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public ServiceCounterDataType getRepublishCount() throws UaException {
        BaseDataVariableTypeNode node = this.getRepublishCountNode();
        return this.cast(node.getValue().getValue().getValue(), ServiceCounterDataType.class);
    }

    @Override
    public void setRepublishCount(ServiceCounterDataType republishCount) throws UaException {
        BaseDataVariableTypeNode node = this.getRepublishCountNode();
        ExtensionObject value = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)republishCount);
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ServiceCounterDataType readRepublishCount() throws UaException {
        try {
            return this.readRepublishCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeRepublishCount(ServiceCounterDataType republishCount) throws UaException {
        try {
            this.writeRepublishCountAsync(republishCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ServiceCounterDataType> readRepublishCountAsync() {
        return ((CompletableFuture)this.getRepublishCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), ServiceCounterDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeRepublishCountAsync(ServiceCounterDataType republishCount) {
        ExtensionObject encoded = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)republishCount);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getRepublishCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getRepublishCountNode() throws UaException {
        try {
            return this.getRepublishCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getRepublishCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "RepublishCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public ServiceCounterDataType getTransferSubscriptionsCount() throws UaException {
        BaseDataVariableTypeNode node = this.getTransferSubscriptionsCountNode();
        return this.cast(node.getValue().getValue().getValue(), ServiceCounterDataType.class);
    }

    @Override
    public void setTransferSubscriptionsCount(ServiceCounterDataType transferSubscriptionsCount) throws UaException {
        BaseDataVariableTypeNode node = this.getTransferSubscriptionsCountNode();
        ExtensionObject value = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)transferSubscriptionsCount);
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ServiceCounterDataType readTransferSubscriptionsCount() throws UaException {
        try {
            return this.readTransferSubscriptionsCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeTransferSubscriptionsCount(ServiceCounterDataType transferSubscriptionsCount) throws UaException {
        try {
            this.writeTransferSubscriptionsCountAsync(transferSubscriptionsCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ServiceCounterDataType> readTransferSubscriptionsCountAsync() {
        return ((CompletableFuture)this.getTransferSubscriptionsCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), ServiceCounterDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeTransferSubscriptionsCountAsync(ServiceCounterDataType transferSubscriptionsCount) {
        ExtensionObject encoded = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)transferSubscriptionsCount);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getTransferSubscriptionsCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getTransferSubscriptionsCountNode() throws UaException {
        try {
            return this.getTransferSubscriptionsCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getTransferSubscriptionsCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "TransferSubscriptionsCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public ServiceCounterDataType getDeleteSubscriptionsCount() throws UaException {
        BaseDataVariableTypeNode node = this.getDeleteSubscriptionsCountNode();
        return this.cast(node.getValue().getValue().getValue(), ServiceCounterDataType.class);
    }

    @Override
    public void setDeleteSubscriptionsCount(ServiceCounterDataType deleteSubscriptionsCount) throws UaException {
        BaseDataVariableTypeNode node = this.getDeleteSubscriptionsCountNode();
        ExtensionObject value = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)deleteSubscriptionsCount);
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ServiceCounterDataType readDeleteSubscriptionsCount() throws UaException {
        try {
            return this.readDeleteSubscriptionsCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeDeleteSubscriptionsCount(ServiceCounterDataType deleteSubscriptionsCount) throws UaException {
        try {
            this.writeDeleteSubscriptionsCountAsync(deleteSubscriptionsCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ServiceCounterDataType> readDeleteSubscriptionsCountAsync() {
        return ((CompletableFuture)this.getDeleteSubscriptionsCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), ServiceCounterDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeDeleteSubscriptionsCountAsync(ServiceCounterDataType deleteSubscriptionsCount) {
        ExtensionObject encoded = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)deleteSubscriptionsCount);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getDeleteSubscriptionsCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getDeleteSubscriptionsCountNode() throws UaException {
        try {
            return this.getDeleteSubscriptionsCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getDeleteSubscriptionsCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DeleteSubscriptionsCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public ServiceCounterDataType getAddNodesCount() throws UaException {
        BaseDataVariableTypeNode node = this.getAddNodesCountNode();
        return this.cast(node.getValue().getValue().getValue(), ServiceCounterDataType.class);
    }

    @Override
    public void setAddNodesCount(ServiceCounterDataType addNodesCount) throws UaException {
        BaseDataVariableTypeNode node = this.getAddNodesCountNode();
        ExtensionObject value = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)addNodesCount);
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ServiceCounterDataType readAddNodesCount() throws UaException {
        try {
            return this.readAddNodesCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeAddNodesCount(ServiceCounterDataType addNodesCount) throws UaException {
        try {
            this.writeAddNodesCountAsync(addNodesCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ServiceCounterDataType> readAddNodesCountAsync() {
        return ((CompletableFuture)this.getAddNodesCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), ServiceCounterDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeAddNodesCountAsync(ServiceCounterDataType addNodesCount) {
        ExtensionObject encoded = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)addNodesCount);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getAddNodesCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getAddNodesCountNode() throws UaException {
        try {
            return this.getAddNodesCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getAddNodesCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "AddNodesCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public ServiceCounterDataType getAddReferencesCount() throws UaException {
        BaseDataVariableTypeNode node = this.getAddReferencesCountNode();
        return this.cast(node.getValue().getValue().getValue(), ServiceCounterDataType.class);
    }

    @Override
    public void setAddReferencesCount(ServiceCounterDataType addReferencesCount) throws UaException {
        BaseDataVariableTypeNode node = this.getAddReferencesCountNode();
        ExtensionObject value = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)addReferencesCount);
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ServiceCounterDataType readAddReferencesCount() throws UaException {
        try {
            return this.readAddReferencesCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeAddReferencesCount(ServiceCounterDataType addReferencesCount) throws UaException {
        try {
            this.writeAddReferencesCountAsync(addReferencesCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ServiceCounterDataType> readAddReferencesCountAsync() {
        return ((CompletableFuture)this.getAddReferencesCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), ServiceCounterDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeAddReferencesCountAsync(ServiceCounterDataType addReferencesCount) {
        ExtensionObject encoded = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)addReferencesCount);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getAddReferencesCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getAddReferencesCountNode() throws UaException {
        try {
            return this.getAddReferencesCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getAddReferencesCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "AddReferencesCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public ServiceCounterDataType getDeleteNodesCount() throws UaException {
        BaseDataVariableTypeNode node = this.getDeleteNodesCountNode();
        return this.cast(node.getValue().getValue().getValue(), ServiceCounterDataType.class);
    }

    @Override
    public void setDeleteNodesCount(ServiceCounterDataType deleteNodesCount) throws UaException {
        BaseDataVariableTypeNode node = this.getDeleteNodesCountNode();
        ExtensionObject value = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)deleteNodesCount);
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ServiceCounterDataType readDeleteNodesCount() throws UaException {
        try {
            return this.readDeleteNodesCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeDeleteNodesCount(ServiceCounterDataType deleteNodesCount) throws UaException {
        try {
            this.writeDeleteNodesCountAsync(deleteNodesCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ServiceCounterDataType> readDeleteNodesCountAsync() {
        return ((CompletableFuture)this.getDeleteNodesCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), ServiceCounterDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeDeleteNodesCountAsync(ServiceCounterDataType deleteNodesCount) {
        ExtensionObject encoded = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)deleteNodesCount);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getDeleteNodesCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getDeleteNodesCountNode() throws UaException {
        try {
            return this.getDeleteNodesCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getDeleteNodesCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DeleteNodesCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public ServiceCounterDataType getDeleteReferencesCount() throws UaException {
        BaseDataVariableTypeNode node = this.getDeleteReferencesCountNode();
        return this.cast(node.getValue().getValue().getValue(), ServiceCounterDataType.class);
    }

    @Override
    public void setDeleteReferencesCount(ServiceCounterDataType deleteReferencesCount) throws UaException {
        BaseDataVariableTypeNode node = this.getDeleteReferencesCountNode();
        ExtensionObject value = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)deleteReferencesCount);
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ServiceCounterDataType readDeleteReferencesCount() throws UaException {
        try {
            return this.readDeleteReferencesCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeDeleteReferencesCount(ServiceCounterDataType deleteReferencesCount) throws UaException {
        try {
            this.writeDeleteReferencesCountAsync(deleteReferencesCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ServiceCounterDataType> readDeleteReferencesCountAsync() {
        return ((CompletableFuture)this.getDeleteReferencesCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), ServiceCounterDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeDeleteReferencesCountAsync(ServiceCounterDataType deleteReferencesCount) {
        ExtensionObject encoded = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)deleteReferencesCount);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getDeleteReferencesCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getDeleteReferencesCountNode() throws UaException {
        try {
            return this.getDeleteReferencesCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getDeleteReferencesCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "DeleteReferencesCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public ServiceCounterDataType getBrowseCount() throws UaException {
        BaseDataVariableTypeNode node = this.getBrowseCountNode();
        return this.cast(node.getValue().getValue().getValue(), ServiceCounterDataType.class);
    }

    @Override
    public void setBrowseCount(ServiceCounterDataType browseCount) throws UaException {
        BaseDataVariableTypeNode node = this.getBrowseCountNode();
        ExtensionObject value = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)browseCount);
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ServiceCounterDataType readBrowseCount() throws UaException {
        try {
            return this.readBrowseCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeBrowseCount(ServiceCounterDataType browseCount) throws UaException {
        try {
            this.writeBrowseCountAsync(browseCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ServiceCounterDataType> readBrowseCountAsync() {
        return ((CompletableFuture)this.getBrowseCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), ServiceCounterDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeBrowseCountAsync(ServiceCounterDataType browseCount) {
        ExtensionObject encoded = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)browseCount);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getBrowseCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getBrowseCountNode() throws UaException {
        try {
            return this.getBrowseCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getBrowseCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "BrowseCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public ServiceCounterDataType getBrowseNextCount() throws UaException {
        BaseDataVariableTypeNode node = this.getBrowseNextCountNode();
        return this.cast(node.getValue().getValue().getValue(), ServiceCounterDataType.class);
    }

    @Override
    public void setBrowseNextCount(ServiceCounterDataType browseNextCount) throws UaException {
        BaseDataVariableTypeNode node = this.getBrowseNextCountNode();
        ExtensionObject value = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)browseNextCount);
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ServiceCounterDataType readBrowseNextCount() throws UaException {
        try {
            return this.readBrowseNextCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeBrowseNextCount(ServiceCounterDataType browseNextCount) throws UaException {
        try {
            this.writeBrowseNextCountAsync(browseNextCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ServiceCounterDataType> readBrowseNextCountAsync() {
        return ((CompletableFuture)this.getBrowseNextCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), ServiceCounterDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeBrowseNextCountAsync(ServiceCounterDataType browseNextCount) {
        ExtensionObject encoded = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)browseNextCount);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getBrowseNextCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getBrowseNextCountNode() throws UaException {
        try {
            return this.getBrowseNextCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getBrowseNextCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "BrowseNextCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public ServiceCounterDataType getTranslateBrowsePathsToNodeIdsCount() throws UaException {
        BaseDataVariableTypeNode node = this.getTranslateBrowsePathsToNodeIdsCountNode();
        return this.cast(node.getValue().getValue().getValue(), ServiceCounterDataType.class);
    }

    @Override
    public void setTranslateBrowsePathsToNodeIdsCount(ServiceCounterDataType translateBrowsePathsToNodeIdsCount) throws UaException {
        BaseDataVariableTypeNode node = this.getTranslateBrowsePathsToNodeIdsCountNode();
        ExtensionObject value = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)translateBrowsePathsToNodeIdsCount);
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ServiceCounterDataType readTranslateBrowsePathsToNodeIdsCount() throws UaException {
        try {
            return this.readTranslateBrowsePathsToNodeIdsCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeTranslateBrowsePathsToNodeIdsCount(ServiceCounterDataType translateBrowsePathsToNodeIdsCount) throws UaException {
        try {
            this.writeTranslateBrowsePathsToNodeIdsCountAsync(translateBrowsePathsToNodeIdsCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ServiceCounterDataType> readTranslateBrowsePathsToNodeIdsCountAsync() {
        return ((CompletableFuture)this.getTranslateBrowsePathsToNodeIdsCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), ServiceCounterDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeTranslateBrowsePathsToNodeIdsCountAsync(ServiceCounterDataType translateBrowsePathsToNodeIdsCount) {
        ExtensionObject encoded = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)translateBrowsePathsToNodeIdsCount);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getTranslateBrowsePathsToNodeIdsCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getTranslateBrowsePathsToNodeIdsCountNode() throws UaException {
        try {
            return this.getTranslateBrowsePathsToNodeIdsCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getTranslateBrowsePathsToNodeIdsCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "TranslateBrowsePathsToNodeIdsCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public ServiceCounterDataType getQueryFirstCount() throws UaException {
        BaseDataVariableTypeNode node = this.getQueryFirstCountNode();
        return this.cast(node.getValue().getValue().getValue(), ServiceCounterDataType.class);
    }

    @Override
    public void setQueryFirstCount(ServiceCounterDataType queryFirstCount) throws UaException {
        BaseDataVariableTypeNode node = this.getQueryFirstCountNode();
        ExtensionObject value = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)queryFirstCount);
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ServiceCounterDataType readQueryFirstCount() throws UaException {
        try {
            return this.readQueryFirstCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeQueryFirstCount(ServiceCounterDataType queryFirstCount) throws UaException {
        try {
            this.writeQueryFirstCountAsync(queryFirstCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ServiceCounterDataType> readQueryFirstCountAsync() {
        return ((CompletableFuture)this.getQueryFirstCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), ServiceCounterDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeQueryFirstCountAsync(ServiceCounterDataType queryFirstCount) {
        ExtensionObject encoded = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)queryFirstCount);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getQueryFirstCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getQueryFirstCountNode() throws UaException {
        try {
            return this.getQueryFirstCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getQueryFirstCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "QueryFirstCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public ServiceCounterDataType getQueryNextCount() throws UaException {
        BaseDataVariableTypeNode node = this.getQueryNextCountNode();
        return this.cast(node.getValue().getValue().getValue(), ServiceCounterDataType.class);
    }

    @Override
    public void setQueryNextCount(ServiceCounterDataType queryNextCount) throws UaException {
        BaseDataVariableTypeNode node = this.getQueryNextCountNode();
        ExtensionObject value = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)queryNextCount);
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ServiceCounterDataType readQueryNextCount() throws UaException {
        try {
            return this.readQueryNextCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeQueryNextCount(ServiceCounterDataType queryNextCount) throws UaException {
        try {
            this.writeQueryNextCountAsync(queryNextCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ServiceCounterDataType> readQueryNextCountAsync() {
        return ((CompletableFuture)this.getQueryNextCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), ServiceCounterDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeQueryNextCountAsync(ServiceCounterDataType queryNextCount) {
        ExtensionObject encoded = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)queryNextCount);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getQueryNextCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getQueryNextCountNode() throws UaException {
        try {
            return this.getQueryNextCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getQueryNextCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "QueryNextCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public ServiceCounterDataType getRegisterNodesCount() throws UaException {
        BaseDataVariableTypeNode node = this.getRegisterNodesCountNode();
        return this.cast(node.getValue().getValue().getValue(), ServiceCounterDataType.class);
    }

    @Override
    public void setRegisterNodesCount(ServiceCounterDataType registerNodesCount) throws UaException {
        BaseDataVariableTypeNode node = this.getRegisterNodesCountNode();
        ExtensionObject value = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)registerNodesCount);
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ServiceCounterDataType readRegisterNodesCount() throws UaException {
        try {
            return this.readRegisterNodesCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeRegisterNodesCount(ServiceCounterDataType registerNodesCount) throws UaException {
        try {
            this.writeRegisterNodesCountAsync(registerNodesCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ServiceCounterDataType> readRegisterNodesCountAsync() {
        return ((CompletableFuture)this.getRegisterNodesCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), ServiceCounterDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeRegisterNodesCountAsync(ServiceCounterDataType registerNodesCount) {
        ExtensionObject encoded = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)registerNodesCount);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getRegisterNodesCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getRegisterNodesCountNode() throws UaException {
        try {
            return this.getRegisterNodesCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getRegisterNodesCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "RegisterNodesCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }

    @Override
    public ServiceCounterDataType getUnregisterNodesCount() throws UaException {
        BaseDataVariableTypeNode node = this.getUnregisterNodesCountNode();
        return this.cast(node.getValue().getValue().getValue(), ServiceCounterDataType.class);
    }

    @Override
    public void setUnregisterNodesCount(ServiceCounterDataType unregisterNodesCount) throws UaException {
        BaseDataVariableTypeNode node = this.getUnregisterNodesCountNode();
        ExtensionObject value = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)unregisterNodesCount);
        node.setValue(new Variant((Object)value));
    }

    @Override
    public ServiceCounterDataType readUnregisterNodesCount() throws UaException {
        try {
            return this.readUnregisterNodesCountAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeUnregisterNodesCount(ServiceCounterDataType unregisterNodesCount) throws UaException {
        try {
            this.writeUnregisterNodesCountAsync(unregisterNodesCount).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends ServiceCounterDataType> readUnregisterNodesCountAsync() {
        return ((CompletableFuture)this.getUnregisterNodesCountNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), ServiceCounterDataType.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeUnregisterNodesCountAsync(ServiceCounterDataType unregisterNodesCount) {
        ExtensionObject encoded = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)unregisterNodesCount);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getUnregisterNodesCountNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public BaseDataVariableTypeNode getUnregisterNodesCountNode() throws UaException {
        try {
            return this.getUnregisterNodesCountNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends BaseDataVariableTypeNode> getUnregisterNodesCountNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "UnregisterNodesCount", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=47"), false);
        return future.thenApply(node -> (BaseDataVariableTypeNode)node);
    }
}

