/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.helpers;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.DoubleStream;
import java.util.stream.Stream;
import org.eclipse.core.resources.IProject;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.helpers.ModelHelper;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.Demultiplexer;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.HiddenElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.preferences.PreferenceProvider;

public final class FBShapeHelper {
    public static final double IEC61499_LINE_HEIGHT = 100.0;
    private static final double AVARAGE_CHAR_WIDTH = CoordinateConverter.INSTANCE.screenToIEC61499((int)CoordinateConverter.INSTANCE.getAverageCharacterWidth());
    private static final double WIDTH_ADJUST_NAME = CoordinateConverter.INSTANCE.screenToIEC61499(5);
    private static final double WIDTH_ADJUST_TYPE_NAME = CoordinateConverter.INSTANCE.screenToIEC61499(47);
    private static final double WIDTH_ADJUST_STRUCT_NAME = CoordinateConverter.INSTANCE.screenToIEC61499(48);
    private static final double WIDTH_ADJUST_INTERFACE = CoordinateConverter.INSTANCE.screenToIEC61499(12);
    private static final double WIDTH_ADJUST_INTERFACE_ADAPTER = CoordinateConverter.INSTANCE.screenToIEC61499(17);
    private static final double WIDTH_ADJUST_INTERFACE_INOUT = CoordinateConverter.INSTANCE.screenToIEC61499(18);
    private static final double WIDTH_ADJUST_HIDDEN = CoordinateConverter.INSTANCE.screenToIEC61499(21);
    private static final double WIDTH_ADJUST_SUBAPP_INTERFACE = CoordinateConverter.INSTANCE.screenToIEC61499(35);
    private static final double HEIGHT_ADJUST = CoordinateConverter.INSTANCE.screenToIEC61499(7);
    private static final double HEIGHT_ADJUST_MUX = CoordinateConverter.INSTANCE.screenToIEC61499(8);
    private static final double HEIGHT_ADJUST_HIDDEN = CoordinateConverter.INSTANCE.screenToIEC61499(15);
    private static final double HEIGHT_ADJUST_SUBAPP = CoordinateConverter.INSTANCE.screenToIEC61499(19);

    public static double getWidth(BlockFBNetworkElement element) {
        IProject project = ModelHelper.getProjectFromContext(element);
        int minPinLabelSize = PreferenceProvider.getInt("org.eclipse.fordiac.ide.model", "MinPinLabelSize", 0, project);
        int maxPinLabelSize = PreferenceProvider.getInt("org.eclipse.fordiac.ide.model", "MaxPinLabelSize", 60, project) + 1;
        int maxTypeLabelSize = PreferenceProvider.getInt("org.eclipse.fordiac.ide.model", "MaxTypeLabelSize", 120, project) + 1;
        double nameWidth = (double)element.getName().length() * AVARAGE_CHAR_WIDTH + WIDTH_ADJUST_NAME;
        double typeNameWidth = (double)FBShapeHelper.getTypeNameCharacters(element, maxTypeLabelSize) * AVARAGE_CHAR_WIDTH + WIDTH_ADJUST_TYPE_NAME;
        double structNameWidth = FBShapeHelper.getStructNameWidth(element);
        double inputWidthTop = FBShapeHelper.getMaxEventPinWidth(element.getInterface().getEventInputs().stream(), minPinLabelSize, maxPinLabelSize);
        double outputWidthTop = FBShapeHelper.getMaxEventPinWidth(element.getInterface().getEventOutputs().stream(), minPinLabelSize, maxPinLabelSize);
        double inputWidthBottom = FBShapeHelper.getMaxPinWidth(element, minPinLabelSize, maxPinLabelSize, true);
        double outputWidthBottom = FBShapeHelper.getMaxPinWidth(element, minPinLabelSize, maxPinLabelSize, false);
        double interfaceWidth = Math.max(inputWidthTop + outputWidthTop, inputWidthBottom + outputWidthBottom);
        return DoubleStream.of(nameWidth, typeNameWidth, structNameWidth, interfaceWidth).max().orElse(0.0);
    }

    public static double getHeight(BlockFBNetworkElement element) {
        int fbLines = element instanceof StructManipulator ? 3 : 2;
        InterfaceList interfaceList = element.getInterface();
        int eventLines = FBShapeHelper.getMaxLinesCounter(interfaceList.getEventInputs(), interfaceList.getEventOutputs());
        int dataLines = FBShapeHelper.getMaxLinesCounter(interfaceList.getInputVars(), interfaceList.getOutputVars());
        int adapterLines = FBShapeHelper.getMaxLinesCounter(interfaceList.getPlugs(), interfaceList.getSockets());
        int inOutLines = FBShapeHelper.getMaxLinesCounter(interfaceList.getInOutVars(), interfaceList.getOutMappedInOutVars());
        int errorLines = FBShapeHelper.getMaxLinesCounter(interfaceList.getErrorMarker().stream().filter(IInterfaceElement::isIsInput), interfaceList.getErrorMarker().stream().filter(Predicate.not(IInterfaceElement::isIsInput)));
        int lines = eventLines + fbLines + dataLines + inOutLines + adapterLines + errorLines;
        double heightAdjust = element instanceof StructManipulator ? HEIGHT_ADJUST_MUX : HEIGHT_ADJUST;
        return (double)lines * 100.0 + FBShapeHelper.getHiddenHeightAdjust(element) + heightAdjust;
    }

    public static double getSubappWidthAdjust(FBNetworkElement element) {
        IProject project = ModelHelper.getProjectFromContext(element);
        int maxInterfaceBarSize = PreferenceProvider.getInt("org.eclipse.fordiac.ide.model", "MaxInterfaceBarSize", 40, project);
        return 2.0 * (AVARAGE_CHAR_WIDTH * (double)maxInterfaceBarSize + WIDTH_ADJUST_SUBAPP_INTERFACE);
    }

    public static double getSubappHeightAdjust(FBNetworkElement element) {
        int commentLines = 1;
        if (element.getComment() != null && !element.getComment().isBlank()) {
            commentLines = (int)((long)commentLines + element.getComment().chars().filter(c -> c == 10).count());
        }
        return (double)(commentLines + 1) * 100.0 + HEIGHT_ADJUST_SUBAPP;
    }

    private static int getTypeNameCharacters(FBNetworkElement element, int maxTypeLabelSize) {
        return element.getTypeName() != null ? Math.min(element.getTypeName().length(), maxTypeLabelSize) : 0;
    }

    private static double getStructNameWidth(FBNetworkElement element) {
        StructManipulator structManipulator;
        if (element instanceof StructManipulator && (structManipulator = (StructManipulator)element).getDataType() != null) {
            return (double)structManipulator.getDataType().getName().length() * AVARAGE_CHAR_WIDTH + WIDTH_ADJUST_STRUCT_NAME;
        }
        return 0.0;
    }

    private static double getMaxEventPinWidth(Stream<Event> pins, int minPinLabelSize, int maxPinLabelSize) {
        int topInputLabelSize = pins.filter(HiddenElement::isVisible).map(INamedElement::getName).mapToInt(String::length).max().orElse(-1);
        if (topInputLabelSize < 0) {
            return 0.0;
        }
        topInputLabelSize = Math.clamp((long)topInputLabelSize, minPinLabelSize, maxPinLabelSize);
        return (double)topInputLabelSize * AVARAGE_CHAR_WIDTH + WIDTH_ADJUST_INTERFACE;
    }

    private static double getMaxPinWidth(BlockFBNetworkElement element, int minPinLabelSize, int maxPinLabelSize, boolean isInput) {
        double hiddenSize;
        Predicate<IInterfaceElement> inputFilter = isInput ? IInterfaceElement::isIsInput : Predicate.not(IInterfaceElement::isIsInput);
        double largestInterface = element.getInterface().getAllInterfaceElements().stream().filter(Predicate.not(Event.class::isInstance)).filter(HiddenElement::isVisible).filter(inputFilter).mapToDouble(ie -> {
            double d;
            IInterfaceElement iInterfaceElement;
            int labelSize = Math.clamp((long)ie.getName().length(), minPinLabelSize, maxPinLabelSize);
            IInterfaceElement iInterfaceElement2 = ie;
            Objects.requireNonNull(iInterfaceElement2);
            IInterfaceElement iInterfaceElement3 = iInterfaceElement = iInterfaceElement2;
            int n3 = 0;
            block4: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{VarDeclaration.class, AdapterDeclaration.class}, (Object)iInterfaceElement3, n3)) {
                    case 0: {
                        VarDeclaration v = (VarDeclaration)iInterfaceElement;
                        if (!v.isInOutVar()) {
                            iInterfaceElement3 = iInterfaceElement;
                            n3 = 1;
                            continue block4;
                        }
                        d = WIDTH_ADJUST_INTERFACE_INOUT;
                        break block4;
                    }
                    case 1: {
                        AdapterDeclaration a = (AdapterDeclaration)iInterfaceElement;
                        d = WIDTH_ADJUST_INTERFACE_ADAPTER;
                        break block4;
                    }
                    default: {
                        d = WIDTH_ADJUST_INTERFACE;
                    }
                }
                break;
            }
            double symbolSize = d;
            return (double)labelSize * AVARAGE_CHAR_WIDTH + symbolSize;
        }).max().orElse(0.0);
        if (largestInterface < WIDTH_ADJUST_HIDDEN && (hiddenSize = FBShapeHelper.getHiddenWidthAdjust(element, isInput)) != 0.0) {
            return hiddenSize;
        }
        return largestInterface;
    }

    protected static double getHiddenWidthAdjust(BlockFBNetworkElement element, boolean isInput) {
        Predicate<IInterfaceElement> inputFilter;
        Predicate<IInterfaceElement> predicate = inputFilter = isInput ? IInterfaceElement::isIsInput : Predicate.not(IInterfaceElement::isIsInput);
        if (element.getInterface().getAllInterfaceElements().stream().filter(inputFilter).anyMatch(Predicate.not(HiddenElement::isVisible)) || !isInput && FBShapeHelper.checkHiddenDemuxPin(element)) {
            return WIDTH_ADJUST_HIDDEN;
        }
        return 0.0;
    }

    protected static double getHiddenHeightAdjust(BlockFBNetworkElement element) {
        if (element.getInterface().getAllInterfaceElements().stream().anyMatch(Predicate.not(HiddenElement::isVisible)) || FBShapeHelper.checkHiddenDemuxPin(element)) {
            return HEIGHT_ADJUST_HIDDEN;
        }
        return 0.0;
    }

    private static boolean checkHiddenDemuxPin(FBNetworkElement element) {
        int allVars;
        int visibleVars;
        Demultiplexer demux;
        return element instanceof Demultiplexer && (demux = (Demultiplexer)element).getDataType() != null && (visibleVars = demux.getMemberVars().size()) != (allVars = ((StructuredType)demux.getDataType()).getMemberVariables().size());
    }

    private static int getMaxLinesCounter(List<? extends IInterfaceElement> inputPins, List<? extends IInterfaceElement> outputPins) {
        return FBShapeHelper.getMaxLinesCounter(inputPins.stream(), outputPins.stream());
    }

    private static int getMaxLinesCounter(Stream<? extends IInterfaceElement> inputPins, Stream<? extends IInterfaceElement> outputPins) {
        return Math.max(FBShapeHelper.countVisiblePins(inputPins), FBShapeHelper.countVisiblePins(outputPins));
    }

    private static int countVisiblePins(Stream<? extends IInterfaceElement> pins) {
        return (int)pins.filter(HiddenElement::isVisible).count();
    }

    private FBShapeHelper() {
        throw new UnsupportedOperationException();
    }
}

