/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.contracts;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.fordiac.ide.contracts.CInterval;
import org.eclipse.fordiac.ide.contracts.ContractIssue;
import org.eclipse.fordiac.ide.contracts.ContractRule;
import org.eclipse.fordiac.ide.contracts.ContractSystem;
import org.eclipse.fordiac.ide.contracts.EventOccurrence;

public record DynamicCheckResult(ContractSystem system, List<RuleData> rules) {
    public DynamicCheckResult(ContractSystem system) {
        this(system, new ArrayList<RuleData>());
    }

    public List<ContractIssue> issues() {
        return this.system.getIssues();
    }

    public static class RuleData {
        private final ContractRule rule;
        private final List<CInterval> intervals;
        private final List<EventOccurrence> markers;
        private Deque<EventOccurrence> causalFIFO;
        private Deque<EventOccurrence> causalLIFO;
        private Map<String, EventOccurrence> causalID;
        private final boolean[] slidingWindow;
        private boolean[] triggerSet;
        private int triggerSequence;

        public RuleData(ContractRule rule) {
            this.rule = rule;
            this.intervals = new ArrayList<CInterval>();
            this.markers = new ArrayList<EventOccurrence>();
            ContractRule.SlidingWindow nOutOfM = rule.getNOutOfM();
            if (nOutOfM != null && nOutOfM.n() != nOutOfM.outOf()) {
                this.slidingWindow = new boolean[nOutOfM.outOf()];
                Arrays.fill(this.slidingWindow, true);
            } else {
                this.slidingWindow = null;
            }
            if (rule.getType() == ContractRule.Type.REACTION) {
                this.triggerSet = new boolean[rule.getInputs().size()];
            } else if (rule.getType() == ContractRule.Type.AGE) {
                this.triggerSet = new boolean[rule.getOutputs().size()];
            }
            if (rule.getType() == ContractRule.Type.CAUSAL_REACTION || rule.getType() == ContractRule.Type.CAUSAL_AGE) {
                switch (rule.getCausalRelation()) {
                    case FIFO: {
                        this.causalFIFO = new ArrayDeque<EventOccurrence>();
                        break;
                    }
                    case LIFO: {
                        this.causalLIFO = new ArrayDeque<EventOccurrence>();
                        break;
                    }
                    case ID: {
                        this.causalID = new HashMap<String, EventOccurrence>();
                        break;
                    }
                }
            }
        }

        public boolean hasSlidingWindow() {
            return this.slidingWindow != null;
        }

        public boolean add2SlidingWindow(boolean fulfill) {
            int fulfillCount = 0;
            int i = 0;
            while (i < this.slidingWindow.length - 1) {
                this.slidingWindow[i] = this.slidingWindow[i + 1];
                if (this.slidingWindow[i]) {
                    ++fulfillCount;
                }
                ++i;
            }
            this.slidingWindow[this.slidingWindow.length - 1] = fulfill;
            if (fulfill) {
                ++fulfillCount;
            }
            return fulfillCount >= this.rule.getNOutOfM().n();
        }

        public boolean triggerOccurred(EventOccurrence eo, int index) {
            if (this.rule.getType() == ContractRule.Type.REACTION ? this.rule.inputIsSequence() : this.rule.outputIsSequence()) {
                return this.sequenceTrigger(eo);
            }
            return this.setTrigger(index);
        }

        private boolean sequenceTrigger(EventOccurrence eo) {
            List<String> seq;
            List<String> list = seq = this.rule.getType() == ContractRule.Type.REACTION ? this.rule.getInputs() : this.rule.getOutputs();
            if (eo.eventName().endsWith(seq.get(this.triggerSequence))) {
                ++this.triggerSequence;
                if (this.triggerSequence >= seq.size()) {
                    this.triggerSequence = 0;
                    return true;
                }
            }
            return false;
        }

        private boolean setTrigger(int index) {
            this.triggerSet[index] = true;
            boolean[] blArray = this.triggerSet;
            int n = this.triggerSet.length;
            int n2 = 0;
            while (n2 < n) {
                boolean entry = blArray[n2];
                if (!entry) {
                    return false;
                }
                ++n2;
            }
            Arrays.fill(this.triggerSet, false);
            return true;
        }

        public boolean rememberCausalEvent(EventOccurrence eo) {
            if (this.causalFIFO != null) {
                this.causalFIFO.offer(eo);
            } else if (this.causalLIFO != null) {
                this.causalLIFO.push(eo);
            } else if (this.causalID != null) {
                return this.causalID.put(eo.eventID(), eo) == null;
            }
            return true;
        }

        public EventOccurrence getAssociatedCausalEvent(EventOccurrence eo) {
            if (this.causalFIFO != null) {
                return this.causalFIFO.isEmpty() ? null : this.causalFIFO.poll();
            }
            if (this.causalLIFO != null) {
                return this.causalLIFO.isEmpty() ? null : this.causalLIFO.pop();
            }
            if (this.causalID != null) {
                return this.causalID.remove(eo.eventID());
            }
            return null;
        }

        public SearchResult searchInterval(CInterval interval) {
            boolean isSequence;
            List<String> ports;
            if (this.rule.getType() == ContractRule.Type.REACTION) {
                ports = this.rule.getOutputs();
                isSequence = this.rule.outputIsSequence();
            } else {
                ports = this.rule.getInputs();
                isSequence = this.rule.inputIsSequence();
            }
            if (isSequence) {
                return this.searchForSequence(interval, ports, this.rule.isOnce());
            }
            return this.searchForSet(interval, ports, this.rule.isOnce());
        }

        private SearchResult searchForSequence(CInterval inter, List<String> ports, boolean once) {
            int sequenceIdx = 0;
            int eventIdx = RuleData.firstIndex(this.markers, inter);
            boolean checkingOnce = false;
            for (EventOccurrence eo : RuleData.iterateInterval(this.markers, inter)) {
                ++eventIdx;
                if (eo.type() != EventOccurrence.Type.RECORDED || !eo.eventName().endsWith(ports.get(sequenceIdx)) || ++sequenceIdx < ports.size()) continue;
                EventOccurrence.State state = checkingOnce ? EventOccurrence.State.ISSUE : EventOccurrence.State.FULFILLING;
                int j = 0;
                while (j < ports.size()) {
                    EventOccurrence eoSeq = this.markers.get(eventIdx - ports.size() + j);
                    eoSeq.setState(state);
                    ++j;
                }
                if (once) {
                    sequenceIdx = 0;
                    once = false;
                    checkingOnce = true;
                    continue;
                }
                if (checkingOnce) {
                    return SearchResult.TOO_OFTEN;
                }
                return SearchResult.VALID;
            }
            return checkingOnce ? SearchResult.VALID : SearchResult.MISSED;
        }

        private SearchResult searchForSet(CInterval inter, List<String> ports, boolean once) {
            HashSet<String> set = new HashSet<String>(ports);
            ArrayList<EventOccurrence> fulfill = new ArrayList<EventOccurrence>(set.size());
            boolean checkingOnce = false;
            for (EventOccurrence eo : RuleData.iterateInterval(this.markers, inter)) {
                if (eo.type() != EventOccurrence.Type.RECORDED || !set.remove(eo.getShortName())) continue;
                fulfill.add(eo);
                if (!set.isEmpty()) continue;
                EventOccurrence.State state = checkingOnce ? EventOccurrence.State.ISSUE : EventOccurrence.State.FULFILLING;
                for (EventOccurrence eoSet : fulfill) {
                    eoSet.setState(state);
                }
                if (once) {
                    set.addAll(ports);
                    fulfill.clear();
                    once = false;
                    checkingOnce = true;
                    continue;
                }
                if (checkingOnce) {
                    return SearchResult.TOO_OFTEN;
                }
                return SearchResult.VALID;
            }
            return checkingOnce ? SearchResult.VALID : SearchResult.MISSED;
        }

        private static Iterable<EventOccurrence> iterateInterval(final List<EventOccurrence> list, final CInterval interval) {
            return () -> new Iterator<EventOccurrence>(){
                int index;
                {
                    this.index = RuleData.firstIndex(list2, cInterval);
                }

                @Override
                public boolean hasNext() {
                    return this.index < list.size() && interval.contains(((EventOccurrence)list.get(this.index)).timestampNs());
                }

                @Override
                public EventOccurrence next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    int i = this.index++;
                    return (EventOccurrence)list.get(i);
                }
            };
        }

        private static int firstIndex(List<EventOccurrence> list, CInterval interval) {
            EventOccurrence key = new EventOccurrence("", interval.getLowerBound());
            int index = Collections.binarySearch(list, key);
            if (index < 0) {
                index = Math.abs(index + 1);
            }
            if (index < list.size() && !interval.contains(list.get(index).timestampNs())) {
                ++index;
            }
            return index;
        }

        public ContractRule rule() {
            return this.rule;
        }

        public List<CInterval> intervals() {
            return this.intervals;
        }

        public List<EventOccurrence> markers() {
            return this.markers;
        }

        public static enum SearchResult {
            VALID,
            MISSED,
            TOO_OFTEN;

        }
    }
}

