/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.util.comm.datatypes;

import java.io.DataInputStream;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_ANY;
import org.eclipse.fordiac.ide.util.comm.datatypes.IEC_ANY_DATE;
import org.eclipse.fordiac.ide.util.comm.exceptions.DataTypeValueOutOfBoundsException;

public class IEC_TIME_OF_DAY
extends IEC_ANY_DATE {
    public IEC_TIME_OF_DAY() {
        Calendar c = Calendar.getInstance();
        this.reduceToTime(c);
        this.value = c.getTimeInMillis();
    }

    public IEC_TIME_OF_DAY(long initial) {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date(initial));
        this.reduceToTime(c);
        this.value = c.getTimeInMillis();
    }

    public IEC_TIME_OF_DAY(Date initial) {
        Calendar c = Calendar.getInstance();
        c.setTime(initial);
        this.reduceToTime(c);
        this.value = initial.getTime();
    }

    public IEC_TIME_OF_DAY(String initial) {
        this.fromString(initial);
    }

    private void fromString(String paValueString) throws DataTypeValueOutOfBoundsException, NumberFormatException {
        String valueString = paValueString.toLowerCase();
        if (!valueString.startsWith("tod#") && !valueString.startsWith("time_of_day#")) {
            throw new DataTypeValueOutOfBoundsException("Illegal value");
        }
        valueString = valueString.split("#")[1];
        Calendar c = Calendar.getInstance();
        c.clear();
        String[] time = valueString.split(":");
        if (time.length != 3) {
            throw new DataTypeValueOutOfBoundsException("Illegal value");
        }
        c.set(11, Integer.parseInt(time[0]));
        c.set(12, Integer.parseInt(time[1]));
        float seconds = Float.parseFloat(time[2]);
        c.set(13, (int)seconds);
        c.set(14, (int)(seconds - (float)((int)seconds)) * 1000);
        this.value = c.getTimeInMillis();
    }

    public IEC_TIME_OF_DAY(DataInputStream in) {
        super(in);
    }

    @Override
    public byte[] encodeTag() {
        byte[] retval = new byte[]{78};
        return retval;
    }

    private void reduceToTime(Calendar c) {
        int[] temp = new int[]{c.get(11), c.get(12), c.get(13), c.get(14)};
        c.clear();
        c.set(11, temp[0]);
        c.set(12, temp[1]);
        c.set(13, temp[2]);
        c.set(14, temp[3]);
    }

    @Override
    public boolean setValue(IEC_ANY source) {
        boolean retval = false;
        if (source.getClass().equals(this.getClass())) {
            this.value = ((IEC_TIME_OF_DAY)source).getValue();
            retval = true;
        }
        return retval;
    }

    @Override
    public boolean setValue(String source) {
        try {
            this.fromString(source);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }
}

