/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemconfiguration.properties;

import java.util.List;
import org.eclipse.fordiac.ide.deployment.DeploymentCoordinator;
import org.eclipse.fordiac.ide.deployment.IDeploymentExecutor;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeNameCommand;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.systemconfiguration.commands.ChangeProfileCommand;
import org.eclipse.fordiac.ide.systemconfiguration.editparts.DeviceEditPart;
import org.eclipse.fordiac.ide.systemconfiguration.properties.AbstractDevResInterfaceSection;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class DeviceInterfaceSection
extends AbstractDevResInterfaceSection {
    private static String[] profileNames = null;
    private Combo profile;

    protected Device getInputType(Object input) {
        if (input instanceof DeviceEditPart) {
            return ((DeviceEditPart)((Object)input)).getModel();
        }
        return null;
    }

    @Override
    protected void createFBInfoGroup(Composite parent) {
        Composite composite = this.getWidgetFactory().createComposite(parent);
        composite.setLayout((Layout)new GridLayout(4, false));
        composite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.getWidgetFactory().createCLabel(composite, "Instance Name:");
        this.nameText = this.createGroupText(composite, true);
        this.nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DeviceInterfaceSection.this.removeContentAdapter();
                DeviceInterfaceSection.this.executeCommand((Command)new ChangeNameCommand(DeviceInterfaceSection.this.getType(), DeviceInterfaceSection.this.nameText.getText()));
                DeviceInterfaceSection.this.addContentAdapter();
            }
        });
        this.getWidgetFactory().createCLabel(composite, "Profile:");
        this.profile = new Combo(composite, 12);
        this.profile.setItems(DeviceInterfaceSection.getAvailableProfileNames());
        this.profile.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DeviceInterfaceSection.this.removeContentAdapter();
                DeviceInterfaceSection.this.executeCommand(new ChangeProfileCommand((Device)DeviceInterfaceSection.this.getType(), DeviceInterfaceSection.this.profile.getText()));
                DeviceInterfaceSection.this.refresh();
                DeviceInterfaceSection.this.addContentAdapter();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.getWidgetFactory().createCLabel(composite, "Instance Comment:");
        this.commentText = this.createGroupText(composite, true);
        GridData gridData = new GridData(4, 0, true, false);
        gridData.horizontalSpan = 3;
        this.commentText.setLayoutData((Object)gridData);
        this.commentText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DeviceInterfaceSection.this.removeContentAdapter();
                DeviceInterfaceSection.this.executeCommand((Command)new ChangeCommentCommand(DeviceInterfaceSection.this.getType(), DeviceInterfaceSection.this.commentText.getText()));
                DeviceInterfaceSection.this.addContentAdapter();
            }
        });
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.type != null) {
            this.setProfile();
        }
    }

    private void setProfile() {
        int i = 0;
        String[] stringArray = this.profile.getItems();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String p = stringArray[n2];
            if (p.equals(((Device)this.getType()).getProfile())) {
                this.profile.select(i);
                break;
            }
            ++i;
            ++n2;
        }
    }

    private static String[] getAvailableProfileNames() {
        if (profileNames == null) {
            List deploymentExecutors = DeploymentCoordinator.loadDeploymentExecutors();
            String[] newProfileNames = new String[deploymentExecutors.size()];
            int i = 0;
            for (IDeploymentExecutor idepExec : deploymentExecutors) {
                newProfileNames[i] = idepExec.getProfileName();
                ++i;
            }
            profileNames = newProfileNames;
        }
        return profileNames;
    }
}

