/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataexport;

import java.util.List;
import org.eclipse.fordiac.ide.model.dataexport.CommonElementExporter;
import org.eclipse.fordiac.ide.model.dataexport.SubApplicationTypeExporter;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFBType;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.ResourceType;
import org.eclipse.fordiac.ide.model.libraryElement.ResourceTypeFB;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class FBNetworkExporter {
    private final Document dom;

    FBNetworkExporter(Document dom) {
        this.dom = dom;
    }

    Element createFBNetworkElement(FBNetwork fbNetwork) {
        String elementName = "SubAppNetwork";
        if (fbNetwork.eContainer() instanceof FBType && !(fbNetwork.eContainer() instanceof SubAppType) || fbNetwork.eContainer() instanceof Resource || fbNetwork.eContainer() instanceof ResourceType) {
            elementName = "FBNetwork";
        }
        Element fbNetworkElement = this.dom.createElement(elementName);
        this.addFBNetworkElements(fbNetworkElement, fbNetwork);
        this.addConnections(fbNetworkElement, (List<? extends Connection>)fbNetwork.getDataConnections(), "DataConnections", fbNetwork);
        this.addConnections(fbNetworkElement, (List<? extends Connection>)fbNetwork.getEventConnections(), "EventConnections", fbNetwork);
        this.addConnections(fbNetworkElement, (List<? extends Connection>)fbNetwork.getAdapterConnections(), "AdapterConnections", fbNetwork);
        return fbNetworkElement;
    }

    private void addFBNetworkElements(Element fbNetwork, FBNetwork network) {
        for (FBNetworkElement element : network.getNetworkElements()) {
            Element fbElement = this.createFNElementDomNode(element);
            if (fbElement == null) continue;
            CommonElementExporter.setNameAttribute(fbElement, element.getName());
            if (element.getType() != null) {
                CommonElementExporter.setTypeAttribute(fbElement, element.getType());
            }
            CommonElementExporter.setCommentAttribute(fbElement, element);
            CommonElementExporter.exportXandY(element, fbElement);
            CommonElementExporter.addParamsConfig(this.dom, fbElement, element.getInterface().getInputVars());
            fbNetwork.appendChild(fbElement);
        }
    }

    private Element createFNElementDomNode(FBNetworkElement element) {
        if (!(element.getType() instanceof AdapterFBType)) {
            if (element instanceof FB && !(element instanceof ResourceTypeFB)) {
                return this.dom.createElement("FB");
            }
            if (element instanceof SubApp) {
                Element subAppElement = this.dom.createElement("SubApp");
                if (((SubApp)element).getType() == null) {
                    this.createUntypedSubAppcontents(subAppElement, (SubApp)element);
                }
                return subAppElement;
            }
        }
        return null;
    }

    private void createUntypedSubAppcontents(Element subAppElement, SubApp element) {
        new SubApplicationTypeExporter().addInterfaceList(this.dom, subAppElement, element.getInterface());
        if (element.getSubAppNetwork() != null) {
            subAppElement.appendChild(new FBNetworkExporter(this.dom).createFBNetworkElement(element.getSubAppNetwork()));
        }
    }

    private void addConnections(Element fbNetworkElement, List<? extends Connection> connections, String connectionElementName, FBNetwork fbNetwork) {
        Element connectionList = this.dom.createElement(connectionElementName);
        for (Connection connection : connections) {
            this.addConnection(connectionList, connection, fbNetwork);
        }
        if (!connections.isEmpty()) {
            fbNetworkElement.appendChild(connectionList);
        }
    }

    private void addConnection(Element connectionsContainer, Connection connection, FBNetwork fbNetwork) {
        Element connectionElement = this.dom.createElement("Connection");
        if (connection.getSource() != null && connection.getSource().eContainer() instanceof InterfaceList) {
            connectionElement.setAttribute("Source", FBNetworkExporter.getConnectionEndpointIdentifier(connection.getSource(), fbNetwork));
        }
        if (connection.getDestination() != null && connection.getDestination().eContainer() instanceof InterfaceList) {
            connectionElement.setAttribute("Destination", FBNetworkExporter.getConnectionEndpointIdentifier(connection.getDestination(), fbNetwork));
        }
        CommonElementExporter.setCommentAttribute(connectionElement, connection);
        FBNetworkExporter.setConnectionCoordinates(connection, connectionElement);
        connectionsContainer.appendChild(connectionElement);
    }

    private static String getConnectionEndpointIdentifier(IInterfaceElement interfaceElement, FBNetwork fbNetwork) {
        String retVal = "";
        if (interfaceElement.getFBNetworkElement() != null && interfaceElement.getFBNetworkElement().getFbNetwork() == fbNetwork) {
            retVal = String.valueOf(interfaceElement.getFBNetworkElement().getName()) + ".";
        }
        retVal = String.valueOf(retVal) + interfaceElement.getName();
        return retVal;
    }

    private static void setConnectionCoordinates(Connection connection, Element connectionElement) {
        connectionElement.setAttribute("dx1", CommonElementExporter.reConvertCoordinate(connection.getDx1()).toString());
        connectionElement.setAttribute("dx2", CommonElementExporter.reConvertCoordinate(connection.getDx2()).toString());
        connectionElement.setAttribute("dy", CommonElementExporter.reConvertCoordinate(connection.getDy()).toString());
    }
}

