/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.ui.wizard;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.fordiac.ide.deployment.AbstractDeviceManagementCommunicationHandler;
import org.eclipse.fordiac.ide.deployment.DeploymentCoordinator;
import org.eclipse.fordiac.ide.deployment.exceptions.DisconnectException;
import org.eclipse.fordiac.ide.deployment.exceptions.InvalidMgmtID;
import org.eclipse.fordiac.ide.deployment.ui.Activator;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public class BootFileDeviceManagementCommunicationHandler
extends AbstractDeviceManagementCommunicationHandler {
    StringBuffer stringBuffer = new StringBuffer();
    public String origMgrID;

    public static void createBootFile(List<Object> workList, String fileName, Shell shell) {
        if (fileName != null) {
            DeploymentCoordinator deployment = DeploymentCoordinator.getInstance();
            BootFileDeviceManagementCommunicationHandler bootFileHandler = new BootFileDeviceManagementCommunicationHandler();
            deployment.performDeployment(workList.toArray(), (AbstractDeviceManagementCommunicationHandler)bootFileHandler);
            bootFileHandler.writeToBootFile(fileName, shell);
        }
    }

    private BootFileDeviceManagementCommunicationHandler() {
    }

    public void connect(String address) throws InvalidMgmtID, UnknownHostException, IOException {
        this.origMgrID = address;
    }

    public void disconnect() throws DisconnectException {
    }

    public void sendREQ(String destination, String request) throws IOException {
        this.stringBuffer.append(String.valueOf(destination) + ";" + request + "\n");
        String info = this.origMgrID;
        if (!destination.equals("")) {
            info = String.valueOf(info) + ": " + destination;
        }
        this.postCommandSent(info, destination, request);
    }

    public void writeToBootFile(String fileName, Shell shell) {
        File bootFile = new File(fileName);
        int res = 64;
        if (bootFile.exists()) {
            MessageBox msgBox = new MessageBox(shell, 196);
            String msg = MessageFormat.format("File Exists, overwrite {0}?", bootFile.getAbsolutePath());
            msgBox.setMessage(msg);
            res = msgBox.open();
        } else {
            try {
                bootFile.createNewFile();
            }
            catch (IOException e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
        }
        if (res == 64) {
            try {
                PrintWriter boot = new PrintWriter(new FileOutputStream(bootFile));
                boot.write(this.stringBuffer.toString());
                boot.flush();
                boot.close();
            }
            catch (FileNotFoundException e) {
                Activator.getDefault().logError(e.getMessage(), e);
            }
        }
    }

    public void clearStringBuffer() {
        this.stringBuffer = new StringBuffer();
    }

    public void sendQUERY(String destination, String request) throws IOException {
    }
}

