/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.BorderLayout;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.fordiac.ide.application.ApplicationPlugin;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.editparts.AbstractFBNElementEditPart;
import org.eclipse.fordiac.ide.application.figures.FBNetworkElementTooltipFigure;
import org.eclipse.fordiac.ide.gef.Activator;
import org.eclipse.fordiac.ide.gef.draw2d.AdvancedRoundedRectangle;
import org.eclipse.fordiac.ide.gef.draw2d.ITransparencyFigure;
import org.eclipse.fordiac.ide.gef.draw2d.SetableAlphaLabel;
import org.eclipse.fordiac.ide.gef.draw2d.UnderlineAlphaLabel;
import org.eclipse.fordiac.ide.model.Palette.PaletteEntry;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFBType;
import org.eclipse.fordiac.ide.model.libraryElement.Annotation;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.util.imageprovider.FordiacImage;
import org.eclipse.fordiac.ide.util.preferences.PreferenceGetter;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public abstract class AbstractFBNetworkElementFigure
extends Shape
implements ITransparencyFigure {
    protected static final Dimension MIN_DIMENSION = new Dimension(50, 50);
    protected FBNetworkElement model = null;
    protected SetableAlphaLabel instanceNameLabel = null;
    protected RoundedRectangle top;
    protected AdvancedRoundedRectangle middle;
    protected AdvancedRoundedRectangle bottom;
    protected final Figure eventInputs = new Figure();
    protected final Figure eventOutputs = new Figure();
    protected final Figure dataInputs = new Figure();
    protected final Figure sockets = new Figure();
    protected final Figure dataOutputs = new Figure();
    protected final Figure plugs = new Figure();
    protected UnderlineAlphaLabel typeLabel;
    protected AbstractFBNElementEditPart editPart;

    public static void openTypeInEditor(FBNetworkElement element) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        PaletteEntry entry = element.getPaletteEntry();
        if (entry != null) {
            IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(entry.getFile().getName());
            try {
                page.openEditor((IEditorInput)new FileEditorInput(entry.getFile()), desc.getId());
            }
            catch (PartInitException e) {
                ApplicationPlugin.getDefault().logError(e.getMessage(), (Exception)((Object)e));
            }
        }
    }

    protected AbstractFBNetworkElementFigure() {
        this.configureRectangles();
    }

    public ZoomManager getZoomManager() {
        return this.editPart != null ? this.editPart.getZoomManager() : null;
    }

    protected void configureRectangles() {
        IPreferenceStore pf = Activator.getDefault().getPreferenceStore();
        int cornerDim = pf.getInt("CornerDim");
        Color borderColor = this.getBorderColor(this.model.getType());
        this.top = new AdvancedRoundedRectangle(25, this.getZoomManager(), (Figure)this, true, borderColor);
        this.top.setCornerDimensions(new Dimension(cornerDim, cornerDim));
        GridLayout topLayout = new GridLayout(2, false);
        topLayout.marginHeight = 4;
        topLayout.marginWidth = 1;
        topLayout.horizontalSpacing = 2;
        this.top.setLayoutManager((LayoutManager)topLayout);
        this.middle = new AdvancedRoundedRectangle(24, this.getZoomManager(), (Figure)this, true, borderColor);
        this.bottom = new AdvancedRoundedRectangle(28, this.getZoomManager(), (Figure)this, true, borderColor);
        this.bottom.setCornerDimensions(new Dimension(cornerDim, cornerDim));
        GridLayout bottomLayout = new GridLayout(2, false);
        bottomLayout.marginHeight = 4;
        bottomLayout.marginWidth = 1;
        bottomLayout.horizontalSpacing = 0;
        this.bottom.setLayoutManager((LayoutManager)bottomLayout);
    }

    protected Color getBorderColor(LibraryElement type) {
        if (type instanceof AdapterFBType) {
            return PreferenceGetter.getColor((String)"AdapterConnectionConnectorColor");
        }
        return ColorConstants.gray;
    }

    public AbstractFBNetworkElementFigure(FBNetworkElement model, AbstractFBNElementEditPart editPart) {
        this.model = model;
        this.editPart = editPart;
        this.configureRectangles();
        this.setFillXOR(false);
        this.setOpaque(false);
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.verticalSpacing = 2;
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = -1;
        this.setLayoutManager((LayoutManager)gridLayout);
        this.createInstanceNameLabel(model.getName());
        this.add((IFigure)this.top);
        GridData topLayoutData = new GridData(784);
        this.setConstraint((IFigure)this.top, topLayoutData);
        this.setupTopIOs();
        Figure middleContainer = new Figure();
        BorderLayout borderLayout = new BorderLayout();
        middleContainer.setLayoutManager((LayoutManager)borderLayout);
        borderLayout.setHorizontalSpacing(10);
        middleContainer.setBorder((Border)new MarginBorder(0, 7, 0, 7));
        this.add((IFigure)middleContainer);
        GridData middleLayouData = new GridData(768);
        this.setConstraint((IFigure)middleContainer, middleLayouData);
        this.setupTypeNameAndVersion(model, middleContainer);
        GridData bottomLayoutData = new GridData(1808);
        bottomLayoutData.verticalAlignment = 128;
        this.add((IFigure)this.bottom);
        this.setConstraint((IFigure)this.bottom, bottomLayoutData);
        this.setBottomIOs();
        this.refreshToolTips();
        this.updateResourceTypeFigure();
    }

    protected void setupTopIOs() {
        ToolbarLayout topInputsLayout = new ToolbarLayout(false);
        GridData topInputsLayoutData = new GridData(1808);
        this.eventInputs.setLayoutManager((LayoutManager)topInputsLayout);
        this.top.add((IFigure)this.eventInputs);
        this.top.setConstraint((IFigure)this.eventInputs, (Object)topInputsLayoutData);
        ToolbarLayout topOutputsLayout = new ToolbarLayout(false);
        GridData topOutputsLayoutData = new GridData(1680);
        topOutputsLayout.setMinorAlignment(2);
        this.eventOutputs.setLayoutManager((LayoutManager)topOutputsLayout);
        this.top.add((IFigure)this.eventOutputs);
        this.top.setConstraint((IFigure)this.eventOutputs, (Object)topOutputsLayoutData);
    }

    protected void setBottomIOs() {
        Figure bottomInputArea = new Figure();
        bottomInputArea.setLayoutManager((LayoutManager)new ToolbarLayout(false));
        GridData bottomInputsLayoutData = new GridData(1808);
        bottomInputsLayoutData.verticalAlignment = 128;
        this.bottom.add((IFigure)bottomInputArea);
        this.bottom.setConstraint((IFigure)bottomInputArea, (Object)bottomInputsLayoutData);
        this.dataInputs.setLayoutManager((LayoutManager)new ToolbarLayout(false));
        bottomInputArea.add((IFigure)this.dataInputs);
        this.sockets.setLayoutManager((LayoutManager)new ToolbarLayout(false));
        bottomInputArea.add((IFigure)this.sockets);
        Figure bottomOutputArea = new Figure();
        bottomOutputArea.setLayoutManager((LayoutManager)new ToolbarLayout(false));
        ((ToolbarLayout)bottomOutputArea.getLayoutManager()).setMinorAlignment(2);
        GridData bottomOutputsLayoutData = new GridData(656);
        this.bottom.add((IFigure)bottomOutputArea);
        this.bottom.setConstraint((IFigure)bottomOutputArea, (Object)bottomOutputsLayoutData);
        this.dataOutputs.setLayoutManager((LayoutManager)new ToolbarLayout(false));
        ((ToolbarLayout)this.dataOutputs.getLayoutManager()).setMinorAlignment(2);
        bottomOutputArea.add((IFigure)this.dataOutputs);
        this.plugs.setLayoutManager((LayoutManager)new ToolbarLayout(false));
        ((ToolbarLayout)this.plugs.getLayoutManager()).setMinorAlignment(2);
        bottomOutputArea.add((IFigure)this.plugs);
    }

    protected void createInstanceNameLabel(String instanceName) {
        GridData instanceNameLayout = new GridData();
        instanceNameLayout.grabExcessHorizontalSpace = true;
        instanceNameLayout.horizontalAlignment = 0x1000000;
        this.instanceNameLabel = new SetableAlphaLabel();
        this.instanceNameLabel.setText(instanceName);
        this.instanceNameLabel.setTextAlignment(2);
        this.instanceNameLabel.setLabelAlignment(2);
        this.instanceNameLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
        this.add((IFigure)this.instanceNameLabel);
        this.setConstraint((IFigure)this.instanceNameLabel, instanceNameLayout);
    }

    protected void setupTypeNameAndVersion(FBNetworkElement model, Figure container) {
        container.add((IFigure)this.middle, (Object)BorderLayout.CENTER);
        this.middle.setCornerDimensions(new Dimension());
        GridLayout middleLayout = new GridLayout(1, true);
        middleLayout.marginHeight = 0;
        middleLayout.verticalSpacing = 1;
        this.middle.setLayoutManager((LayoutManager)middleLayout);
        LibraryElement type = model.getType();
        String typeName = type != null ? type.getName() : Messages.FBFigure_TYPE_NOT_SET;
        this.typeLabel = new UnderlineAlphaLabel(typeName != null ? typeName : Messages.FBFigure_NOT_DEFINED_Text);
        this.middle.add((IFigure)this.typeLabel);
        this.typeLabel.setTextAlignment(2);
        this.middle.setConstraint((IFigure)this.typeLabel, (Object)new GridData(768));
        this.typeLabel.setOpaque(false);
        this.typeLabel.setFont(JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.defaultfont"));
        this.setupMouseListener(this.editPart);
    }

    private void setupMouseListener(final AbstractFBNElementEditPart editPart) {
        this.middle.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent me) {
            }

            public void mouseEntered(MouseEvent me) {
                if ((me.getState() & 0x40000) != 0 && editPart.isOnlyThisOrNothingSelected()) {
                    AbstractFBNetworkElementFigure.this.typeLabel.setDrawUnderline(true);
                }
            }

            public void mouseExited(MouseEvent me) {
                AbstractFBNetworkElementFigure.this.typeLabel.setDrawUnderline(false);
            }

            public void mouseHover(MouseEvent me) {
                this.mouseMoved(me);
            }

            public void mouseMoved(MouseEvent me) {
                if ((me.getState() & 0x40000) != 0 && editPart.isOnlyThisOrNothingSelected()) {
                    if (!AbstractFBNetworkElementFigure.this.typeLabel.isDrawUnderline()) {
                        AbstractFBNetworkElementFigure.this.typeLabel.setDrawUnderline(true);
                    }
                } else if (AbstractFBNetworkElementFigure.this.typeLabel.isDrawUnderline()) {
                    AbstractFBNetworkElementFigure.this.typeLabel.setDrawUnderline(false);
                }
            }
        });
        this.middle.addMouseListener((MouseListener)this.createOpenTypeMouseListener(editPart));
    }

    protected OpenTypeListener createOpenTypeMouseListener(AbstractFBNElementEditPart editPart) {
        return new OpenTypeListener(editPart);
    }

    protected void updateResourceTypeFigure() {
        if (this.isResoruceTypeFBNElement()) {
            this.getInstanceNameLabel().setIcon(FordiacImage.ICON_LockedState.getImage());
        }
    }

    private void updateOverlay() {
        Image image = this.getInstanceNameLabel().getIcon();
        for (Annotation anno : this.model.getAnnotations()) {
            if (anno.getServity() != 2) continue;
            image = FordiacImage.getErrorOverlayImage((Image)image);
            break;
        }
        if (this.model.getPaletteEntry() == null && !(this.model instanceof SubApp)) {
            image = FordiacImage.getErrorOverlayImage((Image)image);
        }
        this.getInstanceNameLabel().setIcon(image);
    }

    public void refreshIcon() {
        if (this.isResoruceTypeFBNElement()) {
            this.updateResourceTypeFigure();
        } else {
            this.getInstanceNameLabel().setIcon(null);
        }
        this.updateOverlay();
    }

    public String toString() {
        return String.valueOf(this.model.getTypeName()) + ":" + this.model.getName();
    }

    public SetableAlphaLabel getInstanceNameLabel() {
        return this.instanceNameLabel;
    }

    public void refreshToolTips() {
        this.setToolTip((IFigure)new FBNetworkElementTooltipFigure(this.model));
    }

    public Figure getEventInputs() {
        return this.eventInputs;
    }

    public Figure getEventOutputs() {
        return this.eventOutputs;
    }

    public Figure getDataInputs() {
        return this.dataInputs;
    }

    public Figure getSockets() {
        return this.sockets;
    }

    public Figure getDataOutputs() {
        return this.dataOutputs;
    }

    public Figure getPlugs() {
        return this.plugs;
    }

    protected void fillShape(Graphics graphics) {
    }

    protected void outlineShape(Graphics graphics) {
    }

    public void setAlpha(int value) {
        super.setAlpha(value);
        this.bottom.setAlpha(value);
        this.top.setAlpha(value);
        this.middle.setAlpha(value);
        if (this.instanceNameLabel != null) {
            this.instanceNameLabel.setAlpha(value);
        }
        if (this.typeLabel != null) {
            this.typeLabel.setAlpha(value);
        }
    }

    public void setTransparency(int value) {
        this.setAlpha(value);
    }

    public int getTransparency() {
        return this.getAlpha();
    }

    public Image getIcon() {
        return this.getInstanceNameLabel().getIcon();
    }

    public void setIcon(Image image) {
        this.getInstanceNameLabel().setIcon(image);
    }

    protected abstract boolean isResoruceTypeFBNElement();

    private final class OpenTypeListener
    implements MouseListener {
        final AbstractFBNElementEditPart editPart;

        public OpenTypeListener(AbstractFBNElementEditPart editPart) {
            this.editPart = editPart;
        }

        public void mousePressed(MouseEvent me) {
            if ((me.getState() & 0x40000) != 0 && this.editPart.isOnlyThisOrNothingSelected()) {
                AbstractFBNetworkElementFigure.openTypeInEditor(this.editPart.getModel());
            }
        }

        public void mouseReleased(MouseEvent me) {
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }
    }
}

