/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.editors;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.fordiac.ide.application.actions.CopyEditPartsAction;
import org.eclipse.fordiac.ide.application.actions.DeleteFBNetworkAction;
import org.eclipse.fordiac.ide.application.actions.FBNetworkSelectAllAction;
import org.eclipse.fordiac.ide.application.actions.PasteEditPartsAction;
import org.eclipse.fordiac.ide.application.actions.SaveAsSubApplicationTypeAction;
import org.eclipse.fordiac.ide.application.actions.UnmapAction;
import org.eclipse.fordiac.ide.application.actions.UnmapAllAction;
import org.eclipse.fordiac.ide.application.actions.UpdateFBTypeAction;
import org.eclipse.fordiac.ide.application.editors.FBTypePaletteViewerProvider;
import org.eclipse.fordiac.ide.application.editors.UIFBNetworkContextMenuProvider;
import org.eclipse.fordiac.ide.application.editparts.ConnectionEditPart;
import org.eclipse.fordiac.ide.application.editparts.ElementEditPartFactory;
import org.eclipse.fordiac.ide.application.editparts.FBEditPart;
import org.eclipse.fordiac.ide.application.editparts.SubAppForFBNetworkEditPart;
import org.eclipse.fordiac.ide.application.utilities.ApplicationEditorTemplateTransferDropTargetListener;
import org.eclipse.fordiac.ide.application.utilities.FBNetworkFlyoutPreferences;
import org.eclipse.fordiac.ide.gef.DiagramEditorWithFlyoutPalette;
import org.eclipse.fordiac.ide.gef.editparts.ZoomScalableFreeformRootEditPart;
import org.eclipse.fordiac.ide.model.Palette.Palette;
import org.eclipse.fordiac.ide.model.libraryElement.Application;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.systemmanagement.ISystemEditor;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.fordiac.ide.util.PersistableUntypedEditorInput;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.tools.MarqueeDragTracker;
import org.eclipse.gef.tools.MarqueeSelectionTool;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;

public class FBNetworkEditor
extends DiagramEditorWithFlyoutPalette
implements ISystemEditor {
    EContentAdapter adapter = new EContentAdapter(){

        public void notifyChanged(Notification notification) {
            int type = notification.getEventType();
            int featureId = notification.getFeatureID(Application.class);
            switch (type) {
                case 1: {
                    if (featureId != 1) break;
                    FBNetworkEditor.this.setPartName(FBNetworkEditor.this.getModel().getApplication().getName());
                    break;
                }
            }
        }
    };
    private FBNetwork model;

    protected void setModel(FBNetwork model) {
        this.model = model;
    }

    public CommandStack getFBEditorCommandStack() {
        return this.getCommandStack();
    }

    protected ScalableFreeformRootEditPart createRootEditPart() {
        return new ZoomScalableFreeformRootEditPart(this.getSite(), this.getActionRegistry()){

            public DragTracker getDragTracker(Request req) {
                MarqueeDragTracker dragTracker = new MarqueeDragTracker(){
                    static final int DEFAULT_MODE = 0;
                    static final int TOGGLE_MODE = 1;

                    protected void performMarqueeSelect() {
                        Collection marqueeSelectedEditParts = this.calculateMarqueeSelectedEditParts();
                        LinkedHashSet<EditPart> editPartsToSelect = new LinkedHashSet<EditPart>();
                        HashSet<EditPart> editPartsToDeselect = new HashSet<EditPart>();
                        for (EditPart affectedEditPart : marqueeSelectedEditParts) {
                            if (affectedEditPart.getSelected() == 0 || this.getCurrentSelectionMode() != 1) {
                                if (!(affectedEditPart instanceof FBEditPart) && !(affectedEditPart instanceof ConnectionEditPart) && !(affectedEditPart instanceof SubAppForFBNetworkEditPart)) continue;
                                editPartsToSelect.add(affectedEditPart);
                                continue;
                            }
                            editPartsToDeselect.add(affectedEditPart);
                        }
                        if (this.getCurrentSelectionMode() != 0) {
                            editPartsToSelect.addAll(this.getCurrentViewer().getSelectedEditParts());
                            editPartsToSelect.removeAll(editPartsToDeselect);
                        }
                        this.getCurrentViewer().setSelection((ISelection)new StructuredSelection(editPartsToSelect.toArray()));
                    }
                };
                dragTracker.setMarqueeBehavior(MarqueeSelectionTool.BEHAVIOR_NODES_CONTAINED_AND_RELATED_CONNECTIONS);
                return dragTracker;
            }
        };
    }

    public FBNetwork getModel() {
        return this.model;
    }

    protected EditPartFactory getEditPartFactory() {
        return new ElementEditPartFactory((GraphicalEditor)this, this.getZoomManger());
    }

    protected ContextMenuProvider getContextMenuProvider(ScrollingGraphicalViewer viewer, ZoomManager zoomManager) {
        UIFBNetworkContextMenuProvider cmp = new UIFBNetworkContextMenuProvider(this, this.getActionRegistry(), zoomManager, this.getPalette());
        return cmp;
    }

    protected Palette getPalette() {
        return this.getSystem().getPalette();
    }

    protected TransferDropTargetListener createTransferDropTargetListener() {
        return new ApplicationEditorTemplateTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer(), this.getSystem());
    }

    protected void setModel(IEditorInput input) {
        if (input instanceof PersistableUntypedEditorInput) {
            PersistableUntypedEditorInput untypedInput = (PersistableUntypedEditorInput)input;
            Object content = untypedInput.getContent();
            if (content instanceof Application) {
                Application app = (Application)content;
                this.model = app.getFBNetwork();
                app.eAdapters().add((Object)this.adapter);
            }
            if (input.getName() != null) {
                this.setPartName(input.getName());
            }
        }
        super.setModel(input);
    }

    protected void configureGraphicalViewer() {
        super.configureGraphicalViewer();
        CopyEditPartsAction copy = (CopyEditPartsAction)this.getActionRegistry().getAction((Object)ActionFactory.COPY.getId());
        this.getGraphicalViewer().addSelectionChangedListener((ISelectionChangedListener)copy);
    }

    public AutomationSystem getSystem() {
        return this.getModel().getAutomationSystem();
    }

    public void doSave(IProgressMonitor monitor) {
        SystemManager.INSTANCE.saveSystem(this.getSystem());
        this.getCommandStack().markSaveLocation();
        this.firePropertyChange(257);
    }

    protected void createActions() {
        ActionRegistry registry = this.getActionRegistry();
        Object action = new SaveAsSubApplicationTypeAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new UnmapAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new UnmapAllAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = new CopyEditPartsAction((IEditorPart)this);
        registry.registerAction((IAction)action);
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)action);
        action = new PasteEditPartsAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)action);
        action = new UpdateFBTypeAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        super.createActions();
        action = registry.getAction((Object)ActionFactory.SELECT_ALL.getId());
        registry.removeAction((IAction)action);
        this.getSelectionActions().remove(action.getId());
        action = new FBNetworkSelectAllAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
        action = registry.getAction((Object)ActionFactory.DELETE.getId());
        registry.removeAction((IAction)action);
        this.getSelectionActions().remove(action.getId());
        action = new DeleteFBNetworkAction((IWorkbenchPart)this);
        registry.registerAction((IAction)action);
        this.getSelectionActions().add(action.getId());
    }

    public void dispose() {
        if (this.adapter != null && this.getModel() != null && this.getModel().eAdapters().contains((Object)this.adapter)) {
            this.getModel().eAdapters().remove((Object)this.adapter);
        }
        super.dispose();
        this.getEditDomain().setPaletteViewer(null);
    }

    protected PaletteRoot getPaletteRoot() {
        return null;
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        return new FBTypePaletteViewerProvider(this.getSystem().getProject(), (EditDomain)this.getEditDomain(), this.getPalletNavigatorID());
    }

    protected String getPalletNavigatorID() {
        return "org.eclipse.fordiac.ide.fbpaletteviewer";
    }

    protected FlyoutPaletteComposite.FlyoutPreferences getPalettePreferences() {
        return FBNetworkFlyoutPreferences.INSTANCE;
    }

    public void selectFB(FB fb) {
        EditPart editPart = (EditPart)this.getGraphicalViewer().getEditPartRegistry().get(fb);
        if (editPart != null) {
            this.getGraphicalViewer().select(editPart);
            this.getGraphicalViewer().reveal(editPart);
        }
    }

    public void doSaveAs() {
    }
}

