.\"	@(#)x11:contrib/clients/xloadimage/xlito.man 1.3 93/07/29 Labtam
.\"	
.TH XLITO 1 "7 Jul 1993"
.SH NAME
xlito (XLoadImageTrailingOptions) \- Append/Delete/Show a Trailing Option 
string in a file.
.SH SYNOPSIS
\fIxlito\fR [option] [string] files ...
.SH DESCRIPTION
\fIxlito\fR (XLoadImageTrailingOptions) is a utility that provides
a file format independent way of marking image files with the appropriate
options to display correctly.  It does this by appending to a file, a string
specified by the user. The string is marked with some magic numbers so that
it can be extracted by a program that knows what to look for. Since almost all
image files have some sort of image dimension information in the file, the
programs that load or manipulate these files generally do not look beyond
the point at which they have read the complete image, so trailing information
is safely be hidden. If appending this information causes trouble with other
utilities, it can simply be deleted.
.PP
Appropriate version of \fIxloadimage\fR (ie. \fIxli 1.00\fR) will recognise
these trailing options at the end of the image files, and will treat the
embedded string as if it were a sequence of command line \fIImage Options\fR.
Any \fIGlobal Options\fR will be ignored, and unlike command line
\fIimage Options,\fR \fITrailing Options\fR are never propagated to other
images.
.PP
Old versions of \fIxloadimage\fR (3.01 or less) can be made forward compatible
by using the \fI-x\fR option to pull the trailing options out of the image files,
and put them on the command line where \fIxloadimage\fR can see them.
.SH OPTIONS
The default behavior is to display the trailing option strings (if any) of
the files on the argument line.  The following options change the behavior of
\fIxlito:\fR
.TP 8
-c \fIoption_string file_name ...\fR
This adds or changes the embedded string to \fIoption_string\fR. 
The string will have to be quoted if it is composed of more than one word.
.TP
-d \fIfile_name ...\fR
Delete any embedded trailing option strings in the given files.
.TP
-x \fIfile_name ...\fR
Process the files and create a command line string suitable for use by
\fIxloadimage.\fR Arguments starting with \fI-\fR are echoed, arguments
not starting with \fI-\fR are treated as files and any trailing options
strings are echoed followed by the file name. The \fIxloadimage\fR option
\fI-name\fR is treated correctly. 
.SH EXAMPLES
If fred.gif has the wrong aspect ratio, then it might need
viewing with the \fIxloadimage\fR options:
.sp
.ti +5
xloadimage -yzoom 130 fred.gif
.PP
This option can then be appended to the file by:
.sp
.ti +5
xlito -c "-yzoom 130" fred.gif
.PP
and from then on some new versions of xloadimage will get the appropriate options
from the image file itself. Old versions of \fIxloadimage\fR can be made to
work by using:
.sp
.ti +5
xloadimage \(gaxlito -x fred.gif\(ga
.PP
This can be made transparent by using a script containing something like:
.sp
.ti +5
xloadimage \(gaxlito -x $\(**\(ga
.PP
The script could be called \fIxli\fR for instance.
.PP
The options can be deleted with:
.sp
.ti +5
xlito -d fred.gif
.SH AUTHOR
.nf
Graeme Gill
Labtam Australia
graeme@labtam.oz.au
.fi
.SH MAINTAINER
.nf
smar@reptiles.org
.fi
.SH COMPATIBILITY WITH IMAGE FILES
Some image files are actually ascii files that are used in other contexts.
X Bitmap files are an example. They are formatted as 'C' style
#defines and an initialised array of characters, so that they can be included
in 'C' source code.  Adding trailing options would therefore render the file
unusable with a compiler, since it will get a syntax error on the railing option
string and the magic numbers. The solution to this is that xlito will ignore a
certain amount (a few hundred bytes) after the trailing options, and uses a
padding of 20 bytes before the trailing options. These two areas will be
maintained when changing an existing trailing option. In the case of an X
bitmap then, the solution is to edit the file and place the embedded string
in some 'C' comments:
.PP
eg: say the file starts as:
.br
#define tt_width 4
.br
#define tt_height 4
.br
static char tt_bits[] = {
.br
   0x08, 0x02, 0x04, 0x01};
.PP
and you add a trailing options:
.br
#define tt_width 4
.br
#define tt_height 4
.br
static char tt_bits[] = {
.br
   0x08, 0x02, 0x04, 0x01};
.br
01234567890123456789XXX xloadimage trailing options XXX0007"-smooth"0007XXX
.br
xloadimage trailing options XXX
.PP
Then the trailing options can be commented out:
.br
#define tt_width 4
.br
#define tt_height 4
.br
static char tt_bits[] = {
.br
   0x08, 0x02, 0x04, 0x01};
.br
/\(**234567890123456789XXX xloadimage trailing options XXX0007"-smooth"0007XXX
.br
xloadimage trailing options XXX \(**/
.SH BUGS
xlito doesn't cope with compressed files. A files will need uncompressing, the
options added, and then compressing again.


