#ifndef __LOADFILE_H__ /* file wrapper */
#define __LOADFILE_H__
/*
 * Jeffrey Friedl
 * Omron Corporation			ʳ
 * Nagaokakyoshi, Japan			617Ĺ
 *
 * jfriedl@nff.ncl.omron.co.jp
 *
 * This work is placed under the terms of the GNU General Purpose License
 * (the "GNU Copyleft").
 *
 * October 1993
 *
 * Routine to load a file and to load, create, and/or write an accompanying
 * index. WRT loadfile, a "file" is a rather high-level object that has
 * an index and other substructures associated with it.
 *
 * On a lower level is "readfile" which deals with filesystem files
 * as singular entities.
 */

#define loadfile_version 102 /* 1.02 */
#include "longlinenote.h"
#include "index.h"
#include "virtfile.h"

/*
 * Info about a loaded file. Here, a "file" is rather high-level concept.
 */
struct fileinfo
{
    VirtFile *v;                        /* pointer to virtual file */
    const char *short_filename;         /* short name of file */
    const struct index *index;		/* index for file */
    const char *indexfile;              /* name of file index was read from */
};


/*
 * Load a named text file, and automatically load or calculate an index
 * for it. Also can write the index to a file (these options controlled
 * by the FLAGS given below).
 */
extern struct fileinfo *
    loadfile(const char *filename, unsigned percent, unsigned flags);

/* These flags must be distinct from those in index.h */
#define LOADFILE_WRITEINDEX    0x00010000
#define LOADFILE_READINDEX     0x00020000
#define LOADFILE_NO_MEM_INDEX  0x00040000
#define LOADFILE_READifPRESENT 0x00080000
/*
 * File extension expected for index read and written by loadfile.
 */
#define LOADFILE_INDEX_EXTENTION   ".jin" /* jeff's index */


/*
 * Given the name of a text file, return the name of its associated index
 * file (or what it would be called were it to exist). The returned string
 * should eventually be free'd by the user.
 */
extern char *indexfile_name(const char *datafile_name);

#endif /* file wrapper */
