/* Maps from DWARF register numbers to pt_regs fields for each architecture. */
#ifndef REGMAP
#define REGMAP(a, b)
#endif
#ifdef __i386__
#define IPREG 8
#define CFA_RESTORE_REGNO 4
REGMAP(0, eax)
REGMAP(1, ecx)
REGMAP(2, edx)
REGMAP(3, ebx)
REGMAP(4, esp)
REGMAP(5, ebp)
REGMAP(6, esi)
REGMAP(7, edi)
REGMAP(8, eip)
REGMAP(9, eflags)
REGMAP(10, xcs)
REGMAP(11, xss)
REGMAP(12, xds)
REGMAP(13, xes)
REGMAP(14, xfs)
#endif

#ifdef __amd64__
#define CFA_RESTORE_REGNO 7
#define IPREG 16
REGMAP(0, rax)
REGMAP(1, rdx)
REGMAP(2, rcx)
REGMAP(3, rbx)
REGMAP(4, rsi)
REGMAP(5, rdi)
REGMAP(6, rbp)
REGMAP(7, rsp)
REGMAP(8, r8)
REGMAP(9, r9)
REGMAP(10, r10)
REGMAP(11, r11)
REGMAP(12, r12)
REGMAP(13, r13)
REGMAP(14, r14)
REGMAP(15, r15)
REGMAP(16, rip)
/* floating point regs
REGMAP(17, rxmm0)
REGMAP(18, rxmm1)
REGMAP(19, rxmm2)
REGMAP(20, rxmm3)
REGMAP(21, rxmm4)
REGMAP(22, rxmm5)
REGMAP(23, rxmm6)
REGMAP(24, rxmm7)
REGMAP(25, rxmm8)
REGMAP(26, rxmm9)
REGMAP(27, rxmm10)
REGMAP(28, rxmm11)
REGMAP(29, rxmm12)
REGMAP(30, rxmm13)
REGMAP(31, rxmm14)
REGMAP(32, rxmm15)
REGMAP(33, rst0)
REGMAP(34, rst1)
REGMAP(35, rst2)
REGMAP(36, rst3)
REGMAP(37, rst4)
REGMAP(38, rst5)
REGMAP(39, rst6)
REGMAP(40, rst7)
REGMAP(41, mm0)
REGMAP(42, mm1)
REGMAP(43, mm2)
REGMAP(44, mm3)
REGMAP(45, mm4)
REGMAP(46, mm5)
REGMAP(47, mm6)
REGMAP(48, mm7)
*/
REGMAP(49, eflags)
REGMAP(50, es)
REGMAP(51, cs)
REGMAP(52, ss)
REGMAP(53, ds)
REGMAP(54, fs)
REGMAP(55, gs)
REGMAP(58, fs_base)
REGMAP(59, gs_base)
#endif

#ifdef __ARM_ARCH
#if ELF_BITS == 32
#define IPREG 15
#define CFA_RESTORE_REGNO 13
REGMAP(0, regs[0])
REGMAP(1, regs[1])
REGMAP(2, regs[2])
REGMAP(3, regs[3])
REGMAP(4, regs[4])
REGMAP(5, regs[5])
REGMAP(6, regs[6])
REGMAP(7, regs[7])
REGMAP(8, regs[8])
REGMAP(9, regs[9])
REGMAP(10, regs[10])
REGMAP(11, regs[11])
REGMAP(12, regs[12])
REGMAP(13, regs[13])
REGMAP(14, regs[14])
REGMAP(15, regs[15])
REGMAP(16, regs[16])
REGMAP(17, regs[17])
#else
#define IPREG 32
#define CFA_RESTORE_REGNO 31
REGMAP(0, regs[0])
REGMAP(1, regs[1])
REGMAP(2, regs[2])
REGMAP(3, regs[3])
REGMAP(4, regs[4])
REGMAP(5, regs[5])
REGMAP(6, regs[6])
REGMAP(7, regs[7])
REGMAP(8, regs[8])
REGMAP(9, regs[9])
REGMAP(10, regs[10])
REGMAP(11, regs[11])
REGMAP(12, regs[12])
REGMAP(13, regs[13])
REGMAP(14, regs[14])
REGMAP(15, regs[15])
REGMAP(16, regs[16])
REGMAP(17, regs[17])
REGMAP(18, regs[18])
REGMAP(19, regs[19])
REGMAP(20, regs[20])
REGMAP(21, regs[21])
REGMAP(22, regs[22])
REGMAP(23, regs[23])
REGMAP(24, regs[24])
REGMAP(25, regs[25])
REGMAP(26, regs[26])
REGMAP(27, regs[27])
REGMAP(28, regs[28])
REGMAP(29, regs[29])
REGMAP(30, regs[30])
REGMAP(31, sp)
REGMAP(32, pc)
#endif
#endif
#undef REGMAP
