/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "realm-dbus-generated.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.realmd.Provider
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:RealmDbusProvider
 * @title: RealmDbusProvider
 * @short_description: Generated C code for the org.freedesktop.realmd.Provider D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-realmd-Provider.top_of_page">org.freedesktop.realmd.Provider</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.realmd.Provider ---- */

static const _ExtendedGDBusArgInfo _realm_dbus_provider_method_info_discover_IN_ARG_string =
{
  {
    -1,
    (gchar *) "string",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _realm_dbus_provider_method_info_discover_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _realm_dbus_provider_method_info_discover_IN_ARG_pointers[] =
{
  &_realm_dbus_provider_method_info_discover_IN_ARG_string.parent_struct,
  &_realm_dbus_provider_method_info_discover_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _realm_dbus_provider_method_info_discover_OUT_ARG_relevance =
{
  {
    -1,
    (gchar *) "relevance",
    (gchar *) "i",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _realm_dbus_provider_method_info_discover_OUT_ARG_realm =
{
  {
    -1,
    (gchar *) "realm",
    (gchar *) "ao",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _realm_dbus_provider_method_info_discover_OUT_ARG_pointers[] =
{
  &_realm_dbus_provider_method_info_discover_OUT_ARG_relevance.parent_struct,
  &_realm_dbus_provider_method_info_discover_OUT_ARG_realm.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _realm_dbus_provider_method_info_discover =
{
  {
    -1,
    (gchar *) "Discover",
    (GDBusArgInfo **) &_realm_dbus_provider_method_info_discover_IN_ARG_pointers,
    (GDBusArgInfo **) &_realm_dbus_provider_method_info_discover_OUT_ARG_pointers,
    NULL
  },
  "handle-discover",
  FALSE
};

static const GDBusMethodInfo * const _realm_dbus_provider_method_info_pointers[] =
{
  &_realm_dbus_provider_method_info_discover.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _realm_dbus_provider_property_info_name =
{
  {
    -1,
    (gchar *) "Name",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "name",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _realm_dbus_provider_property_info_version =
{
  {
    -1,
    (gchar *) "Version",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _realm_dbus_provider_property_info_realms =
{
  {
    -1,
    (gchar *) "Realms",
    (gchar *) "ao",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "realms",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _realm_dbus_provider_property_info_pointers[] =
{
  &_realm_dbus_provider_property_info_name.parent_struct,
  &_realm_dbus_provider_property_info_version.parent_struct,
  &_realm_dbus_provider_property_info_realms.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _realm_dbus_provider_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.realmd.Provider",
    (GDBusMethodInfo **) &_realm_dbus_provider_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_realm_dbus_provider_property_info_pointers,
    NULL
  },
  "provider",
};


/**
 * realm_dbus_provider_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-realmd-Provider.top_of_page">org.freedesktop.realmd.Provider</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
realm_dbus_provider_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_realm_dbus_provider_interface_info.parent_struct;
}

/**
 * realm_dbus_provider_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #RealmDbusProvider interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
realm_dbus_provider_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "name");
  g_object_class_override_property (klass, property_id_begin++, "version");
  g_object_class_override_property (klass, property_id_begin++, "realms");
  return property_id_begin - 1;
}



/**
 * RealmDbusProvider:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Provider.top_of_page">org.freedesktop.realmd.Provider</link>.
 */

/**
 * RealmDbusProviderIface:
 * @parent_iface: The parent interface.
 * @handle_discover: Handler for the #RealmDbusProvider::handle-discover signal.
 * @get_name: Getter for the #RealmDbusProvider:name property.
 * @get_realms: Getter for the #RealmDbusProvider:realms property.
 * @get_version: Getter for the #RealmDbusProvider:version property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Provider.top_of_page">org.freedesktop.realmd.Provider</link>.
 */

typedef RealmDbusProviderIface RealmDbusProviderInterface;
G_DEFINE_INTERFACE (RealmDbusProvider, realm_dbus_provider, G_TYPE_OBJECT)

static void
realm_dbus_provider_default_init (RealmDbusProviderIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * RealmDbusProvider::handle-discover:
   * @object: A #RealmDbusProvider.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_string: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-realmd-Provider.Discover">Discover()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call realm_dbus_provider_complete_discover() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-discover",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (RealmDbusProviderIface, handle_discover),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * RealmDbusProvider:name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-realmd-Provider.Name">"Name"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("name", "Name", "Name", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * RealmDbusProvider:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-realmd-Provider.Version">"Version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("version", "Version", "Version", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * RealmDbusProvider:realms:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-realmd-Provider.Realms">"Realms"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("realms", "Realms", "Realms", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * realm_dbus_provider_get_name: (skip)
 * @object: A #RealmDbusProvider.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-realmd-Provider.Name">"Name"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use realm_dbus_provider_dup_name() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
realm_dbus_provider_get_name (RealmDbusProvider *object)
{
  return REALM_DBUS_PROVIDER_GET_IFACE (object)->get_name (object);
}

/**
 * realm_dbus_provider_dup_name: (skip)
 * @object: A #RealmDbusProvider.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-realmd-Provider.Name">"Name"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
realm_dbus_provider_dup_name (RealmDbusProvider *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "name", &value, NULL);
  return value;
}

/**
 * realm_dbus_provider_set_name: (skip)
 * @object: A #RealmDbusProvider.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-realmd-Provider.Name">"Name"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
realm_dbus_provider_set_name (RealmDbusProvider *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "name", value, NULL);
}

/**
 * realm_dbus_provider_get_version: (skip)
 * @object: A #RealmDbusProvider.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-realmd-Provider.Version">"Version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use realm_dbus_provider_dup_version() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
realm_dbus_provider_get_version (RealmDbusProvider *object)
{
  return REALM_DBUS_PROVIDER_GET_IFACE (object)->get_version (object);
}

/**
 * realm_dbus_provider_dup_version: (skip)
 * @object: A #RealmDbusProvider.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-realmd-Provider.Version">"Version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
realm_dbus_provider_dup_version (RealmDbusProvider *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "version", &value, NULL);
  return value;
}

/**
 * realm_dbus_provider_set_version: (skip)
 * @object: A #RealmDbusProvider.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-realmd-Provider.Version">"Version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
realm_dbus_provider_set_version (RealmDbusProvider *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * realm_dbus_provider_get_realms: (skip)
 * @object: A #RealmDbusProvider.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-realmd-Provider.Realms">"Realms"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use realm_dbus_provider_dup_realms() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
realm_dbus_provider_get_realms (RealmDbusProvider *object)
{
  return REALM_DBUS_PROVIDER_GET_IFACE (object)->get_realms (object);
}

/**
 * realm_dbus_provider_dup_realms: (skip)
 * @object: A #RealmDbusProvider.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-realmd-Provider.Realms">"Realms"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
realm_dbus_provider_dup_realms (RealmDbusProvider *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "realms", &value, NULL);
  return value;
}

/**
 * realm_dbus_provider_set_realms: (skip)
 * @object: A #RealmDbusProvider.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-realmd-Provider.Realms">"Realms"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
realm_dbus_provider_set_realms (RealmDbusProvider *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "realms", value, NULL);
}

/**
 * realm_dbus_provider_call_discover:
 * @proxy: A #RealmDbusProviderProxy.
 * @arg_string: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-realmd-Provider.Discover">Discover()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call realm_dbus_provider_call_discover_finish() to get the result of the operation.
 *
 * See realm_dbus_provider_call_discover_sync() for the synchronous, blocking version of this method.
 */
void
realm_dbus_provider_call_discover (
    RealmDbusProvider *proxy,
    const gchar *arg_string,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Discover",
    g_variant_new ("(s@a{sv})",
                   arg_string,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * realm_dbus_provider_call_discover_finish:
 * @proxy: A #RealmDbusProviderProxy.
 * @out_relevance: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_realm: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to realm_dbus_provider_call_discover().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with realm_dbus_provider_call_discover().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
realm_dbus_provider_call_discover_finish (
    RealmDbusProvider *proxy,
    gint *out_relevance,
    gchar ***out_realm,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i^ao)",
                 out_relevance,
                 out_realm);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * realm_dbus_provider_call_discover_sync:
 * @proxy: A #RealmDbusProviderProxy.
 * @arg_string: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @out_relevance: (out) (optional): Return location for return parameter or %NULL to ignore.
 * @out_realm: (out) (optional) (array zero-terminated=1): Return location for return parameter or %NULL to ignore.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-realmd-Provider.Discover">Discover()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See realm_dbus_provider_call_discover() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
realm_dbus_provider_call_discover_sync (
    RealmDbusProvider *proxy,
    const gchar *arg_string,
    GVariant *arg_options,
    gint *out_relevance,
    gchar ***out_realm,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Discover",
    g_variant_new ("(s@a{sv})",
                   arg_string,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "(i^ao)",
                 out_relevance,
                 out_realm);
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * realm_dbus_provider_complete_discover:
 * @object: A #RealmDbusProvider.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 * @relevance: Parameter to return.
 * @realm: Parameter to return.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-realmd-Provider.Discover">Discover()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
realm_dbus_provider_complete_discover (
    RealmDbusProvider *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation,
    gint relevance,
    const gchar *const *realm)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("(i^ao)",
                   relevance,
                   realm));
}

/* ------------------------------------------------------------------------ */

/**
 * RealmDbusProviderProxy:
 *
 * The #RealmDbusProviderProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * RealmDbusProviderProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #RealmDbusProviderProxy.
 */

struct _RealmDbusProviderProxyPrivate
{
  GData *qdata;
};

static void realm_dbus_provider_proxy_iface_init (RealmDbusProviderIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (RealmDbusProviderProxy, realm_dbus_provider_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (RealmDbusProviderProxy)
                         G_IMPLEMENT_INTERFACE (REALM_DBUS_TYPE_PROVIDER, realm_dbus_provider_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (RealmDbusProviderProxy, realm_dbus_provider_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (REALM_DBUS_TYPE_PROVIDER, realm_dbus_provider_proxy_iface_init))

#endif
static void
realm_dbus_provider_proxy_finalize (GObject *object)
{
  RealmDbusProviderProxy *proxy = REALM_DBUS_PROVIDER_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (realm_dbus_provider_proxy_parent_class)->finalize (object);
}

static void
realm_dbus_provider_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _realm_dbus_provider_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
realm_dbus_provider_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.realmd.Provider: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
realm_dbus_provider_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _realm_dbus_provider_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.realmd.Provider", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) realm_dbus_provider_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
realm_dbus_provider_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_realm_dbus_provider_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], REALM_DBUS_TYPE_PROVIDER);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, REALM_DBUS_TYPE_PROVIDER);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
realm_dbus_provider_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  RealmDbusProviderProxy *proxy = REALM_DBUS_PROVIDER_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_realm_dbus_provider_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_realm_dbus_provider_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
realm_dbus_provider_proxy_get_name (RealmDbusProvider *object)
{
  RealmDbusProviderProxy *proxy = REALM_DBUS_PROVIDER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Name");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
realm_dbus_provider_proxy_get_version (RealmDbusProvider *object)
{
  RealmDbusProviderProxy *proxy = REALM_DBUS_PROVIDER_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Version");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
realm_dbus_provider_proxy_get_realms (RealmDbusProvider *object)
{
  RealmDbusProviderProxy *proxy = REALM_DBUS_PROVIDER_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "Realms");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Realms");
  if (variant != NULL)
    {
      value = g_variant_get_objv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "Realms", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static void
realm_dbus_provider_proxy_init (RealmDbusProviderProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = realm_dbus_provider_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, REALM_DBUS_TYPE_PROVIDER_PROXY, RealmDbusProviderProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), realm_dbus_provider_interface_info ());
}

static void
realm_dbus_provider_proxy_class_init (RealmDbusProviderProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = realm_dbus_provider_proxy_finalize;
  gobject_class->get_property = realm_dbus_provider_proxy_get_property;
  gobject_class->set_property = realm_dbus_provider_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = realm_dbus_provider_proxy_g_signal;
  proxy_class->g_properties_changed = realm_dbus_provider_proxy_g_properties_changed;

  realm_dbus_provider_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (RealmDbusProviderProxyPrivate));
#endif
}

static void
realm_dbus_provider_proxy_iface_init (RealmDbusProviderIface *iface)
{
  iface->get_name = realm_dbus_provider_proxy_get_name;
  iface->get_version = realm_dbus_provider_proxy_get_version;
  iface->get_realms = realm_dbus_provider_proxy_get_realms;
}

/**
 * realm_dbus_provider_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Provider.top_of_page">org.freedesktop.realmd.Provider</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call realm_dbus_provider_proxy_new_finish() to get the result of the operation.
 *
 * See realm_dbus_provider_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
realm_dbus_provider_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (REALM_DBUS_TYPE_PROVIDER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.realmd.Provider", NULL);
}

/**
 * realm_dbus_provider_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to realm_dbus_provider_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with realm_dbus_provider_proxy_new().
 *
 * Returns: (transfer full) (type RealmDbusProviderProxy): The constructed proxy object or %NULL if @error is set.
 */
RealmDbusProvider *
realm_dbus_provider_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return REALM_DBUS_PROVIDER (ret);
  else
    return NULL;
}

/**
 * realm_dbus_provider_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Provider.top_of_page">org.freedesktop.realmd.Provider</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See realm_dbus_provider_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type RealmDbusProviderProxy): The constructed proxy object or %NULL if @error is set.
 */
RealmDbusProvider *
realm_dbus_provider_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (REALM_DBUS_TYPE_PROVIDER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.realmd.Provider", NULL);
  if (ret != NULL)
    return REALM_DBUS_PROVIDER (ret);
  else
    return NULL;
}


/**
 * realm_dbus_provider_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like realm_dbus_provider_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call realm_dbus_provider_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See realm_dbus_provider_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
realm_dbus_provider_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (REALM_DBUS_TYPE_PROVIDER_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.realmd.Provider", NULL);
}

/**
 * realm_dbus_provider_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to realm_dbus_provider_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with realm_dbus_provider_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type RealmDbusProviderProxy): The constructed proxy object or %NULL if @error is set.
 */
RealmDbusProvider *
realm_dbus_provider_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return REALM_DBUS_PROVIDER (ret);
  else
    return NULL;
}

/**
 * realm_dbus_provider_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like realm_dbus_provider_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See realm_dbus_provider_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type RealmDbusProviderProxy): The constructed proxy object or %NULL if @error is set.
 */
RealmDbusProvider *
realm_dbus_provider_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (REALM_DBUS_TYPE_PROVIDER_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.realmd.Provider", NULL);
  if (ret != NULL)
    return REALM_DBUS_PROVIDER (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * RealmDbusProviderSkeleton:
 *
 * The #RealmDbusProviderSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * RealmDbusProviderSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #RealmDbusProviderSkeleton.
 */

struct _RealmDbusProviderSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_realm_dbus_provider_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  RealmDbusProviderSkeleton *skeleton = REALM_DBUS_PROVIDER_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], REALM_DBUS_TYPE_PROVIDER);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, REALM_DBUS_TYPE_PROVIDER);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_realm_dbus_provider_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  RealmDbusProviderSkeleton *skeleton = REALM_DBUS_PROVIDER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_realm_dbus_provider_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_realm_dbus_provider_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  RealmDbusProviderSkeleton *skeleton = REALM_DBUS_PROVIDER_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_realm_dbus_provider_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _realm_dbus_provider_skeleton_vtable =
{
  _realm_dbus_provider_skeleton_handle_method_call,
  _realm_dbus_provider_skeleton_handle_get_property,
  _realm_dbus_provider_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
realm_dbus_provider_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return realm_dbus_provider_interface_info ();
}

static GDBusInterfaceVTable *
realm_dbus_provider_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_realm_dbus_provider_skeleton_vtable;
}

static GVariant *
realm_dbus_provider_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  RealmDbusProviderSkeleton *skeleton = REALM_DBUS_PROVIDER_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_realm_dbus_provider_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _realm_dbus_provider_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _realm_dbus_provider_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _realm_dbus_provider_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.realmd.Provider", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _realm_dbus_provider_emit_changed (gpointer user_data);

static void
realm_dbus_provider_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  RealmDbusProviderSkeleton *skeleton = REALM_DBUS_PROVIDER_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _realm_dbus_provider_emit_changed (skeleton);
}

static void realm_dbus_provider_skeleton_iface_init (RealmDbusProviderIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (RealmDbusProviderSkeleton, realm_dbus_provider_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (RealmDbusProviderSkeleton)
                         G_IMPLEMENT_INTERFACE (REALM_DBUS_TYPE_PROVIDER, realm_dbus_provider_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (RealmDbusProviderSkeleton, realm_dbus_provider_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (REALM_DBUS_TYPE_PROVIDER, realm_dbus_provider_skeleton_iface_init))

#endif
static void
realm_dbus_provider_skeleton_finalize (GObject *object)
{
  RealmDbusProviderSkeleton *skeleton = REALM_DBUS_PROVIDER_SKELETON (object);
  guint n;
  for (n = 0; n < 3; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (realm_dbus_provider_skeleton_parent_class)->finalize (object);
}

static void
realm_dbus_provider_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  RealmDbusProviderSkeleton *skeleton = REALM_DBUS_PROVIDER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_realm_dbus_provider_emit_changed (gpointer user_data)
{
  RealmDbusProviderSkeleton *skeleton = REALM_DBUS_PROVIDER_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.realmd.Provider",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_realm_dbus_provider_schedule_emit_changed (RealmDbusProviderSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
realm_dbus_provider_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  RealmDbusProviderSkeleton *skeleton = REALM_DBUS_PROVIDER_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _realm_dbus_provider_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _realm_dbus_provider_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
realm_dbus_provider_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  RealmDbusProviderSkeleton *skeleton = REALM_DBUS_PROVIDER_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _realm_dbus_provider_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _realm_dbus_provider_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
realm_dbus_provider_skeleton_init (RealmDbusProviderSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = realm_dbus_provider_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, REALM_DBUS_TYPE_PROVIDER_SKELETON, RealmDbusProviderSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 3);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRV);
}

static const gchar *
realm_dbus_provider_skeleton_get_name (RealmDbusProvider *object)
{
  RealmDbusProviderSkeleton *skeleton = REALM_DBUS_PROVIDER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
realm_dbus_provider_skeleton_get_version (RealmDbusProvider *object)
{
  RealmDbusProviderSkeleton *skeleton = REALM_DBUS_PROVIDER_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
realm_dbus_provider_skeleton_get_realms (RealmDbusProvider *object)
{
  RealmDbusProviderSkeleton *skeleton = REALM_DBUS_PROVIDER_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
realm_dbus_provider_skeleton_class_init (RealmDbusProviderSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = realm_dbus_provider_skeleton_finalize;
  gobject_class->get_property = realm_dbus_provider_skeleton_get_property;
  gobject_class->set_property = realm_dbus_provider_skeleton_set_property;
  gobject_class->notify       = realm_dbus_provider_skeleton_notify;


  realm_dbus_provider_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = realm_dbus_provider_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = realm_dbus_provider_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = realm_dbus_provider_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = realm_dbus_provider_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (RealmDbusProviderSkeletonPrivate));
#endif
}

static void
realm_dbus_provider_skeleton_iface_init (RealmDbusProviderIface *iface)
{
  iface->get_name = realm_dbus_provider_skeleton_get_name;
  iface->get_version = realm_dbus_provider_skeleton_get_version;
  iface->get_realms = realm_dbus_provider_skeleton_get_realms;
}

/**
 * realm_dbus_provider_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Provider.top_of_page">org.freedesktop.realmd.Provider</link>.
 *
 * Returns: (transfer full) (type RealmDbusProviderSkeleton): The skeleton object.
 */
RealmDbusProvider *
realm_dbus_provider_skeleton_new (void)
{
  return REALM_DBUS_PROVIDER (g_object_new (REALM_DBUS_TYPE_PROVIDER_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.realmd.Service
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:RealmDbusService
 * @title: RealmDbusService
 * @short_description: Generated C code for the org.freedesktop.realmd.Service D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-realmd-Service.top_of_page">org.freedesktop.realmd.Service</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.realmd.Service ---- */

static const _ExtendedGDBusArgInfo _realm_dbus_service_method_info_cancel_IN_ARG_operation =
{
  {
    -1,
    (gchar *) "operation",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _realm_dbus_service_method_info_cancel_IN_ARG_pointers[] =
{
  &_realm_dbus_service_method_info_cancel_IN_ARG_operation.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _realm_dbus_service_method_info_cancel =
{
  {
    -1,
    (gchar *) "Cancel",
    (GDBusArgInfo **) &_realm_dbus_service_method_info_cancel_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-cancel",
  FALSE
};

static const _ExtendedGDBusArgInfo _realm_dbus_service_method_info_set_locale_IN_ARG_locale =
{
  {
    -1,
    (gchar *) "locale",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _realm_dbus_service_method_info_set_locale_IN_ARG_pointers[] =
{
  &_realm_dbus_service_method_info_set_locale_IN_ARG_locale.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _realm_dbus_service_method_info_set_locale =
{
  {
    -1,
    (gchar *) "SetLocale",
    (GDBusArgInfo **) &_realm_dbus_service_method_info_set_locale_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-locale",
  FALSE
};

static const _ExtendedGDBusMethodInfo _realm_dbus_service_method_info_release =
{
  {
    -1,
    (gchar *) "Release",
    NULL,
    NULL,
    NULL
  },
  "handle-release",
  FALSE
};

static const GDBusMethodInfo * const _realm_dbus_service_method_info_pointers[] =
{
  &_realm_dbus_service_method_info_cancel.parent_struct,
  &_realm_dbus_service_method_info_set_locale.parent_struct,
  &_realm_dbus_service_method_info_release.parent_struct,
  NULL
};

static const _ExtendedGDBusArgInfo _realm_dbus_service_signal_info_diagnostics_ARG_data =
{
  {
    -1,
    (gchar *) "data",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _realm_dbus_service_signal_info_diagnostics_ARG_operation =
{
  {
    -1,
    (gchar *) "operation",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _realm_dbus_service_signal_info_diagnostics_ARG_pointers[] =
{
  &_realm_dbus_service_signal_info_diagnostics_ARG_data.parent_struct,
  &_realm_dbus_service_signal_info_diagnostics_ARG_operation.parent_struct,
  NULL
};

static const _ExtendedGDBusSignalInfo _realm_dbus_service_signal_info_diagnostics =
{
  {
    -1,
    (gchar *) "Diagnostics",
    (GDBusArgInfo **) &_realm_dbus_service_signal_info_diagnostics_ARG_pointers,
    NULL
  },
  "diagnostics"
};

static const GDBusSignalInfo * const _realm_dbus_service_signal_info_pointers[] =
{
  &_realm_dbus_service_signal_info_diagnostics.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _realm_dbus_service_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.realmd.Service",
    (GDBusMethodInfo **) &_realm_dbus_service_method_info_pointers,
    (GDBusSignalInfo **) &_realm_dbus_service_signal_info_pointers,
    NULL,
    NULL
  },
  "service",
};


/**
 * realm_dbus_service_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-realmd-Service.top_of_page">org.freedesktop.realmd.Service</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
realm_dbus_service_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_realm_dbus_service_interface_info.parent_struct;
}

/**
 * realm_dbus_service_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #RealmDbusService interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
realm_dbus_service_override_properties (GObjectClass *klass G_GNUC_UNUSED, guint property_id_begin)
{
  return property_id_begin - 1;
}



/**
 * RealmDbusService:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Service.top_of_page">org.freedesktop.realmd.Service</link>.
 */

/**
 * RealmDbusServiceIface:
 * @parent_iface: The parent interface.
 * @handle_cancel: Handler for the #RealmDbusService::handle-cancel signal.
 * @handle_release: Handler for the #RealmDbusService::handle-release signal.
 * @handle_set_locale: Handler for the #RealmDbusService::handle-set-locale signal.
 * @diagnostics: Handler for the #RealmDbusService::diagnostics signal.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Service.top_of_page">org.freedesktop.realmd.Service</link>.
 */

typedef RealmDbusServiceIface RealmDbusServiceInterface;
G_DEFINE_INTERFACE (RealmDbusService, realm_dbus_service, G_TYPE_OBJECT)

static void
realm_dbus_service_default_init (RealmDbusServiceIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * RealmDbusService::handle-cancel:
   * @object: A #RealmDbusService.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_operation: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-realmd-Service.Cancel">Cancel()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call realm_dbus_service_complete_cancel() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-cancel",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (RealmDbusServiceIface, handle_cancel),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * RealmDbusService::handle-set-locale:
   * @object: A #RealmDbusService.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_locale: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-realmd-Service.SetLocale">SetLocale()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call realm_dbus_service_complete_set_locale() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-locale",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (RealmDbusServiceIface, handle_set_locale),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * RealmDbusService::handle-release:
   * @object: A #RealmDbusService.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-realmd-Service.Release">Release()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call realm_dbus_service_complete_release() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-release",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (RealmDbusServiceIface, handle_release),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /* GObject signals for received D-Bus signals: */
  /**
   * RealmDbusService::diagnostics:
   * @object: A #RealmDbusService.
   * @arg_data: Argument.
   * @arg_operation: Argument.
   *
   * On the client-side, this signal is emitted whenever the D-Bus signal <link linkend="gdbus-signal-org-freedesktop-realmd-Service.Diagnostics">"Diagnostics"</link> is received.
   *
   * On the service-side, this signal can be used with e.g. g_signal_emit_by_name() to make the object emit the D-Bus signal.
   */
  g_signal_new ("diagnostics",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (RealmDbusServiceIface, diagnostics),
    NULL,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_NONE,
    2, G_TYPE_STRING, G_TYPE_STRING);

}

/**
 * realm_dbus_service_emit_diagnostics:
 * @object: A #RealmDbusService.
 * @arg_data: Argument to pass with the signal.
 * @arg_operation: Argument to pass with the signal.
 *
 * Emits the <link linkend="gdbus-signal-org-freedesktop-realmd-Service.Diagnostics">"Diagnostics"</link> D-Bus signal.
 */
void
realm_dbus_service_emit_diagnostics (
    RealmDbusService *object,
    const gchar *arg_data,
    const gchar *arg_operation)
{
  g_signal_emit_by_name (object, "diagnostics", arg_data, arg_operation);
}

/**
 * realm_dbus_service_call_cancel:
 * @proxy: A #RealmDbusServiceProxy.
 * @arg_operation: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-realmd-Service.Cancel">Cancel()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call realm_dbus_service_call_cancel_finish() to get the result of the operation.
 *
 * See realm_dbus_service_call_cancel_sync() for the synchronous, blocking version of this method.
 */
void
realm_dbus_service_call_cancel (
    RealmDbusService *proxy,
    const gchar *arg_operation,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Cancel",
    g_variant_new ("(s)",
                   arg_operation),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * realm_dbus_service_call_cancel_finish:
 * @proxy: A #RealmDbusServiceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to realm_dbus_service_call_cancel().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with realm_dbus_service_call_cancel().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
realm_dbus_service_call_cancel_finish (
    RealmDbusService *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * realm_dbus_service_call_cancel_sync:
 * @proxy: A #RealmDbusServiceProxy.
 * @arg_operation: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-realmd-Service.Cancel">Cancel()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See realm_dbus_service_call_cancel() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
realm_dbus_service_call_cancel_sync (
    RealmDbusService *proxy,
    const gchar *arg_operation,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Cancel",
    g_variant_new ("(s)",
                   arg_operation),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * realm_dbus_service_call_set_locale:
 * @proxy: A #RealmDbusServiceProxy.
 * @arg_locale: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-realmd-Service.SetLocale">SetLocale()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call realm_dbus_service_call_set_locale_finish() to get the result of the operation.
 *
 * See realm_dbus_service_call_set_locale_sync() for the synchronous, blocking version of this method.
 */
void
realm_dbus_service_call_set_locale (
    RealmDbusService *proxy,
    const gchar *arg_locale,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetLocale",
    g_variant_new ("(s)",
                   arg_locale),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * realm_dbus_service_call_set_locale_finish:
 * @proxy: A #RealmDbusServiceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to realm_dbus_service_call_set_locale().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with realm_dbus_service_call_set_locale().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
realm_dbus_service_call_set_locale_finish (
    RealmDbusService *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * realm_dbus_service_call_set_locale_sync:
 * @proxy: A #RealmDbusServiceProxy.
 * @arg_locale: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-realmd-Service.SetLocale">SetLocale()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See realm_dbus_service_call_set_locale() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
realm_dbus_service_call_set_locale_sync (
    RealmDbusService *proxy,
    const gchar *arg_locale,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetLocale",
    g_variant_new ("(s)",
                   arg_locale),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * realm_dbus_service_call_release:
 * @proxy: A #RealmDbusServiceProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-realmd-Service.Release">Release()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call realm_dbus_service_call_release_finish() to get the result of the operation.
 *
 * See realm_dbus_service_call_release_sync() for the synchronous, blocking version of this method.
 */
void
realm_dbus_service_call_release (
    RealmDbusService *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Release",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * realm_dbus_service_call_release_finish:
 * @proxy: A #RealmDbusServiceProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to realm_dbus_service_call_release().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with realm_dbus_service_call_release().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
realm_dbus_service_call_release_finish (
    RealmDbusService *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * realm_dbus_service_call_release_sync:
 * @proxy: A #RealmDbusServiceProxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-realmd-Service.Release">Release()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See realm_dbus_service_call_release() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
realm_dbus_service_call_release_sync (
    RealmDbusService *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Release",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * realm_dbus_service_complete_cancel:
 * @object: A #RealmDbusService.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-realmd-Service.Cancel">Cancel()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
realm_dbus_service_complete_cancel (
    RealmDbusService *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * realm_dbus_service_complete_set_locale:
 * @object: A #RealmDbusService.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-realmd-Service.SetLocale">SetLocale()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
realm_dbus_service_complete_set_locale (
    RealmDbusService *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * realm_dbus_service_complete_release:
 * @object: A #RealmDbusService.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-realmd-Service.Release">Release()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
realm_dbus_service_complete_release (
    RealmDbusService *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * RealmDbusServiceProxy:
 *
 * The #RealmDbusServiceProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * RealmDbusServiceProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #RealmDbusServiceProxy.
 */

struct _RealmDbusServiceProxyPrivate
{
  GData *qdata;
};

static void realm_dbus_service_proxy_iface_init (RealmDbusServiceIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (RealmDbusServiceProxy, realm_dbus_service_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (RealmDbusServiceProxy)
                         G_IMPLEMENT_INTERFACE (REALM_DBUS_TYPE_SERVICE, realm_dbus_service_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (RealmDbusServiceProxy, realm_dbus_service_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (REALM_DBUS_TYPE_SERVICE, realm_dbus_service_proxy_iface_init))

#endif
static void
realm_dbus_service_proxy_finalize (GObject *object)
{
  RealmDbusServiceProxy *proxy = REALM_DBUS_SERVICE_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (realm_dbus_service_proxy_parent_class)->finalize (object);
}

static void
realm_dbus_service_proxy_get_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  GValue       *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
realm_dbus_service_proxy_set_property (GObject      *object G_GNUC_UNUSED,
  guint         prop_id G_GNUC_UNUSED,
  const GValue *value G_GNUC_UNUSED,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
}

static void
realm_dbus_service_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_realm_dbus_service_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], REALM_DBUS_TYPE_SERVICE);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, REALM_DBUS_TYPE_SERVICE);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
realm_dbus_service_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  RealmDbusServiceProxy *proxy = REALM_DBUS_SERVICE_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_realm_dbus_service_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_realm_dbus_service_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static void
realm_dbus_service_proxy_init (RealmDbusServiceProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = realm_dbus_service_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, REALM_DBUS_TYPE_SERVICE_PROXY, RealmDbusServiceProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), realm_dbus_service_interface_info ());
}

static void
realm_dbus_service_proxy_class_init (RealmDbusServiceProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = realm_dbus_service_proxy_finalize;
  gobject_class->get_property = realm_dbus_service_proxy_get_property;
  gobject_class->set_property = realm_dbus_service_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = realm_dbus_service_proxy_g_signal;
  proxy_class->g_properties_changed = realm_dbus_service_proxy_g_properties_changed;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (RealmDbusServiceProxyPrivate));
#endif
}

static void
realm_dbus_service_proxy_iface_init (RealmDbusServiceIface *iface G_GNUC_UNUSED)
{
}

/**
 * realm_dbus_service_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Service.top_of_page">org.freedesktop.realmd.Service</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call realm_dbus_service_proxy_new_finish() to get the result of the operation.
 *
 * See realm_dbus_service_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
realm_dbus_service_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (REALM_DBUS_TYPE_SERVICE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.realmd.Service", NULL);
}

/**
 * realm_dbus_service_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to realm_dbus_service_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with realm_dbus_service_proxy_new().
 *
 * Returns: (transfer full) (type RealmDbusServiceProxy): The constructed proxy object or %NULL if @error is set.
 */
RealmDbusService *
realm_dbus_service_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return REALM_DBUS_SERVICE (ret);
  else
    return NULL;
}

/**
 * realm_dbus_service_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Service.top_of_page">org.freedesktop.realmd.Service</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See realm_dbus_service_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type RealmDbusServiceProxy): The constructed proxy object or %NULL if @error is set.
 */
RealmDbusService *
realm_dbus_service_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (REALM_DBUS_TYPE_SERVICE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.realmd.Service", NULL);
  if (ret != NULL)
    return REALM_DBUS_SERVICE (ret);
  else
    return NULL;
}


/**
 * realm_dbus_service_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like realm_dbus_service_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call realm_dbus_service_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See realm_dbus_service_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
realm_dbus_service_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (REALM_DBUS_TYPE_SERVICE_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.realmd.Service", NULL);
}

/**
 * realm_dbus_service_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to realm_dbus_service_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with realm_dbus_service_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type RealmDbusServiceProxy): The constructed proxy object or %NULL if @error is set.
 */
RealmDbusService *
realm_dbus_service_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return REALM_DBUS_SERVICE (ret);
  else
    return NULL;
}

/**
 * realm_dbus_service_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like realm_dbus_service_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See realm_dbus_service_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type RealmDbusServiceProxy): The constructed proxy object or %NULL if @error is set.
 */
RealmDbusService *
realm_dbus_service_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (REALM_DBUS_TYPE_SERVICE_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.realmd.Service", NULL);
  if (ret != NULL)
    return REALM_DBUS_SERVICE (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * RealmDbusServiceSkeleton:
 *
 * The #RealmDbusServiceSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * RealmDbusServiceSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #RealmDbusServiceSkeleton.
 */

struct _RealmDbusServiceSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_realm_dbus_service_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  RealmDbusServiceSkeleton *skeleton = REALM_DBUS_SERVICE_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], REALM_DBUS_TYPE_SERVICE);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, REALM_DBUS_TYPE_SERVICE);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_realm_dbus_service_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  RealmDbusServiceSkeleton *skeleton = REALM_DBUS_SERVICE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_realm_dbus_service_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_realm_dbus_service_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  RealmDbusServiceSkeleton *skeleton = REALM_DBUS_SERVICE_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_realm_dbus_service_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _realm_dbus_service_skeleton_vtable =
{
  _realm_dbus_service_skeleton_handle_method_call,
  _realm_dbus_service_skeleton_handle_get_property,
  _realm_dbus_service_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
realm_dbus_service_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return realm_dbus_service_interface_info ();
}

static GDBusInterfaceVTable *
realm_dbus_service_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_realm_dbus_service_skeleton_vtable;
}

static GVariant *
realm_dbus_service_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  RealmDbusServiceSkeleton *skeleton = REALM_DBUS_SERVICE_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_realm_dbus_service_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _realm_dbus_service_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _realm_dbus_service_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _realm_dbus_service_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.realmd.Service", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static void
realm_dbus_service_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton G_GNUC_UNUSED)
{
}

static void
_realm_dbus_service_on_signal_diagnostics (
    RealmDbusService *object,
    const gchar *arg_data,
    const gchar *arg_operation)
{
  RealmDbusServiceSkeleton *skeleton = REALM_DBUS_SERVICE_SKELETON (object);

  GList      *connections, *l;
  GVariant   *signal_variant;
  connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));

  signal_variant = g_variant_ref_sink (g_variant_new ("(ss)",
                   arg_data,
                   arg_operation));
  for (l = connections; l != NULL; l = l->next)
    {
      GDBusConnection *connection = l->data;
      g_dbus_connection_emit_signal (connection,
        NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.realmd.Service", "Diagnostics",
        signal_variant, NULL);
    }
  g_variant_unref (signal_variant);
  g_list_free_full (connections, g_object_unref);
}

static void realm_dbus_service_skeleton_iface_init (RealmDbusServiceIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (RealmDbusServiceSkeleton, realm_dbus_service_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (RealmDbusServiceSkeleton)
                         G_IMPLEMENT_INTERFACE (REALM_DBUS_TYPE_SERVICE, realm_dbus_service_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (RealmDbusServiceSkeleton, realm_dbus_service_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (REALM_DBUS_TYPE_SERVICE, realm_dbus_service_skeleton_iface_init))

#endif
static void
realm_dbus_service_skeleton_finalize (GObject *object)
{
  RealmDbusServiceSkeleton *skeleton = REALM_DBUS_SERVICE_SKELETON (object);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (realm_dbus_service_skeleton_parent_class)->finalize (object);
}

static void
realm_dbus_service_skeleton_init (RealmDbusServiceSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = realm_dbus_service_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, REALM_DBUS_TYPE_SERVICE_SKELETON, RealmDbusServiceSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
}

static void
realm_dbus_service_skeleton_class_init (RealmDbusServiceSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = realm_dbus_service_skeleton_finalize;

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = realm_dbus_service_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = realm_dbus_service_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = realm_dbus_service_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = realm_dbus_service_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (RealmDbusServiceSkeletonPrivate));
#endif
}

static void
realm_dbus_service_skeleton_iface_init (RealmDbusServiceIface *iface)
{
  iface->diagnostics = _realm_dbus_service_on_signal_diagnostics;
}

/**
 * realm_dbus_service_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Service.top_of_page">org.freedesktop.realmd.Service</link>.
 *
 * Returns: (transfer full) (type RealmDbusServiceSkeleton): The skeleton object.
 */
RealmDbusService *
realm_dbus_service_skeleton_new (void)
{
  return REALM_DBUS_SERVICE (g_object_new (REALM_DBUS_TYPE_SERVICE_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.realmd.Realm
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:RealmDbusRealm
 * @title: RealmDbusRealm
 * @short_description: Generated C code for the org.freedesktop.realmd.Realm D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-realmd-Realm.top_of_page">org.freedesktop.realmd.Realm</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.realmd.Realm ---- */

static const _ExtendedGDBusArgInfo _realm_dbus_realm_method_info_deconfigure_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _realm_dbus_realm_method_info_deconfigure_IN_ARG_pointers[] =
{
  &_realm_dbus_realm_method_info_deconfigure_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _realm_dbus_realm_method_info_deconfigure =
{
  {
    -1,
    (gchar *) "Deconfigure",
    (GDBusArgInfo **) &_realm_dbus_realm_method_info_deconfigure_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-deconfigure",
  FALSE
};

static const _ExtendedGDBusArgInfo _realm_dbus_realm_method_info_change_login_policy_IN_ARG_login_policy =
{
  {
    -1,
    (gchar *) "login_policy",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _realm_dbus_realm_method_info_change_login_policy_IN_ARG_permitted_add =
{
  {
    -1,
    (gchar *) "permitted_add",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _realm_dbus_realm_method_info_change_login_policy_IN_ARG_permitted_remove =
{
  {
    -1,
    (gchar *) "permitted_remove",
    (gchar *) "as",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _realm_dbus_realm_method_info_change_login_policy_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _realm_dbus_realm_method_info_change_login_policy_IN_ARG_pointers[] =
{
  &_realm_dbus_realm_method_info_change_login_policy_IN_ARG_login_policy.parent_struct,
  &_realm_dbus_realm_method_info_change_login_policy_IN_ARG_permitted_add.parent_struct,
  &_realm_dbus_realm_method_info_change_login_policy_IN_ARG_permitted_remove.parent_struct,
  &_realm_dbus_realm_method_info_change_login_policy_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _realm_dbus_realm_method_info_change_login_policy =
{
  {
    -1,
    (gchar *) "ChangeLoginPolicy",
    (GDBusArgInfo **) &_realm_dbus_realm_method_info_change_login_policy_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-change-login-policy",
  FALSE
};

static const GDBusMethodInfo * const _realm_dbus_realm_method_info_pointers[] =
{
  &_realm_dbus_realm_method_info_deconfigure.parent_struct,
  &_realm_dbus_realm_method_info_change_login_policy.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _realm_dbus_realm_property_info_name =
{
  {
    -1,
    (gchar *) "Name",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "name",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _realm_dbus_realm_property_info_configured =
{
  {
    -1,
    (gchar *) "Configured",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "configured",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _realm_dbus_realm_property_info_supported_interfaces =
{
  {
    -1,
    (gchar *) "SupportedInterfaces",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "supported-interfaces",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _realm_dbus_realm_property_info_details =
{
  {
    -1,
    (gchar *) "Details",
    (gchar *) "a(ss)",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "details",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _realm_dbus_realm_property_info_required_packages =
{
  {
    -1,
    (gchar *) "RequiredPackages",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "required-packages",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _realm_dbus_realm_property_info_login_formats =
{
  {
    -1,
    (gchar *) "LoginFormats",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "login-formats",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _realm_dbus_realm_property_info_login_policy =
{
  {
    -1,
    (gchar *) "LoginPolicy",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "login-policy",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _realm_dbus_realm_property_info_permitted_logins =
{
  {
    -1,
    (gchar *) "PermittedLogins",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "permitted-logins",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _realm_dbus_realm_property_info_permitted_groups =
{
  {
    -1,
    (gchar *) "PermittedGroups",
    (gchar *) "as",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "permitted-groups",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _realm_dbus_realm_property_info_pointers[] =
{
  &_realm_dbus_realm_property_info_name.parent_struct,
  &_realm_dbus_realm_property_info_configured.parent_struct,
  &_realm_dbus_realm_property_info_supported_interfaces.parent_struct,
  &_realm_dbus_realm_property_info_details.parent_struct,
  &_realm_dbus_realm_property_info_required_packages.parent_struct,
  &_realm_dbus_realm_property_info_login_formats.parent_struct,
  &_realm_dbus_realm_property_info_login_policy.parent_struct,
  &_realm_dbus_realm_property_info_permitted_logins.parent_struct,
  &_realm_dbus_realm_property_info_permitted_groups.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _realm_dbus_realm_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.realmd.Realm",
    (GDBusMethodInfo **) &_realm_dbus_realm_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_realm_dbus_realm_property_info_pointers,
    NULL
  },
  "realm",
};


/**
 * realm_dbus_realm_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-realmd-Realm.top_of_page">org.freedesktop.realmd.Realm</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
realm_dbus_realm_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_realm_dbus_realm_interface_info.parent_struct;
}

/**
 * realm_dbus_realm_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #RealmDbusRealm interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
realm_dbus_realm_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "name");
  g_object_class_override_property (klass, property_id_begin++, "configured");
  g_object_class_override_property (klass, property_id_begin++, "supported-interfaces");
  g_object_class_override_property (klass, property_id_begin++, "details");
  g_object_class_override_property (klass, property_id_begin++, "required-packages");
  g_object_class_override_property (klass, property_id_begin++, "login-formats");
  g_object_class_override_property (klass, property_id_begin++, "login-policy");
  g_object_class_override_property (klass, property_id_begin++, "permitted-logins");
  g_object_class_override_property (klass, property_id_begin++, "permitted-groups");
  return property_id_begin - 1;
}



/**
 * RealmDbusRealm:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Realm.top_of_page">org.freedesktop.realmd.Realm</link>.
 */

/**
 * RealmDbusRealmIface:
 * @parent_iface: The parent interface.
 * @handle_change_login_policy: Handler for the #RealmDbusRealm::handle-change-login-policy signal.
 * @handle_deconfigure: Handler for the #RealmDbusRealm::handle-deconfigure signal.
 * @get_configured: Getter for the #RealmDbusRealm:configured property.
 * @get_details: Getter for the #RealmDbusRealm:details property.
 * @get_login_formats: Getter for the #RealmDbusRealm:login-formats property.
 * @get_login_policy: Getter for the #RealmDbusRealm:login-policy property.
 * @get_name: Getter for the #RealmDbusRealm:name property.
 * @get_permitted_groups: Getter for the #RealmDbusRealm:permitted-groups property.
 * @get_permitted_logins: Getter for the #RealmDbusRealm:permitted-logins property.
 * @get_required_packages: Getter for the #RealmDbusRealm:required-packages property.
 * @get_supported_interfaces: Getter for the #RealmDbusRealm:supported-interfaces property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Realm.top_of_page">org.freedesktop.realmd.Realm</link>.
 */

typedef RealmDbusRealmIface RealmDbusRealmInterface;
G_DEFINE_INTERFACE (RealmDbusRealm, realm_dbus_realm, G_TYPE_OBJECT)

static void
realm_dbus_realm_default_init (RealmDbusRealmIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * RealmDbusRealm::handle-deconfigure:
   * @object: A #RealmDbusRealm.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-realmd-Realm.Deconfigure">Deconfigure()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call realm_dbus_realm_complete_deconfigure() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-deconfigure",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (RealmDbusRealmIface, handle_deconfigure),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * RealmDbusRealm::handle-change-login-policy:
   * @object: A #RealmDbusRealm.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_login_policy: Argument passed by remote caller.
   * @arg_permitted_add: Argument passed by remote caller.
   * @arg_permitted_remove: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-realmd-Realm.ChangeLoginPolicy">ChangeLoginPolicy()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call realm_dbus_realm_complete_change_login_policy() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-change-login-policy",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (RealmDbusRealmIface, handle_change_login_policy),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    5,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_STRV, G_TYPE_STRV, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * RealmDbusRealm:name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-realmd-Realm.Name">"Name"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("name", "Name", "Name", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * RealmDbusRealm:configured:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-realmd-Realm.Configured">"Configured"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("configured", "Configured", "Configured", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * RealmDbusRealm:supported-interfaces:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-realmd-Realm.SupportedInterfaces">"SupportedInterfaces"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("supported-interfaces", "SupportedInterfaces", "SupportedInterfaces", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * RealmDbusRealm:details:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-realmd-Realm.Details">"Details"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("details", "Details", "Details", G_VARIANT_TYPE ("a(ss)"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * RealmDbusRealm:required-packages:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-realmd-Realm.RequiredPackages">"RequiredPackages"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("required-packages", "RequiredPackages", "RequiredPackages", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * RealmDbusRealm:login-formats:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-realmd-Realm.LoginFormats">"LoginFormats"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("login-formats", "LoginFormats", "LoginFormats", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * RealmDbusRealm:login-policy:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-realmd-Realm.LoginPolicy">"LoginPolicy"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("login-policy", "LoginPolicy", "LoginPolicy", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * RealmDbusRealm:permitted-logins:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-realmd-Realm.PermittedLogins">"PermittedLogins"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("permitted-logins", "PermittedLogins", "PermittedLogins", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * RealmDbusRealm:permitted-groups:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-realmd-Realm.PermittedGroups">"PermittedGroups"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_boxed ("permitted-groups", "PermittedGroups", "PermittedGroups", G_TYPE_STRV, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * realm_dbus_realm_get_name: (skip)
 * @object: A #RealmDbusRealm.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.Name">"Name"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use realm_dbus_realm_dup_name() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
realm_dbus_realm_get_name (RealmDbusRealm *object)
{
  return REALM_DBUS_REALM_GET_IFACE (object)->get_name (object);
}

/**
 * realm_dbus_realm_dup_name: (skip)
 * @object: A #RealmDbusRealm.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.Name">"Name"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
realm_dbus_realm_dup_name (RealmDbusRealm *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "name", &value, NULL);
  return value;
}

/**
 * realm_dbus_realm_set_name: (skip)
 * @object: A #RealmDbusRealm.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.Name">"Name"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
realm_dbus_realm_set_name (RealmDbusRealm *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "name", value, NULL);
}

/**
 * realm_dbus_realm_get_configured: (skip)
 * @object: A #RealmDbusRealm.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.Configured">"Configured"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use realm_dbus_realm_dup_configured() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
realm_dbus_realm_get_configured (RealmDbusRealm *object)
{
  return REALM_DBUS_REALM_GET_IFACE (object)->get_configured (object);
}

/**
 * realm_dbus_realm_dup_configured: (skip)
 * @object: A #RealmDbusRealm.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.Configured">"Configured"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
realm_dbus_realm_dup_configured (RealmDbusRealm *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "configured", &value, NULL);
  return value;
}

/**
 * realm_dbus_realm_set_configured: (skip)
 * @object: A #RealmDbusRealm.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.Configured">"Configured"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
realm_dbus_realm_set_configured (RealmDbusRealm *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "configured", value, NULL);
}

/**
 * realm_dbus_realm_get_supported_interfaces: (skip)
 * @object: A #RealmDbusRealm.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.SupportedInterfaces">"SupportedInterfaces"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use realm_dbus_realm_dup_supported_interfaces() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
realm_dbus_realm_get_supported_interfaces (RealmDbusRealm *object)
{
  return REALM_DBUS_REALM_GET_IFACE (object)->get_supported_interfaces (object);
}

/**
 * realm_dbus_realm_dup_supported_interfaces: (skip)
 * @object: A #RealmDbusRealm.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.SupportedInterfaces">"SupportedInterfaces"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
realm_dbus_realm_dup_supported_interfaces (RealmDbusRealm *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "supported-interfaces", &value, NULL);
  return value;
}

/**
 * realm_dbus_realm_set_supported_interfaces: (skip)
 * @object: A #RealmDbusRealm.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.SupportedInterfaces">"SupportedInterfaces"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
realm_dbus_realm_set_supported_interfaces (RealmDbusRealm *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "supported-interfaces", value, NULL);
}

/**
 * realm_dbus_realm_get_details: (skip)
 * @object: A #RealmDbusRealm.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.Details">"Details"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use realm_dbus_realm_dup_details() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
realm_dbus_realm_get_details (RealmDbusRealm *object)
{
  return REALM_DBUS_REALM_GET_IFACE (object)->get_details (object);
}

/**
 * realm_dbus_realm_dup_details: (skip)
 * @object: A #RealmDbusRealm.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.Details">"Details"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
realm_dbus_realm_dup_details (RealmDbusRealm *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "details", &value, NULL);
  return value;
}

/**
 * realm_dbus_realm_set_details: (skip)
 * @object: A #RealmDbusRealm.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.Details">"Details"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
realm_dbus_realm_set_details (RealmDbusRealm *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "details", value, NULL);
}

/**
 * realm_dbus_realm_get_required_packages: (skip)
 * @object: A #RealmDbusRealm.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.RequiredPackages">"RequiredPackages"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use realm_dbus_realm_dup_required_packages() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
realm_dbus_realm_get_required_packages (RealmDbusRealm *object)
{
  return REALM_DBUS_REALM_GET_IFACE (object)->get_required_packages (object);
}

/**
 * realm_dbus_realm_dup_required_packages: (skip)
 * @object: A #RealmDbusRealm.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.RequiredPackages">"RequiredPackages"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
realm_dbus_realm_dup_required_packages (RealmDbusRealm *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "required-packages", &value, NULL);
  return value;
}

/**
 * realm_dbus_realm_set_required_packages: (skip)
 * @object: A #RealmDbusRealm.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.RequiredPackages">"RequiredPackages"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
realm_dbus_realm_set_required_packages (RealmDbusRealm *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "required-packages", value, NULL);
}

/**
 * realm_dbus_realm_get_login_formats: (skip)
 * @object: A #RealmDbusRealm.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.LoginFormats">"LoginFormats"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use realm_dbus_realm_dup_login_formats() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
realm_dbus_realm_get_login_formats (RealmDbusRealm *object)
{
  return REALM_DBUS_REALM_GET_IFACE (object)->get_login_formats (object);
}

/**
 * realm_dbus_realm_dup_login_formats: (skip)
 * @object: A #RealmDbusRealm.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.LoginFormats">"LoginFormats"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
realm_dbus_realm_dup_login_formats (RealmDbusRealm *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "login-formats", &value, NULL);
  return value;
}

/**
 * realm_dbus_realm_set_login_formats: (skip)
 * @object: A #RealmDbusRealm.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.LoginFormats">"LoginFormats"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
realm_dbus_realm_set_login_formats (RealmDbusRealm *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "login-formats", value, NULL);
}

/**
 * realm_dbus_realm_get_login_policy: (skip)
 * @object: A #RealmDbusRealm.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.LoginPolicy">"LoginPolicy"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use realm_dbus_realm_dup_login_policy() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
realm_dbus_realm_get_login_policy (RealmDbusRealm *object)
{
  return REALM_DBUS_REALM_GET_IFACE (object)->get_login_policy (object);
}

/**
 * realm_dbus_realm_dup_login_policy: (skip)
 * @object: A #RealmDbusRealm.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.LoginPolicy">"LoginPolicy"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
realm_dbus_realm_dup_login_policy (RealmDbusRealm *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "login-policy", &value, NULL);
  return value;
}

/**
 * realm_dbus_realm_set_login_policy: (skip)
 * @object: A #RealmDbusRealm.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.LoginPolicy">"LoginPolicy"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
realm_dbus_realm_set_login_policy (RealmDbusRealm *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "login-policy", value, NULL);
}

/**
 * realm_dbus_realm_get_permitted_logins: (skip)
 * @object: A #RealmDbusRealm.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.PermittedLogins">"PermittedLogins"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use realm_dbus_realm_dup_permitted_logins() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
realm_dbus_realm_get_permitted_logins (RealmDbusRealm *object)
{
  return REALM_DBUS_REALM_GET_IFACE (object)->get_permitted_logins (object);
}

/**
 * realm_dbus_realm_dup_permitted_logins: (skip)
 * @object: A #RealmDbusRealm.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.PermittedLogins">"PermittedLogins"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
realm_dbus_realm_dup_permitted_logins (RealmDbusRealm *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "permitted-logins", &value, NULL);
  return value;
}

/**
 * realm_dbus_realm_set_permitted_logins: (skip)
 * @object: A #RealmDbusRealm.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.PermittedLogins">"PermittedLogins"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
realm_dbus_realm_set_permitted_logins (RealmDbusRealm *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "permitted-logins", value, NULL);
}

/**
 * realm_dbus_realm_get_permitted_groups: (skip)
 * @object: A #RealmDbusRealm.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.PermittedGroups">"PermittedGroups"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use realm_dbus_realm_dup_permitted_groups() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *const *
realm_dbus_realm_get_permitted_groups (RealmDbusRealm *object)
{
  return REALM_DBUS_REALM_GET_IFACE (object)->get_permitted_groups (object);
}

/**
 * realm_dbus_realm_dup_permitted_groups: (skip)
 * @object: A #RealmDbusRealm.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.PermittedGroups">"PermittedGroups"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_strfreev().
 */
gchar **
realm_dbus_realm_dup_permitted_groups (RealmDbusRealm *object)
{
  gchar **value;
  g_object_get (G_OBJECT (object), "permitted-groups", &value, NULL);
  return value;
}

/**
 * realm_dbus_realm_set_permitted_groups: (skip)
 * @object: A #RealmDbusRealm.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-realmd-Realm.PermittedGroups">"PermittedGroups"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
realm_dbus_realm_set_permitted_groups (RealmDbusRealm *object, const gchar *const *value)
{
  g_object_set (G_OBJECT (object), "permitted-groups", value, NULL);
}

/**
 * realm_dbus_realm_call_deconfigure:
 * @proxy: A #RealmDbusRealmProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-realmd-Realm.Deconfigure">Deconfigure()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call realm_dbus_realm_call_deconfigure_finish() to get the result of the operation.
 *
 * See realm_dbus_realm_call_deconfigure_sync() for the synchronous, blocking version of this method.
 */
void
realm_dbus_realm_call_deconfigure (
    RealmDbusRealm *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Deconfigure",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * realm_dbus_realm_call_deconfigure_finish:
 * @proxy: A #RealmDbusRealmProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to realm_dbus_realm_call_deconfigure().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with realm_dbus_realm_call_deconfigure().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
realm_dbus_realm_call_deconfigure_finish (
    RealmDbusRealm *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * realm_dbus_realm_call_deconfigure_sync:
 * @proxy: A #RealmDbusRealmProxy.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-realmd-Realm.Deconfigure">Deconfigure()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See realm_dbus_realm_call_deconfigure() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
realm_dbus_realm_call_deconfigure_sync (
    RealmDbusRealm *proxy,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Deconfigure",
    g_variant_new ("(@a{sv})",
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * realm_dbus_realm_call_change_login_policy:
 * @proxy: A #RealmDbusRealmProxy.
 * @arg_login_policy: Argument to pass with the method invocation.
 * @arg_permitted_add: Argument to pass with the method invocation.
 * @arg_permitted_remove: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-realmd-Realm.ChangeLoginPolicy">ChangeLoginPolicy()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call realm_dbus_realm_call_change_login_policy_finish() to get the result of the operation.
 *
 * See realm_dbus_realm_call_change_login_policy_sync() for the synchronous, blocking version of this method.
 */
void
realm_dbus_realm_call_change_login_policy (
    RealmDbusRealm *proxy,
    const gchar *arg_login_policy,
    const gchar *const *arg_permitted_add,
    const gchar *const *arg_permitted_remove,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ChangeLoginPolicy",
    g_variant_new ("(s^as^as@a{sv})",
                   arg_login_policy,
                   arg_permitted_add,
                   arg_permitted_remove,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * realm_dbus_realm_call_change_login_policy_finish:
 * @proxy: A #RealmDbusRealmProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to realm_dbus_realm_call_change_login_policy().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with realm_dbus_realm_call_change_login_policy().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
realm_dbus_realm_call_change_login_policy_finish (
    RealmDbusRealm *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * realm_dbus_realm_call_change_login_policy_sync:
 * @proxy: A #RealmDbusRealmProxy.
 * @arg_login_policy: Argument to pass with the method invocation.
 * @arg_permitted_add: Argument to pass with the method invocation.
 * @arg_permitted_remove: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-realmd-Realm.ChangeLoginPolicy">ChangeLoginPolicy()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See realm_dbus_realm_call_change_login_policy() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
realm_dbus_realm_call_change_login_policy_sync (
    RealmDbusRealm *proxy,
    const gchar *arg_login_policy,
    const gchar *const *arg_permitted_add,
    const gchar *const *arg_permitted_remove,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ChangeLoginPolicy",
    g_variant_new ("(s^as^as@a{sv})",
                   arg_login_policy,
                   arg_permitted_add,
                   arg_permitted_remove,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * realm_dbus_realm_complete_deconfigure:
 * @object: A #RealmDbusRealm.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-realmd-Realm.Deconfigure">Deconfigure()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
realm_dbus_realm_complete_deconfigure (
    RealmDbusRealm *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * realm_dbus_realm_complete_change_login_policy:
 * @object: A #RealmDbusRealm.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-realmd-Realm.ChangeLoginPolicy">ChangeLoginPolicy()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
realm_dbus_realm_complete_change_login_policy (
    RealmDbusRealm *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * RealmDbusRealmProxy:
 *
 * The #RealmDbusRealmProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * RealmDbusRealmProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #RealmDbusRealmProxy.
 */

struct _RealmDbusRealmProxyPrivate
{
  GData *qdata;
};

static void realm_dbus_realm_proxy_iface_init (RealmDbusRealmIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (RealmDbusRealmProxy, realm_dbus_realm_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (RealmDbusRealmProxy)
                         G_IMPLEMENT_INTERFACE (REALM_DBUS_TYPE_REALM, realm_dbus_realm_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (RealmDbusRealmProxy, realm_dbus_realm_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (REALM_DBUS_TYPE_REALM, realm_dbus_realm_proxy_iface_init))

#endif
static void
realm_dbus_realm_proxy_finalize (GObject *object)
{
  RealmDbusRealmProxy *proxy = REALM_DBUS_REALM_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (realm_dbus_realm_proxy_parent_class)->finalize (object);
}

static void
realm_dbus_realm_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 9);
  info = (const _ExtendedGDBusPropertyInfo *) _realm_dbus_realm_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
realm_dbus_realm_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.realmd.Realm: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
realm_dbus_realm_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 9);
  info = (const _ExtendedGDBusPropertyInfo *) _realm_dbus_realm_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.realmd.Realm", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) realm_dbus_realm_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
realm_dbus_realm_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_realm_dbus_realm_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], REALM_DBUS_TYPE_REALM);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, REALM_DBUS_TYPE_REALM);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
realm_dbus_realm_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  RealmDbusRealmProxy *proxy = REALM_DBUS_REALM_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_realm_dbus_realm_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_realm_dbus_realm_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
realm_dbus_realm_proxy_get_name (RealmDbusRealm *object)
{
  RealmDbusRealmProxy *proxy = REALM_DBUS_REALM_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Name");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
realm_dbus_realm_proxy_get_configured (RealmDbusRealm *object)
{
  RealmDbusRealmProxy *proxy = REALM_DBUS_REALM_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Configured");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
realm_dbus_realm_proxy_get_supported_interfaces (RealmDbusRealm *object)
{
  RealmDbusRealmProxy *proxy = REALM_DBUS_REALM_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "SupportedInterfaces");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SupportedInterfaces");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "SupportedInterfaces", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
realm_dbus_realm_proxy_get_details (RealmDbusRealm *object)
{
  RealmDbusRealmProxy *proxy = REALM_DBUS_REALM_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Details");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static const gchar *const *
realm_dbus_realm_proxy_get_required_packages (RealmDbusRealm *object)
{
  RealmDbusRealmProxy *proxy = REALM_DBUS_REALM_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "RequiredPackages");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "RequiredPackages");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "RequiredPackages", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
realm_dbus_realm_proxy_get_login_formats (RealmDbusRealm *object)
{
  RealmDbusRealmProxy *proxy = REALM_DBUS_REALM_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "LoginFormats");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "LoginFormats");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "LoginFormats", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
realm_dbus_realm_proxy_get_login_policy (RealmDbusRealm *object)
{
  RealmDbusRealmProxy *proxy = REALM_DBUS_REALM_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "LoginPolicy");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
realm_dbus_realm_proxy_get_permitted_logins (RealmDbusRealm *object)
{
  RealmDbusRealmProxy *proxy = REALM_DBUS_REALM_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "PermittedLogins");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "PermittedLogins");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "PermittedLogins", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *const *
realm_dbus_realm_proxy_get_permitted_groups (RealmDbusRealm *object)
{
  RealmDbusRealmProxy *proxy = REALM_DBUS_REALM_PROXY (object);
  GVariant *variant;
  const gchar *const *value = NULL;
  value = g_datalist_get_data (&proxy->priv->qdata, "PermittedGroups");
  if (value != NULL)
    return value;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "PermittedGroups");
  if (variant != NULL)
    {
      value = g_variant_get_strv (variant, NULL);
      g_datalist_set_data_full (&proxy->priv->qdata, "PermittedGroups", (gpointer) value, g_free);
      g_variant_unref (variant);
    }
  return value;
}

static void
realm_dbus_realm_proxy_init (RealmDbusRealmProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = realm_dbus_realm_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, REALM_DBUS_TYPE_REALM_PROXY, RealmDbusRealmProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), realm_dbus_realm_interface_info ());
}

static void
realm_dbus_realm_proxy_class_init (RealmDbusRealmProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = realm_dbus_realm_proxy_finalize;
  gobject_class->get_property = realm_dbus_realm_proxy_get_property;
  gobject_class->set_property = realm_dbus_realm_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = realm_dbus_realm_proxy_g_signal;
  proxy_class->g_properties_changed = realm_dbus_realm_proxy_g_properties_changed;

  realm_dbus_realm_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (RealmDbusRealmProxyPrivate));
#endif
}

static void
realm_dbus_realm_proxy_iface_init (RealmDbusRealmIface *iface)
{
  iface->get_name = realm_dbus_realm_proxy_get_name;
  iface->get_configured = realm_dbus_realm_proxy_get_configured;
  iface->get_supported_interfaces = realm_dbus_realm_proxy_get_supported_interfaces;
  iface->get_details = realm_dbus_realm_proxy_get_details;
  iface->get_required_packages = realm_dbus_realm_proxy_get_required_packages;
  iface->get_login_formats = realm_dbus_realm_proxy_get_login_formats;
  iface->get_login_policy = realm_dbus_realm_proxy_get_login_policy;
  iface->get_permitted_logins = realm_dbus_realm_proxy_get_permitted_logins;
  iface->get_permitted_groups = realm_dbus_realm_proxy_get_permitted_groups;
}

/**
 * realm_dbus_realm_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Realm.top_of_page">org.freedesktop.realmd.Realm</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call realm_dbus_realm_proxy_new_finish() to get the result of the operation.
 *
 * See realm_dbus_realm_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
realm_dbus_realm_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (REALM_DBUS_TYPE_REALM_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.realmd.Realm", NULL);
}

/**
 * realm_dbus_realm_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to realm_dbus_realm_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with realm_dbus_realm_proxy_new().
 *
 * Returns: (transfer full) (type RealmDbusRealmProxy): The constructed proxy object or %NULL if @error is set.
 */
RealmDbusRealm *
realm_dbus_realm_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return REALM_DBUS_REALM (ret);
  else
    return NULL;
}

/**
 * realm_dbus_realm_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Realm.top_of_page">org.freedesktop.realmd.Realm</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See realm_dbus_realm_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type RealmDbusRealmProxy): The constructed proxy object or %NULL if @error is set.
 */
RealmDbusRealm *
realm_dbus_realm_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (REALM_DBUS_TYPE_REALM_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.realmd.Realm", NULL);
  if (ret != NULL)
    return REALM_DBUS_REALM (ret);
  else
    return NULL;
}


/**
 * realm_dbus_realm_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like realm_dbus_realm_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call realm_dbus_realm_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See realm_dbus_realm_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
realm_dbus_realm_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (REALM_DBUS_TYPE_REALM_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.realmd.Realm", NULL);
}

/**
 * realm_dbus_realm_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to realm_dbus_realm_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with realm_dbus_realm_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type RealmDbusRealmProxy): The constructed proxy object or %NULL if @error is set.
 */
RealmDbusRealm *
realm_dbus_realm_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return REALM_DBUS_REALM (ret);
  else
    return NULL;
}

/**
 * realm_dbus_realm_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like realm_dbus_realm_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See realm_dbus_realm_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type RealmDbusRealmProxy): The constructed proxy object or %NULL if @error is set.
 */
RealmDbusRealm *
realm_dbus_realm_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (REALM_DBUS_TYPE_REALM_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.realmd.Realm", NULL);
  if (ret != NULL)
    return REALM_DBUS_REALM (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * RealmDbusRealmSkeleton:
 *
 * The #RealmDbusRealmSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * RealmDbusRealmSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #RealmDbusRealmSkeleton.
 */

struct _RealmDbusRealmSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_realm_dbus_realm_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  RealmDbusRealmSkeleton *skeleton = REALM_DBUS_REALM_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], REALM_DBUS_TYPE_REALM);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, REALM_DBUS_TYPE_REALM);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_realm_dbus_realm_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  RealmDbusRealmSkeleton *skeleton = REALM_DBUS_REALM_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_realm_dbus_realm_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_realm_dbus_realm_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  RealmDbusRealmSkeleton *skeleton = REALM_DBUS_REALM_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_realm_dbus_realm_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _realm_dbus_realm_skeleton_vtable =
{
  _realm_dbus_realm_skeleton_handle_method_call,
  _realm_dbus_realm_skeleton_handle_get_property,
  _realm_dbus_realm_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
realm_dbus_realm_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return realm_dbus_realm_interface_info ();
}

static GDBusInterfaceVTable *
realm_dbus_realm_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_realm_dbus_realm_skeleton_vtable;
}

static GVariant *
realm_dbus_realm_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  RealmDbusRealmSkeleton *skeleton = REALM_DBUS_REALM_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_realm_dbus_realm_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _realm_dbus_realm_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _realm_dbus_realm_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _realm_dbus_realm_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.realmd.Realm", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _realm_dbus_realm_emit_changed (gpointer user_data);

static void
realm_dbus_realm_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  RealmDbusRealmSkeleton *skeleton = REALM_DBUS_REALM_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _realm_dbus_realm_emit_changed (skeleton);
}

static void realm_dbus_realm_skeleton_iface_init (RealmDbusRealmIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (RealmDbusRealmSkeleton, realm_dbus_realm_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (RealmDbusRealmSkeleton)
                         G_IMPLEMENT_INTERFACE (REALM_DBUS_TYPE_REALM, realm_dbus_realm_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (RealmDbusRealmSkeleton, realm_dbus_realm_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (REALM_DBUS_TYPE_REALM, realm_dbus_realm_skeleton_iface_init))

#endif
static void
realm_dbus_realm_skeleton_finalize (GObject *object)
{
  RealmDbusRealmSkeleton *skeleton = REALM_DBUS_REALM_SKELETON (object);
  guint n;
  for (n = 0; n < 9; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (realm_dbus_realm_skeleton_parent_class)->finalize (object);
}

static void
realm_dbus_realm_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  RealmDbusRealmSkeleton *skeleton = REALM_DBUS_REALM_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 9);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_realm_dbus_realm_emit_changed (gpointer user_data)
{
  RealmDbusRealmSkeleton *skeleton = REALM_DBUS_REALM_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.realmd.Realm",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_realm_dbus_realm_schedule_emit_changed (RealmDbusRealmSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
realm_dbus_realm_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  RealmDbusRealmSkeleton *skeleton = REALM_DBUS_REALM_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _realm_dbus_realm_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _realm_dbus_realm_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
realm_dbus_realm_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  RealmDbusRealmSkeleton *skeleton = REALM_DBUS_REALM_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 9);
  info = (const _ExtendedGDBusPropertyInfo *) _realm_dbus_realm_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _realm_dbus_realm_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
realm_dbus_realm_skeleton_init (RealmDbusRealmSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = realm_dbus_realm_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, REALM_DBUS_TYPE_REALM_SKELETON, RealmDbusRealmSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 9);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[3], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[4], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[5], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[6], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[7], G_TYPE_STRV);
  g_value_init (&skeleton->priv->properties[8], G_TYPE_STRV);
}

static const gchar *
realm_dbus_realm_skeleton_get_name (RealmDbusRealm *object)
{
  RealmDbusRealmSkeleton *skeleton = REALM_DBUS_REALM_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
realm_dbus_realm_skeleton_get_configured (RealmDbusRealm *object)
{
  RealmDbusRealmSkeleton *skeleton = REALM_DBUS_REALM_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
realm_dbus_realm_skeleton_get_supported_interfaces (RealmDbusRealm *object)
{
  RealmDbusRealmSkeleton *skeleton = REALM_DBUS_REALM_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
realm_dbus_realm_skeleton_get_details (RealmDbusRealm *object)
{
  RealmDbusRealmSkeleton *skeleton = REALM_DBUS_REALM_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[3]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
realm_dbus_realm_skeleton_get_required_packages (RealmDbusRealm *object)
{
  RealmDbusRealmSkeleton *skeleton = REALM_DBUS_REALM_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[4]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
realm_dbus_realm_skeleton_get_login_formats (RealmDbusRealm *object)
{
  RealmDbusRealmSkeleton *skeleton = REALM_DBUS_REALM_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[5]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
realm_dbus_realm_skeleton_get_login_policy (RealmDbusRealm *object)
{
  RealmDbusRealmSkeleton *skeleton = REALM_DBUS_REALM_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[6]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
realm_dbus_realm_skeleton_get_permitted_logins (RealmDbusRealm *object)
{
  RealmDbusRealmSkeleton *skeleton = REALM_DBUS_REALM_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[7]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *const *
realm_dbus_realm_skeleton_get_permitted_groups (RealmDbusRealm *object)
{
  RealmDbusRealmSkeleton *skeleton = REALM_DBUS_REALM_SKELETON (object);
  const gchar *const *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_boxed (&(skeleton->priv->properties[8]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
realm_dbus_realm_skeleton_class_init (RealmDbusRealmSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = realm_dbus_realm_skeleton_finalize;
  gobject_class->get_property = realm_dbus_realm_skeleton_get_property;
  gobject_class->set_property = realm_dbus_realm_skeleton_set_property;
  gobject_class->notify       = realm_dbus_realm_skeleton_notify;


  realm_dbus_realm_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = realm_dbus_realm_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = realm_dbus_realm_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = realm_dbus_realm_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = realm_dbus_realm_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (RealmDbusRealmSkeletonPrivate));
#endif
}

static void
realm_dbus_realm_skeleton_iface_init (RealmDbusRealmIface *iface)
{
  iface->get_name = realm_dbus_realm_skeleton_get_name;
  iface->get_configured = realm_dbus_realm_skeleton_get_configured;
  iface->get_supported_interfaces = realm_dbus_realm_skeleton_get_supported_interfaces;
  iface->get_details = realm_dbus_realm_skeleton_get_details;
  iface->get_required_packages = realm_dbus_realm_skeleton_get_required_packages;
  iface->get_login_formats = realm_dbus_realm_skeleton_get_login_formats;
  iface->get_login_policy = realm_dbus_realm_skeleton_get_login_policy;
  iface->get_permitted_logins = realm_dbus_realm_skeleton_get_permitted_logins;
  iface->get_permitted_groups = realm_dbus_realm_skeleton_get_permitted_groups;
}

/**
 * realm_dbus_realm_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Realm.top_of_page">org.freedesktop.realmd.Realm</link>.
 *
 * Returns: (transfer full) (type RealmDbusRealmSkeleton): The skeleton object.
 */
RealmDbusRealm *
realm_dbus_realm_skeleton_new (void)
{
  return REALM_DBUS_REALM (g_object_new (REALM_DBUS_TYPE_REALM_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.realmd.Kerberos
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:RealmDbusKerberos
 * @title: RealmDbusKerberos
 * @short_description: Generated C code for the org.freedesktop.realmd.Kerberos D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-realmd-Kerberos.top_of_page">org.freedesktop.realmd.Kerberos</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.realmd.Kerberos ---- */

static const _ExtendedGDBusPropertyInfo _realm_dbus_kerberos_property_info_realm_name =
{
  {
    -1,
    (gchar *) "RealmName",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "realm-name",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _realm_dbus_kerberos_property_info_domain_name =
{
  {
    -1,
    (gchar *) "DomainName",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "domain-name",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _realm_dbus_kerberos_property_info_pointers[] =
{
  &_realm_dbus_kerberos_property_info_realm_name.parent_struct,
  &_realm_dbus_kerberos_property_info_domain_name.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _realm_dbus_kerberos_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.realmd.Kerberos",
    NULL,
    NULL,
    (GDBusPropertyInfo **) &_realm_dbus_kerberos_property_info_pointers,
    NULL
  },
  "kerberos",
};


/**
 * realm_dbus_kerberos_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-realmd-Kerberos.top_of_page">org.freedesktop.realmd.Kerberos</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
realm_dbus_kerberos_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_realm_dbus_kerberos_interface_info.parent_struct;
}

/**
 * realm_dbus_kerberos_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #RealmDbusKerberos interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
realm_dbus_kerberos_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "realm-name");
  g_object_class_override_property (klass, property_id_begin++, "domain-name");
  return property_id_begin - 1;
}



/**
 * RealmDbusKerberos:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Kerberos.top_of_page">org.freedesktop.realmd.Kerberos</link>.
 */

/**
 * RealmDbusKerberosIface:
 * @parent_iface: The parent interface.
 * @get_domain_name: Getter for the #RealmDbusKerberos:domain-name property.
 * @get_realm_name: Getter for the #RealmDbusKerberos:realm-name property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Kerberos.top_of_page">org.freedesktop.realmd.Kerberos</link>.
 */

typedef RealmDbusKerberosIface RealmDbusKerberosInterface;
G_DEFINE_INTERFACE (RealmDbusKerberos, realm_dbus_kerberos, G_TYPE_OBJECT)

static void
realm_dbus_kerberos_default_init (RealmDbusKerberosIface *iface)
{
  /* GObject properties for D-Bus properties: */
  /**
   * RealmDbusKerberos:realm-name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-realmd-Kerberos.RealmName">"RealmName"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("realm-name", "RealmName", "RealmName", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * RealmDbusKerberos:domain-name:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-realmd-Kerberos.DomainName">"DomainName"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("domain-name", "DomainName", "DomainName", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * realm_dbus_kerberos_get_realm_name: (skip)
 * @object: A #RealmDbusKerberos.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-realmd-Kerberos.RealmName">"RealmName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use realm_dbus_kerberos_dup_realm_name() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
realm_dbus_kerberos_get_realm_name (RealmDbusKerberos *object)
{
  return REALM_DBUS_KERBEROS_GET_IFACE (object)->get_realm_name (object);
}

/**
 * realm_dbus_kerberos_dup_realm_name: (skip)
 * @object: A #RealmDbusKerberos.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-realmd-Kerberos.RealmName">"RealmName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
realm_dbus_kerberos_dup_realm_name (RealmDbusKerberos *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "realm-name", &value, NULL);
  return value;
}

/**
 * realm_dbus_kerberos_set_realm_name: (skip)
 * @object: A #RealmDbusKerberos.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-realmd-Kerberos.RealmName">"RealmName"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
realm_dbus_kerberos_set_realm_name (RealmDbusKerberos *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "realm-name", value, NULL);
}

/**
 * realm_dbus_kerberos_get_domain_name: (skip)
 * @object: A #RealmDbusKerberos.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-realmd-Kerberos.DomainName">"DomainName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use realm_dbus_kerberos_dup_domain_name() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
realm_dbus_kerberos_get_domain_name (RealmDbusKerberos *object)
{
  return REALM_DBUS_KERBEROS_GET_IFACE (object)->get_domain_name (object);
}

/**
 * realm_dbus_kerberos_dup_domain_name: (skip)
 * @object: A #RealmDbusKerberos.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-realmd-Kerberos.DomainName">"DomainName"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
realm_dbus_kerberos_dup_domain_name (RealmDbusKerberos *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "domain-name", &value, NULL);
  return value;
}

/**
 * realm_dbus_kerberos_set_domain_name: (skip)
 * @object: A #RealmDbusKerberos.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-realmd-Kerberos.DomainName">"DomainName"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
realm_dbus_kerberos_set_domain_name (RealmDbusKerberos *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "domain-name", value, NULL);
}

/* ------------------------------------------------------------------------ */

/**
 * RealmDbusKerberosProxy:
 *
 * The #RealmDbusKerberosProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * RealmDbusKerberosProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #RealmDbusKerberosProxy.
 */

struct _RealmDbusKerberosProxyPrivate
{
  GData *qdata;
};

static void realm_dbus_kerberos_proxy_iface_init (RealmDbusKerberosIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (RealmDbusKerberosProxy, realm_dbus_kerberos_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (RealmDbusKerberosProxy)
                         G_IMPLEMENT_INTERFACE (REALM_DBUS_TYPE_KERBEROS, realm_dbus_kerberos_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (RealmDbusKerberosProxy, realm_dbus_kerberos_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (REALM_DBUS_TYPE_KERBEROS, realm_dbus_kerberos_proxy_iface_init))

#endif
static void
realm_dbus_kerberos_proxy_finalize (GObject *object)
{
  RealmDbusKerberosProxy *proxy = REALM_DBUS_KERBEROS_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (realm_dbus_kerberos_proxy_parent_class)->finalize (object);
}

static void
realm_dbus_kerberos_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _realm_dbus_kerberos_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
realm_dbus_kerberos_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.realmd.Kerberos: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
realm_dbus_kerberos_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _realm_dbus_kerberos_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.realmd.Kerberos", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) realm_dbus_kerberos_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
realm_dbus_kerberos_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_realm_dbus_kerberos_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], REALM_DBUS_TYPE_KERBEROS);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, REALM_DBUS_TYPE_KERBEROS);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
realm_dbus_kerberos_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  RealmDbusKerberosProxy *proxy = REALM_DBUS_KERBEROS_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_realm_dbus_kerberos_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_realm_dbus_kerberos_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
realm_dbus_kerberos_proxy_get_realm_name (RealmDbusKerberos *object)
{
  RealmDbusKerberosProxy *proxy = REALM_DBUS_KERBEROS_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "RealmName");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static const gchar *
realm_dbus_kerberos_proxy_get_domain_name (RealmDbusKerberos *object)
{
  RealmDbusKerberosProxy *proxy = REALM_DBUS_KERBEROS_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "DomainName");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static void
realm_dbus_kerberos_proxy_init (RealmDbusKerberosProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = realm_dbus_kerberos_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, REALM_DBUS_TYPE_KERBEROS_PROXY, RealmDbusKerberosProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), realm_dbus_kerberos_interface_info ());
}

static void
realm_dbus_kerberos_proxy_class_init (RealmDbusKerberosProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = realm_dbus_kerberos_proxy_finalize;
  gobject_class->get_property = realm_dbus_kerberos_proxy_get_property;
  gobject_class->set_property = realm_dbus_kerberos_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = realm_dbus_kerberos_proxy_g_signal;
  proxy_class->g_properties_changed = realm_dbus_kerberos_proxy_g_properties_changed;

  realm_dbus_kerberos_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (RealmDbusKerberosProxyPrivate));
#endif
}

static void
realm_dbus_kerberos_proxy_iface_init (RealmDbusKerberosIface *iface)
{
  iface->get_realm_name = realm_dbus_kerberos_proxy_get_realm_name;
  iface->get_domain_name = realm_dbus_kerberos_proxy_get_domain_name;
}

/**
 * realm_dbus_kerberos_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Kerberos.top_of_page">org.freedesktop.realmd.Kerberos</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call realm_dbus_kerberos_proxy_new_finish() to get the result of the operation.
 *
 * See realm_dbus_kerberos_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
realm_dbus_kerberos_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (REALM_DBUS_TYPE_KERBEROS_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.realmd.Kerberos", NULL);
}

/**
 * realm_dbus_kerberos_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to realm_dbus_kerberos_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with realm_dbus_kerberos_proxy_new().
 *
 * Returns: (transfer full) (type RealmDbusKerberosProxy): The constructed proxy object or %NULL if @error is set.
 */
RealmDbusKerberos *
realm_dbus_kerberos_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return REALM_DBUS_KERBEROS (ret);
  else
    return NULL;
}

/**
 * realm_dbus_kerberos_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Kerberos.top_of_page">org.freedesktop.realmd.Kerberos</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See realm_dbus_kerberos_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type RealmDbusKerberosProxy): The constructed proxy object or %NULL if @error is set.
 */
RealmDbusKerberos *
realm_dbus_kerberos_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (REALM_DBUS_TYPE_KERBEROS_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.realmd.Kerberos", NULL);
  if (ret != NULL)
    return REALM_DBUS_KERBEROS (ret);
  else
    return NULL;
}


/**
 * realm_dbus_kerberos_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like realm_dbus_kerberos_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call realm_dbus_kerberos_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See realm_dbus_kerberos_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
realm_dbus_kerberos_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (REALM_DBUS_TYPE_KERBEROS_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.realmd.Kerberos", NULL);
}

/**
 * realm_dbus_kerberos_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to realm_dbus_kerberos_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with realm_dbus_kerberos_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type RealmDbusKerberosProxy): The constructed proxy object or %NULL if @error is set.
 */
RealmDbusKerberos *
realm_dbus_kerberos_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return REALM_DBUS_KERBEROS (ret);
  else
    return NULL;
}

/**
 * realm_dbus_kerberos_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like realm_dbus_kerberos_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See realm_dbus_kerberos_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type RealmDbusKerberosProxy): The constructed proxy object or %NULL if @error is set.
 */
RealmDbusKerberos *
realm_dbus_kerberos_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (REALM_DBUS_TYPE_KERBEROS_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.realmd.Kerberos", NULL);
  if (ret != NULL)
    return REALM_DBUS_KERBEROS (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * RealmDbusKerberosSkeleton:
 *
 * The #RealmDbusKerberosSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * RealmDbusKerberosSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #RealmDbusKerberosSkeleton.
 */

struct _RealmDbusKerberosSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_realm_dbus_kerberos_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  RealmDbusKerberosSkeleton *skeleton = REALM_DBUS_KERBEROS_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], REALM_DBUS_TYPE_KERBEROS);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, REALM_DBUS_TYPE_KERBEROS);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_realm_dbus_kerberos_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  RealmDbusKerberosSkeleton *skeleton = REALM_DBUS_KERBEROS_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_realm_dbus_kerberos_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_realm_dbus_kerberos_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  RealmDbusKerberosSkeleton *skeleton = REALM_DBUS_KERBEROS_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_realm_dbus_kerberos_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _realm_dbus_kerberos_skeleton_vtable =
{
  _realm_dbus_kerberos_skeleton_handle_method_call,
  _realm_dbus_kerberos_skeleton_handle_get_property,
  _realm_dbus_kerberos_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
realm_dbus_kerberos_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return realm_dbus_kerberos_interface_info ();
}

static GDBusInterfaceVTable *
realm_dbus_kerberos_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_realm_dbus_kerberos_skeleton_vtable;
}

static GVariant *
realm_dbus_kerberos_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  RealmDbusKerberosSkeleton *skeleton = REALM_DBUS_KERBEROS_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_realm_dbus_kerberos_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _realm_dbus_kerberos_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _realm_dbus_kerberos_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _realm_dbus_kerberos_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.realmd.Kerberos", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _realm_dbus_kerberos_emit_changed (gpointer user_data);

static void
realm_dbus_kerberos_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  RealmDbusKerberosSkeleton *skeleton = REALM_DBUS_KERBEROS_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _realm_dbus_kerberos_emit_changed (skeleton);
}

static void realm_dbus_kerberos_skeleton_iface_init (RealmDbusKerberosIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (RealmDbusKerberosSkeleton, realm_dbus_kerberos_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (RealmDbusKerberosSkeleton)
                         G_IMPLEMENT_INTERFACE (REALM_DBUS_TYPE_KERBEROS, realm_dbus_kerberos_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (RealmDbusKerberosSkeleton, realm_dbus_kerberos_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (REALM_DBUS_TYPE_KERBEROS, realm_dbus_kerberos_skeleton_iface_init))

#endif
static void
realm_dbus_kerberos_skeleton_finalize (GObject *object)
{
  RealmDbusKerberosSkeleton *skeleton = REALM_DBUS_KERBEROS_SKELETON (object);
  guint n;
  for (n = 0; n < 2; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (realm_dbus_kerberos_skeleton_parent_class)->finalize (object);
}

static void
realm_dbus_kerberos_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  RealmDbusKerberosSkeleton *skeleton = REALM_DBUS_KERBEROS_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_realm_dbus_kerberos_emit_changed (gpointer user_data)
{
  RealmDbusKerberosSkeleton *skeleton = REALM_DBUS_KERBEROS_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.realmd.Kerberos",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_realm_dbus_kerberos_schedule_emit_changed (RealmDbusKerberosSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
realm_dbus_kerberos_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  RealmDbusKerberosSkeleton *skeleton = REALM_DBUS_KERBEROS_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _realm_dbus_kerberos_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _realm_dbus_kerberos_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
realm_dbus_kerberos_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  RealmDbusKerberosSkeleton *skeleton = REALM_DBUS_KERBEROS_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 2);
  info = (const _ExtendedGDBusPropertyInfo *) _realm_dbus_kerberos_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _realm_dbus_kerberos_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
realm_dbus_kerberos_skeleton_init (RealmDbusKerberosSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = realm_dbus_kerberos_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, REALM_DBUS_TYPE_KERBEROS_SKELETON, RealmDbusKerberosSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 2);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_STRING);
}

static const gchar *
realm_dbus_kerberos_skeleton_get_realm_name (RealmDbusKerberos *object)
{
  RealmDbusKerberosSkeleton *skeleton = REALM_DBUS_KERBEROS_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static const gchar *
realm_dbus_kerberos_skeleton_get_domain_name (RealmDbusKerberos *object)
{
  RealmDbusKerberosSkeleton *skeleton = REALM_DBUS_KERBEROS_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
realm_dbus_kerberos_skeleton_class_init (RealmDbusKerberosSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = realm_dbus_kerberos_skeleton_finalize;
  gobject_class->get_property = realm_dbus_kerberos_skeleton_get_property;
  gobject_class->set_property = realm_dbus_kerberos_skeleton_set_property;
  gobject_class->notify       = realm_dbus_kerberos_skeleton_notify;


  realm_dbus_kerberos_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = realm_dbus_kerberos_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = realm_dbus_kerberos_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = realm_dbus_kerberos_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = realm_dbus_kerberos_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (RealmDbusKerberosSkeletonPrivate));
#endif
}

static void
realm_dbus_kerberos_skeleton_iface_init (RealmDbusKerberosIface *iface)
{
  iface->get_realm_name = realm_dbus_kerberos_skeleton_get_realm_name;
  iface->get_domain_name = realm_dbus_kerberos_skeleton_get_domain_name;
}

/**
 * realm_dbus_kerberos_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-Kerberos.top_of_page">org.freedesktop.realmd.Kerberos</link>.
 *
 * Returns: (transfer full) (type RealmDbusKerberosSkeleton): The skeleton object.
 */
RealmDbusKerberos *
realm_dbus_kerberos_skeleton_new (void)
{
  return REALM_DBUS_KERBEROS (g_object_new (REALM_DBUS_TYPE_KERBEROS_SKELETON, NULL));
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.realmd.KerberosMembership
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:RealmDbusKerberosMembership
 * @title: RealmDbusKerberosMembership
 * @short_description: Generated C code for the org.freedesktop.realmd.KerberosMembership D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-realmd-KerberosMembership.top_of_page">org.freedesktop.realmd.KerberosMembership</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.realmd.KerberosMembership ---- */

static const _ExtendedGDBusArgInfo _realm_dbus_kerberos_membership_method_info_join_IN_ARG_credentials =
{
  {
    -1,
    (gchar *) "credentials",
    (gchar *) "(ssv)",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _realm_dbus_kerberos_membership_method_info_join_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _realm_dbus_kerberos_membership_method_info_join_IN_ARG_pointers[] =
{
  &_realm_dbus_kerberos_membership_method_info_join_IN_ARG_credentials.parent_struct,
  &_realm_dbus_kerberos_membership_method_info_join_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _realm_dbus_kerberos_membership_method_info_join =
{
  {
    -1,
    (gchar *) "Join",
    (GDBusArgInfo **) &_realm_dbus_kerberos_membership_method_info_join_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-join",
  FALSE
};

static const _ExtendedGDBusArgInfo _realm_dbus_kerberos_membership_method_info_leave_IN_ARG_credentials =
{
  {
    -1,
    (gchar *) "credentials",
    (gchar *) "(ssv)",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _realm_dbus_kerberos_membership_method_info_leave_IN_ARG_options =
{
  {
    -1,
    (gchar *) "options",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _realm_dbus_kerberos_membership_method_info_leave_IN_ARG_pointers[] =
{
  &_realm_dbus_kerberos_membership_method_info_leave_IN_ARG_credentials.parent_struct,
  &_realm_dbus_kerberos_membership_method_info_leave_IN_ARG_options.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _realm_dbus_kerberos_membership_method_info_leave =
{
  {
    -1,
    (gchar *) "Leave",
    (GDBusArgInfo **) &_realm_dbus_kerberos_membership_method_info_leave_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-leave",
  FALSE
};

static const GDBusMethodInfo * const _realm_dbus_kerberos_membership_method_info_pointers[] =
{
  &_realm_dbus_kerberos_membership_method_info_join.parent_struct,
  &_realm_dbus_kerberos_membership_method_info_leave.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _realm_dbus_kerberos_membership_property_info_suggested_administrator =
{
  {
    -1,
    (gchar *) "SuggestedAdministrator",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "suggested-administrator",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _realm_dbus_kerberos_membership_property_info_supported_join_credentials =
{
  {
    -1,
    (gchar *) "SupportedJoinCredentials",
    (gchar *) "a(ss)",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "supported-join-credentials",
  FALSE,
  TRUE
};

static const _ExtendedGDBusPropertyInfo _realm_dbus_kerberos_membership_property_info_supported_leave_credentials =
{
  {
    -1,
    (gchar *) "SupportedLeaveCredentials",
    (gchar *) "a(ss)",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "supported-leave-credentials",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _realm_dbus_kerberos_membership_property_info_pointers[] =
{
  &_realm_dbus_kerberos_membership_property_info_suggested_administrator.parent_struct,
  &_realm_dbus_kerberos_membership_property_info_supported_join_credentials.parent_struct,
  &_realm_dbus_kerberos_membership_property_info_supported_leave_credentials.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _realm_dbus_kerberos_membership_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.realmd.KerberosMembership",
    (GDBusMethodInfo **) &_realm_dbus_kerberos_membership_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_realm_dbus_kerberos_membership_property_info_pointers,
    NULL
  },
  "kerberos-membership",
};


/**
 * realm_dbus_kerberos_membership_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-realmd-KerberosMembership.top_of_page">org.freedesktop.realmd.KerberosMembership</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
realm_dbus_kerberos_membership_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_realm_dbus_kerberos_membership_interface_info.parent_struct;
}

/**
 * realm_dbus_kerberos_membership_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #RealmDbusKerberosMembership interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
realm_dbus_kerberos_membership_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "suggested-administrator");
  g_object_class_override_property (klass, property_id_begin++, "supported-join-credentials");
  g_object_class_override_property (klass, property_id_begin++, "supported-leave-credentials");
  return property_id_begin - 1;
}



/**
 * RealmDbusKerberosMembership:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-KerberosMembership.top_of_page">org.freedesktop.realmd.KerberosMembership</link>.
 */

/**
 * RealmDbusKerberosMembershipIface:
 * @parent_iface: The parent interface.
 * @handle_join: Handler for the #RealmDbusKerberosMembership::handle-join signal.
 * @handle_leave: Handler for the #RealmDbusKerberosMembership::handle-leave signal.
 * @get_suggested_administrator: Getter for the #RealmDbusKerberosMembership:suggested-administrator property.
 * @get_supported_join_credentials: Getter for the #RealmDbusKerberosMembership:supported-join-credentials property.
 * @get_supported_leave_credentials: Getter for the #RealmDbusKerberosMembership:supported-leave-credentials property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-KerberosMembership.top_of_page">org.freedesktop.realmd.KerberosMembership</link>.
 */

typedef RealmDbusKerberosMembershipIface RealmDbusKerberosMembershipInterface;
G_DEFINE_INTERFACE (RealmDbusKerberosMembership, realm_dbus_kerberos_membership, G_TYPE_OBJECT)

static void
realm_dbus_kerberos_membership_default_init (RealmDbusKerberosMembershipIface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * RealmDbusKerberosMembership::handle-join:
   * @object: A #RealmDbusKerberosMembership.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_credentials: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-realmd-KerberosMembership.Join">Join()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call realm_dbus_kerberos_membership_complete_join() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-join",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (RealmDbusKerberosMembershipIface, handle_join),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT, G_TYPE_VARIANT);

  /**
   * RealmDbusKerberosMembership::handle-leave:
   * @object: A #RealmDbusKerberosMembership.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_credentials: Argument passed by remote caller.
   * @arg_options: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-realmd-KerberosMembership.Leave">Leave()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call realm_dbus_kerberos_membership_complete_leave() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-leave",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (RealmDbusKerberosMembershipIface, handle_leave),
    g_signal_accumulator_true_handled,
    NULL,
    g_cclosure_marshal_generic,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT, G_TYPE_VARIANT);

  /* GObject properties for D-Bus properties: */
  /**
   * RealmDbusKerberosMembership:suggested-administrator:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-realmd-KerberosMembership.SuggestedAdministrator">"SuggestedAdministrator"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("suggested-administrator", "SuggestedAdministrator", "SuggestedAdministrator", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * RealmDbusKerberosMembership:supported-join-credentials:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-realmd-KerberosMembership.SupportedJoinCredentials">"SupportedJoinCredentials"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("supported-join-credentials", "SupportedJoinCredentials", "SupportedJoinCredentials", G_VARIANT_TYPE ("a(ss)"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
  /**
   * RealmDbusKerberosMembership:supported-leave-credentials:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-realmd-KerberosMembership.SupportedLeaveCredentials">"SupportedLeaveCredentials"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_variant ("supported-leave-credentials", "SupportedLeaveCredentials", "SupportedLeaveCredentials", G_VARIANT_TYPE ("a(ss)"), NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * realm_dbus_kerberos_membership_get_suggested_administrator: (skip)
 * @object: A #RealmDbusKerberosMembership.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-realmd-KerberosMembership.SuggestedAdministrator">"SuggestedAdministrator"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use realm_dbus_kerberos_membership_dup_suggested_administrator() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
realm_dbus_kerberos_membership_get_suggested_administrator (RealmDbusKerberosMembership *object)
{
  return REALM_DBUS_KERBEROS_MEMBERSHIP_GET_IFACE (object)->get_suggested_administrator (object);
}

/**
 * realm_dbus_kerberos_membership_dup_suggested_administrator: (skip)
 * @object: A #RealmDbusKerberosMembership.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-realmd-KerberosMembership.SuggestedAdministrator">"SuggestedAdministrator"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
realm_dbus_kerberos_membership_dup_suggested_administrator (RealmDbusKerberosMembership *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "suggested-administrator", &value, NULL);
  return value;
}

/**
 * realm_dbus_kerberos_membership_set_suggested_administrator: (skip)
 * @object: A #RealmDbusKerberosMembership.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-realmd-KerberosMembership.SuggestedAdministrator">"SuggestedAdministrator"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
realm_dbus_kerberos_membership_set_suggested_administrator (RealmDbusKerberosMembership *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "suggested-administrator", value, NULL);
}

/**
 * realm_dbus_kerberos_membership_get_supported_join_credentials: (skip)
 * @object: A #RealmDbusKerberosMembership.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-realmd-KerberosMembership.SupportedJoinCredentials">"SupportedJoinCredentials"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use realm_dbus_kerberos_membership_dup_supported_join_credentials() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
realm_dbus_kerberos_membership_get_supported_join_credentials (RealmDbusKerberosMembership *object)
{
  return REALM_DBUS_KERBEROS_MEMBERSHIP_GET_IFACE (object)->get_supported_join_credentials (object);
}

/**
 * realm_dbus_kerberos_membership_dup_supported_join_credentials: (skip)
 * @object: A #RealmDbusKerberosMembership.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-realmd-KerberosMembership.SupportedJoinCredentials">"SupportedJoinCredentials"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
realm_dbus_kerberos_membership_dup_supported_join_credentials (RealmDbusKerberosMembership *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "supported-join-credentials", &value, NULL);
  return value;
}

/**
 * realm_dbus_kerberos_membership_set_supported_join_credentials: (skip)
 * @object: A #RealmDbusKerberosMembership.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-realmd-KerberosMembership.SupportedJoinCredentials">"SupportedJoinCredentials"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
realm_dbus_kerberos_membership_set_supported_join_credentials (RealmDbusKerberosMembership *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "supported-join-credentials", value, NULL);
}

/**
 * realm_dbus_kerberos_membership_get_supported_leave_credentials: (skip)
 * @object: A #RealmDbusKerberosMembership.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-realmd-KerberosMembership.SupportedLeaveCredentials">"SupportedLeaveCredentials"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use realm_dbus_kerberos_membership_dup_supported_leave_credentials() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
GVariant *
realm_dbus_kerberos_membership_get_supported_leave_credentials (RealmDbusKerberosMembership *object)
{
  return REALM_DBUS_KERBEROS_MEMBERSHIP_GET_IFACE (object)->get_supported_leave_credentials (object);
}

/**
 * realm_dbus_kerberos_membership_dup_supported_leave_credentials: (skip)
 * @object: A #RealmDbusKerberosMembership.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-realmd-KerberosMembership.SupportedLeaveCredentials">"SupportedLeaveCredentials"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_variant_unref().
 */
GVariant *
realm_dbus_kerberos_membership_dup_supported_leave_credentials (RealmDbusKerberosMembership *object)
{
  GVariant *value;
  g_object_get (G_OBJECT (object), "supported-leave-credentials", &value, NULL);
  return value;
}

/**
 * realm_dbus_kerberos_membership_set_supported_leave_credentials: (skip)
 * @object: A #RealmDbusKerberosMembership.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-realmd-KerberosMembership.SupportedLeaveCredentials">"SupportedLeaveCredentials"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
realm_dbus_kerberos_membership_set_supported_leave_credentials (RealmDbusKerberosMembership *object, GVariant *value)
{
  g_object_set (G_OBJECT (object), "supported-leave-credentials", value, NULL);
}

/**
 * realm_dbus_kerberos_membership_call_join:
 * @proxy: A #RealmDbusKerberosMembershipProxy.
 * @arg_credentials: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-realmd-KerberosMembership.Join">Join()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call realm_dbus_kerberos_membership_call_join_finish() to get the result of the operation.
 *
 * See realm_dbus_kerberos_membership_call_join_sync() for the synchronous, blocking version of this method.
 */
void
realm_dbus_kerberos_membership_call_join (
    RealmDbusKerberosMembership *proxy,
    GVariant *arg_credentials,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Join",
    g_variant_new ("(@(ssv)@a{sv})",
                   arg_credentials,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * realm_dbus_kerberos_membership_call_join_finish:
 * @proxy: A #RealmDbusKerberosMembershipProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to realm_dbus_kerberos_membership_call_join().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with realm_dbus_kerberos_membership_call_join().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
realm_dbus_kerberos_membership_call_join_finish (
    RealmDbusKerberosMembership *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * realm_dbus_kerberos_membership_call_join_sync:
 * @proxy: A #RealmDbusKerberosMembershipProxy.
 * @arg_credentials: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-realmd-KerberosMembership.Join">Join()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See realm_dbus_kerberos_membership_call_join() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
realm_dbus_kerberos_membership_call_join_sync (
    RealmDbusKerberosMembership *proxy,
    GVariant *arg_credentials,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Join",
    g_variant_new ("(@(ssv)@a{sv})",
                   arg_credentials,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * realm_dbus_kerberos_membership_call_leave:
 * @proxy: A #RealmDbusKerberosMembershipProxy.
 * @arg_credentials: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-realmd-KerberosMembership.Leave">Leave()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call realm_dbus_kerberos_membership_call_leave_finish() to get the result of the operation.
 *
 * See realm_dbus_kerberos_membership_call_leave_sync() for the synchronous, blocking version of this method.
 */
void
realm_dbus_kerberos_membership_call_leave (
    RealmDbusKerberosMembership *proxy,
    GVariant *arg_credentials,
    GVariant *arg_options,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "Leave",
    g_variant_new ("(@(ssv)@a{sv})",
                   arg_credentials,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * realm_dbus_kerberos_membership_call_leave_finish:
 * @proxy: A #RealmDbusKerberosMembershipProxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to realm_dbus_kerberos_membership_call_leave().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with realm_dbus_kerberos_membership_call_leave().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
realm_dbus_kerberos_membership_call_leave_finish (
    RealmDbusKerberosMembership *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * realm_dbus_kerberos_membership_call_leave_sync:
 * @proxy: A #RealmDbusKerberosMembershipProxy.
 * @arg_credentials: Argument to pass with the method invocation.
 * @arg_options: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-realmd-KerberosMembership.Leave">Leave()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See realm_dbus_kerberos_membership_call_leave() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
realm_dbus_kerberos_membership_call_leave_sync (
    RealmDbusKerberosMembership *proxy,
    GVariant *arg_credentials,
    GVariant *arg_options,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "Leave",
    g_variant_new ("(@(ssv)@a{sv})",
                   arg_credentials,
                   arg_options),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * realm_dbus_kerberos_membership_complete_join:
 * @object: A #RealmDbusKerberosMembership.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-realmd-KerberosMembership.Join">Join()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
realm_dbus_kerberos_membership_complete_join (
    RealmDbusKerberosMembership *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * realm_dbus_kerberos_membership_complete_leave:
 * @object: A #RealmDbusKerberosMembership.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-realmd-KerberosMembership.Leave">Leave()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
realm_dbus_kerberos_membership_complete_leave (
    RealmDbusKerberosMembership *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * RealmDbusKerberosMembershipProxy:
 *
 * The #RealmDbusKerberosMembershipProxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * RealmDbusKerberosMembershipProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #RealmDbusKerberosMembershipProxy.
 */

struct _RealmDbusKerberosMembershipProxyPrivate
{
  GData *qdata;
};

static void realm_dbus_kerberos_membership_proxy_iface_init (RealmDbusKerberosMembershipIface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (RealmDbusKerberosMembershipProxy, realm_dbus_kerberos_membership_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (RealmDbusKerberosMembershipProxy)
                         G_IMPLEMENT_INTERFACE (REALM_DBUS_TYPE_KERBEROS_MEMBERSHIP, realm_dbus_kerberos_membership_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (RealmDbusKerberosMembershipProxy, realm_dbus_kerberos_membership_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (REALM_DBUS_TYPE_KERBEROS_MEMBERSHIP, realm_dbus_kerberos_membership_proxy_iface_init))

#endif
static void
realm_dbus_kerberos_membership_proxy_finalize (GObject *object)
{
  RealmDbusKerberosMembershipProxy *proxy = REALM_DBUS_KERBEROS_MEMBERSHIP_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (realm_dbus_kerberos_membership_proxy_parent_class)->finalize (object);
}

static void
realm_dbus_kerberos_membership_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _realm_dbus_kerberos_membership_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
realm_dbus_kerberos_membership_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.realmd.KerberosMembership: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
realm_dbus_kerberos_membership_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _realm_dbus_kerberos_membership_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.realmd.KerberosMembership", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) realm_dbus_kerberos_membership_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
realm_dbus_kerberos_membership_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_realm_dbus_kerberos_membership_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], REALM_DBUS_TYPE_KERBEROS_MEMBERSHIP);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, REALM_DBUS_TYPE_KERBEROS_MEMBERSHIP);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
realm_dbus_kerberos_membership_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  RealmDbusKerberosMembershipProxy *proxy = REALM_DBUS_KERBEROS_MEMBERSHIP_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_realm_dbus_kerberos_membership_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_realm_dbus_kerberos_membership_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
realm_dbus_kerberos_membership_proxy_get_suggested_administrator (RealmDbusKerberosMembership *object)
{
  RealmDbusKerberosMembershipProxy *proxy = REALM_DBUS_KERBEROS_MEMBERSHIP_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SuggestedAdministrator");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static GVariant *
realm_dbus_kerberos_membership_proxy_get_supported_join_credentials (RealmDbusKerberosMembership *object)
{
  RealmDbusKerberosMembershipProxy *proxy = REALM_DBUS_KERBEROS_MEMBERSHIP_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SupportedJoinCredentials");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static GVariant *
realm_dbus_kerberos_membership_proxy_get_supported_leave_credentials (RealmDbusKerberosMembership *object)
{
  RealmDbusKerberosMembershipProxy *proxy = REALM_DBUS_KERBEROS_MEMBERSHIP_PROXY (object);
  GVariant *variant;
  GVariant *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "SupportedLeaveCredentials");
  value = variant;
  if (variant != NULL)
    g_variant_unref (variant);
  return value;
}

static void
realm_dbus_kerberos_membership_proxy_init (RealmDbusKerberosMembershipProxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = realm_dbus_kerberos_membership_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, REALM_DBUS_TYPE_KERBEROS_MEMBERSHIP_PROXY, RealmDbusKerberosMembershipProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), realm_dbus_kerberos_membership_interface_info ());
}

static void
realm_dbus_kerberos_membership_proxy_class_init (RealmDbusKerberosMembershipProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = realm_dbus_kerberos_membership_proxy_finalize;
  gobject_class->get_property = realm_dbus_kerberos_membership_proxy_get_property;
  gobject_class->set_property = realm_dbus_kerberos_membership_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = realm_dbus_kerberos_membership_proxy_g_signal;
  proxy_class->g_properties_changed = realm_dbus_kerberos_membership_proxy_g_properties_changed;

  realm_dbus_kerberos_membership_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (RealmDbusKerberosMembershipProxyPrivate));
#endif
}

static void
realm_dbus_kerberos_membership_proxy_iface_init (RealmDbusKerberosMembershipIface *iface)
{
  iface->get_suggested_administrator = realm_dbus_kerberos_membership_proxy_get_suggested_administrator;
  iface->get_supported_join_credentials = realm_dbus_kerberos_membership_proxy_get_supported_join_credentials;
  iface->get_supported_leave_credentials = realm_dbus_kerberos_membership_proxy_get_supported_leave_credentials;
}

/**
 * realm_dbus_kerberos_membership_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-KerberosMembership.top_of_page">org.freedesktop.realmd.KerberosMembership</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call realm_dbus_kerberos_membership_proxy_new_finish() to get the result of the operation.
 *
 * See realm_dbus_kerberos_membership_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
realm_dbus_kerberos_membership_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (REALM_DBUS_TYPE_KERBEROS_MEMBERSHIP_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.realmd.KerberosMembership", NULL);
}

/**
 * realm_dbus_kerberos_membership_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to realm_dbus_kerberos_membership_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with realm_dbus_kerberos_membership_proxy_new().
 *
 * Returns: (transfer full) (type RealmDbusKerberosMembershipProxy): The constructed proxy object or %NULL if @error is set.
 */
RealmDbusKerberosMembership *
realm_dbus_kerberos_membership_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return REALM_DBUS_KERBEROS_MEMBERSHIP (ret);
  else
    return NULL;
}

/**
 * realm_dbus_kerberos_membership_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-KerberosMembership.top_of_page">org.freedesktop.realmd.KerberosMembership</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See realm_dbus_kerberos_membership_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type RealmDbusKerberosMembershipProxy): The constructed proxy object or %NULL if @error is set.
 */
RealmDbusKerberosMembership *
realm_dbus_kerberos_membership_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (REALM_DBUS_TYPE_KERBEROS_MEMBERSHIP_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.realmd.KerberosMembership", NULL);
  if (ret != NULL)
    return REALM_DBUS_KERBEROS_MEMBERSHIP (ret);
  else
    return NULL;
}


/**
 * realm_dbus_kerberos_membership_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like realm_dbus_kerberos_membership_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call realm_dbus_kerberos_membership_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See realm_dbus_kerberos_membership_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
realm_dbus_kerberos_membership_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (REALM_DBUS_TYPE_KERBEROS_MEMBERSHIP_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.realmd.KerberosMembership", NULL);
}

/**
 * realm_dbus_kerberos_membership_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to realm_dbus_kerberos_membership_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with realm_dbus_kerberos_membership_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type RealmDbusKerberosMembershipProxy): The constructed proxy object or %NULL if @error is set.
 */
RealmDbusKerberosMembership *
realm_dbus_kerberos_membership_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return REALM_DBUS_KERBEROS_MEMBERSHIP (ret);
  else
    return NULL;
}

/**
 * realm_dbus_kerberos_membership_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like realm_dbus_kerberos_membership_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See realm_dbus_kerberos_membership_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type RealmDbusKerberosMembershipProxy): The constructed proxy object or %NULL if @error is set.
 */
RealmDbusKerberosMembership *
realm_dbus_kerberos_membership_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (REALM_DBUS_TYPE_KERBEROS_MEMBERSHIP_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.realmd.KerberosMembership", NULL);
  if (ret != NULL)
    return REALM_DBUS_KERBEROS_MEMBERSHIP (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * RealmDbusKerberosMembershipSkeleton:
 *
 * The #RealmDbusKerberosMembershipSkeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * RealmDbusKerberosMembershipSkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #RealmDbusKerberosMembershipSkeleton.
 */

struct _RealmDbusKerberosMembershipSkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_realm_dbus_kerberos_membership_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  RealmDbusKerberosMembershipSkeleton *skeleton = REALM_DBUS_KERBEROS_MEMBERSHIP_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], REALM_DBUS_TYPE_KERBEROS_MEMBERSHIP);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, REALM_DBUS_TYPE_KERBEROS_MEMBERSHIP);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_realm_dbus_kerberos_membership_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  RealmDbusKerberosMembershipSkeleton *skeleton = REALM_DBUS_KERBEROS_MEMBERSHIP_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_realm_dbus_kerberos_membership_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_realm_dbus_kerberos_membership_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  RealmDbusKerberosMembershipSkeleton *skeleton = REALM_DBUS_KERBEROS_MEMBERSHIP_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_realm_dbus_kerberos_membership_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _realm_dbus_kerberos_membership_skeleton_vtable =
{
  _realm_dbus_kerberos_membership_skeleton_handle_method_call,
  _realm_dbus_kerberos_membership_skeleton_handle_get_property,
  _realm_dbus_kerberos_membership_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
realm_dbus_kerberos_membership_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return realm_dbus_kerberos_membership_interface_info ();
}

static GDBusInterfaceVTable *
realm_dbus_kerberos_membership_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_realm_dbus_kerberos_membership_skeleton_vtable;
}

static GVariant *
realm_dbus_kerberos_membership_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  RealmDbusKerberosMembershipSkeleton *skeleton = REALM_DBUS_KERBEROS_MEMBERSHIP_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  if (_realm_dbus_kerberos_membership_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _realm_dbus_kerberos_membership_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _realm_dbus_kerberos_membership_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _realm_dbus_kerberos_membership_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.realmd.KerberosMembership", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _realm_dbus_kerberos_membership_emit_changed (gpointer user_data);

static void
realm_dbus_kerberos_membership_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  RealmDbusKerberosMembershipSkeleton *skeleton = REALM_DBUS_KERBEROS_MEMBERSHIP_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _realm_dbus_kerberos_membership_emit_changed (skeleton);
}

static void realm_dbus_kerberos_membership_skeleton_iface_init (RealmDbusKerberosMembershipIface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (RealmDbusKerberosMembershipSkeleton, realm_dbus_kerberos_membership_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (RealmDbusKerberosMembershipSkeleton)
                         G_IMPLEMENT_INTERFACE (REALM_DBUS_TYPE_KERBEROS_MEMBERSHIP, realm_dbus_kerberos_membership_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (RealmDbusKerberosMembershipSkeleton, realm_dbus_kerberos_membership_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (REALM_DBUS_TYPE_KERBEROS_MEMBERSHIP, realm_dbus_kerberos_membership_skeleton_iface_init))

#endif
static void
realm_dbus_kerberos_membership_skeleton_finalize (GObject *object)
{
  RealmDbusKerberosMembershipSkeleton *skeleton = REALM_DBUS_KERBEROS_MEMBERSHIP_SKELETON (object);
  guint n;
  for (n = 0; n < 3; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (realm_dbus_kerberos_membership_skeleton_parent_class)->finalize (object);
}

static void
realm_dbus_kerberos_membership_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  RealmDbusKerberosMembershipSkeleton *skeleton = REALM_DBUS_KERBEROS_MEMBERSHIP_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_realm_dbus_kerberos_membership_emit_changed (gpointer user_data)
{
  RealmDbusKerberosMembershipSkeleton *skeleton = REALM_DBUS_KERBEROS_MEMBERSHIP_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.realmd.KerberosMembership",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_realm_dbus_kerberos_membership_schedule_emit_changed (RealmDbusKerberosMembershipSkeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
realm_dbus_kerberos_membership_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  RealmDbusKerberosMembershipSkeleton *skeleton = REALM_DBUS_KERBEROS_MEMBERSHIP_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _realm_dbus_kerberos_membership_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _realm_dbus_kerberos_membership_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
realm_dbus_kerberos_membership_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  RealmDbusKerberosMembershipSkeleton *skeleton = REALM_DBUS_KERBEROS_MEMBERSHIP_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 3);
  info = (const _ExtendedGDBusPropertyInfo *) _realm_dbus_kerberos_membership_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _realm_dbus_kerberos_membership_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
realm_dbus_kerberos_membership_skeleton_init (RealmDbusKerberosMembershipSkeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = realm_dbus_kerberos_membership_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, REALM_DBUS_TYPE_KERBEROS_MEMBERSHIP_SKELETON, RealmDbusKerberosMembershipSkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 3);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
  g_value_init (&skeleton->priv->properties[1], G_TYPE_VARIANT);
  g_value_init (&skeleton->priv->properties[2], G_TYPE_VARIANT);
}

static const gchar *
realm_dbus_kerberos_membership_skeleton_get_suggested_administrator (RealmDbusKerberosMembership *object)
{
  RealmDbusKerberosMembershipSkeleton *skeleton = REALM_DBUS_KERBEROS_MEMBERSHIP_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
realm_dbus_kerberos_membership_skeleton_get_supported_join_credentials (RealmDbusKerberosMembership *object)
{
  RealmDbusKerberosMembershipSkeleton *skeleton = REALM_DBUS_KERBEROS_MEMBERSHIP_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[1]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static GVariant *
realm_dbus_kerberos_membership_skeleton_get_supported_leave_credentials (RealmDbusKerberosMembership *object)
{
  RealmDbusKerberosMembershipSkeleton *skeleton = REALM_DBUS_KERBEROS_MEMBERSHIP_SKELETON (object);
  GVariant *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_value_get_variant (&(skeleton->priv->properties[2]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
realm_dbus_kerberos_membership_skeleton_class_init (RealmDbusKerberosMembershipSkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = realm_dbus_kerberos_membership_skeleton_finalize;
  gobject_class->get_property = realm_dbus_kerberos_membership_skeleton_get_property;
  gobject_class->set_property = realm_dbus_kerberos_membership_skeleton_set_property;
  gobject_class->notify       = realm_dbus_kerberos_membership_skeleton_notify;


  realm_dbus_kerberos_membership_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = realm_dbus_kerberos_membership_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = realm_dbus_kerberos_membership_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = realm_dbus_kerberos_membership_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = realm_dbus_kerberos_membership_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (RealmDbusKerberosMembershipSkeletonPrivate));
#endif
}

static void
realm_dbus_kerberos_membership_skeleton_iface_init (RealmDbusKerberosMembershipIface *iface)
{
  iface->get_suggested_administrator = realm_dbus_kerberos_membership_skeleton_get_suggested_administrator;
  iface->get_supported_join_credentials = realm_dbus_kerberos_membership_skeleton_get_supported_join_credentials;
  iface->get_supported_leave_credentials = realm_dbus_kerberos_membership_skeleton_get_supported_leave_credentials;
}

/**
 * realm_dbus_kerberos_membership_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-realmd-KerberosMembership.top_of_page">org.freedesktop.realmd.KerberosMembership</link>.
 *
 * Returns: (transfer full) (type RealmDbusKerberosMembershipSkeleton): The skeleton object.
 */
RealmDbusKerberosMembership *
realm_dbus_kerberos_membership_skeleton_new (void)
{
  return REALM_DBUS_KERBEROS_MEMBERSHIP (g_object_new (REALM_DBUS_TYPE_KERBEROS_MEMBERSHIP_SKELETON, NULL));
}

