% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prop.R
\name{prop}
\alias{prop}
\alias{props}
\title{Proportions of values in a vector}
\usage{
prop(data, ..., weights = NULL, na.rm = TRUE, digits = 4)

props(data, ..., na.rm = TRUE, digits = 4)
}
\arguments{
\item{data}{A data frame. May also be a grouped data frame (see 'Examples').}

\item{...}{One or more value pairs of comparisons (logical predicates). Put
variable names the left-hand-side and values to match on the
right hand side. Expressions may be quoted or unquoted. See
'Examples'.}

\item{weights}{Vector of weights that will be applied to weight all observations.
Must be a vector of same length as the input vector. Default is
\code{NULL}, so no weights are used.}

\item{na.rm}{Logical, whether to remove NA values from the vector when the
proportion is calculated. \code{na.rm = FALSE} gives you the raw
percentage of a value in a vector, \code{na.rm = TRUE} the valid
percentage.}

\item{digits}{Amount of digits for returned values.}
}
\value{
For one condition, a numeric value with the proportion of the values
inside a vector. For more than one condition, a data frame with one column
of conditions and one column with proportions. For grouped data frames,
returns a data frame with one column per group with grouping categories,
followed by one column with proportions per condition.
}
\description{
\code{prop()} calculates the proportion of a value or category
in a variable. \code{props()} does the same, but allows for
multiple logical conditions in one statement. It is similar
to \code{mean()} with logical predicates, however, both
\code{prop()} and \code{props()} work with grouped data frames.
}
\details{
\code{prop()} only allows one logical statement per comparison,
while \code{props()} allows multiple logical statements per comparison.
However, \code{prop()} supports weighting of variables before calculating
proportions, and comparisons may also be quoted. Hence, \code{prop()}
also processes comparisons, which are passed as character vector
(see 'Examples').
}
\examples{
\dontshow{if (getRversion() >= "4.2.0" && requireNamespace("datawizard", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(efc)

# proportion of value 1 in e42dep
prop(efc, e42dep == 1)

# expression may also be completely quoted
prop(efc, "e42dep == 1")

# use "props()" for multiple logical statements
props(efc, e17age > 70 & e17age < 80)

# proportion of value 1 in e42dep, and all values greater
# than 2 in e42dep, including missing values. will return a data frame
prop(efc, e42dep == 1, e42dep > 2, na.rm = FALSE)

# for factors or character vectors, use quoted or unquoted values
library(datawizard)
# convert numeric to factor, using labels as factor levels
efc$e16sex <- to_factor(efc$e16sex)
efc$n4pstu <- to_factor(efc$n4pstu)

# get proportion of female older persons
prop(efc, e16sex == female)

# get proportion of male older persons
prop(efc, e16sex == "male")

# "props()" needs quotes around non-numeric factor levels
props(efc,
  e17age > 70 & e17age < 80,
  n4pstu == 'Care Level 1' | n4pstu == 'Care Level 3'
)

# also works with pipe-chains
efc |> prop(e17age > 70)
efc |> prop(e17age > 70, e16sex == 1)
\dontshow{\}) # examplesIf}
}
