//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmigrate

import (
	"encoding/json"
	"fmt"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"reflect"
)

// UnmarshalJSON implements the json.Unmarshaller interface for type AssessedMachineProperties.
func (a *AssessedMachineProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bootType":
			err = unpopulate(val, "BootType", &a.BootType)
			delete(rawMsg, key)
		case "confidenceRatingInPercentage":
			err = unpopulate(val, "ConfidenceRatingInPercentage", &a.ConfidenceRatingInPercentage)
			delete(rawMsg, key)
		case "createdTimestamp":
			err = unpopulateTimeRFC3339(val, "CreatedTimestamp", &a.CreatedTimestamp)
			delete(rawMsg, key)
		case "datacenterMachineArmId":
			err = unpopulate(val, "DatacenterMachineArmID", &a.DatacenterMachineArmID)
			delete(rawMsg, key)
		case "datacenterManagementServerArmId":
			err = unpopulate(val, "DatacenterManagementServerArmID", &a.DatacenterManagementServerArmID)
			delete(rawMsg, key)
		case "datacenterManagementServerName":
			err = unpopulate(val, "DatacenterManagementServerName", &a.DatacenterManagementServerName)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &a.Description)
			delete(rawMsg, key)
		case "disks":
			err = unpopulate(val, "Disks", &a.Disks)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &a.DisplayName)
			delete(rawMsg, key)
		case "megabytesOfMemory":
			err = unpopulate(val, "MegabytesOfMemory", &a.MegabytesOfMemory)
			delete(rawMsg, key)
		case "megabytesOfMemoryForRecommendedSize":
			err = unpopulate(val, "MegabytesOfMemoryForRecommendedSize", &a.MegabytesOfMemoryForRecommendedSize)
			delete(rawMsg, key)
		case "monthlyBandwidthCost":
			err = unpopulate(val, "MonthlyBandwidthCost", &a.MonthlyBandwidthCost)
			delete(rawMsg, key)
		case "monthlyComputeCostForRecommendedSize":
			err = unpopulate(val, "MonthlyComputeCostForRecommendedSize", &a.MonthlyComputeCostForRecommendedSize)
			delete(rawMsg, key)
		case "monthlyPremiumStorageCost":
			err = unpopulate(val, "MonthlyPremiumStorageCost", &a.MonthlyPremiumStorageCost)
			delete(rawMsg, key)
		case "monthlyStandardSSDStorageCost":
			err = unpopulate(val, "MonthlyStandardSSDStorageCost", &a.MonthlyStandardSSDStorageCost)
			delete(rawMsg, key)
		case "monthlyStorageCost":
			err = unpopulate(val, "MonthlyStorageCost", &a.MonthlyStorageCost)
			delete(rawMsg, key)
		case "networkAdapters":
			err = unpopulate(val, "NetworkAdapters", &a.NetworkAdapters)
			delete(rawMsg, key)
		case "numberOfCores":
			err = unpopulate(val, "NumberOfCores", &a.NumberOfCores)
			delete(rawMsg, key)
		case "numberOfCoresForRecommendedSize":
			err = unpopulate(val, "NumberOfCoresForRecommendedSize", &a.NumberOfCoresForRecommendedSize)
			delete(rawMsg, key)
		case "operatingSystemName":
			err = unpopulate(val, "OperatingSystemName", &a.OperatingSystemName)
			delete(rawMsg, key)
		case "operatingSystemType":
			err = unpopulate(val, "OperatingSystemType", &a.OperatingSystemType)
			delete(rawMsg, key)
		case "operatingSystemVersion":
			err = unpopulate(val, "OperatingSystemVersion", &a.OperatingSystemVersion)
			delete(rawMsg, key)
		case "percentageCoresUtilization":
			err = unpopulate(val, "PercentageCoresUtilization", &a.PercentageCoresUtilization)
			delete(rawMsg, key)
		case "percentageMemoryUtilization":
			err = unpopulate(val, "PercentageMemoryUtilization", &a.PercentageMemoryUtilization)
			delete(rawMsg, key)
		case "recommendedSize":
			err = unpopulate(val, "RecommendedSize", &a.RecommendedSize)
			delete(rawMsg, key)
		case "suitability":
			err = unpopulate(val, "Suitability", &a.Suitability)
			delete(rawMsg, key)
		case "suitabilityDetail":
			err = unpopulate(val, "SuitabilityDetail", &a.SuitabilityDetail)
			delete(rawMsg, key)
		case "suitabilityExplanation":
			err = unpopulate(val, "SuitabilityExplanation", &a.SuitabilityExplanation)
			delete(rawMsg, key)
		case "updatedTimestamp":
			err = unpopulateTimeRFC3339(val, "UpdatedTimestamp", &a.UpdatedTimestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type AssessmentProperties.
func (a AssessmentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "azureDiskType", a.AzureDiskType)
	populate(objectMap, "azureHybridUseBenefit", a.AzureHybridUseBenefit)
	populate(objectMap, "azureLocation", a.AzureLocation)
	populate(objectMap, "azureOfferCode", a.AzureOfferCode)
	populate(objectMap, "azurePricingTier", a.AzurePricingTier)
	populate(objectMap, "azureStorageRedundancy", a.AzureStorageRedundancy)
	populate(objectMap, "azureVmFamilies", a.AzureVMFamilies)
	populate(objectMap, "confidenceRatingInPercentage", a.ConfidenceRatingInPercentage)
	populateTimeRFC3339(objectMap, "createdTimestamp", a.CreatedTimestamp)
	populate(objectMap, "currency", a.Currency)
	populate(objectMap, "discountPercentage", a.DiscountPercentage)
	populate(objectMap, "eaSubscriptionId", a.EaSubscriptionID)
	populate(objectMap, "monthlyBandwidthCost", a.MonthlyBandwidthCost)
	populate(objectMap, "monthlyComputeCost", a.MonthlyComputeCost)
	populate(objectMap, "monthlyPremiumStorageCost", a.MonthlyPremiumStorageCost)
	populate(objectMap, "monthlyStandardSSDStorageCost", a.MonthlyStandardSSDStorageCost)
	populate(objectMap, "monthlyStorageCost", a.MonthlyStorageCost)
	populate(objectMap, "numberOfMachines", a.NumberOfMachines)
	populate(objectMap, "percentile", a.Percentile)
	populateTimeRFC3339(objectMap, "perfDataEndTime", a.PerfDataEndTime)
	populateTimeRFC3339(objectMap, "perfDataStartTime", a.PerfDataStartTime)
	populateTimeRFC3339(objectMap, "pricesTimestamp", a.PricesTimestamp)
	populate(objectMap, "reservedInstance", a.ReservedInstance)
	populate(objectMap, "scalingFactor", a.ScalingFactor)
	populate(objectMap, "sizingCriterion", a.SizingCriterion)
	populate(objectMap, "stage", a.Stage)
	populate(objectMap, "status", a.Status)
	populate(objectMap, "timeRange", a.TimeRange)
	populateTimeRFC3339(objectMap, "updatedTimestamp", a.UpdatedTimestamp)
	populate(objectMap, "vmUptime", a.VMUptime)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type AssessmentProperties.
func (a *AssessmentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", a, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "azureDiskType":
			err = unpopulate(val, "AzureDiskType", &a.AzureDiskType)
			delete(rawMsg, key)
		case "azureHybridUseBenefit":
			err = unpopulate(val, "AzureHybridUseBenefit", &a.AzureHybridUseBenefit)
			delete(rawMsg, key)
		case "azureLocation":
			err = unpopulate(val, "AzureLocation", &a.AzureLocation)
			delete(rawMsg, key)
		case "azureOfferCode":
			err = unpopulate(val, "AzureOfferCode", &a.AzureOfferCode)
			delete(rawMsg, key)
		case "azurePricingTier":
			err = unpopulate(val, "AzurePricingTier", &a.AzurePricingTier)
			delete(rawMsg, key)
		case "azureStorageRedundancy":
			err = unpopulate(val, "AzureStorageRedundancy", &a.AzureStorageRedundancy)
			delete(rawMsg, key)
		case "azureVmFamilies":
			err = unpopulate(val, "AzureVMFamilies", &a.AzureVMFamilies)
			delete(rawMsg, key)
		case "confidenceRatingInPercentage":
			err = unpopulate(val, "ConfidenceRatingInPercentage", &a.ConfidenceRatingInPercentage)
			delete(rawMsg, key)
		case "createdTimestamp":
			err = unpopulateTimeRFC3339(val, "CreatedTimestamp", &a.CreatedTimestamp)
			delete(rawMsg, key)
		case "currency":
			err = unpopulate(val, "Currency", &a.Currency)
			delete(rawMsg, key)
		case "discountPercentage":
			err = unpopulate(val, "DiscountPercentage", &a.DiscountPercentage)
			delete(rawMsg, key)
		case "eaSubscriptionId":
			err = unpopulate(val, "EaSubscriptionID", &a.EaSubscriptionID)
			delete(rawMsg, key)
		case "monthlyBandwidthCost":
			err = unpopulate(val, "MonthlyBandwidthCost", &a.MonthlyBandwidthCost)
			delete(rawMsg, key)
		case "monthlyComputeCost":
			err = unpopulate(val, "MonthlyComputeCost", &a.MonthlyComputeCost)
			delete(rawMsg, key)
		case "monthlyPremiumStorageCost":
			err = unpopulate(val, "MonthlyPremiumStorageCost", &a.MonthlyPremiumStorageCost)
			delete(rawMsg, key)
		case "monthlyStandardSSDStorageCost":
			err = unpopulate(val, "MonthlyStandardSSDStorageCost", &a.MonthlyStandardSSDStorageCost)
			delete(rawMsg, key)
		case "monthlyStorageCost":
			err = unpopulate(val, "MonthlyStorageCost", &a.MonthlyStorageCost)
			delete(rawMsg, key)
		case "numberOfMachines":
			err = unpopulate(val, "NumberOfMachines", &a.NumberOfMachines)
			delete(rawMsg, key)
		case "percentile":
			err = unpopulate(val, "Percentile", &a.Percentile)
			delete(rawMsg, key)
		case "perfDataEndTime":
			err = unpopulateTimeRFC3339(val, "PerfDataEndTime", &a.PerfDataEndTime)
			delete(rawMsg, key)
		case "perfDataStartTime":
			err = unpopulateTimeRFC3339(val, "PerfDataStartTime", &a.PerfDataStartTime)
			delete(rawMsg, key)
		case "pricesTimestamp":
			err = unpopulateTimeRFC3339(val, "PricesTimestamp", &a.PricesTimestamp)
			delete(rawMsg, key)
		case "reservedInstance":
			err = unpopulate(val, "ReservedInstance", &a.ReservedInstance)
			delete(rawMsg, key)
		case "scalingFactor":
			err = unpopulate(val, "ScalingFactor", &a.ScalingFactor)
			delete(rawMsg, key)
		case "sizingCriterion":
			err = unpopulate(val, "SizingCriterion", &a.SizingCriterion)
			delete(rawMsg, key)
		case "stage":
			err = unpopulate(val, "Stage", &a.Stage)
			delete(rawMsg, key)
		case "status":
			err = unpopulate(val, "Status", &a.Status)
			delete(rawMsg, key)
		case "timeRange":
			err = unpopulate(val, "TimeRange", &a.TimeRange)
			delete(rawMsg, key)
		case "updatedTimestamp":
			err = unpopulateTimeRFC3339(val, "UpdatedTimestamp", &a.UpdatedTimestamp)
			delete(rawMsg, key)
		case "vmUptime":
			err = unpopulate(val, "VMUptime", &a.VMUptime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", a, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type CollectorAgentProperties.
func (c CollectorAgentProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "id", c.ID)
	populateTimeRFC3339(objectMap, "lastHeartbeatUtc", c.LastHeartbeatUTC)
	populate(objectMap, "spnDetails", c.SpnDetails)
	populate(objectMap, "version", c.Version)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type CollectorAgentProperties.
func (c *CollectorAgentProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", c, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "id":
			err = unpopulate(val, "ID", &c.ID)
			delete(rawMsg, key)
		case "lastHeartbeatUtc":
			err = unpopulateTimeRFC3339(val, "LastHeartbeatUTC", &c.LastHeartbeatUTC)
			delete(rawMsg, key)
		case "spnDetails":
			err = unpopulate(val, "SpnDetails", &c.SpnDetails)
			delete(rawMsg, key)
		case "version":
			err = unpopulate(val, "Version", &c.Version)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", c, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type DownloadURL.
func (d *DownloadURL) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", d, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assessmentReportUrl":
			err = unpopulate(val, "AssessmentReportURL", &d.AssessmentReportURL)
			delete(rawMsg, key)
		case "expirationTime":
			err = unpopulateTimeRFC3339(val, "ExpirationTime", &d.ExpirationTime)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", d, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type GroupBodyProperties.
func (g GroupBodyProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "machines", g.Machines)
	populate(objectMap, "operationType", g.OperationType)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type GroupProperties.
func (g GroupProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "areAssessmentsRunning", g.AreAssessmentsRunning)
	populate(objectMap, "assessments", g.Assessments)
	populateTimeRFC3339(objectMap, "createdTimestamp", g.CreatedTimestamp)
	populate(objectMap, "groupStatus", g.GroupStatus)
	populate(objectMap, "groupType", g.GroupType)
	populate(objectMap, "machineCount", g.MachineCount)
	populateTimeRFC3339(objectMap, "updatedTimestamp", g.UpdatedTimestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type GroupProperties.
func (g *GroupProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", g, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "areAssessmentsRunning":
			err = unpopulate(val, "AreAssessmentsRunning", &g.AreAssessmentsRunning)
			delete(rawMsg, key)
		case "assessments":
			err = unpopulate(val, "Assessments", &g.Assessments)
			delete(rawMsg, key)
		case "createdTimestamp":
			err = unpopulateTimeRFC3339(val, "CreatedTimestamp", &g.CreatedTimestamp)
			delete(rawMsg, key)
		case "groupStatus":
			err = unpopulate(val, "GroupStatus", &g.GroupStatus)
			delete(rawMsg, key)
		case "groupType":
			err = unpopulate(val, "GroupType", &g.GroupType)
			delete(rawMsg, key)
		case "machineCount":
			err = unpopulate(val, "MachineCount", &g.MachineCount)
			delete(rawMsg, key)
		case "updatedTimestamp":
			err = unpopulateTimeRFC3339(val, "UpdatedTimestamp", &g.UpdatedTimestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", g, err)
		}
	}
	return nil
}

// UnmarshalJSON implements the json.Unmarshaller interface for type MachineProperties.
func (m *MachineProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", m, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "bootType":
			err = unpopulate(val, "BootType", &m.BootType)
			delete(rawMsg, key)
		case "createdTimestamp":
			err = unpopulateTimeRFC3339(val, "CreatedTimestamp", &m.CreatedTimestamp)
			delete(rawMsg, key)
		case "datacenterManagementServerArmId":
			err = unpopulate(val, "DatacenterManagementServerArmID", &m.DatacenterManagementServerArmID)
			delete(rawMsg, key)
		case "datacenterManagementServerName":
			err = unpopulate(val, "DatacenterManagementServerName", &m.DatacenterManagementServerName)
			delete(rawMsg, key)
		case "description":
			err = unpopulate(val, "Description", &m.Description)
			delete(rawMsg, key)
		case "discoveryMachineArmId":
			err = unpopulate(val, "DiscoveryMachineArmID", &m.DiscoveryMachineArmID)
			delete(rawMsg, key)
		case "disks":
			err = unpopulate(val, "Disks", &m.Disks)
			delete(rawMsg, key)
		case "displayName":
			err = unpopulate(val, "DisplayName", &m.DisplayName)
			delete(rawMsg, key)
		case "groups":
			err = unpopulate(val, "Groups", &m.Groups)
			delete(rawMsg, key)
		case "megabytesOfMemory":
			err = unpopulate(val, "MegabytesOfMemory", &m.MegabytesOfMemory)
			delete(rawMsg, key)
		case "networkAdapters":
			err = unpopulate(val, "NetworkAdapters", &m.NetworkAdapters)
			delete(rawMsg, key)
		case "numberOfCores":
			err = unpopulate(val, "NumberOfCores", &m.NumberOfCores)
			delete(rawMsg, key)
		case "operatingSystemName":
			err = unpopulate(val, "OperatingSystemName", &m.OperatingSystemName)
			delete(rawMsg, key)
		case "operatingSystemType":
			err = unpopulate(val, "OperatingSystemType", &m.OperatingSystemType)
			delete(rawMsg, key)
		case "operatingSystemVersion":
			err = unpopulate(val, "OperatingSystemVersion", &m.OperatingSystemVersion)
			delete(rawMsg, key)
		case "updatedTimestamp":
			err = unpopulateTimeRFC3339(val, "UpdatedTimestamp", &m.UpdatedTimestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", m, err)
		}
	}
	return nil
}

// MarshalJSON implements the json.Marshaller interface for type Project.
func (p Project) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "eTag", p.ETag)
	populate(objectMap, "id", p.ID)
	populate(objectMap, "location", p.Location)
	populate(objectMap, "name", p.Name)
	populate(objectMap, "properties", p.Properties)
	populate(objectMap, "tags", &p.Tags)
	populate(objectMap, "type", p.Type)
	return json.Marshal(objectMap)
}

// MarshalJSON implements the json.Marshaller interface for type ProjectProperties.
func (p ProjectProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	populate(objectMap, "assessmentSolutionId", p.AssessmentSolutionID)
	populateTimeRFC3339(objectMap, "createdTimestamp", p.CreatedTimestamp)
	populate(objectMap, "customerStorageAccountArmId", p.CustomerStorageAccountArmID)
	populate(objectMap, "customerWorkspaceId", p.CustomerWorkspaceID)
	populate(objectMap, "customerWorkspaceLocation", p.CustomerWorkspaceLocation)
	populateTimeRFC3339(objectMap, "lastAssessmentTimestamp", p.LastAssessmentTimestamp)
	populate(objectMap, "numberOfAssessments", p.NumberOfAssessments)
	populate(objectMap, "numberOfGroups", p.NumberOfGroups)
	populate(objectMap, "numberOfMachines", p.NumberOfMachines)
	populate(objectMap, "privateEndpointConnections", p.PrivateEndpointConnections)
	populate(objectMap, "projectStatus", p.ProjectStatus)
	populate(objectMap, "provisioningState", p.ProvisioningState)
	populate(objectMap, "publicNetworkAccess", p.PublicNetworkAccess)
	populate(objectMap, "serviceEndpoint", p.ServiceEndpoint)
	populateTimeRFC3339(objectMap, "updatedTimestamp", p.UpdatedTimestamp)
	return json.Marshal(objectMap)
}

// UnmarshalJSON implements the json.Unmarshaller interface for type ProjectProperties.
func (p *ProjectProperties) UnmarshalJSON(data []byte) error {
	var rawMsg map[string]json.RawMessage
	if err := json.Unmarshal(data, &rawMsg); err != nil {
		return fmt.Errorf("unmarshalling type %T: %v", p, err)
	}
	for key, val := range rawMsg {
		var err error
		switch key {
		case "assessmentSolutionId":
			err = unpopulate(val, "AssessmentSolutionID", &p.AssessmentSolutionID)
			delete(rawMsg, key)
		case "createdTimestamp":
			err = unpopulateTimeRFC3339(val, "CreatedTimestamp", &p.CreatedTimestamp)
			delete(rawMsg, key)
		case "customerStorageAccountArmId":
			err = unpopulate(val, "CustomerStorageAccountArmID", &p.CustomerStorageAccountArmID)
			delete(rawMsg, key)
		case "customerWorkspaceId":
			err = unpopulate(val, "CustomerWorkspaceID", &p.CustomerWorkspaceID)
			delete(rawMsg, key)
		case "customerWorkspaceLocation":
			err = unpopulate(val, "CustomerWorkspaceLocation", &p.CustomerWorkspaceLocation)
			delete(rawMsg, key)
		case "lastAssessmentTimestamp":
			err = unpopulateTimeRFC3339(val, "LastAssessmentTimestamp", &p.LastAssessmentTimestamp)
			delete(rawMsg, key)
		case "numberOfAssessments":
			err = unpopulate(val, "NumberOfAssessments", &p.NumberOfAssessments)
			delete(rawMsg, key)
		case "numberOfGroups":
			err = unpopulate(val, "NumberOfGroups", &p.NumberOfGroups)
			delete(rawMsg, key)
		case "numberOfMachines":
			err = unpopulate(val, "NumberOfMachines", &p.NumberOfMachines)
			delete(rawMsg, key)
		case "privateEndpointConnections":
			err = unpopulate(val, "PrivateEndpointConnections", &p.PrivateEndpointConnections)
			delete(rawMsg, key)
		case "projectStatus":
			err = unpopulate(val, "ProjectStatus", &p.ProjectStatus)
			delete(rawMsg, key)
		case "provisioningState":
			err = unpopulate(val, "ProvisioningState", &p.ProvisioningState)
			delete(rawMsg, key)
		case "publicNetworkAccess":
			err = unpopulate(val, "PublicNetworkAccess", &p.PublicNetworkAccess)
			delete(rawMsg, key)
		case "serviceEndpoint":
			err = unpopulate(val, "ServiceEndpoint", &p.ServiceEndpoint)
			delete(rawMsg, key)
		case "updatedTimestamp":
			err = unpopulateTimeRFC3339(val, "UpdatedTimestamp", &p.UpdatedTimestamp)
			delete(rawMsg, key)
		}
		if err != nil {
			return fmt.Errorf("unmarshalling type %T: %v", p, err)
		}
	}
	return nil
}

func populate(m map[string]interface{}, k string, v interface{}) {
	if v == nil {
		return
	} else if azcore.IsNullValue(v) {
		m[k] = nil
	} else if !reflect.ValueOf(v).IsNil() {
		m[k] = v
	}
}

func unpopulate(data json.RawMessage, fn string, v interface{}) error {
	if data == nil {
		return nil
	}
	if err := json.Unmarshal(data, v); err != nil {
		return fmt.Errorf("struct field %s: %v", fn, err)
	}
	return nil
}
