
Akatab is an OpenType-enabled font family that supports the Tifinagh script. It includes a number of optional user-selected features that may be useful or required for particular uses or languages. This document lists all the user-selected features. These features are primarily specified using four-letter tags (e.g. 'cv17'). For more information on how to access OpenType features in specific environments and applications, see [Using Font Features](https://software.sil.org/fonts/features). 

Akatab also provides for a number of common features such as ligature formation, contextual substitution and diacritic positioning. It also provides right-to-left rendering of text. Most applications will make use of these features when the proper sequence of characters is entered.

This page uses web fonts (WOFF2) to demonstrate font features and should display correctly in all modern browsers. For detailed information, see [Using SIL Fonts on Web Pages](https://software.sil.org/fonts/webfonts). For a more concise example of how to use Akatab as a web font, see [Akatab Webfont Example](../web/Akatab-webfont-example.html).

*If this document is not displaying correctly, a PDF version is also provided in the documentation/pdf folder of the release package.*

## User-selected feature list

### Character variants

#### Alternate YA

<span class='affects'>Affects: U+2D30</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard | <span class='akatab-R normal'>ⴰ</span> | <span class='akatab-R normal'> ‮ⴰ</span> | `cv01=0`
Circle   | <span class='akatab-cv01-1-R normal'>ⴰ</span> | <span class='akatab-cv01-1-R normal'> ‮ⴰ</span> | `cv01=1`

#### Alternate YAF

<span class='affects'>Affects: U+2D3C</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard            | <span class='akatab-R normal'>ⴼ</span> | <span class='akatab-R normal'> ‮ⴼ</span> | `cv02=0`
I-shape             | <span class='akatab-cv02-1-R normal'>ⴼ</span> | <span class='akatab-cv02-1-R normal'> ‮ⴼ</span> | `cv02=1`
Open top and bottom | <span class='akatab-cv14-1-R normal'>ⴼ</span> | <span class='akatab-cv14-1-R normal'> ‮ⴼ</span> | `cv14=1 (or cv02=2)`

#### Alternate YAGHH

<span class='affects'>Affects: U+2D34</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard     | <span class='akatab-R normal'>ⴴ</span> | <span class='akatab-R normal'> ‮ⴴ</span> | `cv03=0`
Round bottom | <span class='akatab-cv03-1-R normal'>ⴴ</span> | <span class='akatab-cv03-1-R normal'> ‮ⴴ</span> | `cv03=1`

#### Alternate YAGN 

<span class='affects'>Affects: U+2D50</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard              | <span class='akatab-R normal'>ⵐ</span> | <span class='akatab-R normal'> ‮ⵐ</span> | `cv04=0`
Lowered bottom stroke | <span class='akatab-cv04-1-R normal'>ⵐ</span> | <span class='akatab-cv04-1-R normal'> ‮ⵐ</span> | `cv04=1`

#### Alternate YU

<span class='affects'>Affects: U+2D53</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard      | <span class='akatab-R normal'>ⵓ</span> | <span class='akatab-R normal'> ‮ⵓ</span> | `cv05=0`
Short strokes | <span class='akatab-cv05-1-R normal'>ⵓ</span> | <span class='akatab-cv05-1-R normal'> ‮ⵓ</span> | `cv05=1`

#### Alternate YAZ

<span class='affects'>Affects: U+2D63</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard | <span class='akatab-R normal'>ⵣ</span> | <span class='akatab-R normal'> ‮ⵣ</span> | `cv06=0`
Squared  | <span class='akatab-cv06-1-R normal'>ⵣ</span> | <span class='akatab-cv06-1-R normal'> ‮ⵣ</span> | `cv06=1`

#### Alternate AHAGGAR YAZH

<span class='affects'>Affects: U+2D4B</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard | <span class='akatab-R normal'>ⵋ</span> | <span class='akatab-R normal'> ‮ⵋ</span> | `cv07=0`
Squared  | <span class='akatab-cv07-1-R normal'>ⵋ</span> | <span class='akatab-cv07-1-R normal'> ‮ⵋ</span> | `cv07=1`

#### Alternate YAB

<span class='affects'>Affects: U+2D31</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard         | <span class='akatab-R normal'>ⴱ</span> | <span class='akatab-R normal'> ‮ⴱ</span> | `cv08=0`
Rectangle style  | <span class='akatab-cv08-1-R normal'>ⴱ</span> | <span class='akatab-cv08-1-R normal'> ‮ⴱ</span> | `cv08=1`

#### Alternate YAG

<span class='affects'>Affects: U+2D33</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard    | <span class='akatab-R normal'>ⴳ</span> | <span class='akatab-R normal'> ‮ⴳ</span> | `cv09=0`
Rounded top | <span class='akatab-cv09-1-R normal'>ⴳ</span> | <span class='akatab-cv09-1-R normal'> ‮ⴳ</span> | `cv09=1`

#### Alternate YAJ

<span class='affects'>Affects: U+2D36</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard   | <span class='akatab-R normal'>ⴶ</span> | <span class='akatab-R normal'> ‮ⴶ</span> | `cv10=0`
Lower dots | <span class='akatab-cv10-1-R normal'>ⴶ</span> | <span class='akatab-cv10-1-R normal'> ‮ⴶ</span> | `cv10=1`

#### Alternate YAH (Tuareg yab)

<span class='affects'>Affects: U+2D40</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard        | <span class='akatab-R normal'>ⵀ</span> | <span class='akatab-R normal'> ‮ⵀ</span> | `cv11=0`
Rectangle style | <span class='akatab-cv11-1-R normal'>ⵀ</span> | <span class='akatab-cv11-1-R normal'> ‮ⵀ</span> | `cv11=1`

#### Alternate YASH

<span class='affects'>Affects: U+2D5B</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard | <span class='akatab-R normal'>ⵛ</span> | <span class='akatab-R normal'> ‮ⵛ</span> | `cv12=0`
8 shape  | <span class='akatab-cv12-1-R normal'>ⵛ</span> | <span class='akatab-cv12-1-R normal'> ‮ⵛ</span> | `cv12=1`

#### Alternate YATT

<span class='affects'>Affects: U+2D5F</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard | <span class='akatab-R normal'>ⵟ</span> | <span class='akatab-R normal'> ‮ⵟ</span> | `cv13=0`
F shape  | <span class='akatab-cv13-1-R normal'>ⵟ</span> | <span class='akatab-cv13-1-R normal'> ‮ⵟ</span> | `cv13=1`

#### Alternate YADH

<span class='affects'>Affects: U+2D38</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard       | <span class='akatab-R normal'>ⴸ</span> | <span class='akatab-R normal'> ‮ⴸ</span> | `cv15=0`
Rounded bottom | <span class='akatab-cv15-1-R normal'>ⴸ</span> | <span class='akatab-cv15-1-R normal'> ‮ⴸ</span> | `cv15=1`

#### Alternate YAL and YAL

<span class='affects'>Affects: U+2D4D U+2D4F</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard| <span class='akatab-R normal'>ⵏⵏⵏ ⵏⵍⵏ ⵍⵍⵍ ⵍⵏⵍ</span> | <span class='akatab-R normal'> ‮ⵏⵏⵏ ⵏⵍⵏ ⵍⵍⵍ ⵍⵏⵍ</span> | `cv19=0`
Slanted | <span class='akatab-cv19-1-R normal'>ⵏⵏⵏ ⵏⵍⵏ ⵍⵍⵍ ⵍⵏⵍ</span> | <span class='akatab-cv19-1-R normal'>  ‮ⵏⵏⵏ ⵏⵍⵏ ⵍⵍⵍ ⵍⵏⵍ</span> | `cv19=1`

#### Alternate punctuation

<span class='affects'>Affects: U+0021 U+002C U+002E</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard Latin | <span class='akatab-R normal'>! , .</span> | | `cv20=0`
Decorative     | <span class='akatab-cv20-1-R normal'>! , .</span> | | `cv20=1`


### Ligature variants

#### Alternate YAB YAT

<span class='affects'>Affects: U+2D31 U+2D5C</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard   | <span class='akatab-R normal'>ⴱ⵿ⵜ</span> | <span class='akatab-R normal'> ‮ⴱ⵿ⵜ</span> | `cv31=0`
Interior T | <span class='akatab-cv31-1-R normal'>ⴱ⵿ⵜ</span> | <span class='akatab-cv31-1-R normal'> ‮ⴱ⵿ⵜ</span> | `cv31=1`

#### Alternate YAR YAT

<span class='affects'>Affects: U+2D54 U+2D5C</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard         | <span class='akatab-R normal'>ⵔ⵿ⵜ</span> | <span class='akatab-R normal'> ‮ⵔ⵿ⵜ</span> | `cv32=0`
Large interior T | <span class='akatab-cv32-1-R normal'>ⵔ⵿ⵜ</span> | <span class='akatab-cv32-1-R normal'> ‮ⵔ⵿ⵜ</span> | `cv32=1`
Small interior T | <span class='akatab-cv32-2-R normal'>ⵔ⵿ⵜ</span> | <span class='akatab-cv32-2-R normal'> ‮ⵔ⵿ⵜ</span> | `cv32=2`

#### Alternate YAS YAT

<span class='affects'>Affects: U+2D59 U+2D5C</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard                   | <span class='akatab-R normal'>ⵙ⵿ⵜ</span> | <span class='akatab-R normal'> ‮ⵙ⵿ⵜ</span> | `cv33=0`
Large interior T lower dot | <span class='akatab-cv33-1-R normal'>ⵙ⵿ⵜ</span> | <span class='akatab-cv33-1-R normal'> ‮ⵙ⵿ⵜ</span> | `cv33=1`
Small interior T           | <span class='akatab-cv33-2-R normal'>ⵙ⵿ⵜ</span> | <span class='akatab-cv33-2-R normal'> ‮ⵙ⵿ⵜ</span> | `cv33=2`
Large interior T upper dot | <span class='akatab-cv33-3-R normal'>ⵙ⵿ⵜ</span> | <span class='akatab-cv33-3-R normal'> ‮ⵙ⵿ⵜ</span> | `cv33=3`

#### Alternate YAM YAT

<span class='affects'>Affects: U+2D4E U+2D5C</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard       | <span class='akatab-R normal'>ⵎ⵿ⵜ</span> | <span class='akatab-R normal'> ‮ⵎ⵿ⵜ</span> | `cv34=0`
Mid exterior T | <span class='akatab-cv34-1-R normal'>ⵎ⵿ⵜ</span> | <span class='akatab-cv34-1-R normal'> ‮ⵎ⵿ⵜ</span> | `cv34=1`
Low interior T | <span class='akatab-cv34-2-R normal'>ⵎ⵿ⵜ</span> | <span class='akatab-cv34-2-R normal'> ‮ⵎ⵿ⵜ</span> | `cv34=2`
Center T       | <span class='akatab-cv34-3-R normal'>ⵎ⵿ⵜ</span> | <span class='akatab-cv34-3-R normal'> ‮ⵎ⵿ⵜ</span> | `cv34=3`

#### Alternate YAF YAT

<span class='affects'>Affects: U+2D3C U+2D5C</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard                      | <span class='akatab-R normal'>ⴼ⵿ⵜ</span> | <span class='akatab-R normal'> ‮ⴼ⵿ⵜ</span> | `cv35=0`
Single bar, middle exterior T | <span class='akatab-cv02-1-R normal'>ⴼ⵿ⵜ</span> | <span class='akatab-cv02-1-R normal'> ‮ⴼ⵿ⵜ</span> | `cv02=1`
Double bar, middle exterior T | <span class='akatab-cv35-1-R normal'>ⴼ⵿ⵜ</span> | <span class='akatab-cv35-1-R normal'> ‮ⴼ⵿ⵜ</span> | `cv35=1`
Single bar, middle interior T | <span class='akatab-cv35-2-R normal'>ⴼ⵿ⵜ</span> | <span class='akatab-cv35-2-R normal'> ‮ⴼ⵿ⵜ</span> | `cv35=2 (or cv02=1)`
Open top & bottom, interior T | <span class='akatab-cv14-1-R normal'>ⴼ⵿ⵜ</span> | <span class='akatab-cv14-1-R normal'> ‮ⴼ⵿ⵜ</span> | `cv14=1 (or cv02=2)`

#### Alternate YAN TUAREG YAK

<span class='affects'>Affects: U+2D4F U+2D3E</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard            | <span class='akatab-R normal'>ⵏ⵿ⴾ</span> | <span class='akatab-R normal'> ‮ⵏ⵿ⴾ</span> | `cv36=0`
Double cluster dots | <span class='akatab-cv36-1-R normal'> ‮ⵏ⵿ⴾ</span> | <span class='akatab-cv36-1-R normal'>ⵏ⵿ⴾ</span> | `cv36=1`

#### Alternate YAN YAT

<span class='affects'>Affects: U+2D4F U+2D5C</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard | <span class='akatab-R normal'>ⵏ⵿ⵜ</span> | <span class='akatab-R normal'> ‮ⵏ⵿ⵜ</span> | `cv37=0`
Side bar | <span class='akatab-cv37-1-R normal'>ⵏ⵿ⵜ</span> | <span class='akatab-cv37-1-R normal'> ‮ⵏ⵿ⵜ</span> | `cv37=1`
Top bar  | <span class='akatab-cv37-2-R normal'>ⵏ⵿ⵜ</span> | <span class='akatab-cv37-2-R normal'> ‮ⵏ⵿ⵜ</span> | `cv37=2`

#### Alternate YAL YAT

<span class='affects'>Affects: U+2D4D U+2D5C</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard   | <span class='akatab-R normal'>ⵍ⵿ⵜ</span> | <span class='akatab-R normal'> ‮ⵍ⵿ⵜ</span> | `cv38=0`
Internal T | <span class='akatab-cv38-1-R normal'>ⵍ⵿ⵜ</span> | <span class='akatab-cv38-1-R normal'> ‮ⵍ⵿ⵜ</span> | `cv38=1`
Middle bar | <span class='akatab-cv38-2-R normal'>ⵍ⵿ⵜ</span> | <span class='akatab-cv38-2-R normal'> ‮ⵍ⵿ⵜ</span> | `cv38=2`
X shape    | <span class='akatab-cv38-3-R normal'>ⵍ⵿ⵜ</span> | <span class='akatab-cv38-3-R normal'> ‮ⵍ⵿ⵜ</span> | `cv38=3`

#### Alternate YU YAT (WT)

<span class='affects'>Affects: U+2D53 U+2D5C</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard           | <span class='akatab-R normal'>ⵓ⵿ⵜ</span> | <span class='akatab-R normal'> ‮ⵓ⵿ⵜ</span> | `cv39=0`
Left short strokes | <span class='akatab-cv05-1-R normal'>ⵓ⵿ⵜ</span> | <span class='akatab-cv05-1-R normal'> ‮ⵓ⵿ⵜ</span> | `cv05=1`
Tall T, left dots  | <span class='akatab-cv39-1-R normal'>ⵓ⵿ⵜ</span> | <span class='akatab-cv39-1-R normal'> ‮ⵓ⵿ⵜ</span> | `cv39=1`
Tall T, cross dots | <span class='akatab-cv39-2-R normal'>ⵓ⵿ⵜ</span> | <span class='akatab-cv39-2-R normal'> ‮ⵓ⵿ⵜ</span> | `cv39=2`

#### Alternate TUAREG YAZH YAT

<span class='affects'>Affects: U+2D4C U+2D5C</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard       | <span class='akatab-R normal'>ⵌ⵿ⵜ</span> | <span class='akatab-R normal'> ‮ⵌ⵿ⵜ</span> | `cv40=0`
Mid exterior T | <span class='akatab-cv40-1-R normal'>ⵌ⵿ⵜ</span> | <span class='akatab-cv40-1-R normal'> ‮ⵌ⵿ⵜ</span> | `cv40=1`
Center T       | <span class='akatab-cv40-2-R normal'>ⵌ⵿ⵜ</span> | <span class='akatab-cv40-2-R normal'> ‮ⵌ⵿ⵜ</span> | `cv40=2`

#### Alternate YAN YAD

<span class='affects'>Affects: U+2D4F U+2D37</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard         | <span class='akatab-R normal'>ⵏ⵿ⴷ</span> | <span class='akatab-R normal'> ‮ⵏ⵿ⴷ</span> | `cv41=0`
Up down pointers | <span class='akatab-cv41-1-R normal'>ⵏ⵿ⴷ</span> | <span class='akatab-cv41-1-R normal'> ‮ⵏ⵿ⴷ</span> | `cv41=1`

#### Alternate YAN YAF

<span class='affects'>Affects: U+2D4F U+2D3C</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard            | <span class='akatab-R normal'>ⵏ⵿ⴼ</span> | <span class='akatab-R normal'> ‮ⵏ⵿ⴼ</span> | `cv42=0`
Top and bottom bars | <span class='akatab-cv42-1-R normal'>ⵏ⵿ⴼ</span> | <span class='akatab-cv42-1-R normal'> ‮ⵏ⵿ⴼ</span> | `cv42=1`
No bars             | <span class='akatab-cv14-1-R normal'>ⵏ⵿ⴼ</span> | <span class='akatab-cv14-1-R normal'> ‮ⵏ⵿ⴼ</span> | `cv14=1 (or cv02=2)`

#### Alternate YAN YAJ

<span class='affects'>Affects: U+2D4F U+2D36</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard            | <span class='akatab-R normal'>ⵏ⵿ⴶ</span> | <span class='akatab-R normal'> ‮ⵏ⵿ⴶ</span> | `cv43=0`
Top and bottom dots | <span class='akatab-cv43-1-R normal'>ⵏ⵿ⴶ</span> | <span class='akatab-cv43-1-R normal'> ‮ⵏ⵿ⴶ</span> | `cv43=1`

#### Alternate YAN YAS

<span class='affects'>Affects: U+2D4F U+2D59</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard     | <span class='akatab-R normal'>ⵏ⵿ⵙ</span> | <span class='akatab-R normal'> ‮ⵏ⵿ⵙ</span> | `cv44=0`
Interior YAN | <span class='akatab-cv44-1-R normal'>ⵏ⵿ⵙ</span> | <span class='akatab-cv44-1-R normal'> ‮ⵏ⵿ⵙ</span> | `cv44=1`

#### Alternate YAN TUAREG YAZH

<span class='affects'>Affects: U+2D4F U+2D4C</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard         | <span class='akatab-R normal'>ⵏ⵿ⵌ</span> | <span class='akatab-R normal'> ‮ⵏ⵿ⵌ</span> | `cv45=0`
Exterior circles | <span class='akatab-cv45-1-R normal'>ⵏ⵿ⵌ</span> | <span class='akatab-cv45-1-R normal'> ‮ⵏ⵿ⵌ</span> | `cv45=1`

#### Alternate YAR TUAREG YAK

<span class='affects'>Affects: U+2D54 U+2D3E</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard            | <span class='akatab-R normal'>ⵔ⵿ⴾ</span> | <span class='akatab-R normal'> ‮ⵔ⵿ⴾ</span> | `cv46=0`
Double cluster dots | <span class='akatab-cv46-1-R normal'>ⵔ⵿ⴾ</span> | <span class='akatab-cv46-1-R normal'> ‮ⵔ⵿ⴾ</span> | `cv46=1`

#### Alternate YASH TUAREG YAK

<span class='affects'>Affects: U+2D5B U+2D3E</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:--- | :--------------------------- | :--------------------------- | :-------
Standard            | <span class='akatab-R normal'>ⵛ⵿ⴾ</span> | <span class='akatab-R normal'> ‮ⵛ⵿ⴾ</span> | `cv47=0`
Double cluster dots | <span class='akatab-cv47-1-R normal'>ⵛ⵿ⴾ</span> | <span class='akatab-cv47-1-R normal'> ‮ⵛ⵿ⴾ</span> | `cv47=1`
8 shape             | <span class='akatab-cv12-1-R normal'>ⵛ⵿ⴾ</span> | <span class='akatab-cv12-1-R normal'> ‮ⵛ⵿ⴾ</span> | `cv12=1`
8 shape, double cluster dots | <span class='akatab-cv47-2-R normal'>ⵛ⵿ⴾ</span> | <span class='akatab-cv47-2-R normal'> ‮ⵛ⵿ⴾ</span> | `cv47=2`

#### Alternate YASH YAT

<span class='affects'>Affects: U+2D5B U+2D5C</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard   | <span class='akatab-R normal'>ⵛ⵿ⵜ</span> | <span class='akatab-R normal'> ‮ⵛ⵿ⵜ</span> | `cv48=0`
Internal T | <span class='akatab-cv48-1-R normal'>ⵛ⵿ⵜ</span> | <span class='akatab-cv48-1-R normal'> ‮ⵛ⵿ⵜ</span> | `cv48=1`


### Stylistic sets

#### Alternate YA

<span class='affects'>Affects: U+2D30</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard | <span class='akatab-R normal'>ⴰ</span> | <span class='akatab-R normal'> ‮ⴰ</span> | `ss01=0`
Circle   | <span class='akatab-ss01-1-R normal'>ⴰ</span> | <span class='akatab-ss01-1-R normal'> ‮ⴰ</span> | `ss01=1`

#### Alternate YAF

<span class='affects'>Affects: U+2D3C</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard            | <span class='akatab-R normal'>ⴼ</span> | <span class='akatab-R normal'> ‮ⴼ</span> | `ss02=0`
I-shape             | <span class='akatab-ss02-1-R normal'>ⴼ</span> | <span class='akatab-ss02-1-R normal'> ‮ⴼ</span> | `ss02=1`
Open top and bottom | <span class='akatab-ss14-1-R normal'>ⴼ</span> | <span class='akatab-ss14-1-R normal'> ‮ⴼ</span> | `ss14=1`

#### Alternate YAGHH

<span class='affects'>Affects: U+2D34</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard     | <span class='akatab-R normal'>ⴴ</span> | <span class='akatab-R normal'> ‮ⴴ</span> | `ss03=0`
Round bottom | <span class='akatab-ss03-1-R normal'>ⴴ</span> | <span class='akatab-ss03-1-R normal'> ‮ⴴ</span> | `ss03=1`

#### Alternate YAGN 

<span class='affects'>Affects: U+2D50</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard              | <span class='akatab-R normal'>ⵐ</span> | <span class='akatab-R normal'> ‮ⵐ</span> | `ss04=0`
Lowered bottom stroke | <span class='akatab-ss04-1-R normal'>ⵐ</span> | <span class='akatab-ss04-1-R normal'> ‮ⵐ</span> | `ss04=1`

#### Alternate YU

<span class='affects'>Affects: U+2D53</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard      | <span class='akatab-R normal'>ⵓ</span> | <span class='akatab-R normal'> ‮ⵓ</span> | `ss05=0`
Short strokes | <span class='akatab-ss05-1-R normal'>ⵓ</span> | <span class='akatab-ss05-1-R normal'> ‮ⵓ</span> | `ss05=1`

#### Alternate YAZ

<span class='affects'>Affects: U+2D63</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard | <span class='akatab-R normal'>ⵣ</span> | <span class='akatab-R normal'>ⵣ</span> | `ss06=0`
Squared  | <span class='akatab-ss06-1-R normal'>ⵣ</span> | <span class='akatab-ss06-1-R normal'>ⵣ</span> | `ss06=1`

#### Alternate Ahaggar YAZH

<span class='affects'>Affects: U+2D4B</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard | <span class='akatab-R normal'>ⵋ</span> | <span class='akatab-R normal'> ‮ⵋ</span> | `ss07=0`
Squared  | <span class='akatab-ss07-1-R normal'>ⵋ</span> | <span class='akatab-ss07-1-R normal'> ‮ⵋ</span> | `ss07=1`

#### Alternate YAB

<span class='affects'>Affects: U+2D31</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard         | <span class='akatab-R normal'>ⴱ</span> | <span class='akatab-R normal'> ‮ⴱ</span> | `ss08=0`
Rectangle style  | <span class='akatab-ss08-1-R normal'>ⴱ</span> | <span class='akatab-ss08-1-R normal'> ‮ⴱ</span> | `ss08=1`

#### Alternate YAG

<span class='affects'>Affects: U+2D33</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard    | <span class='akatab-R normal'>ⴳ</span> | <span class='akatab-R normal'> ‮ⴳ</span> | `ss09=0`
Rounded top | <span class='akatab-ss09-1-R normal'>ⴳ</span> | <span class='akatab-ss09-1-R normal'> ‮ⴳ</span> | `ss09=1`

#### Alternate YAJ

<span class='affects'>Affects: U+2D36</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard   | <span class='akatab-R normal'>ⴶ</span> | <span class='akatab-R normal'> ‮ⴶ</span> | `ss10=0`
Lower dots | <span class='akatab-ss10-1-R normal'>ⴶ</span> | <span class='akatab-ss10-1-R normal'> ‮ⴶ</span> | `ss10=1`

#### Alternate YAH (Tuareg yab)

<span class='affects'>Affects: U+2D40</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard        | <span class='akatab-R normal'>ⵀ</span> | <span class='akatab-R normal'> ‮ⵀ</span> | `ss11=0`
Rectangle style | <span class='akatab-ss11-1-R normal'>ⵀ</span> | <span class='akatab-ss11-1-R normal'> ‮ⵀ</span> | `ss11=1`

#### Alternate YASH

<span class='affects'>Affects: U+2D5B</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard | <span class='akatab-R normal'>ⵛ</span> | <span class='akatab-R normal'> ‮ⵛ</span> | `ss12=0`
8 shape  | <span class='akatab-ss12-1-R normal'>ⵛ</span> | <span class='akatab-ss12-1-R normal'> ‮ⵛ</span> | `ss12=1`

#### Alternate YATT

<span class='affects'>Affects: U+2D5F</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard | <span class='akatab-R normal'>ⵟ</span> | <span class='akatab-R normal'> ‮ⵟ</span> | `ss13=0`
F shape  | <span class='akatab-ss13-1-R normal'>ⵟ</span> | <span class='akatab-ss13-1-R normal'> ‮ⵟ</span> | `ss13=1`

#### Alternate YADH

<span class='affects'>Affects: U+2D38</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard       | <span class='akatab-R normal'>ⴸ</span> | <span class='akatab-R normal'> ‮ⴸ</span> | `ss15=0`
Rounded bottom | <span class='akatab-ss15-1-R normal'>ⴸ</span> | <span class='akatab-ss15-1-R normal'> ‮ⴸ</span> | `ss15=1`

#### Alternate YAL and YAL

<span class='affects'>Affects: U+2D4D U+2D4F</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard| <span class='akatab-R normal'>ⵏⵏⵏ ⵏⵍⵏ ⵍⵍⵍ ⵍⵏⵍ</span> | <span class='akatab-R normal'> ‮ⵏⵏⵏ ⵏⵍⵏ ⵍⵍⵍ ⵍⵏⵍ</span> | `ss19=0`
Slanted | <span class='akatab-ss19-1-R normal'>ⵏⵏⵏ ⵏⵍⵏ ⵍⵍⵍ ⵍⵏⵍ</span> | <span class='akatab-ss19-1-R normal'> ‮ⵏⵏⵏ ⵏⵍⵏ ⵍⵍⵍ ⵍⵏⵍ</span> | `ss19=1`

#### Alternate punctuation

<span class='affects'>Affects: U+0021 U+002C U+002E</span>

Feature  | Sample                       | Sample right-to-left         | Feature setting
:------- | :--------------------------- | :--------------------------- | :-------
Standard Latin | <span class='akatab-R normal'>! , .</span> | | `ss20=0`
Decorative     | <span class='akatab-ss20-1-R normal'>! , .</span> | | `ss20=1`


## Common features list
<p>The Akatab fonts contain logic that uses features to render certain glyphs and sequences properly. This logic processes the sequence of glyphs and produces the proper visual representation.<br>

The sections below show the use of some formatting characters, notably the TIFINAGH CONSONANT JOINER (U+2D7F) and RIGHT-TO-LEFT OVERRIDE (U+202E). A recommended keyboard for Tifinagh characters and these special characters can be downloaded at the [Keyman Tuareg Tifinagh keyboard](https://keyman.com/keyboards/tuareg_tifinagh) web site.

### Contextual shaping
<p>Two Tifinagh characters, TIFINAGH LETTER YAL (U+2D4D) and TIFINAGH LETTER YAN (U+2D4F), could cause ambiguity when they appear next to each other. To prevent uncertainty, the second character in the sequence is raised as in the example below:<br>
<span class='akatab-R normal'>ⵏⵏⵏ ⵏⵍⵏ ⵍⵍⵍ ⵍⵏⵍ</span><br>
If the user's preference is slanted bars, the user-selected features *cv19* or *ss19* can be used, as illustrated in the user-selected font features section above.


### Ligature formation
<p>Bi-consonant ligatures are formed after typing the character sequences shown in the examples below. Type the first character, e.g. <span class='akatab-B'> ⴱ </span> (U+2D31), the TIFINAGH CONSONANT JOINER <span class='akatab-B'> &#x2D7F;&#x00A0; </span> (U+2D7F), and then the second character, e.g. <span class='akatab-B'> ⵜ </span>, to get the <span class='akatab-B'> ⴱ⵿ⵜ </span> ligature.</p>

![Akatab biconsonant ligature examples](assets/images/Akatab biconsonant ligature examples.png){.fullsize}
[caption]<em>Akatab bi-consonant ligature examples</em>[/caption]


### Right-to-left Tifinagh
<p>Historically, Tifinagh did not have a fixed direction. Modern Tifinagh is commonly printed as left-to-right text and [The Unicode Standard: Tifinagh section](https://www.unicode.org/versions/Unicode15.0.0/ch19.pdf#G43184) specifies its directionality as strong left to right while recognizing it can be bidirectional. Akatab has glyph and rendering support for writing in both directions. To get right-to-left behaviour and then reverse the direction, the user can use two invisible formatting characters to change the direction of the characters and the text as follows:<br>
<ol type="1">
  <li>U+202E (RIGHT-TO-LEFT OVERRIDE) for right-to-left Tifinagh<br>
    The text that follows will be right-to-left. Additionally, the directionality of characters is changed to right-to-left.
  </li>
  <li>U+202C (POP DIRECTIONAL FORMATTING) to revert direction for Tifinagh text<br>
    The text that follows reverts to the direction of the text before the previous U+202E character. 
  </li>
</ol>
</p>‮

#### Akatab examples

<p>
<strong>The following text demonstrates Tifinagh left-to-right behaviour:</strong><br>
<span class='akatab-R normal'> ⵙⵏⵜⵜ ⵜⵙⴾⵍⵏ ⵓⵔ ⵜⴶⵂⵏⵜ ⵎⵉ </span>
</p>
<p>
<strong>The following text demonstrates Tifinagh right-to-left behaviour using the U+202E character:</strong><br>
<span dir="rtl" class='akatab-R normal'> &#x202E; ⵙⵏⵜⵜ ⵜⵙⴾⵍⵏ ⵓⵔ ⵜⴶⵂⵏⵜ ⵎⵉ </span>

<strong>The following text demonstrates both Tifinagh directional behaviours using the U+202E and U+202C characters:</strong><br>
<span dir="rtl" class='akatab-R normal'> &#x202E; ⵙⵏⵜⵜ ⵜⵙⴾⵍⵏ ⵓⵔ ⵜⴶⵂⵏⵜ ⵎⵉ  &#x202C; ⵙⵏⵜⵜ ⵜⵙⴾⵍⵏ ⵓⵔ ⵜⴶⵂⵏⵜ ⵎⵉ </span>
</p>‮
<!-- 
Using hard-coded directional characters in the HTML code (as illustrated above) can prevent accidental deletion of invisible characters.
-->

[font id='akatab' face='Akatab-Regular' bold='Akatab-Bold' size='150%']
[font id='akatab-cv01-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv01 1']
[font id='akatab-cv01-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv01 1']
[font id='akatab-cv02-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv02 1']
[font id='akatab-cv02-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv02 1']
[font id='akatab-cv14-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv14 1']
[font id='akatab-cv14-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv14 1']
[font id='akatab-cv03-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv03 1']
[font id='akatab-cv03-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv03 1']
[font id='akatab-cv04-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv04 1']
[font id='akatab-cv04-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv04 1']
[font id='akatab-cv05-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv05 1']
[font id='akatab-cv05-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv05 1']
[font id='akatab-cv06-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv06 1']
[font id='akatab-cv06-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv06 1']
[font id='akatab-cv07-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv07 1']
[font id='akatab-cv07-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv07 1']
[font id='akatab-cv08-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv08 1']
[font id='akatab-cv08-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv08 1']
[font id='akatab-cv09-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv09 1']
[font id='akatab-cv09-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv09 1']
[font id='akatab-cv10-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv10 1']
[font id='akatab-cv10-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv10 1']
[font id='akatab-cv11-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv11 1']
[font id='akatab-cv11-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv11 1']
[font id='akatab-cv12-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv12 1']
[font id='akatab-cv12-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv12 1']
[font id='akatab-cv13-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv13 1']
[font id='akatab-cv13-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv13 1']
[font id='akatab-cv15-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv15 1']
[font id='akatab-cv15-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv15 1']
[font id='akatab-cv19-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv19 1']
[font id='akatab-cv19-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv19 1']
[font id='akatab-cv20-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv20 1']
[font id='akatab-cv31-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv31 1']
[font id='akatab-cv31-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv31 1']
[font id='akatab-cv32-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv32 1']
[font id='akatab-cv32-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv32 1']
[font id='akatab-cv32-2' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv32 2']
[font id='akatab-cv32-2' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv32 2']
[font id='akatab-cv33-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv33 1']
[font id='akatab-cv33-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv33 1']
[font id='akatab-cv33-2' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv33 2']
[font id='akatab-cv33-2' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv33 2']
[font id='akatab-cv33-3' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv33 3']
[font id='akatab-cv33-3' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv33 3']
[font id='akatab-cv34-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv34 1']
[font id='akatab-cv34-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv34 1']
[font id='akatab-cv34-2' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv34 2']
[font id='akatab-cv34-2' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv34 2']
[font id='akatab-cv34-3' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv34 3']
[font id='akatab-cv34-3' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv34 3']
[font id='akatab-cv02-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv02 1']
[font id='akatab-cv02-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv02 1']
[font id='akatab-cv35-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv35 1']
[font id='akatab-cv35-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv35 1']
[font id='akatab-cv35-2' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv35 2']
[font id='akatab-cv35-2' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv35 2']
[font id='akatab-cv14-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv14 1']
[font id='akatab-cv14-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv14 1']
[font id='akatab-cv36-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv36 1']
[font id='akatab-cv36-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv36 1']
[font id='akatab-cv37-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv37 1']
[font id='akatab-cv37-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv37 1']
[font id='akatab-cv37-2' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv37 2']
[font id='akatab-cv37-2' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv37 2']
[font id='akatab-cv38-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv38 1']
[font id='akatab-cv38-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv38 1']
[font id='akatab-cv38-2' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv38 2']
[font id='akatab-cv38-2' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv38 2']
[font id='akatab-cv38-3' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv38 3']
[font id='akatab-cv38-3' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv38 3']
[font id='akatab-cv05-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv05 1']
[font id='akatab-cv05-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv05 1']
[font id='akatab-cv39-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv39 1']
[font id='akatab-cv39-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv39 1']
[font id='akatab-cv39-2' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv39 2']
[font id='akatab-cv39-2' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv39 2']
[font id='akatab-cv40-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv40 1']
[font id='akatab-cv40-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv40 1']
[font id='akatab-cv40-2' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv40 2']
[font id='akatab-cv40-2' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv40 2']
[font id='akatab-cv41-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv41 1']
[font id='akatab-cv41-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv41 1']
[font id='akatab-cv42-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv42 1']
[font id='akatab-cv42-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv42 1']
[font id='akatab-cv14-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv14 1']
[font id='akatab-cv14-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv14 1']
[font id='akatab-cv43-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv43 1']
[font id='akatab-cv43-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv43 1']
[font id='akatab-cv44-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv44 1']
[font id='akatab-cv44-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv44 1']
[font id='akatab-cv45-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv45 1']
[font id='akatab-cv45-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv45 1']
[font id='akatab-cv46-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv46 1']
[font id='akatab-cv46-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv46 1']
[font id='akatab-cv47-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv47 1']
[font id='akatab-cv47-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv47 1']
[font id='akatab-cv12-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv12 1']
[font id='akatab-cv12-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv12 1']
[font id='akatab-cv47-2' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv47 2']
[font id='akatab-cv47-2' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv47 2']
[font id='akatab-cv48-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv48 1']
[font id='akatab-cv48-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='cv48 1']
[font id='akatab-ss01-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='ss01 1']
[font id='akatab-ss01-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='ss01 1']
[font id='akatab-ss02-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='ss02 1']
[font id='akatab-ss02-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='ss02 1']
[font id='akatab-ss14-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='ss14 1']
[font id='akatab-ss14-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='ss14 1']
[font id='akatab-ss03-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='ss03 1']
[font id='akatab-ss03-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='ss03 1']
[font id='akatab-ss04-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='ss04 1']
[font id='akatab-ss04-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='ss04 1']
[font id='akatab-ss05-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='ss05 1']
[font id='akatab-ss05-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='ss05 1']
[font id='akatab-ss06-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='ss06 1']
[font id='akatab-ss06-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='ss06 1']
[font id='akatab-ss07-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='ss07 1']
[font id='akatab-ss07-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='ss07 1']
[font id='akatab-ss08-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='ss08 1']
[font id='akatab-ss08-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='ss08 1']
[font id='akatab-ss09-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='ss09 1']
[font id='akatab-ss09-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='ss09 1']
[font id='akatab-ss10-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='ss10 1']
[font id='akatab-ss10-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='ss10 1']
[font id='akatab-ss11-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='ss11 1']
[font id='akatab-ss11-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='ss11 1']
[font id='akatab-ss12-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='ss12 1']
[font id='akatab-ss12-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='ss12 1']
[font id='akatab-ss13-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='ss13 1']
[font id='akatab-ss13-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='ss13 1']
[font id='akatab-ss15-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='ss15 1']
[font id='akatab-ss15-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='ss15 1']
[font id='akatab-ss19-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='ss19 1']
[font id='akatab-ss19-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='ss19 1']
[font id='akatab-ss20-1' face='Akatab-Regular' bold='Akatab-Bold' size='150%' feats='ss20 1']
