<?php

return CRM_Core_CodeGen_SqlData::create('civicrm_uf_field')
  ->addDefaults([
    'is_reserved' => 0,
    'is_required' => 0,
    'visibility' => 'User and User Admin Only',
    'phone_type_id' => NULL,
    'in_selector' => 0,
    'is_searchable' => 0,
    'help_post' => NULL,
    'location_type_id' => NULL,
  ])
  ->addValues([
    [
      'uf_group_id' => 1,
      'field_name' => 'first_name',
      'is_required' => 1,
      'weight' => 1,
      'label' => ts('First Name'),
      'field_type' => 'Individual',
    ],
    [
      'uf_group_id' => 1,
      'field_name' => 'last_name',
      'is_required' => 1,
      'weight' => 2,
      'label' => ts('Last Name'),
      'field_type' => 'Individual',
    ],
    [
      'uf_group_id' => 1,
      'field_name' => 'street_address',
      'weight' => 3,
      'location_type_id' => 1,
      'label' => ts('Street Address (Home)'),
      'field_type' => 'Contact',
    ],
    [
      'uf_group_id' => 1,
      'field_name' => 'city',
      'weight' => 4,
      'location_type_id' => 1,
      'label' => ts('City (Home)'),
      'field_type' => 'Contact',
    ],
    [
      'uf_group_id' => 1,
      'field_name' => 'postal_code',
      'weight' => 5,
      'location_type_id' => 1,
      'label' => ts('Postal Code (Home)'),
      'field_type' => 'Contact',
    ],
    [
      'uf_group_id' => 1,
      'field_name' => 'country',
      'weight' => 6,
      'location_type_id' => 1,
      'label' => ts('Country (Home)'),
      'field_type' => 'Contact',
    ],
    [
      'uf_group_id' => 1,
      'field_name' => 'state_province',
      'weight' => 7,
      'location_type_id' => 1,
      'label' => ts('State (Home)'),
      'field_type' => 'Contact',
    ],
    [
      'uf_group_id' => 2,
      'field_name' => 'first_name',
      'is_required' => 1,
      'weight' => 1,
      'label' => ts('First Name'),
      'field_type' => 'Individual',
    ],
    [
      'uf_group_id' => 2,
      'field_name' => 'last_name',
      'is_required' => 1,
      'weight' => 2,
      'label' => ts('Last Name'),
      'field_type' => 'Individual',
    ],
    [
      'uf_group_id' => 2,
      'field_name' => 'email',
      'is_required' => 1,
      'weight' => 3,
      'label' => ts('Email Address'),
      'field_type' => 'Contact',
    ],
    [
      'uf_group_id' => 3,
      'field_name' => 'participant_status',
      'is_required' => 1,
      'is_reserved' => 1,
      'weight' => 1,
      'label' => ts('Participant Status'),
      'field_type' => 'Participant',
    ],
    [
      'uf_group_id' => 4,
      'field_name' => 'first_name',
      'is_required' => 1,
      'weight' => 1,
      'label' => ts('First Name'),
      'field_type' => 'Individual',
    ],
    [
      'uf_group_id' => 4,
      'field_name' => 'last_name',
      'is_required' => 1,
      'weight' => 2,
      'label' => ts('Last Name'),
      'field_type' => 'Individual',
    ],
    [
      'uf_group_id' => 4,
      'field_name' => 'email',
      'weight' => 3,
      'label' => ts('Email Address'),
      'field_type' => 'Contact',
    ],
    [
      'uf_group_id' => 5,
      'field_name' => 'organization_name',
      'is_required' => 1,
      'weight' => 2,
      'label' => ts('Organization Name'),
      'field_type' => 'Organization',
    ],
    [
      'uf_group_id' => 5,
      'field_name' => 'email',
      'weight' => 3,
      'label' => ts('Email Address'),
      'field_type' => 'Contact',
    ],
    [
      'uf_group_id' => 6,
      'field_name' => 'household_name',
      'is_required' => 1,
      'weight' => 2,
      'label' => ts('Household Name'),
      'field_type' => 'Household',
    ],
    [
      'uf_group_id' => 6,
      'field_name' => 'email',
      'weight' => 3,
      'label' => ts('Email Address'),
      'field_type' => 'Contact',
    ],
    [
      'uf_group_id' => 7,
      'field_name' => 'phone',
      'is_required' => 1,
      'weight' => 1,
      'location_type_id' => 1,
      'label' => ts('Home Phone'),
      'field_type' => 'Contact',
      'phone_type_id' => 1,
    ],
    [
      'uf_group_id' => 7,
      'field_name' => 'phone',
      'is_required' => 1,
      'weight' => 2,
      'location_type_id' => 1,
      'label' => ts('Home Mobile'),
      'field_type' => 'Contact',
      'phone_type_id' => 2,
    ],
    [
      'uf_group_id' => 7,
      'field_name' => 'street_address',
      'is_required' => 1,
      'weight' => 3,
      'label' => ts('Primary Address'),
      'field_type' => 'Contact',
    ],
    [
      'uf_group_id' => 7,
      'field_name' => 'city',
      'is_required' => 1,
      'weight' => 4,
      'label' => ts('City'),
      'field_type' => 'Contact',
    ],
    [
      'uf_group_id' => 7,
      'field_name' => 'state_province',
      'is_required' => 1,
      'weight' => 5,
      'label' => ts('State'),
      'field_type' => 'Contact',
    ],
    [
      'uf_group_id' => 7,
      'field_name' => 'postal_code',
      'is_required' => 1,
      'weight' => 6,
      'label' => ts('Postal Code'),
      'field_type' => 'Contact',
    ],
    [
      'uf_group_id' => 7,
      'field_name' => 'email',
      'is_required' => 1,
      'weight' => 7,
      'label' => ts('Primary Email'),
      'field_type' => 'Contact',
    ],
    [
      'uf_group_id' => 7,
      'field_name' => 'group',
      'is_required' => 1,
      'weight' => 8,
      'label' => ts('Groups'),
      'field_type' => 'Contact',
    ],
    [
      'uf_group_id' => 7,
      'field_name' => 'tag',
      'is_required' => 1,
      'weight' => 9,
      'label' => ts('Tags'),
      'field_type' => 'Contact',
    ],
    [
      'uf_group_id' => 7,
      'field_name' => 'gender_id',
      'is_required' => 1,
      'weight' => 10,
      'label' => ts('Gender'),
      'field_type' => 'Individual',
    ],
    [
      'uf_group_id' => 7,
      'field_name' => 'birth_date',
      'is_required' => 1,
      'weight' => 11,
      'label' => ts('Date of Birth'),
      'field_type' => 'Individual',
    ],
    [
      'uf_group_id' => 8,
      'field_name' => 'street_address',
      'is_required' => 1,
      'is_reserved' => 1,
      'weight' => 1,
      'location_type_id' => 1,
      'label' => ts('Street Address (Home)'),
      'field_type' => 'Contact',
    ],
    [
      'uf_group_id' => 8,
      'field_name' => 'city',
      'is_required' => 1,
      'is_reserved' => 1,
      'weight' => 2,
      'location_type_id' => 1,
      'label' => ts('City (Home)'),
      'field_type' => 'Contact',
    ],
    [
      'uf_group_id' => 8,
      'field_name' => 'postal_code',
      'weight' => 3,
      'location_type_id' => 1,
      'label' => ts('Postal Code (Home)'),
      'field_type' => 'Contact',
    ],
    [
      'uf_group_id' => 8,
      'field_name' => 'country',
      'weight' => 4,
      'location_type_id' => 1,
      'label' => ts('Country (Home)'),
      'field_type' => 'Contact',
    ],
    [
      'uf_group_id' => 8,
      'field_name' => 'state_province',
      'weight' => 5,
      'location_type_id' => 1,
      'label' => ts('State (Home)'),
      'field_type' => 'Contact',
    ],
    [
      'uf_group_id' => 9,
      'field_name' => 'organization_name',
      'is_required' => 1,
      'weight' => 1,
      'label' => ts('Organization Name'),
      'field_type' => 'Organization',
    ],
    [
      'uf_group_id' => 9,
      'field_name' => 'phone',
      'is_required' => 1,
      'weight' => 2,
      'location_type_id' => 3,
      // FIXME: Space
      'label' => ts('Phone (Main) '),
      'field_type' => 'Contact',
      'phone_type_id' => 1,
    ],
    [
      'uf_group_id' => 9,
      'field_name' => 'email',
      'is_required' => 1,
      'weight' => 3,
      'location_type_id' => 3,
      // FIXME: Space
      'label' => ts('Email (Main) '),
      'field_type' => 'Contact',
    ],
    [
      'uf_group_id' => 9,
      'field_name' => 'street_address',
      'is_required' => 1,
      'weight' => 4,
      'location_type_id' => 3,
      'label' => ts('Street Address'),
      'field_type' => 'Contact',
    ],
    [
      'uf_group_id' => 9,
      'field_name' => 'city',
      'is_required' => 1,
      'weight' => 5,
      'location_type_id' => 3,
      'label' => ts('City'),
      'field_type' => 'Contact',
    ],
    [
      'uf_group_id' => 9,
      'field_name' => 'postal_code',
      'is_required' => 1,
      'weight' => 6,
      'location_type_id' => 3,
      'label' => ts('Postal Code'),
      'field_type' => 'Contact',
    ],
    [
      'uf_group_id' => 9,
      'field_name' => 'country',
      'is_required' => 1,
      'weight' => 7,
      'location_type_id' => 3,
      'label' => ts('Country'),
      'field_type' => 'Contact',
    ],
    [
      'uf_group_id' => 9,
      'field_name' => 'state_province',
      'is_required' => 1,
      'weight' => 8,
      'location_type_id' => 3,
      'label' => ts('State/Province'),
      'field_type' => 'Contact',
    ],
    [
      'uf_group_id' => 10,
      'field_name' => 'financial_type',
      'is_reserved' => 1,
      'weight' => 1,
      'label' => ts('Financial Type'),
      'field_type' => 'Contribution',
    ],
    [
      'uf_group_id' => 10,
      'field_name' => 'total_amount',
      'is_reserved' => 1,
      'weight' => 2,
      'label' => ts('Amount'),
      'field_type' => 'Contribution',
    ],
    [
      'uf_group_id' => 10,
      'field_name' => 'contribution_status_id',
      'is_required' => 1,
      'is_reserved' => 1,
      'weight' => 3,
      'label' => ts('Status'),
      'field_type' => 'Contribution',
    ],
    [
      'uf_group_id' => 10,
      'field_name' => 'receive_date',
      'is_required' => 1,
      'is_reserved' => 1,
      'weight' => 4,
      'label' => ts('Contribution Date'),
      'field_type' => 'Contribution',
    ],
    [
      'uf_group_id' => 10,
      'field_name' => 'contribution_source',
      'weight' => 5,
      'label' => ts('Contribution Source'),
      'field_type' => 'Contribution',
    ],
    [
      'uf_group_id' => 10,
      'field_name' => 'payment_instrument',
      'weight' => 6,
      'label' => ts('Payment Method'),
      'field_type' => 'Contribution',
    ],
    [
      'uf_group_id' => 10,
      'field_name' => 'contribution_check_number',
      'weight' => 7,
      'label' => ts('Check Number'),
      'field_type' => 'Contribution',
    ],
    [
      'uf_group_id' => 10,
      'field_name' => 'send_receipt',
      'weight' => 8,
      'label' => ts('Send Receipt'),
      'field_type' => 'Contribution',
    ],
    [
      'uf_group_id' => 10,
      'field_name' => 'invoice_id',
      'weight' => 9,
      'label' => ts('Invoice ID'),
      'field_type' => 'Contribution',
    ],
    [
      'uf_group_id' => 10,
      'field_name' => 'soft_credit',
      'weight' => 10,
      'label' => ts('Soft Credit'),
      'field_type' => 'Contribution',
    ],
    [
      'uf_group_id' => 10,
      'field_name' => 'soft_credit_type',
      'weight' => 11,
      'label' => ts('Soft Credit Type'),
      'field_type' => 'Contribution',
    ],
    [
      'uf_group_id' => 11,
      'field_name' => 'membership_type',
      'is_required' => 1,
      'is_reserved' => 1,
      'weight' => 1,
      'label' => ts('Membership Type'),
      'field_type' => 'Membership',
    ],
    [
      'uf_group_id' => 11,
      'field_name' => 'membership_join_date',
      'is_required' => 1,
      'is_reserved' => 1,
      'weight' => 2,
      'label' => ts('Member Since'),
      'field_type' => 'Membership',
    ],
    [
      'uf_group_id' => 11,
      'field_name' => 'membership_start_date',
      'is_reserved' => 1,
      'weight' => 3,
      'label' => ts('Start Date'),
      'field_type' => 'Membership',
    ],
    [
      'uf_group_id' => 11,
      'field_name' => 'membership_end_date',
      'is_reserved' => 1,
      'weight' => 4,
      'label' => ts('End Date'),
      'field_type' => 'Membership',
    ],
    [
      'uf_group_id' => 11,
      'field_name' => 'membership_source',
      'weight' => 5,
      'label' => ts('Membership Source'),
      'field_type' => 'Membership',
    ],
    [
      'uf_group_id' => 11,
      'field_name' => 'send_receipt',
      'weight' => 6,
      'label' => ts('Send Receipt'),
      'field_type' => 'Membership',
    ],
    [
      'uf_group_id' => 11,
      'field_name' => 'financial_type',
      'is_reserved' => 1,
      'weight' => 7,
      'label' => ts('Financial Type'),
      'field_type' => 'Membership',
    ],
    [
      'uf_group_id' => 11,
      'field_name' => 'total_amount',
      'is_reserved' => 1,
      'weight' => 8,
      'label' => ts('Amount'),
      'field_type' => 'Membership',
    ],
    [
      'uf_group_id' => 11,
      'field_name' => 'receive_date',
      'is_required' => 1,
      'is_reserved' => 1,
      'weight' => 9,
      'label' => ts('Contribution Date'),
      'field_type' => 'Membership',
    ],
    [
      'uf_group_id' => 11,
      'field_name' => 'payment_instrument',
      'weight' => 10,
      'label' => ts('Payment Method'),
      'field_type' => 'Membership',
    ],
    [
      'uf_group_id' => 11,
      'field_name' => 'contribution_check_number',
      'weight' => 11,
      'label' => ts('Check Number'),
      'field_type' => 'Membership',
    ],
    [
      'uf_group_id' => 11,
      'field_name' => 'contribution_status_id',
      'is_required' => 1,
      'is_reserved' => 1,
      'weight' => 12,
      'label' => ts('Payment Status'),
      'field_type' => 'Membership',
    ],
    [
      'uf_group_id' => 11,
      'field_name' => 'soft_credit',
      'weight' => 13,

      'label' => ts('Soft Credit'),
      'field_type' => 'Membership',
    ],
    [
      'uf_group_id' => 11,
      'field_name' => 'soft_credit_type',
      'weight' => 14,
      'label' => ts('Soft Credit Type'),
      'field_type' => 'Membership',
    ],
    [
      'uf_group_id' => 12,
      'field_name' => 'first_name',
      'is_required' => 1,
      'weight' => 1,
      'label' => ts('First Name'),
      'field_type' => 'Individual',
    ],
    [
      'uf_group_id' => 12,
      'field_name' => 'last_name',
      'is_required' => 1,
      'weight' => 2,
      'label' => ts('Last Name'),
      'field_type' => 'Individual',
    ],
    [
      'uf_group_id' => 12,
      'field_name' => 'email',
      'is_required' => 1,
      'weight' => 3,
      'label' => ts('Email Address'),
      'field_type' => 'Contact',
    ],
    [
      'uf_group_id' => 13,
      'field_name' => 'prefix_id',
      'is_reserved' => 1,
      'weight' => 1,
      'label' => ts('Individual Prefix'),
      'field_type' => 'Individual',
    ],
    [
      'uf_group_id' => 13,
      'field_name' => 'first_name',
      'is_required' => 1,
      'is_reserved' => 1,
      'weight' => 2,
      'label' => ts('First Name'),
      'field_type' => 'Individual',
    ],
    [
      'uf_group_id' => 13,
      'field_name' => 'last_name',
      'is_required' => 1,
      'is_reserved' => 1,
      'weight' => 3,
      'label' => ts('Last Name'),
      'field_type' => 'Individual',
    ],
    [
      'uf_group_id' => 13,
      'field_name' => 'email',
      'is_reserved' => 1,
      'weight' => 4,
      'location_type_id' => 1,
      'label' => ts('Email Address'),
      'field_type' => 'Contact',
    ],
  ]);
