# CiviCRM 5.48.0

Released April 6, 2022

- **[Synopsis](#synopsis)**
- **[Features](#features)**
- **[Bugs resolved](#bugs)**
- **[Miscellany](#misc)**
- **[Credits](#credits)**
- **[Feedback](#feedback)**

## <a name="synopsis"></a>Synopsis

| *Does this version...?*                                         |         |
|:--------------------------------------------------------------- |:-------:|
| Fix security vulnerabilities?                                   |   no    |
| **Change the database schema?**                                 | **yes** |
| **Alter the API?**                                              | **yes** |
| Require attention to configuration options?                     |   no    |
| **Fix problems installing or upgrading to a previous version?** | **yes** |
| **Introduce features?**                                         | **yes** |
| **Fix bugs?**                                                   | **yes** |

## <a name="features"></a>Features

### Core CiviCRM

- **Add civicrm_admin_ui extension
  ([22628](https://github.com/civicrm/civicrm-core/pull/22628))**

  Adds a new bundled extension `civicrm_admin_ui`. This extension replaces 2
  screens with SearchDisplay Afforms: Custom field groups and Custom fields.

- **Add deprecation notice to APIv3 Explorer
  ([22811](https://github.com/civicrm/civicrm-core/pull/22811))**

  Adds a notice to the APIv3 explorer to encourage users to use APIv4 instead.

- **Apiv4 entity parity (Work Towards
  [dev/core#2486](https://lab.civicrm.org/dev/core/-/issues/2486):
  [22754](https://github.com/civicrm/civicrm-core/pull/22754),
  [22823](https://github.com/civicrm/civicrm-core/pull/22823),
  [22624](https://github.com/civicrm/civicrm-core/pull/22624) and
  [22799](https://github.com/civicrm/civicrm-core/pull/22799))**

  Adds "Extension", "Mailing", "MailingGroup" and "MailingJob" entities to
  APIv4.

- **APIv4 - Add tableName to Entity.get output
  ([22829](https://github.com/civicrm/civicrm-core/pull/22829))**

  Adds `tableName` to the APIv4 Entity.get action output, improving
  flexibility for virtual entities.

- **APIv4 Explorer - Add REST syntax
  ([22722](https://github.com/civicrm/civicrm-core/pull/22722))**

  Displays REST syntax in the APIv4 Explorer.

- **APIv4 - Add metadata about class args
  ([22831](https://github.com/civicrm/civicrm-core/pull/22831))**

  The CustomValue API is a virtual entity, where multiple api entities all get
  routed to the same class by virtue of all sharing the prefix "Custom_" and
  pass a class arg to the php factory functions e.g.
  CustomValue::get('MyCustomGroup').

  Instead of hard-coding this idea into the API Explorer now it's part of the
  entity metadata so that other APIs, notaby ECK, can use a similar pattern.

- **APIv4 Explorer - Add "copy" button to quickly copy code to clipboard
  ([22896](https://github.com/civicrm/civicrm-core/pull/22896))**

  Makes it easy to select and copy generated APIv4 Explorer code.

- **SearchKit - Update APIv3 Extension.get to use APIv4
  ([22788](https://github.com/civicrm/civicrm-core/pull/22788))**

  Updates SearchKit code to use newer version of the API when calling
  Extension.get.

- **SearchKit - Use crmDialogButtons for task popups
  ([22790](https://github.com/civicrm/civicrm-core/pull/22790))**

  Updates the buttons in SearchKit action popups to use standard dialog button
  formatting.

- **SearchKit - Add 'merge contacts' task
  ([22768](https://github.com/civicrm/civicrm-core/pull/22768) and
  [23035](https://github.com/civicrm/civicrm-core/pull/23035))**

  Adds a "merge contacts" task to SearchKit.

- **SearchKit - Customizable "No Results" text
  ([22770](https://github.com/civicrm/civicrm-core/pull/22770))**

  Makes it so users can customize the "No Results" text in SearchKit.

- **SearchKit - Improve import UI to handle update & preview the import
  ([22699](https://github.com/civicrm/civicrm-core/pull/22699))**

  SearchKit has an import/export SavedSearch feature which allows you to
  copy/paste api code in JSON format. This change enables update as well as create,
  and improves that UI to give better user feedback about what will happen when
  the import is run.

- **SearchKit - Support relative dates and datepicker with the DATE() sql fn
  ([22783](https://github.com/civicrm/civicrm-core/pull/22783))**

  Allows one to pick a relative or calendar date in conjunction with the DATE
  ONLY field transformation.

- **Civi\Api4\Queue - Allow use with hook_managed
  ([22796](https://github.com/civicrm/civicrm-core/pull/22796))**

  Flags the entity Queue so that it can be used with hook_managed.

- **Define more usable queue DX for multithreaded background work (Work Towards
  [dev/core#1304](https://lab.civicrm.org/dev/core/-/issues/1304):
  [22812](https://github.com/civicrm/civicrm-core/pull/22812))**

  Expands the schema for civicrm_queue (et al). By configuring properties on
  civicrm_queue (et al), you can tell a generic queue-agent how to handle items
  from this queue.

- **ManagedEntities - Allow "match" param to convert existing records to …
  ([22883](https://github.com/civicrm/civicrm-core/pull/22883))**

  This can help ease the pain of declaring managed entities which may or may not
  already exist - now they can be matched by name or other unique identifier.

- **Database update from 5.47.2 to 5.47.3 fails with a non en_US database.
  ([dev/core#3135](https://lab.civicrm.org/dev/core/-/issues/3151):
  [23063](https://github.com/civicrm/civicrm-core/pull/23063))**  

### CiviContribute

- **Add basic contribution example base for contribution workflows
  ([22636](https://github.com/civicrm/civicrm-core/pull/22636))**

  Makes it so that one can preview Contribution Message Templates.

- **Remove time component from the {contribution.receive_date} token
  ([dev/core#3072](https://lab.civicrm.org/dev/core/-/issues/3072):
  [23071](https://github.com/civicrm/civicrm-core/pull/23071))**

### CiviEvent

- **Introduce a way to link event participants from the associated booking.
  ([dev/user-interface#45](https://lab.civicrm.org/dev/user-interface/-/issues/45):
  [22732](https://github.com/civicrm/civicrm-core/pull/22732))**

  Introduces a way to navigate to participants from the contribution view.

### CiviMail

- **Mailing - Add `serialize` and `add` to `template_options` field
  ([22785](https://github.com/civicrm/civicrm-core/pull/22785))**

  Improves the mailing schema metadata for template_options and template_type
  fields.

- **Start phasing out 'preferred_mail_format' (Work Towards
  [dev/core#2866](https://lab.civicrm.org/dev/core/-/issues/2866):
  [22775](https://github.com/civicrm/civicrm-core/pull/22775),
  [22633](https://github.com/civicrm/civicrm-core/pull/22633) and
  [22635](https://github.com/civicrm/civicrm-core/pull/22635))**

  Ignores preferred mail format when sending a message. Instead sends both html
  and plain text versions and lets the email client decide which to show.
  Removes `preferred_mail_format` from email trait.

### Drupal Integraton

- **civicrm.drush.inc - Add 'civicrm-pipe' subcommand
  ([70](https://github.com/civicrm/civicrm-drupal-8/pull/70))**

  Adds support for the subcommand `drush civicrm-pipe` (`drush cvpipe`).

## <a name="bugs"></a>Bugs resolved

### Core CiviCRM

- **Update DOMPDF to 1.2.1 and update composer-compile-plugin as per master
  ([23102](https://github.com/civicrm/civicrm-core/pull/23102))**

- **Contact Logging Detail report crashes when a contribution and contact are
  updated together
  ([dev/report#85](https://lab.civicrm.org/dev/report/-/issues/85):
  [22242](https://github.com/civicrm/civicrm-core/pull/22242))**

- **Warning: is_dir(): open_basedir restriction in effect
  ([dev/core#2927](https://lab.civicrm.org/dev/core/-/issues/2927):
  [22277](https://github.com/civicrm/civicrm-core/pull/22277))**

  Avoids flooding logs with `open_basedir` in effect.

- **Filter summary no longer appearing on results for Reports
  ([dev/core#3153](https://lab.civicrm.org/dev/core/-/issues/3153):
  [23086](https://github.com/civicrm/civicrm-core/pull/23086))**

- **Switch extension downloader and extensions feed to use Guzzle HTTP library
  ([21097](https://github.com/civicrm/civicrm-core/pull/21097))**

  This fixes some situations (eg. shared servers with open_basedir restrictions
  in effect) where zip file was not downloaded properly and extension could not
  be updated. It also means that we are no longer using our custom
  CRM_Utils_HttpClient::fetch() function from within civicrm core.

- **RC Error: Call to undefined method
  CRM_Contact_Page_View_Summary::addExpectedSmartyVariables()
  ([dev/core#3104](https://lab.civicrm.org/dev/core/-/issues/3104):
  [22897](https://github.com/civicrm/civicrm-core/pull/22897))**

- **Post-upgrade messages no longer being displayed
  ([dev/core#3119](https://lab.civicrm.org/dev/core/-/issues/3119):
  [22985](https://github.com/civicrm/civicrm-core/pull/22985))**

- **CiviReport - Title and Statistics appearing at top and bottom of reports
  ([dev/core#3126](https://lab.civicrm.org/dev/core/-/issues/3126):
  [22976](https://github.com/civicrm/civicrm-core/pull/22976))**

- **APIv4 - Fix setting/getting a multi-record customfield with date+time
  ([22731](https://github.com/civicrm/civicrm-core/pull/22731))**

- **APIv4 - Fix typo in Entity.getFields
  ([22776](https://github.com/civicrm/civicrm-core/pull/22776))**

- **Fix apiv4 Contribution delete & all line items
  ([22749](https://github.com/civicrm/civicrm-core/pull/22749))**

- **Fix API4 Explorer undefined variable error
  ([22849](https://github.com/civicrm/civicrm-core/pull/22849))**

- **Afform - Fix saving and editing entity blocks
  ([22963](https://github.com/civicrm/civicrm-core/pull/22963),
  [22986](https://github.com/civicrm/civicrm-core/pull/22986), and
  [23104](https://github.com/civicrm/civicrm-core/pull/23104))**

- **Afform Gui - Fix selecting html element of text box
  ([22929](https://github.com/civicrm/civicrm-core/pull/22929))**

- **Afform - fix missing submit actions
  ([23024](https://github.com/civicrm/civicrm-core/pull/23024))**

- **SearchKit - Fix support for non-DAO entities
  ([22764](https://github.com/civicrm/civicrm-core/pull/22764))**

- **Fix deleting afforms when deleting saved search
  ([22997](https://github.com/civicrm/civicrm-core/pull/22997))**

  A typo in the code was preventing afforms from being deleted with a
  corresponding saved search, and may have led to afforms being deleted
  incorrectly.

- **SearchKit - Fix multi-valued afform filters
  ([23012](https://github.com/civicrm/civicrm-core/pull/23012))**

  Fixes a SearchKit regression causing multi-select afform filters to stop
  working.

- **Search Kit: Unable to Aggregate on a Custom Field
  ([dev/core#3143](https://lab.civicrm.org/dev/core/-/issues/3143):
  [23070](https://github.com/civicrm/civicrm-core/pull/23070))**

- **Only acl line items based on contribution
  ([22870](https://github.com/civicrm/civicrm-core/pull/22870))**

  Ensures ACL query on line items only joins `entity_id` to contributions.

- **Add handling for civimember disabled
  ([22864](https://github.com/civicrm/civicrm-core/pull/22864))**

- **Revert membership debug handling in IPN
  ([22475](https://github.com/civicrm/civicrm-core/pull/22475))**

- **Format money in custom fields once, on the tpl layer
  ([22728](https://github.com/civicrm/civicrm-core/pull/22728))**

- **New Individual: Unfilled fields "Custom Email Greeting", "Custom Postal
  Greeting", "Custom Addressee" are hidden
  ([dev/core#483](https://lab.civicrm.org/dev/core/-/issues/483):
  [22380](https://github.com/civicrm/civicrm-core/pull/22380))**

- **Fix regression with flexible merging of contact information
  ([22720](https://github.com/civicrm/civicrm-core/pull/22720))**

- **Recent update to {receipt_text} token gives warning in system check after
  upgrade ([22821](https://github.com/civicrm/civicrm-core/pull/22821))**

- **Remove "Search Builder" from menubar on new installs.
  ([22778](https://github.com/civicrm/civicrm-core/pull/22778))**

- **Pseudoconstants - Fix and improve handling of option callbacks
  ([22730](https://github.com/civicrm/civicrm-core/pull/22730))**

- **Refresh entity list after updating custom group (self_hook_*)
  ([22868](https://github.com/civicrm/civicrm-core/pull/22868))**

- **Avoid null column showing on groups search page
  ([22724](https://github.com/civicrm/civicrm-core/pull/22724))**

- **Call to undefined function civicrm_api3_create_error() in
  civicrm/civicrm/CRM/Core/Page/AJAX/Attachment.php:65
  ([22872](https://github.com/civicrm/civicrm-core/pull/22872))**

- **Fix backward-compatability for new method in CRM_Contact_BAO_Query_Hook
  ([22933](https://github.com/civicrm/civicrm-core/pull/22933))**

- **Fix submit handling of thousands when creating data entry batch
  ([22772](https://github.com/civicrm/civicrm-core/pull/22772))**

- **Avoid PHP undefined index notices on extension pages
  ([22848](https://github.com/civicrm/civicrm-core/pull/22848))**

- **Fix issues with PHP GetText and 0 length files
  ([22842](https://github.com/civicrm/civicrm-core/pull/22842))**

- **Remove reference to undefined variable in
  CRM_Contact_Form_Inline_CommunicationPreferences
  ([22840](https://github.com/civicrm/civicrm-core/pull/22840))**

- **Mark methods which are only used statically as static
  ([22844](https://github.com/civicrm/civicrm-core/pull/22844))**

- **Use valid syntax for self-closing br elements
  ([22711](https://github.com/civicrm/civicrm-core/pull/22711))**

- **civicrm_handler_filter_pseudo_constant - Guard against old or inactive
  pseudoconstants ([656](https://github.com/civicrm/civicrm-drupal/pull/656))**

- **Contact token should show contact's info instead of logged in contact
  ([22874](https://github.com/civicrm/civicrm-core/pull/22874))**

- **Fixes fatal error - function doesn't exist
  ([275](https://github.com/civicrm/civicrm-wordpress/pull/275))**

- **Notice fixes ([22706](https://github.com/civicrm/civicrm-core/pull/22706))**

- **Some more notice fixes in smarty
  ([22745](https://github.com/civicrm/civicrm-core/pull/22745))**

- **Enotice fixes
  ([22719](https://github.com/civicrm/civicrm-core/pull/22719))**

- **Enotice fix ([22707](https://github.com/civicrm/civicrm-core/pull/22707))**

- **Mark AJAX methods as static
  ([22895](https://github.com/civicrm/civicrm-core/pull/22895))**

- **Avoid e-notices on pages with tabs
  ([22892](https://github.com/civicrm/civicrm-core/pull/22892))**

- **Flush the metadata cache when the domain is edited
  ([22637](https://github.com/civicrm/civicrm-core/pull/22637))**

- **Remove broken call to function_exists in CRM_Utils_String::isUtf8
  ([22803](https://github.com/civicrm/civicrm-core/pull/22803))**

- **Avoid PHP notices on the UF settings page.
  ([22667](https://github.com/civicrm/civicrm-core/pull/22667))**

- **Fix deprecated warnings, smary grumpy-mode issues in legacy searches
  ([22742](https://github.com/civicrm/civicrm-core/pull/22742))**

- **Return array for setdefaults
  ([22948](https://github.com/civicrm/civicrm-core/pull/22948))**

### CiviCase

- **CiviCase - Call hooks when creating relationships
  ([22814](https://github.com/civicrm/civicrm-core/pull/22814))**

  Ensures hooks are called when creating case relationships.

### CiviContribute

- **Bypass grumpy mode for contribution search totals & criteria
  ([22744](https://github.com/civicrm/civicrm-core/pull/22744))**

- **Clean return values for dummy payment processor
  ([22679](https://github.com/civicrm/civicrm-core/pull/22679))**

- **Adjust css class for payment processor to use `-`
  ([22763](https://github.com/civicrm/civicrm-core/pull/22763))**

- **Fix pledge default on contribution page when the site has a WR for
  "contribution" ([22801](https://github.com/civicrm/civicrm-core/pull/22801))**

- **Format money on transaction list
  ([22438](https://github.com/civicrm/civicrm-core/pull/22438))**

- **Deprecate civicrm_contribution_recur.trxn_id
  ([21539](https://github.com/civicrm/civicrm-core/pull/21539))**

- **php notices on contributionview
  ([22866](https://github.com/civicrm/civicrm-core/pull/22866))**

- **php/smarty notices on contribution view part 2
  ([22869](https://github.com/civicrm/civicrm-core/pull/22869))**

- **smarty/php notices on contribution view part 4
  ([22894](https://github.com/civicrm/civicrm-core/pull/22894))**

- **Cleanup on contribution view
  ([22698](https://github.com/civicrm/civicrm-core/pull/22698))**

- **Contribution view page crashes if you don't have event permissions
  ([dev/core#3094](https://lab.civicrm.org/dev/core/-/issues/3094):
  [22865](https://github.com/civicrm/civicrm-core/pull/22865))**

### CiviEvent

- **Don't perform event timezone check if CiviEvent is disabled
  ([22898](https://github.com/civicrm/civicrm-core/pull/22898))**

## CiviGrant

- **CiviGrant - Don't auto-create any grant types
  ([22913](https://github.com/civicrm/civicrm-core/pull/22913))**

- **Grant checkbox in display prefs does nothing anymore
  ([dev/core#3159](https://lab.civicrm.org/dev/core/-/issues/3159):
  [23105](https://github.com/civicrm/civicrm-core/pull/23105))**

- **Views - CiviGrant is now an extension
  ([654](https://github.com/civicrm/civicrm-drupal/pull/654))**

  Updates the Drupal Views integration to recognize that CiviGrant is now an
  extension.

### CiviMail

- **Move check for mailing workflow permisisons to BAO layer
  ([22766](https://github.com/civicrm/civicrm-core/pull/22766))**

- **BAO_Mailing::create - stop passing by reference
  ([22753](https://github.com/civicrm/civicrm-core/pull/22753))**

- **add checkPerm
  ([22818](https://github.com/civicrm/civicrm-core/pull/22818))**

  Adds checkPerm to crmMailingSimpleDirective, enables ability of permission
  checking in composer mail.

- **A/B testing report should show unique opens, not total opens
  ([dev/core#2100](https://lab.civicrm.org/dev/core/-/issues/2100):
  [20093](https://github.com/civicrm/civicrm-core/pull/20093))**

- **Mailing Report: do not recalculate the recipients when the count is zero
  ([22800](https://github.com/civicrm/civicrm-core/pull/22800))**

- **5.44+ Unsubscribe from Smart Group form generates excessive process load
  ([dev/core#3031](https://lab.civicrm.org/dev/core/-/issues/3031):
  [23051](https://github.com/civicrm/civicrm-core/pull/23051))**

  This splits the select query in two when checking if a contact was subscribed
  to one or more groups.

### CiviMember

- **New Membership fails when price set present but not selected
  ([dev/core#3134](https://lab.civicrm.org/dev/core/-/issues/3134):
  [23027](https://github.com/civicrm/civicrm-core/pull/23027))**

- **Fixes for smarty grumpy mode with membership
  ([22752](https://github.com/civicrm/civicrm-core/pull/22752))**

- **Cleanup on Offline Membership Receipts (ensures variables present across
  flows) ([22736](https://github.com/civicrm/civicrm-core/pull/22736))**

## <a name="misc"></a>Miscellany

- **Move acl check for contributionView to the extension
  ([22684](https://github.com/civicrm/civicrm-core/pull/22684))**

- **Move financial acls for membership to extension
  ([22677](https://github.com/civicrm/civicrm-core/pull/22677))**

- **APIv4 - remove unnecessary field from System::check
  ([22748](https://github.com/civicrm/civicrm-core/pull/22748))**

- **APIv4 - Add fixme about filtering custom fields by sub-type
  ([22827](https://github.com/civicrm/civicrm-core/pull/22827))**

- **Cleanup around taxTerm assignment
  ([22422](https://github.com/civicrm/civicrm-core/pull/22422))**

- **RecurForms test fixes
  ([22784](https://github.com/civicrm/civicrm-core/pull/22784))**

- **Update unit test to use exception
  ([22787](https://github.com/civicrm/civicrm-core/pull/22787))**

- **Added Cancel Recur Subscription test & setter for `supports` on Dummy
  processor ([21895](https://github.com/civicrm/civicrm-core/pull/21895))**

- **Move HookInterface to \Civi\Core namespace
  ([22834](https://github.com/civicrm/civicrm-core/pull/22834))**

- **Cody tidy in CRM_Core_State
  ([22841](https://github.com/civicrm/civicrm-core/pull/22841))**

- **Remove reference to undefined variable
  ([22839](https://github.com/civicrm/civicrm-core/pull/22839))**

- **added as a contributor
  ([22876](https://github.com/civicrm/civicrm-core/pull/22876))**

- **Remove unused parameter, pass-by-ref
  ([22756](https://github.com/civicrm/civicrm-core/pull/22756))**

- **Bump karma from 6.3.14 to 6.3.16
  ([22875](https://github.com/civicrm/civicrm-core/pull/22875))**

- **Bump karma from 6.3.4 to 6.3.14
  ([22758](https://github.com/civicrm/civicrm-core/pull/22758))**

- **Bump ajv from 6.6.1 to 6.12.6
  ([22761](https://github.com/civicrm/civicrm-core/pull/22761))**

- **Remove unit tests based on older framework
  ([71](https://github.com/civicrm/civicrm-drupal-8/pull/71))**

- **REF - Use function to get component name from permission
  ([22688](https://github.com/civicrm/civicrm-core/pull/22688))**

- **[REF] Simplify Location::getValues
  ([22757](https://github.com/civicrm/civicrm-core/pull/22757))**

- **[REF] Fix issue where spaces in payment_processor_type.name field cau…
  ([22760](https://github.com/civicrm/civicrm-core/pull/22760))**

- **[REF] Cleanup billingBlock.js
  ([22713](https://github.com/civicrm/civicrm-core/pull/22713))**

- **[REF] Results of running npm audit fix
  ([22773](https://github.com/civicrm/civicrm-core/pull/22773))**

- **[REF] - Deprecate & delegate BAO::retrieve functions
  ([22543](https://github.com/civicrm/civicrm-core/pull/22543))**

- **REF Deprecate API3 _ipn_process_transaction()
  ([22488](https://github.com/civicrm/civicrm-core/pull/22488))**

- **(REF) CRM_Queue_Queue_* - Retain a copy of `$queueSpec`
  ([22797](https://github.com/civicrm/civicrm-core/pull/22797))**

- **(REF) CRM_Queue_Task - Tighter signature
  ([22794](https://github.com/civicrm/civicrm-core/pull/22794))**

- **[REF] Remove old require_once statements made obsolete by autoloader
  ([22792](https://github.com/civicrm/civicrm-core/pull/22792))**

- **[REF] Simplification in Contact::getValues
  ([22765](https://github.com/civicrm/civicrm-core/pull/22765))**

- **[REF] Fix css code style issues
  ([22807](https://github.com/civicrm/civicrm-core/pull/22807))**

- **[REF] Remove unused api v2 function
  ([22819](https://github.com/civicrm/civicrm-core/pull/22819))**

- **[REF] Update Guzzlehttp/psr7 version to be 1.8.5
  ([22998](https://github.com/civicrm/civicrm-core/pull/22998))**

- **[REF] Rename SoftDeleteEntity -> SoftDeleteActionTrait
  ([22944](https://github.com/civicrm/civicrm-core/pull/22944))**

- **[REF] APIv4 - use entityTypes event to load custom records
  ([22824](https://github.com/civicrm/civicrm-core/pull/22824))**

- **[REF] Cleanup docblocks & unused vars in Membership BAO
  ([22665](https://github.com/civicrm/civicrm-core/pull/22665))**

- **(NFC) tests/phpunit/CRM/Queue - Add common `@group`
  ([22795](https://github.com/civicrm/civicrm-core/pull/22795))**

- **[NFC] Rename RecurForms test class
  ([22820](https://github.com/civicrm/civicrm-core/pull/22820))**

- **[NFC] Batch entry - Avoid warnings when performing math on empty string.
  ([22715](https://github.com/civicrm/civicrm-core/pull/22715))**

- **(NFC) contributor-key.yml - Fix syntax error
  ([22921](https://github.com/civicrm/civicrm-core/pull/22921))**

- **(NFC) LoggingDetailTest - Improve reliability of test
  ([22867](https://github.com/civicrm/civicrm-core/pull/22867))**

- **(NFC) Membership Tests - Update assertions to match behavior circa leap-day
  ([22860](https://github.com/civicrm/civicrm-core/pull/22860))**

- **[NFC] Basic case create test with org
  ([22846](https://github.com/civicrm/civicrm-core/pull/22846))**

## <a name="credits"></a>Credits

This release was developed by the following code authors:

AGH Strategies - Alice Frumin, Andie Hunt; BrightMinded Ltd - Bradley
Taylor;Christian Wach; Circle Interactive - Pradeep Nayak; CiviCRM - Coleman
Watts, Tim Otten; Coop SymbioTIC - Mathieu Lutfy; Dave D; Fuzion - Luke Stewart;
Grype Digital Inc. - Md Rashedul Islam; JMA Consulting - Monish Deb, Seamus Lee;
John Kingsnorth; Kartik Kathuria; Megaphone Technology Consulting - Jon
Goldberg; MJW Consulting - Matthew Wire; Registered Nurses' Association of
Ontario - Ian Wilson; Tadpole Collective - Kevin Cristiano; Wikimedia
Foundation - Eileen McNaughton; Wildsight - Lars Sanders-Green

Most authors also reviewed code for this release; in addition, the following
reviewers contributed their comments:

Agileware - Justin Freeman; Artful Robot - Rich Lott; Blackfly Solutions - Alan
Dixon; Bluehorn Digital - Matt Glaman; CiviCoop - Jaap Jansma; CiviDesk -
Yashodha Chaku; Progressive Technology Project - Jamie McClelland; Semper IT -
Karin Gerritsen; Skvare - Mark Hanna

## <a name="feedback"></a>Feedback

These release notes are edited by Alice Frumin and Andie Hunt.  If you'd like
to provide feedback on them, please log in to https://chat.civicrm.org/civicrm
and contact `@agh1`.
