/*
 * Copyright (C) 2024 Uniontech Technology Co., Ltd.
 *
 * Author:     liuzheng <liuzheng@uniontech.com>
 *
 * Maintainer: liuzheng <liuzheng@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef CLIPDATAPROPERTY_H
#define CLIPDATAPROPERTY_H

#include <vector>
#include <string>
#include <map>
#include <iostream>
#include <fstream>

using namespace std;
class ClipDataProperty
{
public:
    explicit ClipDataProperty();

    bool hasMimeType(string mimeType);

    map<string, string> &getMimeTypes();
    void setMimeTypes(const map<string, string> &mimetypes);

    long long getTimestamp();
    void setTimestamp(const long long &datatime);

    string getTag();
    void setTag(const string &tag);

    char getOwnerPlatform();
    void setOwnerPlatform(const char &type);

    int getPID();
    void setPID(const int &pid);

    void save(ofstream &file);
    void load(ifstream &file);

    int getLength();

private:
    int m_pid;                       // 进程id
    map<string, string> m_mimetypes; // 数据类型
    long long m_wirteTime;           // 写入时间
    char m_datasource;                // 数据来源  0 x11 1 wayland
    string m_tag;                    // 自定义tag标签属性
};

#endif // CLIPDATAPROPERTY_H
