/*
 * Copyright (C) 2024 Uniontech Technology Co., Ltd.
 *
 * Author:     liuzheng <liuzheng@uniontech.com>
 *
 * Maintainer: liuzheng <liuzheng@uniontech.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "clipdataproperty.h"

ClipDataProperty::ClipDataProperty()
{
    m_pid = 100000000;   // 进程id
    m_mimetypes.clear(); // 数据类型
    m_datasource = 2;    // 数据来源  0 x11 1 wayland
    m_tag = string();    // 自定义tag标签属性
}

bool ClipDataProperty::hasMimeType(string mimeType)
{
    auto it = m_mimetypes.find(mimeType);

    if (it != m_mimetypes.end()) {
        return true;
    }
    return false;
}

map<string, string> &ClipDataProperty::getMimeTypes()
{
    return m_mimetypes;
}

void ClipDataProperty::setMimeTypes(const map<string, string> &mimetypes)
{
    m_mimetypes = mimetypes;
}

long long ClipDataProperty::getTimestamp()
{
    return m_wirteTime;
}

void ClipDataProperty::setTimestamp(const long long &datatime)
{
    m_wirteTime = datatime;
}

string ClipDataProperty::getTag()
{
    return m_tag;
}

void ClipDataProperty::setTag(const string &tag)
{
    m_tag = tag;
}

char ClipDataProperty::getOwnerPlatform()
{
    return m_datasource;
}

void ClipDataProperty::setOwnerPlatform(const char &type)
{
    m_datasource = type;
}

int ClipDataProperty::getPID()
{
    return m_pid;
}

void ClipDataProperty::setPID(const int &pid)
{
    m_pid = pid;
}
void ClipDataProperty::save(ofstream &file)
{
    // 写入进程id
    file.write((char *)&m_pid, sizeof(int));

    // 写入数据类型的数量
    int count = m_mimetypes.size();
    file.write((char *)&count, sizeof(int));

    // 遍历每个数据类型，并将其键值对写入文件
    for (auto it = m_mimetypes.begin(); it != m_mimetypes.end(); it++) {
        // 写入键的长度和内容
        int len = it->first.size();
        file.write((char *)&len, sizeof(int));
        file.write(it->first.c_str(), len);

        // 写入值的长度和内容
        len = it->second.size();
        file.write((char *)&len, sizeof(int));
        file.write(it->second.c_str(), len);
    }

    // 写入写入时间
    file.write((char *)&m_wirteTime, sizeof(long long));

    // 写入数据来源
    file.write((char *)&m_datasource, sizeof(int));

    // 写入自定义tag标签属性的长度和内容
    int len = m_tag.size();
    file.write((char *)&len, sizeof(int));
    file.write(m_tag.c_str(), len);
}

void ClipDataProperty::load(ifstream &file)
{
    // 读取进程id
    file.read((char *)&m_pid, sizeof(int));

    // 读取数据类型的数量
    int count = 0;
    file.read((char *)&count, sizeof(int));

    // 遍历每个数据类型，并将其键值对从文件中读取
    for (int i = 0; i < count; i++) {
        // 读取键的长度和内容
        int len = 0;
        file.read((char *)&len, sizeof(int));
        char *key = new char[len + 1];
        file.read(key, len);
        key[len] = '\0';

        // 读取值的长度和内容
        file.read((char *)&len, sizeof(int));
        char *value = new char[len + 1];
        file.read(value, len);
        value[len] = '\0';

        // 将键值对插入数据类型的map中
        m_mimetypes.insert(make_pair(string(key), string(value)));

        // 释放内存
        delete[] key;
        delete[] value;
    }

    // 读取写入时间
    file.read((char *)&m_wirteTime, sizeof(long long));

    // 读取数据来源
    file.read((char *)&m_datasource, sizeof(int));

    // 读取自定义tag标签属性的长度和内容
    int len = 0;
    file.read((char *)&len, sizeof(int));
    char *tag = new char[len + 1];
    file.read(tag, len);
    tag[len] = '\0';

    // 设置自定义tag标签属性
    m_tag = string(tag);

    // 释放内存
    delete[] tag;
}

int ClipDataProperty::getLength()
{
    // 计算需要的内存空间
    int size = sizeof(int) * 4 + sizeof(long long) + sizeof(char); // 基本数据类型和字符串的空间

    // 遍历每个数据类型，并将其键值对写入文件
    for (auto it = m_mimetypes.begin(); it != m_mimetypes.end(); it++) {
        size += it->first.size() + it->second.size() + sizeof(int) * 2;
    }

    size += m_tag.size();
    return size;
}
