/*
 * Copyright (C) 2016 FAUmachine Team <info@faumachine.org>.
 *
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "lib/tree.h"

#include <assert.h>
#include <stdlib.h>

/* LIST */
static void lst_init(lst *list)
{
	list->first = NULL;
	list->last = NULL;
	list->num = 0;
}

static int lst_push(lst *list, void *data_node)
{
	lst_node *node = (lst_node *)data_node;
	node->preceder = list->last;
	node->succeder = NULL;
	if(list->last) {
		list->last->succeder = node;
	} else {
		list->first = node;
	}
	list->num++;
	list->last=node;
	return list->num;
}

static lst_dnode *lst_new_dnode(lst *list, void *data)
{
	lst_dnode *dnode;

	dnode = (lst_dnode *)malloc(sizeof(lst_dnode));
	dnode->data=data;
	if(list) {
		lst_push(list, dnode);
	}
	return dnode;
}

/* LIST */

struct tree_node_t {
	tree_node *parent;
	lst children;

	void *data;
};

void tree_init(tree_node *node)
{
	node->parent = NULL;
	node->data = NULL;
	lst_init(&node->children);
}

tree_node *tree_new(void)
{
	tree_node *ret;
	ret = (tree_node *)malloc(sizeof(tree_node));
	if (ret == NULL) {
		return NULL;
	}
	tree_init(ret);
	return ret;
}
void tree_free(tree_node *node) {
	free(node);
}

void* tree_get_data(tree_node *node)
{
	if (node == NULL) {
		return NULL;
	}
	return node->data;
}

void tree_set_data(tree_node *node, void *data)
{
	assert(node != NULL);
	node->data = data;
}

tree_node* tree_get_parent(tree_node *node)
{
	if (node == NULL) {
		return NULL;
	}
	return node->parent;
}
lst* tree_get_children(tree_node *node)
{
	if (node == NULL) {
		return NULL;
	}
	return &node->children;
}

tree_node* tree_new_child(tree_node *parent, void *data)
{
	tree_node *child;

	child = tree_new();
	if (child == NULL) {
		return NULL;
	}

	child->parent = parent;
	child->data = data;

	lst_new_dnode(&parent->children, child);

	return child;
}

int tree_visit_preorder(tree_node *root, tree_node_callback cb, void *opaque)
{
	int abort;
	lst_dnode *child_iter;

	if (root == NULL || cb == NULL)  {
		return -1;
	}

	abort = cb(root, opaque);
	if (abort == 1) {
		return 1;
	}

	lst_Foreach(&root->children, child_iter) {
		abort = tree_visit_preorder((tree_node *)child_iter->data, cb, opaque);
		if (abort == 1) {
			return 1;
		}
	}
	return 0;
}

int tree_visit_postorder(tree_node *root, tree_node_callback cb, void *opaque)
{
	int abort;
	lst_dnode *child_iter;

	if (root == NULL || cb == NULL)  {
		return -1;
	}

	lst_Foreach(&root->children, child_iter) {
		abort = tree_visit_postorder((tree_node *)child_iter->data, cb, opaque);
		if (abort == 1) {
			return 1;
		}
	}

	abort = cb(root, opaque);
	if (abort == 1) {
		return 1;
	}

	return 0;

}

int tree_visit_children(tree_node *parent, tree_node_callback cb, void *opaque)
{
	int abort;
	lst_dnode *child_iter;

	if (parent == NULL || cb == NULL)  {
		return -1;
	}

	lst_Foreach(&parent->children, child_iter) {
		abort = cb((tree_node *)child_iter->data, opaque);
		if (abort == 1) {
			return 1;
		}
	}

	return 0;

}
