/* amd64-win64.pep.h
   created from amd64-win64.pep.bin, 21047 (0x5237) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2020 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2020 Laszlo Molnar
   Copyright (C) 2000-2020 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */


#define STUB_AMD64_WIN64_PEP_SIZE    21047
#define STUB_AMD64_WIN64_PEP_ADLER32 0xf6019eac
#define STUB_AMD64_WIN64_PEP_CRC32   0x49c903ee

unsigned char stub_amd64_win64_pep[21047] = {
/* 0x0000 */ 127, 69, 76, 70,  2,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0, 62,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */   0,  0,  0,  0,  0,  0,  0,  0,168, 27,  0,  0,  0,  0,  0,  0,
/* 0x0030 */   0,  0,  0,  0, 64,  0,  0,  0,  0,  0, 64,  0,  0,  0,  0,  0,
/* 0x0040 */  72,137, 76, 36,  8, 72,137, 84, 36, 16, 76,137, 68, 36, 24,128,
/* 0x0050 */ 250,  1, 15,133,  0,  0,  0,  0, 83, 86, 87, 85, 72,141, 53,  0,
/* 0x0060 */   0,  0,  0, 72,141,190,  0,  0,  0,  0,102,255,135,  0,  0,  0,
/* 0x0070 */   0,102,129,135,  0,  0,  0,  0,  0,128, 72,141,135,  0,  0,  0,
/* 0x0080 */   0,255, 48,199,  0,  0,  0,  0,128, 80, 87, 49,219, 49,201, 72,
/* 0x0090 */ 131,205,255,232, 80,  0,  0,  0,  1,219,116,  2,243,195,139, 30,
/* 0x00a0 */  72,131,238,252, 17,219,138, 22,243,195, 72,141,  4, 47,131,249,
/* 0x00b0 */   5,138, 16,118, 33, 72,131,253,252,119, 27,131,233,  4,139, 16,
/* 0x00c0 */  72,131,192,  4,131,233,  4,137, 23, 72,141,127,  4,115,239,131,
/* 0x00d0 */ 193,  4,138, 16,116, 16, 72,255,192,136, 23,131,233,  1,138, 16,
/* 0x00e0 */  72,141,127,  1,117,240,243,195,252, 65, 91,235,  8, 72,255,198,
/* 0x00f0 */ 136, 23, 72,255,199,138, 22,  1,219,117, 10,139, 30, 72,131,238,
/* 0x0100 */ 252, 17,219,138, 22,114,230,141, 65,  1, 65,255,211, 17,192,  1,
/* 0x0110 */ 219,117, 10,139, 30, 72,131,238,252, 17,219,138, 22,115,235,131,
/* 0x0120 */ 232,  3,114, 19,193,224,  8, 15,182,210,  9,208, 72,255,198,131,
/* 0x0130 */ 240,255,116, 58, 72, 99,232,141, 65,  1, 65,255,211, 17,201, 65,
/* 0x0140 */ 255,211, 17,201,117, 24,137,193,131,192,  2, 65,255,211, 17,201,
/* 0x0150 */   1,219,117,  8,139, 30, 72,131,238,252, 17,219,115,237, 72,129,
/* 0x0160 */ 253,  0,243,255,255, 17,193,232,  0,  0,  0,  0,235,135,235,  8,
/* 0x0170 */  72,255,198,136, 23, 72,255,199,138, 22,  1,219,117, 10,139, 30,
/* 0x0180 */  72,131,238,252, 17,219,138, 22,114,230,141, 65,  1,235,  7,255,
/* 0x0190 */ 200, 65,255,211, 17,192, 65,255,211, 17,192,  1,219,117, 10,139,
/* 0x01a0 */  30, 72,131,238,252, 17,219,138, 22,115,228,131,232,  3,114, 23,
/* 0x01b0 */ 193,224,  8, 15,182,210,  9,208, 72,255,198,131,240,255,116, 63,
/* 0x01c0 */ 209,248, 72, 99,232,235,  3, 65,255,211, 17,201, 65,255,211, 17,
/* 0x01d0 */ 201,117, 24,255,193, 65,255,211, 17,201,  1,219,117,  8,139, 30,
/* 0x01e0 */  72,131,238,252, 17,219,115,237,131,193,  2, 72,129,253,  0,251,
/* 0x01f0 */ 255,255,131,209,  1,232,  0,  0,  0,  0,233,121,255,255,255,235,
/* 0x0200 */   8, 72,255,198,136, 23, 72,255,199,138, 22,  1,219,117, 10,139,
/* 0x0210 */  30, 72,131,238,252, 17,219,138, 22,114,230,141, 65,  1,235,  7,
/* 0x0220 */ 255,200, 65,255,211, 17,192, 65,255,211, 17,192,  1,219,117, 10,
/* 0x0230 */ 139, 30, 72,131,238,252, 17,219,138, 22,115,228,131,232,  3,114,
/* 0x0240 */  25,193,224,  8, 15,182,210,  9,208, 72,255,198,131,240,255,116,
/* 0x0250 */  88,209,248, 72, 99,232,114, 56,235, 14,  1,219,117,  8,139, 30,
/* 0x0260 */  72,131,238,252, 17,219,114, 40,255,193,  1,219,117,  8,139, 30,
/* 0x0270 */  72,131,238,252, 17,219,114, 24, 65,255,211, 17,201,  1,219,117,
/* 0x0280 */   8,139, 30, 72,131,238,252, 17,219,115,237,131,193,  2,235,  5,
/* 0x0290 */  65,255,211, 17,201, 72,129,253,  0,251,255,255,131,209,  2,232,
/* 0x02a0 */   0,  0,  0,  0,233, 96,255,255,255,184,  0,  0,  0,128, 80, 72,
/* 0x02b0 */ 137,225, 72,137,250, 72,137,247,190,  0,  0,  0,128, 85, 72,137,
/* 0x02c0 */ 229, 68,139,  9, 73,137,208, 72,137,242, 72,141,119,  2, 86,138,
/* 0x02d0 */   7,255,202,136,193, 36,  7,192,233,  3, 72,199,195,  0,253,255,
/* 0x02e0 */ 255, 72,211,227,136,193, 72,141,156, 92,136,241,255,255, 72,131,
/* 0x02f0 */ 227,192,106,  0, 72, 57,220,117,249, 83, 72,141,123,  8,138, 78,
/* 0x0300 */ 255,255,202,136, 71,  2,136,200,192,233,  4,136, 79,  1, 36, 15,
/* 0x0310 */ 136,  7, 72,141, 79,252, 80, 65, 87, 72,141, 71,  4, 69, 49,255,
/* 0x0320 */  65, 86, 65,190,  1,  0,  0,  0, 65, 85, 69, 49,237, 65, 84, 85,
/* 0x0330 */  83, 72,137, 76, 36,240, 72,137, 68, 36,216,184,  1,  0,  0,  0,
/* 0x0340 */  72,137,116, 36,248, 76,137, 68, 36,232,137,195, 68,137, 76, 36,
/* 0x0350 */ 228, 15,182, 79,  2,211,227,137,217, 72,139, 92, 36, 56,255,201,
/* 0x0360 */ 137, 76, 36,212, 15,182, 79,  1,211,224, 72,139, 76, 36,240,255,
/* 0x0370 */ 200,137, 68, 36,208, 15,182,  7,199,  1,  0,  0,  0,  0,199, 68,
/* 0x0380 */  36,200,  0,  0,  0,  0,199, 68, 36,196,  1,  0,  0,  0,199, 68,
/* 0x0390 */  36,192,  1,  0,  0,  0,199, 68, 36,188,  1,  0,  0,  0,199,  3,
/* 0x03a0 */   0,  0,  0,  0,137, 68, 36,204, 15,182, 79,  1,  1,193,184,  0,
/* 0x03b0 */   3,  0,  0,211,224, 49,201,141,184, 54,  7,  0,  0, 65, 57,255,
/* 0x03c0 */ 115, 19, 72,139, 92, 36,216,137,200,255,193, 57,249,102,199,  4,
/* 0x03d0 */  67,  0,  4,235,235, 72,139,124, 36,248,137,208, 69, 49,210, 65,
/* 0x03e0 */ 131,203,255, 49,210, 73,137,252, 73,  1,196, 76, 57,231, 15,132,
/* 0x03f0 */ 239,  8,  0,  0, 15,182,  7, 65,193,226,  8,255,194, 72,255,199,
/* 0x0400 */  65,  9,194,131,250,  4,126,227, 68, 59,124, 36,228, 15,131,218,
/* 0x0410 */   8,  0,  0,139, 68, 36,212, 72, 99, 92, 36,200, 72,139, 84, 36,
/* 0x0420 */ 216, 68, 33,248,137, 68, 36,184, 72, 99,108, 36,184, 72,137,216,
/* 0x0430 */  72,193,224,  4, 72,  1,232, 65,129,251,255,255,255,  0, 76,141,
/* 0x0440 */  12, 66,119, 26, 76, 57,231, 15,132,150,  8,  0,  0, 15,182,  7,
/* 0x0450 */  65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 65, 15,
/* 0x0460 */ 183, 17, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,
/* 0x0470 */ 194, 15,131,197,  1,  0,  0, 65,137,195,184,  0,  8,  0,  0, 72,
/* 0x0480 */ 139, 92, 36,216, 41,200, 15,182, 76, 36,204,190,  1,  0,  0,  0,
/* 0x0490 */ 193,248,  5,141,  4,  2, 65, 15,182,213,102, 65,137,  1,139, 68,
/* 0x04a0 */  36,208, 68, 33,248,211,224,185,  8,  0,  0,  0, 43, 76, 36,204,
/* 0x04b0 */ 211,250,  1,208,105,192,  0,  3,  0,  0,131,124, 36,200,  6,137,
/* 0x04c0 */ 192, 76,141,140, 67,108, 14,  0,  0, 15,142,184,  0,  0,  0, 72,
/* 0x04d0 */ 139, 84, 36,232, 68,137,248, 68, 41,240, 15,182, 44,  2,  1,237,
/* 0x04e0 */  72, 99,214,137,235,129,227,  0,  1,  0,  0, 65,129,251,255,255,
/* 0x04f0 */ 255,  0, 72, 99,195, 73,141,  4, 65, 76,141,  4, 80,119, 26, 76,
/* 0x0500 */  57,231, 15,132,219,  7,  0,  0, 15,182,  7, 65,193,226,  8, 65,
/* 0x0510 */ 193,227,  8, 72,255,199, 65,  9,194, 65, 15,183,144,  0,  2,  0,
/* 0x0520 */   0, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,
/* 0x0530 */ 115, 32, 65,137,195,184,  0,  8,  0,  0,  1,246, 41,200,193,248,
/* 0x0540 */   5,133,219,141,  4,  2,102, 65,137,128,  0,  2,  0,  0,116, 33,
/* 0x0550 */ 235, 45, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,141,116,
/* 0x0560 */  54,  1,102, 41,194,133,219,102, 65,137,144,  0,  2,  0,  0,116,
/* 0x0570 */  14,129,254,255,  0,  0,  0, 15,142, 97,255,255,255,235,120,129,
/* 0x0580 */ 254,255,  0,  0,  0,127,112, 72, 99,198, 65,129,251,255,255,255,
/* 0x0590 */   0, 77,141,  4, 65,119, 26, 76, 57,231, 15,132, 67,  7,  0,  0,
/* 0x05a0 */  15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,
/* 0x05b0 */ 194, 65, 15,183, 16, 68,137,216,193,232, 11, 15,183,202, 15,175,
/* 0x05c0 */ 193, 65, 57,194,115, 24, 65,137,195,184,  0,  8,  0,  0,  1,246,
/* 0x05d0 */  41,200,193,248,  5,141,  4,  2,102, 65,137,  0,235,161, 65, 41,
/* 0x05e0 */ 195, 65, 41,194,137,208,102,193,232,  5,141,116, 54,  1,102, 41,
/* 0x05f0 */ 194,102, 65,137, 16,235,136, 72,139, 76, 36,232, 68,137,248, 65,
/* 0x0600 */ 255,199, 65,137,245, 64,136, 52,  1,131,124, 36,200,  3,127, 13,
/* 0x0610 */ 199, 68, 36,200,  0,  0,  0,  0,233,166,  6,  0,  0,139, 84, 36,
/* 0x0620 */ 200,139, 68, 36,200,131,234,  3,131,232,  6,131,124, 36,200,  9,
/* 0x0630 */  15, 79,208,137, 84, 36,200,233,135,  6,  0,  0, 65, 41,195, 65,
/* 0x0640 */  41,194,137,208,102,193,232,  5,102, 41,194, 72,139, 68, 36,216,
/* 0x0650 */  65,129,251,255,255,255,  0,102, 65,137, 17, 72,141, 52, 88,119,
/* 0x0660 */  26, 76, 57,231, 15,132,121,  6,  0,  0, 15,182,  7, 65,193,226,
/* 0x0670 */   8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,183,150,128,  1,
/* 0x0680 */   0,  0, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,
/* 0x0690 */ 194,115, 78, 65,137,195,184,  0,  8,  0,  0, 76,139, 76, 36,216,
/* 0x06a0 */  41,200,139, 76, 36,196, 68,137,116, 36,196,193,248,  5,141,  4,
/* 0x06b0 */   2,139, 84, 36,192,137, 76, 36,192,102,137,134,128,  1,  0,  0,
/* 0x06c0 */  49,192,131,124, 36,200,  6,137, 84, 36,188, 15,159,192, 73,129,
/* 0x06d0 */ 193,100,  6,  0,  0,141,  4, 64,137, 68, 36,200,233, 84,  2,  0,
/* 0x06e0 */   0, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,102, 41,194,
/* 0x06f0 */  65,129,251,255,255,255,  0,102,137,150,128,  1,  0,  0,119, 26,
/* 0x0700 */  76, 57,231, 15,132,218,  5,  0,  0, 15,182,  7, 65,193,226,  8,
/* 0x0710 */  65,193,227,  8, 72,255,199, 65,  9,194, 15,183,150,152,  1,  0,
/* 0x0720 */   0, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,
/* 0x0730 */  15,131,208,  0,  0,  0, 65,184,  0,  8,  0,  0, 65,137,195, 72,
/* 0x0740 */ 193,227,  5, 68,137,192, 41,200,193,248,  5,141,  4,  2,102,137,
/* 0x0750 */ 134,152,  1,  0,  0, 72,139, 68, 36,216, 72,  1,216, 65,129,251,
/* 0x0760 */ 255,255,255,  0, 72,141, 52,104,119, 26, 76, 57,231, 15,132,112,
/* 0x0770 */   5,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,
/* 0x0780 */ 199, 65,  9,194, 15,183,150,224,  1,  0,  0, 68,137,216,193,232,
/* 0x0790 */  11, 15,183,202, 15,175,193, 65, 57,194,115, 79, 65, 41,200, 65,
/* 0x07a0 */ 137,195, 65,193,248,  5, 69,133,255, 66,141,  4,  2,102,137,134,
/* 0x07b0 */ 224,  1,  0,  0, 15,132, 41,  5,  0,  0, 49,192,131,124, 36,200,
/* 0x07c0 */   6, 72,139, 92, 36,232, 15,159,192,141, 68,  0,  9,137, 68, 36,
/* 0x07d0 */ 200, 68,137,248, 68, 41,240, 68, 15,182, 44,  3, 68,137,248, 65,
/* 0x07e0 */ 255,199, 68,136, 44,  3,233,216,  4,  0,  0, 65, 41,195, 65, 41,
/* 0x07f0 */ 194,137,208,102,193,232,  5,102, 41,194,102,137,150,224,  1,  0,
/* 0x0800 */   0,233, 17,  1,  0,  0, 65, 41,195, 65, 41,194,137,208,102,193,
/* 0x0810 */ 232,  5,102, 41,194, 65,129,251,255,255,255,  0,102,137,150,152,
/* 0x0820 */   1,  0,  0,119, 26, 76, 57,231, 15,132,181,  4,  0,  0, 15,182,
/* 0x0830 */   7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,
/* 0x0840 */ 183,150,176,  1,  0,  0, 68,137,216,193,232, 11, 15,183,202, 15,
/* 0x0850 */ 175,193, 65, 57,194,115, 32, 65,137,195,184,  0,  8,  0,  0, 41,
/* 0x0860 */ 200,193,248,  5,141,  4,  2,102,137,134,176,  1,  0,  0,139, 68,
/* 0x0870 */  36,196,233,152,  0,  0,  0, 65, 41,195, 65, 41,194,137,208,102,
/* 0x0880 */ 193,232,  5,102, 41,194, 65,129,251,255,255,255,  0,102,137,150,
/* 0x0890 */ 176,  1,  0,  0,119, 26, 76, 57,231, 15,132, 68,  4,  0,  0, 15,
/* 0x08a0 */ 182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194,
/* 0x08b0 */  15,183,150,200,  1,  0,  0, 68,137,216,193,232, 11, 15,183,202,
/* 0x08c0 */  15,175,193, 65, 57,194,115, 29, 65,137,195,184,  0,  8,  0,  0,
/* 0x08d0 */  41,200,193,248,  5,141,  4,  2,102,137,134,200,  1,  0,  0,139,
/* 0x08e0 */  68, 36,192,235, 34, 65, 41,195, 65, 41,194,137,208,102,193,232,
/* 0x08f0 */   5,102, 41,194,139, 68, 36,188,102,137,150,200,  1,  0,  0,139,
/* 0x0900 */  84, 36,192,137, 84, 36,188,139, 76, 36,196,137, 76, 36,192, 68,
/* 0x0910 */ 137,116, 36,196, 65,137,198, 49,192,131,124, 36,200,  6, 76,139,
/* 0x0920 */  76, 36,216, 15,159,192, 73,129,193,104, 10,  0,  0,141, 68, 64,
/* 0x0930 */   8,137, 68, 36,200, 65,129,251,255,255,255,  0,119, 26, 76, 57,
/* 0x0940 */ 231, 15,132,156,  3,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,
/* 0x0950 */ 227,  8, 72,255,199, 65,  9,194, 65, 15,183, 17, 68,137,216,193,
/* 0x0960 */ 232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 39, 65,137,195,
/* 0x0970 */ 184,  0,  8,  0,  0, 69, 49,237, 41,200,193,248,  5,141,  4,  2,
/* 0x0980 */ 102, 65,137,  1, 72, 99, 68, 36,184, 72,193,224,  4, 77,141, 68,
/* 0x0990 */   1,  4,235,120, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,
/* 0x09a0 */ 102, 41,194, 65,129,251,255,255,255,  0,102, 65,137, 17,119, 26,
/* 0x09b0 */  76, 57,231, 15,132, 42,  3,  0,  0, 15,182,  7, 65,193,226,  8,
/* 0x09c0 */  65,193,227,  8, 72,255,199, 65,  9,194, 65, 15,183, 81,  2, 68,
/* 0x09d0 */ 137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 52,
/* 0x09e0 */  65,137,195,184,  0,  8,  0,  0, 65,189,  8,  0,  0,  0, 41,200,
/* 0x09f0 */ 193,248,  5,141,  4,  2,102, 65,137, 65,  2, 72, 99, 68, 36,184,
/* 0x0a00 */  72,193,224,  4, 77,141,132,  1,  4,  1,  0,  0, 65,185,  3,  0,
/* 0x0a10 */   0,  0,235, 39, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,
/* 0x0a20 */  77,141,129,  4,  2,  0,  0, 65,189, 16,  0,  0,  0,102, 41,194,
/* 0x0a30 */ 102, 65,137, 81,  2, 65,185,  8,  0,  0,  0, 68,137,203,189,  1,
/* 0x0a40 */   0,  0,  0, 72, 99,197, 65,129,251,255,255,255,  0, 73,141, 52,
/* 0x0a50 */  64,119, 26, 76, 57,231, 15,132,135,  2,  0,  0, 15,182,  7, 65,
/* 0x0a60 */ 193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,183, 14,
/* 0x0a70 */  68,137,216,193,232, 11, 15,183,209, 15,175,194, 65, 57,194,115,
/* 0x0a80 */  23, 65,137,195,184,  0,  8,  0,  0,  1,237, 41,208,193,248,  5,
/* 0x0a90 */ 141,  4,  1,102,137,  6,235, 22, 65, 41,195, 65, 41,194,137,200,
/* 0x0aa0 */ 102,193,232,  5,141,108, 45,  1,102, 41,193,102,137, 14,255,203,
/* 0x0ab0 */ 117,145,184,  1,  0,  0,  0, 68,137,201,211,224, 41,197, 68,  1,
/* 0x0ac0 */ 237,131,124, 36,200,  3, 15,143,194,  1,  0,  0,131, 68, 36,200,
/* 0x0ad0 */   7,184,  3,  0,  0,  0,131,253,  4, 15, 76,197, 72,139, 92, 36,
/* 0x0ae0 */ 216, 65,184,  1,  0,  0,  0, 72,152, 72,193,224,  7, 76,141,140,
/* 0x0af0 */   3, 96,  3,  0,  0,187,  6,  0,  0,  0, 73, 99,192, 65,129,251,
/* 0x0b00 */ 255,255,255,  0, 73,141, 52, 65,119, 26, 76, 57,231, 15,132,208,
/* 0x0b10 */   1,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,
/* 0x0b20 */ 199, 65,  9,194, 15,183, 22, 68,137,216,193,232, 11, 15,183,202,
/* 0x0b30 */  15,175,193, 65, 57,194,115, 24, 65,137,195,184,  0,  8,  0,  0,
/* 0x0b40 */  69,  1,192, 41,200,193,248,  5,141,  4,  2,102,137,  6,235, 23,
/* 0x0b50 */  65, 41,195, 65, 41,194,137,208,102,193,232,  5, 71,141, 68,  0,
/* 0x0b60 */   1,102, 41,194,102,137, 22,255,203,117,143, 65,131,232, 64, 65,
/* 0x0b70 */ 131,248,  3, 69,137,198, 15,142, 13,  1,  0,  0, 65,131,230,  1,
/* 0x0b80 */  68,137,192,209,248, 65,131,206,  2, 65,131,248, 13,141,112,255,
/* 0x0b90 */ 127, 35,137,241, 72,139, 92, 36,216, 73, 99,192, 65,211,230, 72,
/* 0x0ba0 */   1,192, 68,137,242, 72,141, 20, 83, 72, 41,194, 76,141,138, 94,
/* 0x0bb0 */   5,  0,  0,235, 81,141,112,251, 65,129,251,255,255,255,  0,119,
/* 0x0bc0 */  26, 76, 57,231, 15,132, 25,  1,  0,  0, 15,182,  7, 65,193,226,
/* 0x0bd0 */   8, 65,193,227,  8, 72,255,199, 65,  9,194, 65,209,235, 69,  1,
/* 0x0be0 */ 246, 69, 57,218,114,  7, 69, 41,218, 65,131,206,  1,255,206,117,
/* 0x0bf0 */ 199, 76,139, 76, 36,216, 65,193,230,  4,190,  4,  0,  0,  0, 73,
/* 0x0c00 */ 129,193, 68,  6,  0,  0, 65,189,  1,  0,  0,  0,187,  1,  0,  0,
/* 0x0c10 */   0, 72, 99,195, 65,129,251,255,255,255,  0, 77,141,  4, 65,119,
/* 0x0c20 */  26, 76, 57,231, 15,132,185,  0,  0,  0, 15,182,  7, 65,193,226,
/* 0x0c30 */   8, 65,193,227,  8, 72,255,199, 65,  9,194, 65, 15,183, 16, 68,
/* 0x0c40 */ 137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 24,
/* 0x0c50 */  65,137,195,184,  0,  8,  0,  0,  1,219, 41,200,193,248,  5,141,
/* 0x0c60 */   4,  2,102, 65,137,  0,235, 26, 65, 41,195, 65, 41,194,137,208,
/* 0x0c70 */ 102,193,232,  5,141, 92, 27,  1, 69,  9,238,102, 41,194,102, 65,
/* 0x0c80 */ 137, 16, 69,  1,237,255,206,117,136, 65,255,198,116, 64,131,197,
/* 0x0c90 */   2, 69, 57,254,119, 77, 72,139, 84, 36,232, 68,137,248, 68, 41,
/* 0x0ca0 */ 240, 68, 15,182, 44,  2, 68,137,248, 65,255,199,255,205, 68,136,
/* 0x0cb0 */  44,  2, 15,149,194, 49,192, 68, 59,124, 36,228, 15,146,192,133,
/* 0x0cc0 */ 194,117,211, 68, 59,124, 36,228, 15,130, 69,247,255,255, 65,129,
/* 0x0cd0 */ 251,255,255,255,  0,119, 22, 76, 57,231,184,  1,  0,  0,  0,116,
/* 0x0ce0 */  35,235,  7,184,  1,  0,  0,  0,235, 26, 72,255,199,137,248, 43,
/* 0x0cf0 */  68, 36,248, 72,139, 76, 36,240, 72,139, 92, 36, 56,137,  1, 68,
/* 0x0d00 */ 137, 59, 49,192, 91, 93, 65, 92, 65, 93, 65, 94, 65, 95, 65, 87,
/* 0x0d10 */  72,141, 71,  4, 69, 49,255, 65, 86, 65,190,  1,  0,  0,  0, 65,
/* 0x0d20 */  85, 69, 49,237, 65, 84, 85, 83, 72,137, 76, 36,240, 72,137, 68,
/* 0x0d30 */  36,216,184,  1,  0,  0,  0, 72,137,116, 36,248, 76,137, 68, 36,
/* 0x0d40 */ 232,137,195, 68,137, 76, 36,228, 15,182, 79,  2,211,227,137,217,
/* 0x0d50 */  72,139, 92, 36, 56,255,201,137, 76, 36,212, 15,182, 79,  1,211,
/* 0x0d60 */ 224, 72,139, 76, 36,240,255,200,137, 68, 36,208, 15,182,  7,199,
/* 0x0d70 */   1,  0,  0,  0,  0,199, 68, 36,200,  0,  0,  0,  0,199, 68, 36,
/* 0x0d80 */ 196,  1,  0,  0,  0,199, 68, 36,192,  1,  0,  0,  0,199, 68, 36,
/* 0x0d90 */ 188,  1,  0,  0,  0,199,  3,  0,  0,  0,  0,137, 68, 36,204, 15,
/* 0x0da0 */ 182, 79,  1,  1,193,184,  0,  3,  0,  0,211,224, 49,201,141,184,
/* 0x0db0 */  54,  7,  0,  0, 65, 57,255,115, 19, 72,139, 92, 36,216,137,200,
/* 0x0dc0 */ 255,193, 57,249,102,199,  4, 67,  0,  4,235,235, 72,139,124, 36,
/* 0x0dd0 */ 248,137,208, 69, 49,210, 65,131,203,255, 49,210, 73,137,252, 73,
/* 0x0de0 */   1,196, 76, 57,231, 15,132,239,  8,  0,  0, 15,182,  7, 65,193,
/* 0x0df0 */ 226,  8,255,194, 72,255,199, 65,  9,194,131,250,  4,126,227, 68,
/* 0x0e00 */  59,124, 36,228, 15,131,218,  8,  0,  0,139, 68, 36,212, 72, 99,
/* 0x0e10 */  92, 36,200, 72,139, 84, 36,216, 68, 33,248,137, 68, 36,184, 72,
/* 0x0e20 */  99,108, 36,184, 72,137,216, 72,193,224,  4, 72,  1,232, 65,129,
/* 0x0e30 */ 251,255,255,255,  0, 76,141, 12, 66,119, 26, 76, 57,231, 15,132,
/* 0x0e40 */ 150,  8,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,
/* 0x0e50 */ 255,199, 65,  9,194, 65, 15,183, 17, 68,137,216,193,232, 11, 15,
/* 0x0e60 */ 183,202, 15,175,193, 65, 57,194, 15,131,197,  1,  0,  0, 65,137,
/* 0x0e70 */ 195,184,  0,  8,  0,  0, 72,139, 92, 36,216, 41,200, 15,182, 76,
/* 0x0e80 */  36,204,190,  1,  0,  0,  0,193,248,  5,141,  4,  2, 65, 15,182,
/* 0x0e90 */ 213,102, 65,137,  1,139, 68, 36,208, 68, 33,248,211,224,185,  8,
/* 0x0ea0 */   0,  0,  0, 43, 76, 36,204,211,250,  1,208,105,192,  0,  3,  0,
/* 0x0eb0 */   0,131,124, 36,200,  6,137,192, 76,141,140, 67,108, 14,  0,  0,
/* 0x0ec0 */  15,142,184,  0,  0,  0, 72,139, 84, 36,232, 68,137,248, 68, 41,
/* 0x0ed0 */ 240, 15,182, 44,  2,  1,237, 72, 99,214,137,235,129,227,  0,  1,
/* 0x0ee0 */   0,  0, 65,129,251,255,255,255,  0, 72, 99,195, 73,141,  4, 65,
/* 0x0ef0 */  76,141,  4, 80,119, 26, 76, 57,231, 15,132,219,  7,  0,  0, 15,
/* 0x0f00 */ 182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194,
/* 0x0f10 */  65, 15,183,144,  0,  2,  0,  0, 68,137,216,193,232, 11, 15,183,
/* 0x0f20 */ 202, 15,175,193, 65, 57,194,115, 32, 65,137,195,184,  0,  8,  0,
/* 0x0f30 */   0,  1,246, 41,200,193,248,  5,133,219,141,  4,  2,102, 65,137,
/* 0x0f40 */ 128,  0,  2,  0,  0,116, 33,235, 45, 65, 41,195, 65, 41,194,137,
/* 0x0f50 */ 208,102,193,232,  5,141,116, 54,  1,102, 41,194,133,219,102, 65,
/* 0x0f60 */ 137,144,  0,  2,  0,  0,116, 14,129,254,255,  0,  0,  0, 15,142,
/* 0x0f70 */  97,255,255,255,235,120,129,254,255,  0,  0,  0,127,112, 72, 99,
/* 0x0f80 */ 198, 65,129,251,255,255,255,  0, 77,141,  4, 65,119, 26, 76, 57,
/* 0x0f90 */ 231, 15,132, 67,  7,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,
/* 0x0fa0 */ 227,  8, 72,255,199, 65,  9,194, 65, 15,183, 16, 68,137,216,193,
/* 0x0fb0 */ 232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 24, 65,137,195,
/* 0x0fc0 */ 184,  0,  8,  0,  0,  1,246, 41,200,193,248,  5,141,  4,  2,102,
/* 0x0fd0 */  65,137,  0,235,161, 65, 41,195, 65, 41,194,137,208,102,193,232,
/* 0x0fe0 */   5,141,116, 54,  1,102, 41,194,102, 65,137, 16,235,136, 72,139,
/* 0x0ff0 */  76, 36,232, 68,137,248, 65,255,199, 65,137,245, 64,136, 52,  1,
/* 0x1000 */ 131,124, 36,200,  3,127, 13,199, 68, 36,200,  0,  0,  0,  0,233,
/* 0x1010 */ 166,  6,  0,  0,139, 84, 36,200,139, 68, 36,200,131,234,  3,131,
/* 0x1020 */ 232,  6,131,124, 36,200,  9, 15, 79,208,137, 84, 36,200,233,135,
/* 0x1030 */   6,  0,  0, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,102,
/* 0x1040 */  41,194, 72,139, 68, 36,216, 65,129,251,255,255,255,  0,102, 65,
/* 0x1050 */ 137, 17, 72,141, 52, 88,119, 26, 76, 57,231, 15,132,121,  6,  0,
/* 0x1060 */   0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,
/* 0x1070 */   9,194, 15,183,150,128,  1,  0,  0, 68,137,216,193,232, 11, 15,
/* 0x1080 */ 183,202, 15,175,193, 65, 57,194,115, 78, 65,137,195,184,  0,  8,
/* 0x1090 */   0,  0, 76,139, 76, 36,216, 41,200,139, 76, 36,196, 68,137,116,
/* 0x10a0 */  36,196,193,248,  5,141,  4,  2,139, 84, 36,192,137, 76, 36,192,
/* 0x10b0 */ 102,137,134,128,  1,  0,  0, 49,192,131,124, 36,200,  6,137, 84,
/* 0x10c0 */  36,188, 15,159,192, 73,129,193,100,  6,  0,  0,141,  4, 64,137,
/* 0x10d0 */  68, 36,200,233, 84,  2,  0,  0, 65, 41,195, 65, 41,194,137,208,
/* 0x10e0 */ 102,193,232,  5,102, 41,194, 65,129,251,255,255,255,  0,102,137,
/* 0x10f0 */ 150,128,  1,  0,  0,119, 26, 76, 57,231, 15,132,218,  5,  0,  0,
/* 0x1100 */  15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,
/* 0x1110 */ 194, 15,183,150,152,  1,  0,  0, 68,137,216,193,232, 11, 15,183,
/* 0x1120 */ 202, 15,175,193, 65, 57,194, 15,131,208,  0,  0,  0, 65,184,  0,
/* 0x1130 */   8,  0,  0, 65,137,195, 72,193,227,  5, 68,137,192, 41,200,193,
/* 0x1140 */ 248,  5,141,  4,  2,102,137,134,152,  1,  0,  0, 72,139, 68, 36,
/* 0x1150 */ 216, 72,  1,216, 65,129,251,255,255,255,  0, 72,141, 52,104,119,
/* 0x1160 */  26, 76, 57,231, 15,132,112,  5,  0,  0, 15,182,  7, 65,193,226,
/* 0x1170 */   8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,183,150,224,  1,
/* 0x1180 */   0,  0, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65, 57,
/* 0x1190 */ 194,115, 79, 65, 41,200, 65,137,195, 65,193,248,  5, 69,133,255,
/* 0x11a0 */  66,141,  4,  2,102,137,134,224,  1,  0,  0, 15,132, 41,  5,  0,
/* 0x11b0 */   0, 49,192,131,124, 36,200,  6, 72,139, 92, 36,232, 15,159,192,
/* 0x11c0 */ 141, 68,  0,  9,137, 68, 36,200, 68,137,248, 68, 41,240, 68, 15,
/* 0x11d0 */ 182, 44,  3, 68,137,248, 65,255,199, 68,136, 44,  3,233,216,  4,
/* 0x11e0 */   0,  0, 65, 41,195, 65, 41,194,137,208,102,193,232,  5,102, 41,
/* 0x11f0 */ 194,102,137,150,224,  1,  0,  0,233, 17,  1,  0,  0, 65, 41,195,
/* 0x1200 */  65, 41,194,137,208,102,193,232,  5,102, 41,194, 65,129,251,255,
/* 0x1210 */ 255,255,  0,102,137,150,152,  1,  0,  0,119, 26, 76, 57,231, 15,
/* 0x1220 */ 132,181,  4,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8,
/* 0x1230 */  72,255,199, 65,  9,194, 15,183,150,176,  1,  0,  0, 68,137,216,
/* 0x1240 */ 193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 32, 65,137,
/* 0x1250 */ 195,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,137,
/* 0x1260 */ 134,176,  1,  0,  0,139, 68, 36,196,233,152,  0,  0,  0, 65, 41,
/* 0x1270 */ 195, 65, 41,194,137,208,102,193,232,  5,102, 41,194, 65,129,251,
/* 0x1280 */ 255,255,255,  0,102,137,150,176,  1,  0,  0,119, 26, 76, 57,231,
/* 0x1290 */  15,132, 68,  4,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,
/* 0x12a0 */   8, 72,255,199, 65,  9,194, 15,183,150,200,  1,  0,  0, 68,137,
/* 0x12b0 */ 216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 29, 65,
/* 0x12c0 */ 137,195,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,
/* 0x12d0 */ 137,134,200,  1,  0,  0,139, 68, 36,192,235, 34, 65, 41,195, 65,
/* 0x12e0 */  41,194,137,208,102,193,232,  5,102, 41,194,139, 68, 36,188,102,
/* 0x12f0 */ 137,150,200,  1,  0,  0,139, 84, 36,192,137, 84, 36,188,139, 76,
/* 0x1300 */  36,196,137, 76, 36,192, 68,137,116, 36,196, 65,137,198, 49,192,
/* 0x1310 */ 131,124, 36,200,  6, 76,139, 76, 36,216, 15,159,192, 73,129,193,
/* 0x1320 */ 104, 10,  0,  0,141, 68, 64,  8,137, 68, 36,200, 65,129,251,255,
/* 0x1330 */ 255,255,  0,119, 26, 76, 57,231, 15,132,156,  3,  0,  0, 15,182,
/* 0x1340 */   7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,194, 65,
/* 0x1350 */  15,183, 17, 68,137,216,193,232, 11, 15,183,202, 15,175,193, 65,
/* 0x1360 */  57,194,115, 39, 65,137,195,184,  0,  8,  0,  0, 69, 49,237, 41,
/* 0x1370 */ 200,193,248,  5,141,  4,  2,102, 65,137,  1, 72, 99, 68, 36,184,
/* 0x1380 */  72,193,224,  4, 77,141, 68,  1,  4,235,120, 65, 41,195, 65, 41,
/* 0x1390 */ 194,137,208,102,193,232,  5,102, 41,194, 65,129,251,255,255,255,
/* 0x13a0 */   0,102, 65,137, 17,119, 26, 76, 57,231, 15,132, 42,  3,  0,  0,
/* 0x13b0 */  15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,  9,
/* 0x13c0 */ 194, 65, 15,183, 81,  2, 68,137,216,193,232, 11, 15,183,202, 15,
/* 0x13d0 */ 175,193, 65, 57,194,115, 52, 65,137,195,184,  0,  8,  0,  0, 65,
/* 0x13e0 */ 189,  8,  0,  0,  0, 41,200,193,248,  5,141,  4,  2,102, 65,137,
/* 0x13f0 */  65,  2, 72, 99, 68, 36,184, 72,193,224,  4, 77,141,132,  1,  4,
/* 0x1400 */   1,  0,  0, 65,185,  3,  0,  0,  0,235, 39, 65, 41,195, 65, 41,
/* 0x1410 */ 194,137,208,102,193,232,  5, 77,141,129,  4,  2,  0,  0, 65,189,
/* 0x1420 */  16,  0,  0,  0,102, 41,194,102, 65,137, 81,  2, 65,185,  8,  0,
/* 0x1430 */   0,  0, 68,137,203,189,  1,  0,  0,  0, 72, 99,197, 65,129,251,
/* 0x1440 */ 255,255,255,  0, 73,141, 52, 64,119, 26, 76, 57,231, 15,132,135,
/* 0x1450 */   2,  0,  0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,
/* 0x1460 */ 199, 65,  9,194, 15,183, 14, 68,137,216,193,232, 11, 15,183,209,
/* 0x1470 */  15,175,194, 65, 57,194,115, 23, 65,137,195,184,  0,  8,  0,  0,
/* 0x1480 */   1,237, 41,208,193,248,  5,141,  4,  1,102,137,  6,235, 22, 65,
/* 0x1490 */  41,195, 65, 41,194,137,200,102,193,232,  5,141,108, 45,  1,102,
/* 0x14a0 */  41,193,102,137, 14,255,203,117,145,184,  1,  0,  0,  0, 68,137,
/* 0x14b0 */ 201,211,224, 41,197, 68,  1,237,131,124, 36,200,  3, 15,143,194,
/* 0x14c0 */   1,  0,  0,131, 68, 36,200,  7,184,  3,  0,  0,  0,131,253,  4,
/* 0x14d0 */  15, 76,197, 72,139, 92, 36,216, 65,184,  1,  0,  0,  0, 72,152,
/* 0x14e0 */  72,193,224,  7, 76,141,140,  3, 96,  3,  0,  0,187,  6,  0,  0,
/* 0x14f0 */   0, 73, 99,192, 65,129,251,255,255,255,  0, 73,141, 52, 65,119,
/* 0x1500 */  26, 76, 57,231, 15,132,208,  1,  0,  0, 15,182,  7, 65,193,226,
/* 0x1510 */   8, 65,193,227,  8, 72,255,199, 65,  9,194, 15,183, 22, 68,137,
/* 0x1520 */ 216,193,232, 11, 15,183,202, 15,175,193, 65, 57,194,115, 24, 65,
/* 0x1530 */ 137,195,184,  0,  8,  0,  0, 69,  1,192, 41,200,193,248,  5,141,
/* 0x1540 */   4,  2,102,137,  6,235, 23, 65, 41,195, 65, 41,194,137,208,102,
/* 0x1550 */ 193,232,  5, 71,141, 68,  0,  1,102, 41,194,102,137, 22,255,203,
/* 0x1560 */ 117,143, 65,131,232, 64, 65,131,248,  3, 69,137,198, 15,142, 13,
/* 0x1570 */   1,  0,  0, 65,131,230,  1, 68,137,192,209,248, 65,131,206,  2,
/* 0x1580 */  65,131,248, 13,141,112,255,127, 35,137,241, 72,139, 92, 36,216,
/* 0x1590 */  73, 99,192, 65,211,230, 72,  1,192, 68,137,242, 72,141, 20, 83,
/* 0x15a0 */  72, 41,194, 76,141,138, 94,  5,  0,  0,235, 81,141,112,251, 65,
/* 0x15b0 */ 129,251,255,255,255,  0,119, 26, 76, 57,231, 15,132, 25,  1,  0,
/* 0x15c0 */   0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,
/* 0x15d0 */   9,194, 65,209,235, 69,  1,246, 69, 57,218,114,  7, 69, 41,218,
/* 0x15e0 */  65,131,206,  1,255,206,117,199, 76,139, 76, 36,216, 65,193,230,
/* 0x15f0 */   4,190,  4,  0,  0,  0, 73,129,193, 68,  6,  0,  0, 65,189,  1,
/* 0x1600 */   0,  0,  0,187,  1,  0,  0,  0, 72, 99,195, 65,129,251,255,255,
/* 0x1610 */ 255,  0, 77,141,  4, 65,119, 26, 76, 57,231, 15,132,185,  0,  0,
/* 0x1620 */   0, 15,182,  7, 65,193,226,  8, 65,193,227,  8, 72,255,199, 65,
/* 0x1630 */   9,194, 65, 15,183, 16, 68,137,216,193,232, 11, 15,183,202, 15,
/* 0x1640 */ 175,193, 65, 57,194,115, 24, 65,137,195,184,  0,  8,  0,  0,  1,
/* 0x1650 */ 219, 41,200,193,248,  5,141,  4,  2,102, 65,137,  0,235, 26, 65,
/* 0x1660 */  41,195, 65, 41,194,137,208,102,193,232,  5,141, 92, 27,  1, 69,
/* 0x1670 */   9,238,102, 41,194,102, 65,137, 16, 69,  1,237,255,206,117,136,
/* 0x1680 */  65,255,198,116, 64,131,197,  2, 69, 57,254,119, 77, 72,139, 84,
/* 0x1690 */  36,232, 68,137,248, 68, 41,240, 68, 15,182, 44,  2, 68,137,248,
/* 0x16a0 */  65,255,199,255,205, 68,136, 44,  2, 15,149,194, 49,192, 68, 59,
/* 0x16b0 */ 124, 36,228, 15,146,192,133,194,117,211, 68, 59,124, 36,228, 15,
/* 0x16c0 */ 130, 69,247,255,255, 65,129,251,255,255,255,  0,119, 22, 76, 57,
/* 0x16d0 */ 231,184,  1,  0,  0,  0,116, 35,235,  7,184,  1,  0,  0,  0,235,
/* 0x16e0 */  26, 72,255,199,137,248, 43, 68, 36,248, 72,139, 76, 36,240, 72,
/* 0x16f0 */ 139, 92, 36, 56,137,  1, 68,137, 59, 49,192, 91, 93, 65, 92, 65,
/* 0x1700 */  93, 65, 94, 65, 95, 72,139,117,248, 72,139,125, 16,139, 75,  4,
/* 0x1710 */  72,  1,206,139, 19, 72,  1,215,201,201, 88, 94, 95, 88,137,  7,
/* 0x1720 */  72,141,190,  0,  0,  0,  0, 72,137,247, 86, 72,137,247, 72,199,
/* 0x1730 */ 198,  0,  0,  0,  0,178,  0, 83, 87, 72,141, 76, 55,253, 94, 86,
/* 0x1740 */  91,235, 47, 72, 57,206,115, 50, 86, 94,172, 60,128,114, 10, 60,
/* 0x1750 */ 143,119,  6,128,126,254, 15,116,  6, 44,232, 60,  1,119,228, 72,
/* 0x1760 */  57,206,115, 22, 86,173, 40,208,117,223, 95, 15,200, 41,248,  1,
/* 0x1770 */ 216,171, 72, 57,206,115,  3,172,235,223, 91, 94, 72,131,236, 40,
/* 0x1780 */  72,141,190,  0,  0,  0,  0,139,  7,  9,192,116,255,139, 95,  4,
/* 0x1790 */  72,141,140, 48,  0,  0,  0,  0, 72,  1,243, 72,131,199,  8,255,
/* 0x17a0 */  21,  0,  0,  0,  0, 72,149,138,  7, 72,255,199,  8,192,116,215,
/* 0x17b0 */ 121,255,122, 16,139,  7, 72,131,199,  4, 72,139,132, 48,  0,  0,
/* 0x17c0 */   0,  0,235,255, 72, 15,183, 23, 72,131,199,  2,235,255, 72,137,
/* 0x17d0 */ 249, 72,137,250,255,200,242,174, 72,137,233,255, 21,  0,  0,  0,
/* 0x17e0 */   0, 72,  9,192,116,  9, 72,137,  3, 72,131,195,  8,235,255, 72,
/* 0x17f0 */ 131,196, 40, 93, 95, 94, 91, 49,192,195,255, 37,  0,  0,  0,  0,
/* 0x1800 */  72,131,196, 40, 72,141,190,  0,  0,  0,  0, 72,131,199,  4, 72,
/* 0x1810 */ 141, 94,252, 49,192,138,  7, 72,255,199,  9,192,116,255, 60,239,
/* 0x1820 */ 119, 17, 72,  1,195, 72,139,  3, 72, 15,200, 72,  1,240, 72,137,
/* 0x1830 */   3,235,224, 36, 15,193,224, 16,102,139,  7, 72,131,199,  2,  9,
/* 0x1840 */ 192,117,255,139,  7, 72,131,199,  4,235,255, 72,135,247, 72,141,
/* 0x1850 */ 143,  0,  0,  0,  0,235,  4,102,  1, 12,  7,173,  9,192,117,247,
/* 0x1860 */ 193,233, 16,235,  4,102,  1, 12,  7,173,  9,192,117,247, 72,139,
/* 0x1870 */  45,  0,  0,  0,  0, 72,141,190,  0,  0,  0,  0,187,  0,  0,  0,
/* 0x1880 */ 128, 80, 73,137,225, 65,184,  4,  0,  0,  0, 72,137,218, 72,137,
/* 0x1890 */ 249, 72,131,236, 32,255,213, 72,141,135,  0,  0,  0,  0,128, 32,
/* 0x18a0 */ 127,128, 96, 40,127, 76,141, 76, 36, 32, 77,139,  1, 72,137,218,
/* 0x18b0 */  72,137,249,255,213, 72,131,196, 40,198,  5,  0,  0,  0,  0,252,
/* 0x18c0 */  72,141,142,  0,  0,  0,  0,106,  1, 90, 77, 49,192, 80,232,  0,
/* 0x18d0 */   0,  0,  0, 88, 93, 95, 94, 91, 72,141, 68, 36,128,106,  0, 72,
/* 0x18e0 */  57,196,117,249, 72,131,236,128, 76,139, 68, 36, 24, 72,139, 84,
/* 0x18f0 */  36, 16, 72,139, 76, 36,  8,106,  1, 88,195,233,  0,  0,  0,  0,
/* 0x1900 */ 195, 86, 72,141, 53,  0,  0,  0,  0, 72,173, 72,133,192,116, 20,
/* 0x1910 */  81, 82, 65, 80, 72,131,236, 40,255,208, 72,131,196, 40, 65, 88,
/* 0x1920 */  90, 89,235,229, 94,195, 85, 80, 88, 33,161,216,208,213,  0,  0,
/* 0x1930 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1940 */   0,  0,  0,  0,  0, 45,102,105,108,101, 32,102,111,114,109, 97,
/* 0x1950 */ 116, 32,101,108,102, 54, 52, 45,120, 56, 54, 45, 54, 52, 10, 10,
/* 0x1960 */  83,101, 99,116,105,111,110,115, 58, 10, 73,100,120, 32, 78, 97,
/* 0x1970 */ 109,101, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 83,105,122,101,
/* 0x1980 */  32, 32, 32, 32, 32, 32, 86, 77, 65, 32, 32, 32, 32, 32, 32, 32,
/* 0x1990 */  32, 32, 32, 32, 32, 32, 32, 32, 76, 77, 65, 32, 32, 32, 32, 32,
/* 0x19a0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 70,105,108,101, 32,111,
/* 0x19b0 */ 102,102, 32, 32, 65,108,103,110, 32, 32, 70,108, 97,103,115, 10,
/* 0x19c0 */  32, 32, 48, 32, 83, 84, 65, 82, 84, 32, 32, 32, 32, 32, 32, 32,
/* 0x19d0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x19e0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x19f0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x1a00 */  48, 48, 48, 48, 48, 48, 52, 48, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1a10 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x1a20 */  76, 89, 10, 32, 32, 49, 32, 80, 69, 73, 83, 68, 76, 76, 48, 32,
/* 0x1a30 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,102, 32, 32, 48,
/* 0x1a40 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1a50 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1a60 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 52, 48, 32, 32, 50, 42, 42,
/* 0x1a70 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65,
/* 0x1a80 */  68, 79, 78, 76, 89, 10, 32, 32, 50, 32, 80, 69, 73, 83, 68, 76,
/* 0x1a90 */  76, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 57,
/* 0x1aa0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1ab0 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1ac0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 52,102, 32, 32,
/* 0x1ad0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x1ae0 */  82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10,
/* 0x1af0 */  32, 32, 51, 32, 80, 69, 77, 65, 73, 78, 48, 49, 32, 32, 32, 32,
/* 0x1b00 */  32, 32, 48, 48, 48, 48, 48, 48, 49, 50, 32, 32, 48, 48, 48, 48,
/* 0x1b10 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x1b20 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x1b30 */  48, 48, 48, 48, 48, 48, 53, 56, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x1b40 */  67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44,
/* 0x1b50 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 52, 32, 80, 69,
/* 0x1b60 */  73, 67, 79, 78, 83, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x1b70 */  48, 48, 48, 55, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1b80 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1b90 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1ba0 */  54, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x1bb0 */  84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,
/* 0x1bc0 */  78, 76, 89, 10, 32, 32, 53, 32, 80, 69, 73, 67, 79, 78, 83, 50,
/* 0x1bd0 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 57, 32, 32,
/* 0x1be0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1bf0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1c00 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 55, 49, 32, 32, 50, 42,
/* 0x1c10 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x1c20 */  76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32,
/* 0x1c30 */  54, 32, 80, 69, 84, 76, 83, 72, 65, 75, 32, 32, 32, 32, 32, 32,
/* 0x1c40 */  48, 48, 48, 48, 48, 48, 49, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1c50 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x1c60 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x1c70 */  48, 48, 48, 48, 55, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x1c80 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,
/* 0x1c90 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 55, 32, 80, 69, 77, 65,
/* 0x1ca0 */  73, 78, 48, 50, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1cb0 */  48, 49, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1cc0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1cd0 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 56, 97,
/* 0x1ce0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x1cf0 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32, 56, 32, 80,
/* 0x1d00 */  69, 77, 65, 73, 78, 48, 51, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x1d10 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1d20 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1d30 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x1d40 */  48, 56, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x1d50 */  78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 32,
/* 0x1d60 */  57, 32, 78, 82, 86, 95, 72, 69, 65, 68, 32, 32, 32, 32, 32, 32,
/* 0x1d70 */  48, 48, 48, 48, 48, 48, 54, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x1d80 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x1d90 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x1da0 */  48, 48, 48, 48, 56, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x1db0 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x1dc0 */  10, 32, 49, 48, 32, 78, 82, 86, 50, 66, 32, 32, 32, 32, 32, 32,
/* 0x1dd0 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 56, 51, 32, 32, 48, 48, 48,
/* 0x1de0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x1df0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x1e00 */  32, 48, 48, 48, 48, 48, 48,101, 98, 32, 32, 50, 42, 42, 48, 32,
/* 0x1e10 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67,
/* 0x1e20 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 49, 32, 78,
/* 0x1e30 */  82, 86, 50, 68, 32, 32, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x1e40 */  48, 48, 48, 57, 49, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1e50 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x1e60 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x1e70 */  49, 54,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x1e80 */  78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,
/* 0x1e90 */  79, 78, 76, 89, 10, 32, 49, 50, 32, 78, 82, 86, 50, 69, 32, 32,
/* 0x1ea0 */  32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 97, 97, 32,
/* 0x1eb0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1ec0 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1ed0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 49,102,102, 32, 32, 50,
/* 0x1ee0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x1ef0 */  69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x1f00 */  49, 51, 32, 76, 90, 77, 65, 95, 72, 69, 65, 68, 32, 32, 32, 32,
/* 0x1f10 */  32, 48, 48, 48, 48, 48, 48, 49, 52, 32, 32, 48, 48, 48, 48, 48,
/* 0x1f20 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x1f30 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x1f40 */  48, 48, 48, 48, 50, 97, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x1f50 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,
/* 0x1f60 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 52, 32, 76, 90, 77,
/* 0x1f70 */  65, 95, 69, 76, 70, 48, 48, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x1f80 */  48, 53, 97, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1f90 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1fa0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 50, 98,
/* 0x1fb0 */ 100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x1fc0 */  83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 53, 32,
/* 0x1fd0 */  76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 32, 32, 32, 32, 48, 48,
/* 0x1fe0 */  48, 48, 48, 57,102, 55, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x1ff0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2000 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x2010 */  48, 51, 49, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2020 */  69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x2030 */  49, 54, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 32, 32, 32,
/* 0x2040 */  32, 48, 48, 48, 48, 48, 57,102, 55, 32, 32, 48, 48, 48, 48, 48,
/* 0x2050 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x2060 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x2070 */  48, 48, 48, 48,100, 48,101, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2080 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x2090 */  89, 10, 32, 49, 55, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48,
/* 0x20a0 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 49, 52, 32, 32, 48, 48,
/* 0x20b0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x20c0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x20d0 */  32, 32, 48, 48, 48, 48, 49, 55, 48, 53, 32, 32, 50, 42, 42, 48,
/* 0x20e0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,
/* 0x20f0 */  79, 78, 76, 89, 10, 32, 49, 56, 32, 76, 90, 77, 65, 95, 84, 65,
/* 0x2100 */  73, 76, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 50, 32,
/* 0x2110 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2120 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2130 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 55, 49, 57, 32, 32, 50,
/* 0x2140 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x2150 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 49, 57, 32, 80, 69, 77, 65,
/* 0x2160 */  73, 78, 49, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2170 */  48, 49, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2180 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2190 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 55, 49, 98,
/* 0x21a0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x21b0 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 48, 32, 80,
/* 0x21c0 */  69, 84, 76, 83, 72, 65, 75, 50, 32, 32, 32, 32, 32, 48, 48, 48,
/* 0x21d0 */  48, 48, 48, 48, 52, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x21e0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x21f0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,
/* 0x2200 */  55, 49, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2210 */  78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50,
/* 0x2220 */  49, 32, 80, 69, 67, 84, 84, 80, 79, 83, 32, 32, 32, 32, 32, 32,
/* 0x2230 */  48, 48, 48, 48, 48, 48, 48, 55, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2240 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x2250 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x2260 */  48, 48, 49, 55, 50, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2270 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,
/* 0x2280 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 50, 32, 80, 69, 67, 84,
/* 0x2290 */  84, 78, 85, 76, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x22a0 */  48, 51, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x22b0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x22c0 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 55, 50, 55,
/* 0x22d0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x22e0 */  44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 51, 32, 80,
/* 0x22f0 */  69, 70, 73, 76, 84, 69, 82, 52, 57, 32, 32, 32, 32, 48, 48, 48,
/* 0x2300 */  48, 48, 48, 53, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2310 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x2320 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49,
/* 0x2330 */  55, 50, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2340 */  78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68,
/* 0x2350 */  79, 78, 76, 89, 10, 32, 50, 52, 32, 80, 69, 73, 77, 80, 79, 82,
/* 0x2360 */  84, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 51, 52, 32,
/* 0x2370 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2380 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2390 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 55, 55, 99, 32, 32, 50,
/* 0x23a0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x23b0 */  69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x23c0 */  50, 53, 32, 80, 69, 73, 66, 89, 79, 82, 68, 32, 32, 32, 32, 32,
/* 0x23d0 */  32, 48, 48, 48, 48, 48, 48, 48, 50, 32, 32, 48, 48, 48, 48, 48,
/* 0x23e0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x23f0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x2400 */  48, 48, 48, 49, 55, 98, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2410 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,
/* 0x2420 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 54, 32, 80, 69, 75,
/* 0x2430 */  51, 50, 79, 82, 68, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x2440 */  48, 49, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2450 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2460 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 55, 98,
/* 0x2470 */  50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2480 */  83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78,
/* 0x2490 */  76, 89, 10, 32, 50, 55, 32, 80, 69, 73, 77, 79, 82, 68, 49, 32,
/* 0x24a0 */  32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 97, 32, 32, 48,
/* 0x24b0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x24c0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x24d0 */  48, 32, 32, 48, 48, 48, 48, 49, 55, 99, 52, 32, 32, 50, 42, 42,
/* 0x24e0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76,
/* 0x24f0 */  79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 50, 56,
/* 0x2500 */  32, 80, 69, 73, 77, 80, 79, 82, 50, 32, 32, 32, 32, 32, 32, 48,
/* 0x2510 */  48, 48, 48, 48, 48, 50, 49, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x2520 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48,
/* 0x2530 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x2540 */  48, 49, 55, 99,101, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x2550 */  84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69,
/* 0x2560 */  65, 68, 79, 78, 76, 89, 10, 32, 50, 57, 32, 80, 69, 73, 69, 82,
/* 0x2570 */  68, 76, 76, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x2580 */  98, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2590 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x25a0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 55,101,102, 32,
/* 0x25b0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x25c0 */  32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 48, 32, 80, 69,
/* 0x25d0 */  73, 69, 82, 69, 88, 69, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48,
/* 0x25e0 */  48, 48, 48, 54, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x25f0 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2600 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 55,
/* 0x2610 */ 102, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2620 */  84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79,
/* 0x2630 */  78, 76, 89, 10, 32, 51, 49, 32, 80, 69, 73, 77, 68, 79, 78, 69,
/* 0x2640 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 52, 32, 32,
/* 0x2650 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2660 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2670 */  48, 48, 32, 32, 48, 48, 48, 48, 49, 56, 48, 48, 32, 32, 50, 42,
/* 0x2680 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x2690 */  65, 68, 79, 78, 76, 89, 10, 32, 51, 50, 32, 80, 69, 82, 69, 76,
/* 0x26a0 */  79, 67, 49, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48,
/* 0x26b0 */  55, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x26c0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x26d0 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 56, 48, 52, 32,
/* 0x26e0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44,
/* 0x26f0 */  32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89,
/* 0x2700 */  10, 32, 51, 51, 32, 80, 69, 82, 69, 76, 79, 67, 50, 32, 32, 32,
/* 0x2710 */  32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 52, 32, 32, 48, 48, 48,
/* 0x2720 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x2730 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2740 */  32, 48, 48, 48, 48, 49, 56, 48, 98, 32, 32, 50, 42, 42, 48, 32,
/* 0x2750 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79,
/* 0x2760 */  78, 76, 89, 10, 32, 51, 52, 32, 80, 69, 82, 69, 76, 79, 67, 51,
/* 0x2770 */  32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 51, 48, 32, 32,
/* 0x2780 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2790 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x27a0 */  48, 48, 32, 32, 48, 48, 48, 48, 49, 56, 48,102, 32, 32, 50, 42,
/* 0x27b0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69,
/* 0x27c0 */  76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51,
/* 0x27d0 */  53, 32, 82, 69, 76, 54, 52, 66, 73, 71, 32, 32, 32, 32, 32, 32,
/* 0x27e0 */  48, 48, 48, 48, 48, 48, 48, 97, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x27f0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x2800 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48,
/* 0x2810 */  48, 48, 49, 56, 51,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2820 */  78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82,
/* 0x2830 */  69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 54, 32, 82, 69, 76, 79,
/* 0x2840 */  67, 54, 52, 74, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2850 */  48, 50, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2860 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2870 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 56, 52, 57,
/* 0x2880 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2890 */  44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x28a0 */  89, 10, 32, 51, 55, 32, 80, 69, 82, 76, 79, 72, 73, 48, 32, 32,
/* 0x28b0 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 97, 32, 32, 48, 48,
/* 0x28c0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x28d0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x28e0 */  32, 32, 48, 48, 48, 48, 49, 56, 52, 98, 32, 32, 50, 42, 42, 48,
/* 0x28f0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,
/* 0x2900 */  67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 51, 56, 32,
/* 0x2910 */  80, 69, 82, 69, 76, 76, 79, 48, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x2920 */  48, 48, 48, 48, 48, 98, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2930 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2940 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x2950 */  49, 56, 53, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2960 */  69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x2970 */  51, 57, 32, 80, 69, 82, 69, 76, 72, 73, 48, 32, 32, 32, 32, 32,
/* 0x2980 */  32, 48, 48, 48, 48, 48, 48, 48,101, 32, 32, 48, 48, 48, 48, 48,
/* 0x2990 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x29a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x29b0 */  48, 48, 48, 49, 56, 54, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x29c0 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x29d0 */  89, 10, 32, 52, 48, 32, 80, 69, 68, 69, 80, 72, 65, 75, 32, 32,
/* 0x29e0 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 52, 98, 32, 32, 48, 48,
/* 0x29f0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x2a00 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2a10 */  32, 32, 48, 48, 48, 48, 49, 56, 54,101, 32, 32, 50, 42, 42, 48,
/* 0x2a20 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79,
/* 0x2a30 */  67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 49, 32,
/* 0x2a40 */  80, 69, 84, 76, 83, 67, 32, 32, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x2a50 */  48, 48, 48, 48, 49, 98, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2a60 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2a70 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x2a80 */  49, 56, 98, 57, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2a90 */  69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32, 82, 69, 65,
/* 0x2aa0 */  68, 79, 78, 76, 89, 10, 32, 52, 50, 32, 80, 69, 77, 65, 73, 78,
/* 0x2ab0 */  50, 48, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 52,
/* 0x2ac0 */  32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2ad0 */  48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2ae0 */  48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 56,100, 52, 32, 32,
/* 0x2af0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32,
/* 0x2b00 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 51, 32, 67, 76, 69,
/* 0x2b10 */  65, 82, 83, 84, 65, 67, 75, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x2b20 */  48, 49, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2b30 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2b40 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 56,100,
/* 0x2b50 */  56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2b60 */  83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 52, 32,
/* 0x2b70 */  80, 69, 77, 65, 73, 78, 50, 49, 32, 32, 32, 32, 32, 32, 48, 48,
/* 0x2b80 */  48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2b90 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48,
/* 0x2ba0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48,
/* 0x2bb0 */  49, 56,101, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2bc0 */  69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x2bd0 */  52, 53, 32, 80, 69, 73, 83, 68, 76, 76, 57, 32, 32, 32, 32, 32,
/* 0x2be0 */  32, 48, 48, 48, 48, 48, 48, 48,102, 32, 32, 48, 48, 48, 48, 48,
/* 0x2bf0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x2c00 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x2c10 */  48, 48, 48, 49, 56,101, 56, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2c20 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68, 79, 78, 76,
/* 0x2c30 */  89, 10, 32, 52, 54, 32, 80, 69, 82, 69, 84, 85, 82, 78, 32, 32,
/* 0x2c40 */  32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 52, 32, 32, 48, 48,
/* 0x2c50 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x2c60 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2c70 */  32, 32, 48, 48, 48, 48, 49, 56,102, 55, 32, 32, 50, 42, 42, 48,
/* 0x2c80 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 65, 68,
/* 0x2c90 */  79, 78, 76, 89, 10, 32, 52, 55, 32, 80, 69, 68, 79, 74, 85, 77,
/* 0x2ca0 */  80, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 53, 32,
/* 0x2cb0 */  32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2cc0 */  48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2cd0 */  48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 56,102, 98, 32, 32, 50,
/* 0x2ce0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 44, 32, 82,
/* 0x2cf0 */  69, 76, 79, 67, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 32,
/* 0x2d00 */  52, 56, 32, 80, 69, 84, 76, 83, 67, 50, 32, 32, 32, 32, 32, 32,
/* 0x2d10 */  32, 48, 48, 48, 48, 48, 48, 50, 54, 32, 32, 48, 48, 48, 48, 48,
/* 0x2d20 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48,
/* 0x2d30 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 48,
/* 0x2d40 */  48, 48, 48, 49, 57, 48, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2d50 */  79, 78, 84, 69, 78, 84, 83, 44, 32, 82, 69, 76, 79, 67, 44, 32,
/* 0x2d60 */  82, 69, 65, 68, 79, 78, 76, 89, 10, 32, 52, 57, 32, 85, 80, 88,
/* 0x2d70 */  49, 72, 69, 65, 68, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48,
/* 0x2d80 */  48, 50, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2d90 */  48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2da0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 48, 48, 48, 48, 49, 57, 50,
/* 0x2db0 */  54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2dc0 */  83, 44, 32, 82, 69, 65, 68, 79, 78, 76, 89, 10, 83, 89, 77, 66,
/* 0x2dd0 */  79, 76, 32, 84, 65, 66, 76, 69, 58, 10, 48, 48, 48, 48, 48, 48,
/* 0x2de0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x2df0 */ 100, 32, 32, 78, 82, 86, 95, 72, 69, 65, 68,  9, 48, 48, 48, 48,
/* 0x2e00 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86,
/* 0x2e10 */  95, 72, 69, 65, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2e20 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32, 32, 32, 32, 80,
/* 0x2e30 */  69, 73, 77, 68, 79, 78, 69,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2e40 */  48, 48, 48, 48, 48, 48, 48, 48, 32,105,109,112,111,114,116,115,
/* 0x2e50 */  95,100,111,110,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2e60 */  48, 48, 48, 48, 50, 98, 32,108, 32, 32, 32, 32, 32, 32, 32, 80,
/* 0x2e70 */  69, 73, 77, 80, 79, 82, 84,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2e80 */  48, 48, 48, 48, 48, 48, 48, 48, 32,110,101,120,116, 95,102,117,
/* 0x2e90 */ 110, 99, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2ea0 */  48, 48, 97, 32,108, 32, 32, 32, 32, 32, 32, 32, 80, 69, 73, 77,
/* 0x2eb0 */  79, 82, 68, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2ec0 */  48, 48, 48, 48, 48, 32, 98,121,110, 97,109,101, 10, 48, 48, 48,
/* 0x2ed0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 56, 32,108, 32,
/* 0x2ee0 */  32, 32, 32, 32, 32, 32, 80, 69, 73, 77, 80, 79, 82, 50,  9, 48,
/* 0x2ef0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x2f00 */ 110,101,120,116, 95,105,109,112, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x2f10 */  48, 48, 48, 48, 48, 48, 48, 48, 97, 32,108, 32, 32, 32, 32, 32,
/* 0x2f20 */  32, 32, 80, 69, 73, 77, 80, 79, 82, 50,  9, 48, 48, 48, 48, 48,
/* 0x2f30 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,102,105,114,115,
/* 0x2f40 */ 116, 95,105,109,112, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2f50 */  48, 48, 48, 48, 48, 50, 32,108, 32, 32, 32, 32, 32, 32, 32, 82,
/* 0x2f60 */  69, 76, 79, 67, 54, 52, 74,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2f70 */  48, 48, 48, 48, 48, 48, 48, 48, 32,114,101,108,111, 99, 95,101,
/* 0x2f80 */ 110,100,120, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2f90 */  48, 48, 49, 51, 32,108, 32, 32, 32, 32, 32, 32, 32, 80, 69, 82,
/* 0x2fa0 */  69, 76, 79, 67, 51,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2fb0 */  48, 48, 48, 48, 48, 48, 32,114,101,108,111, 99, 95, 97,100,100,
/* 0x2fc0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2fd0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 84, 76, 83, 67,
/* 0x2fe0 */  50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x2ff0 */  48, 48, 32, 80, 69, 84, 76, 83, 67, 50, 10, 48, 48, 48, 48, 48,
/* 0x3000 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3010 */  32,100, 32, 32, 80, 69, 77, 65, 73, 78, 50, 49,  9, 48, 48, 48,
/* 0x3020 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69,
/* 0x3030 */  77, 65, 73, 78, 50, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3040 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3050 */  83, 84, 65, 82, 84,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3060 */  48, 48, 48, 48, 48, 48, 32, 83, 84, 65, 82, 84, 10, 48, 48, 48,
/* 0x3070 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3080 */  32, 32, 32,100, 32, 32, 80, 69, 73, 83, 68, 76, 76, 48,  9, 48,
/* 0x3090 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x30a0 */  80, 69, 73, 83, 68, 76, 76, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x30b0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x30c0 */  32, 32, 80, 69, 73, 83, 68, 76, 76, 49,  9, 48, 48, 48, 48, 48,
/* 0x30d0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 73, 83,
/* 0x30e0 */  68, 76, 76, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x30f0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69,
/* 0x3100 */  77, 65, 73, 78, 48, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3110 */  48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 77, 65, 73, 78, 48, 49,
/* 0x3120 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3130 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 73, 67, 79, 78,
/* 0x3140 */  83, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3150 */  48, 48, 48, 32, 80, 69, 73, 67, 79, 78, 83, 49, 10, 48, 48, 48,
/* 0x3160 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3170 */  32, 32, 32,100, 32, 32, 80, 69, 73, 67, 79, 78, 83, 50,  9, 48,
/* 0x3180 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3190 */  80, 69, 73, 67, 79, 78, 83, 50, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x31a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x31b0 */  32, 32, 80, 69, 84, 76, 83, 72, 65, 75,  9, 48, 48, 48, 48, 48,
/* 0x31c0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 84, 76,
/* 0x31d0 */  83, 72, 65, 75, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x31e0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69,
/* 0x31f0 */  77, 65, 73, 78, 48, 50,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3200 */  48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 77, 65, 73, 78, 48, 50,
/* 0x3210 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3220 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 77, 65, 73, 78,
/* 0x3230 */  48, 51,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3240 */  48, 48, 48, 32, 80, 69, 77, 65, 73, 78, 48, 51, 10, 48, 48, 48,
/* 0x3250 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3260 */  32, 32, 32,100, 32, 32, 78, 82, 86, 50, 66,  9, 48, 48, 48, 48,
/* 0x3270 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86,
/* 0x3280 */  50, 66, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3290 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 82, 86, 50,
/* 0x32a0 */  68,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x32b0 */  48, 48, 32, 78, 82, 86, 50, 68, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x32c0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x32d0 */  32, 32, 78, 82, 86, 50, 69,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x32e0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 78, 82, 86, 50, 69, 10, 48,
/* 0x32f0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3300 */ 108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 72, 69, 65,
/* 0x3310 */  68,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3320 */  48, 48, 32, 76, 90, 77, 65, 95, 72, 69, 65, 68, 10, 48, 48, 48,
/* 0x3330 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3340 */  32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48,
/* 0x3350 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3360 */  48, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48, 48, 10, 48, 48, 48,
/* 0x3370 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3380 */  32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48,
/* 0x3390 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x33a0 */  48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x33b0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x33c0 */  32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48,
/* 0x33d0 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x33e0 */  48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 50, 48, 10, 48, 48, 48,
/* 0x33f0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3400 */  32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48,
/* 0x3410 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3420 */  48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 10, 48, 48, 48,
/* 0x3430 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3440 */  32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 84, 65, 73, 76,  9,
/* 0x3450 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3460 */  32, 76, 90, 77, 65, 95, 84, 65, 73, 76, 10, 48, 48, 48, 48, 48,
/* 0x3470 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3480 */  32,100, 32, 32, 80, 69, 77, 65, 73, 78, 49, 48,  9, 48, 48, 48,
/* 0x3490 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69,
/* 0x34a0 */  77, 65, 73, 78, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x34b0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x34c0 */  80, 69, 84, 76, 83, 72, 65, 75, 50,  9, 48, 48, 48, 48, 48, 48,
/* 0x34d0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 84, 76, 83,
/* 0x34e0 */  72, 65, 75, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x34f0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69,
/* 0x3500 */  67, 84, 84, 80, 79, 83,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3510 */  48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 67, 84, 84, 80, 79, 83,
/* 0x3520 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3530 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 67, 84, 84, 78,
/* 0x3540 */  85, 76,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3550 */  48, 48, 48, 32, 80, 69, 67, 84, 84, 78, 85, 76, 10, 48, 48, 48,
/* 0x3560 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3570 */  32, 32, 32,100, 32, 32, 80, 69, 70, 73, 76, 84, 69, 82, 52, 57,
/* 0x3580 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3590 */  48, 32, 80, 69, 70, 73, 76, 84, 69, 82, 52, 57, 10, 48, 48, 48,
/* 0x35a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x35b0 */  32, 32, 32,100, 32, 32, 80, 69, 73, 77, 80, 79, 82, 84,  9, 48,
/* 0x35c0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x35d0 */  80, 69, 73, 77, 80, 79, 82, 84, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x35e0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x35f0 */  32, 32, 80, 69, 73, 66, 89, 79, 82, 68,  9, 48, 48, 48, 48, 48,
/* 0x3600 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 73, 66,
/* 0x3610 */  89, 79, 82, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3620 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69,
/* 0x3630 */  75, 51, 50, 79, 82, 68,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3640 */  48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 75, 51, 50, 79, 82, 68,
/* 0x3650 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3660 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 73, 77, 79, 82,
/* 0x3670 */  68, 49,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3680 */  48, 48, 48, 32, 80, 69, 73, 77, 79, 82, 68, 49, 10, 48, 48, 48,
/* 0x3690 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x36a0 */  32, 32, 32,100, 32, 32, 80, 69, 73, 77, 80, 79, 82, 50,  9, 48,
/* 0x36b0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x36c0 */  80, 69, 73, 77, 80, 79, 82, 50, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x36d0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x36e0 */  32, 32, 80, 69, 73, 69, 82, 68, 76, 76,  9, 48, 48, 48, 48, 48,
/* 0x36f0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 73, 69,
/* 0x3700 */  82, 68, 76, 76, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3710 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69,
/* 0x3720 */  73, 69, 82, 69, 88, 69,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3730 */  48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 73, 69, 82, 69, 88, 69,
/* 0x3740 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3750 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 73, 77, 68, 79,
/* 0x3760 */  78, 69,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3770 */  48, 48, 48, 32, 80, 69, 73, 77, 68, 79, 78, 69, 10, 48, 48, 48,
/* 0x3780 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3790 */  32, 32, 32,100, 32, 32, 80, 69, 82, 69, 76, 79, 67, 49,  9, 48,
/* 0x37a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x37b0 */  80, 69, 82, 69, 76, 79, 67, 49, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x37c0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x37d0 */  32, 32, 80, 69, 82, 69, 76, 79, 67, 50,  9, 48, 48, 48, 48, 48,
/* 0x37e0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 82, 69,
/* 0x37f0 */  76, 79, 67, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3800 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69,
/* 0x3810 */  82, 69, 76, 79, 67, 51,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3820 */  48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 82, 69, 76, 79, 67, 51,
/* 0x3830 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3840 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 82, 69, 76, 54, 52, 66,
/* 0x3850 */  73, 71,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3860 */  48, 48, 48, 32, 82, 69, 76, 54, 52, 66, 73, 71, 10, 48, 48, 48,
/* 0x3870 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3880 */  32, 32, 32,100, 32, 32, 82, 69, 76, 79, 67, 54, 52, 74,  9, 48,
/* 0x3890 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x38a0 */  82, 69, 76, 79, 67, 54, 52, 74, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x38b0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x38c0 */  32, 32, 80, 69, 82, 76, 79, 72, 73, 48,  9, 48, 48, 48, 48, 48,
/* 0x38d0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 82, 76,
/* 0x38e0 */  79, 72, 73, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x38f0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69,
/* 0x3900 */  82, 69, 76, 76, 79, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3910 */  48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 82, 69, 76, 76, 79, 48,
/* 0x3920 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3930 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 82, 69, 76, 72,
/* 0x3940 */  73, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3950 */  48, 48, 48, 32, 80, 69, 82, 69, 76, 72, 73, 48, 10, 48, 48, 48,
/* 0x3960 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3970 */  32, 32, 32,100, 32, 32, 80, 69, 68, 69, 80, 72, 65, 75,  9, 48,
/* 0x3980 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3990 */  80, 69, 68, 69, 80, 72, 65, 75, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x39a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x39b0 */  32, 32, 80, 69, 84, 76, 83, 67,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x39c0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 84, 76, 83, 67,
/* 0x39d0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x39e0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 77, 65, 73, 78,
/* 0x39f0 */  50, 48,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3a00 */  48, 48, 48, 32, 80, 69, 77, 65, 73, 78, 50, 48, 10, 48, 48, 48,
/* 0x3a10 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3a20 */  32, 32, 32,100, 32, 32, 67, 76, 69, 65, 82, 83, 84, 65, 67, 75,
/* 0x3a30 */   9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3a40 */  48, 32, 67, 76, 69, 65, 82, 83, 84, 65, 67, 75, 10, 48, 48, 48,
/* 0x3a50 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3a60 */  32, 32, 32,100, 32, 32, 80, 69, 73, 83, 68, 76, 76, 57,  9, 48,
/* 0x3a70 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3a80 */  80, 69, 73, 83, 68, 76, 76, 57, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3a90 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x3aa0 */  32, 32, 80, 69, 82, 69, 84, 85, 82, 78,  9, 48, 48, 48, 48, 48,
/* 0x3ab0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 82, 69,
/* 0x3ac0 */  84, 85, 82, 78, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3ad0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69,
/* 0x3ae0 */  68, 79, 74, 85, 77, 80,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3af0 */  48, 48, 48, 48, 48, 48, 48, 32, 80, 69, 68, 79, 74, 85, 77, 80,
/* 0x3b00 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3b10 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 85, 80, 88, 49, 72, 69,
/* 0x3b20 */  65, 68,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3b30 */  48, 48, 48, 32, 85, 80, 88, 49, 72, 69, 65, 68, 10, 48, 48, 48,
/* 0x3b40 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32,
/* 0x3b50 */  32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48,
/* 0x3b60 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,115,116, 97,
/* 0x3b70 */ 114,116, 95,111,102, 95, 99,111,109,112,114,101,115,115,101,100,
/* 0x3b80 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3b90 */  48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9,
/* 0x3ba0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3bb0 */  32,115,116, 97,114,116, 95,111,102, 95,117,110, 99,111,109,112,
/* 0x3bc0 */ 114,101,115,115,101,100, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3bd0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3be0 */  42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3bf0 */  48, 48, 48, 48, 48, 48, 32,105, 99,111,110, 95,111,102,102,115,
/* 0x3c00 */ 101,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3c10 */  48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68,
/* 0x3c20 */  42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3c30 */  48, 48, 32,105, 99,111,110, 95,100,101,108,116, 97, 10, 48, 48,
/* 0x3c40 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x3c50 */  32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48,
/* 0x3c60 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,116,108,
/* 0x3c70 */ 115, 95, 97,100,100,114,101,115,115, 10, 48, 48, 48, 48, 48, 48,
/* 0x3c80 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32,
/* 0x3c90 */  32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x3ca0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32,116,108,115, 95,118, 97,
/* 0x3cb0 */ 108,117,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3cc0 */  48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,
/* 0x3cd0 */  68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3ce0 */  48, 48, 48, 32,108,122,109, 97, 95,117, 95,108,101,110, 10, 48,
/* 0x3cf0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3d00 */  32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48,
/* 0x3d10 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x3d20 */ 122,109, 97, 95, 99, 95,108,101,110, 10, 48, 48, 48, 48, 48, 48,
/* 0x3d30 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32,
/* 0x3d40 */  32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x3d50 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32,102,105,108,116,101,114,
/* 0x3d60 */  95, 98,117,102,102,101,114, 95,115,116, 97,114,116, 10, 48, 48,
/* 0x3d70 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x3d80 */  32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48,
/* 0x3d90 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,102,105,
/* 0x3da0 */ 108,116,101,114, 95,108,101,110,103,116,104, 10, 48, 48, 48, 48,
/* 0x3db0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32,
/* 0x3dc0 */  32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48,
/* 0x3dd0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,102,105,108,116,
/* 0x3de0 */ 101,114, 95, 99,116,111, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3df0 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3e00 */  42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3e10 */  48, 48, 48, 48, 48, 48, 32, 99,111,109,112,114,101,115,115,101,
/* 0x3e20 */ 100, 95,105,109,112,111,114,116,115, 10, 48, 48, 48, 48, 48, 48,
/* 0x3e30 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32,
/* 0x3e40 */  32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x3e50 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32,115,116, 97,114,116, 95,
/* 0x3e60 */ 111,102, 95,105,109,112,111,114,116,115, 10, 48, 48, 48, 48, 48,
/* 0x3e70 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32,
/* 0x3e80 */  32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48,
/* 0x3e90 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 76,111, 97,100, 76,
/* 0x3ea0 */ 105, 98,114, 97,114,121, 65, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3eb0 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x3ec0 */  32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3ed0 */  48, 48, 48, 48, 48, 48, 48, 32,107,101,114,110,101,108, 51, 50,
/* 0x3ee0 */  95,111,114,100,105,110, 97,108,115, 10, 48, 48, 48, 48, 48, 48,
/* 0x3ef0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32,
/* 0x3f00 */  32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48,
/* 0x3f10 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 71,101,116, 80,114,111,
/* 0x3f20 */  99, 65,100,100,114,101,115,115, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3f30 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32,
/* 0x3f40 */  32, 32, 42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3f50 */  48, 48, 48, 48, 48, 48, 48, 48, 32, 69,120,105,116, 80,114,111,
/* 0x3f60 */  99,101,115,115, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3f70 */  48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85,
/* 0x3f80 */  78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3f90 */  48, 48, 48, 48, 32,115,116, 97,114,116, 95,111,102, 95,114,101,
/* 0x3fa0 */ 108,111, 99,115, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3fb0 */  48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85,
/* 0x3fc0 */  78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3fd0 */  48, 48, 48, 48, 32,114,101,108,111, 99, 95,100,101,108,116, 10,
/* 0x3fe0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3ff0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48,
/* 0x4000 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4010 */  86,105,114,116,117, 97,108, 80,114,111,116,101, 99,116, 10, 48,
/* 0x4020 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4030 */  32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48,
/* 0x4040 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,118,
/* 0x4050 */ 112, 95, 98, 97,115,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4060 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4070 */  42, 85, 78, 68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4080 */  48, 48, 48, 48, 48, 48, 32,118,112, 95,115,105,122,101, 10, 48,
/* 0x4090 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x40a0 */  32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,  9, 48, 48,
/* 0x40b0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 32,115,
/* 0x40c0 */ 119,114,105, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x40d0 */  48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,
/* 0x40e0 */  68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x40f0 */  48, 48, 48, 32,116,108,115, 95,109,111,100,117,108,101, 95, 98,
/* 0x4100 */  97,115,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4110 */  48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,
/* 0x4120 */  68, 42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4130 */  48, 48, 48, 32,111,114,105,103,105,110, 97,108, 95,101,110,116,
/* 0x4140 */ 114,121, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4150 */  48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68,
/* 0x4160 */  42,  9, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4170 */  48, 48, 32,116,108,115, 95, 99, 97,108,108, 98, 97, 99,107,115,
/* 0x4180 */  95,112,116,114, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x4190 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69,
/* 0x41a0 */  73, 83, 68, 76, 76, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x41b0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x41c0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x41d0 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x41e0 */  48, 53, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50,
/* 0x41f0 */  32, 32, 32, 32, 32, 80, 69, 77, 65, 73, 78, 50, 49, 45, 48,120,
/* 0x4200 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52,
/* 0x4210 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x4220 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 77, 65, 73, 78,
/* 0x4230 */  48, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32,
/* 0x4240 */  32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x4250 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x4260 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55, 32, 82,
/* 0x4270 */  95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32,
/* 0x4280 */  32,115,116, 97,114,116, 95,111,102, 95, 99,111,109,112,114,101,
/* 0x4290 */ 115,115,101,100, 45, 48,120, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x42a0 */  48, 48, 48, 48, 48, 48, 52, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x42b0 */  48, 48, 48, 48, 48, 48, 48,101, 32, 82, 95, 88, 56, 54, 95, 54,
/* 0x42c0 */  52, 95, 51, 50, 83, 32, 32, 32, 32, 32, 32,115,116, 97,114,116,
/* 0x42d0 */  95,111,102, 95,117,110, 99,111,109,112,114,101,115,115,101,100,
/* 0x42e0 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x42f0 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 73, 67, 79, 78,
/* 0x4300 */  83, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32,
/* 0x4310 */  32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x4320 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x4330 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82,
/* 0x4340 */  95, 88, 56, 54, 95, 54, 52, 95, 51, 50, 83, 32, 32, 32, 32, 32,
/* 0x4350 */  32,105, 99,111,110, 95,111,102,102,115,101,116, 10, 10, 82, 69,
/* 0x4360 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x4370 */  32, 70, 79, 82, 32, 91, 80, 69, 73, 67, 79, 78, 83, 50, 93, 58,
/* 0x4380 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4390 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x43a0 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x43b0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 88, 56, 54,
/* 0x43c0 */  95, 54, 52, 95, 51, 50, 83, 32, 32, 32, 32, 32, 32,105, 99,111,
/* 0x43d0 */ 110, 95,111,102,102,115,101,116, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x43e0 */  48, 48, 48, 48, 48, 48, 48, 48, 55, 32, 82, 95, 88, 56, 54, 95,
/* 0x43f0 */  54, 52, 95, 49, 54, 32, 32, 32, 32, 32, 32, 32,105, 99,111,110,
/* 0x4400 */  95,100,101,108,116, 97, 43, 48,120, 48, 48, 48, 48, 48, 48, 48,
/* 0x4410 */  48, 48, 48, 48, 48, 56, 48, 48, 48, 10, 10, 82, 69, 76, 79, 67,
/* 0x4420 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x4430 */  82, 32, 91, 80, 69, 84, 76, 83, 72, 65, 75, 93, 58, 10, 79, 70,
/* 0x4440 */  70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84,
/* 0x4450 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4460 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4470 */  48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 88, 56, 54, 95, 54, 52,
/* 0x4480 */  95, 51, 50, 83, 32, 32, 32, 32, 32, 32,116,108,115, 95, 97,100,
/* 0x4490 */ 100,114,101,115,115, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x44a0 */  48, 48, 48, 48, 48, 98, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95,
/* 0x44b0 */  51, 50, 32, 32, 32, 32, 32, 32, 32,116,108,115, 95,118, 97,108,
/* 0x44c0 */ 117,101, 43, 48,120, 48, 48, 48, 48, 48, 48, 48, 48, 56, 48, 48,
/* 0x44d0 */  48, 48, 48, 48, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x44e0 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,
/* 0x44f0 */  82, 86, 50, 66, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x4500 */  32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x4510 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x4520 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55,100,
/* 0x4530 */  32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32,
/* 0x4540 */  32, 32, 32, 78, 82, 86, 95, 72, 69, 65, 68, 43, 48,120, 48, 48,
/* 0x4550 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 98, 10, 10,
/* 0x4560 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x4570 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 82, 86, 50, 68, 93, 58, 10,
/* 0x4580 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4590 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x45a0 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x45b0 */  48, 48, 48, 48, 48, 48, 48, 56, 56, 32, 82, 95, 88, 56, 54, 95,
/* 0x45c0 */  54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 78, 82, 86, 95,
/* 0x45d0 */  72, 69, 65, 68, 43, 48,120, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x45e0 */  48, 48, 48, 48, 48, 49, 98, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x45f0 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x4600 */  91, 78, 82, 86, 50, 69, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x4610 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x4620 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x4630 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4640 */  97, 49, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50,
/* 0x4650 */  32, 32, 32, 32, 32, 78, 82, 86, 95, 72, 69, 65, 68, 43, 48,120,
/* 0x4660 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 98,
/* 0x4670 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x4680 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90, 77, 65, 95, 72,
/* 0x4690 */  69, 65, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32,
/* 0x46a0 */  32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x46b0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x46c0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 32,
/* 0x46d0 */  82, 95, 88, 56, 54, 95, 54, 52, 95, 51, 50, 32, 32, 32, 32, 32,
/* 0x46e0 */  32, 32,108,122,109, 97, 95,117, 95,108,101,110, 43, 48,120, 48,
/* 0x46f0 */  48, 48, 48, 48, 48, 48, 48, 56, 48, 48, 48, 48, 48, 48, 48, 10,
/* 0x4700 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 48,
/* 0x4710 */  32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 51, 50, 32, 32, 32, 32,
/* 0x4720 */  32, 32, 32,108,122,109, 97, 95, 99, 95,108,101,110, 43, 48,120,
/* 0x4730 */  48, 48, 48, 48, 48, 48, 48, 48, 56, 48, 48, 48, 48, 48, 48, 48,
/* 0x4740 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x4750 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 67, 84, 84, 80,
/* 0x4760 */  79, 83, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32,
/* 0x4770 */  32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x4780 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x4790 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82,
/* 0x47a0 */  95, 88, 56, 54, 95, 54, 52, 95, 51, 50, 83, 32, 32, 32, 32, 32,
/* 0x47b0 */  32,102,105,108,116,101,114, 95, 98,117,102,102,101,114, 95,115,
/* 0x47c0 */ 116, 97,114,116, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x47d0 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69,
/* 0x47e0 */  70, 73, 76, 84, 69, 82, 52, 57, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x47f0 */  84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69,
/* 0x4800 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x4810 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4820 */  48, 48, 48, 55, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 51, 50,
/* 0x4830 */  83, 32, 32, 32, 32, 32, 32,102,105,108,116,101,114, 95,108,101,
/* 0x4840 */ 110,103,116,104, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4850 */  48, 48, 48, 48, 99, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 56,
/* 0x4860 */  32, 32, 32, 32, 32, 32, 32, 32,102,105,108,116,101,114, 95, 99,
/* 0x4870 */ 116,111, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x4880 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 73, 77,
/* 0x4890 */  80, 79, 82, 84, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x48a0 */  32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x48b0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x48c0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 55,
/* 0x48d0 */  32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 51, 50, 83, 32, 32, 32,
/* 0x48e0 */  32, 32, 32, 99,111,109,112,114,101,115,115,101,100, 95,105,109,
/* 0x48f0 */ 112,111,114,116,115, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4900 */  48, 48, 48, 48, 49, 48, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95,
/* 0x4910 */  80, 67, 56, 32, 32, 32, 32, 32, 32,105,109,112,111,114,116,115,
/* 0x4920 */  95,100,111,110,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4930 */  48, 48, 48, 48, 49, 56, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95,
/* 0x4940 */  51, 50, 83, 32, 32, 32, 32, 32, 32,115,116, 97,114,116, 95,111,
/* 0x4950 */ 102, 95,105,109,112,111,114,116,115, 10, 48, 48, 48, 48, 48, 48,
/* 0x4960 */  48, 48, 48, 48, 48, 48, 48, 48, 50, 53, 32, 82, 95, 88, 56, 54,
/* 0x4970 */  95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 76,111, 97,
/* 0x4980 */ 100, 76,105, 98,114, 97,114,121, 65, 45, 48,120, 48, 48, 48, 48,
/* 0x4990 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 10, 10, 82, 69,
/* 0x49a0 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x49b0 */  32, 70, 79, 82, 32, 91, 80, 69, 73, 66, 89, 79, 82, 68, 93, 58,
/* 0x49c0 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x49d0 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x49e0 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x49f0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 88, 56, 54,
/* 0x4a00 */  95, 54, 52, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 98,121,110,
/* 0x4a10 */  97,109,101, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x4a20 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 75,
/* 0x4a30 */  51, 50, 79, 82, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x4a40 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x4a50 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x4a60 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4a70 */  99, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 51, 50, 83, 32, 32,
/* 0x4a80 */  32, 32, 32, 32,107,101,114,110,101,108, 51, 50, 95,111,114,100,
/* 0x4a90 */ 105,110, 97,108,115, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4aa0 */  48, 48, 48, 48, 49, 49, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95,
/* 0x4ab0 */  80, 67, 56, 32, 32, 32, 32, 32, 32,110,101,120,116, 95,105,109,
/* 0x4ac0 */ 112, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x4ad0 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 73, 77, 79,
/* 0x4ae0 */  82, 68, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32,
/* 0x4af0 */  32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x4b00 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x4b10 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 57, 32,
/* 0x4b20 */  82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 56, 32, 32, 32, 32,
/* 0x4b30 */  32, 32,102,105,114,115,116, 95,105,109,112, 10, 10, 82, 69, 76,
/* 0x4b40 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x4b50 */  70, 79, 82, 32, 91, 80, 69, 73, 77, 80, 79, 82, 50, 93, 58, 10,
/* 0x4b60 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4b70 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4b80 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4b90 */  48, 48, 48, 48, 48, 48, 48, 48,102, 32, 82, 95, 88, 56, 54, 95,
/* 0x4ba0 */  54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 71,101,116, 80,
/* 0x4bb0 */ 114,111, 99, 65,100,100,114,101,115,115, 45, 48,120, 48, 48, 48,
/* 0x4bc0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52, 10, 48, 48,
/* 0x4bd0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50, 48, 32, 82,
/* 0x4be0 */  95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x4bf0 */  32,110,101,120,116, 95,102,117,110, 99, 10, 10, 82, 69, 76, 79,
/* 0x4c00 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x4c10 */  79, 82, 32, 91, 80, 69, 73, 69, 82, 69, 88, 69, 93, 58, 10, 79,
/* 0x4c20 */  70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4c30 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4c40 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4c50 */  48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 88, 56, 54, 95, 54,
/* 0x4c60 */  52, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 69,120,105,116, 80,
/* 0x4c70 */ 114,111, 99,101,115,115, 45, 48,120, 48, 48, 48, 48, 48, 48, 48,
/* 0x4c80 */  48, 48, 48, 48, 48, 48, 48, 48, 52, 10, 10, 82, 69, 76, 79, 67,
/* 0x4c90 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x4ca0 */  82, 32, 91, 80, 69, 82, 69, 76, 79, 67, 49, 93, 58, 10, 79, 70,
/* 0x4cb0 */  70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84,
/* 0x4cc0 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4cd0 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4ce0 */  48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 88, 56, 54, 95, 54, 52,
/* 0x4cf0 */  95, 51, 50, 83, 32, 32, 32, 32, 32, 32,115,116, 97,114,116, 95,
/* 0x4d00 */ 111,102, 95,114,101,108,111, 99,115, 10, 10, 82, 69, 76, 79, 67,
/* 0x4d10 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x4d20 */  82, 32, 91, 80, 69, 82, 69, 76, 79, 67, 51, 93, 58, 10, 79, 70,
/* 0x4d30 */  70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84,
/* 0x4d40 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4d50 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4d60 */  48, 48, 48, 48, 48, 48,101, 32, 82, 95, 88, 56, 54, 95, 54, 52,
/* 0x4d70 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32,114,101,108,111, 99, 95,
/* 0x4d80 */ 101,110,100,120, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x4d90 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 82, 69,
/* 0x4da0 */  76, 54, 52, 66, 73, 71, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x4db0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x4dc0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x4dd0 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4de0 */  48, 51, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 56, 32,
/* 0x4df0 */  32, 32, 32, 32, 32,114,101,108,111, 99, 95, 97,100,100, 10, 10,
/* 0x4e00 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x4e10 */  68, 83, 32, 70, 79, 82, 32, 91, 82, 69, 76, 79, 67, 54, 52, 74,
/* 0x4e20 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32, 32, 32,
/* 0x4e30 */  32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4e40 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x4e50 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 88,
/* 0x4e60 */  56, 54, 95, 54, 52, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,114,
/* 0x4e70 */ 101,108,111, 99, 95, 97,100,100, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x4e80 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x4e90 */  32, 91, 80, 69, 82, 76, 79, 72, 73, 48, 93, 58, 10, 79, 70, 70,
/* 0x4ea0 */  83, 69, 84, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89,
/* 0x4eb0 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4ec0 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4ed0 */  48, 48, 48, 48, 48, 54, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95,
/* 0x4ee0 */  51, 50, 83, 32, 32, 32, 32, 32, 32,114,101,108,111, 99, 95,100,
/* 0x4ef0 */ 101,108,116, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x4f00 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 68,
/* 0x4f10 */  69, 80, 72, 65, 75, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x4f20 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x4f30 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x4f40 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4f50 */  51, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32,
/* 0x4f60 */  32, 32, 32, 32, 86,105,114,116,117, 97,108, 80,114,111,116,101,
/* 0x4f70 */  99,116, 45, 48,120, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4f80 */  48, 48, 48, 48, 52, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4f90 */  48, 48, 48, 48, 48, 97, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95,
/* 0x4fa0 */  51, 50, 83, 32, 32, 32, 32, 32, 32,118,112, 95, 98, 97,115,101,
/* 0x4fb0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4fc0 */ 102, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 51, 50, 32, 32, 32,
/* 0x4fd0 */  32, 32, 32, 32,118,112, 95,115,105,122,101, 43, 48,120, 48, 48,
/* 0x4fe0 */  48, 48, 48, 48, 48, 48, 56, 48, 48, 48, 48, 48, 48, 48, 10, 48,
/* 0x4ff0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 50, 99, 32,
/* 0x5000 */  82, 95, 88, 56, 54, 95, 54, 52, 95, 51, 50, 83, 32, 32, 32, 32,
/* 0x5010 */  32, 32,115,119,114,105, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x5020 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x5030 */  80, 69, 84, 76, 83, 67, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x5040 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x5050 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x5060 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5070 */  48, 50, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50,
/* 0x5080 */  32, 32, 32, 32, 32, 80, 69, 84, 76, 83, 67, 50, 45, 48,120, 48,
/* 0x5090 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 53, 10,
/* 0x50a0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 97,
/* 0x50b0 */  32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 51, 50, 83, 32, 32, 32,
/* 0x50c0 */  32, 32, 32,116,108,115, 95,109,111,100,117,108,101, 95, 98, 97,
/* 0x50d0 */ 115,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x50e0 */  48, 49, 54, 32, 82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51,
/* 0x50f0 */  50, 32, 32, 32, 32, 32, 80, 69, 84, 76, 83, 67, 50, 45, 48,120,
/* 0x5100 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 52,
/* 0x5110 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x5120 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 68, 79, 74, 85,
/* 0x5130 */  77, 80, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32, 32,
/* 0x5140 */  32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x5150 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x5160 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82,
/* 0x5170 */  95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32, 32,
/* 0x5180 */  32,111,114,105,103,105,110, 97,108, 95,101,110,116,114,121, 45,
/* 0x5190 */  48,120, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x51a0 */  48, 52, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x51b0 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 84, 76,
/* 0x51c0 */  83, 67, 50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 32,
/* 0x51d0 */  32, 32, 32, 32, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x51e0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x51f0 */  48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 53, 32,
/* 0x5200 */  82, 95, 88, 56, 54, 95, 54, 52, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x5210 */  32, 32,116,108,115, 95, 99, 97,108,108, 98, 97, 99,107,115, 95,
/* 0x5220 */ 112,116,114, 45, 48,120, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x5230 */  48, 48, 48, 48, 48, 52, 10
};
