---
myst:
  html_meta:
    keywords: LaTeX, composition, flottants, positionnement
---

# Comment est géré le positionnement des flottants ?

## Avec les commandes de base

Les environnements `figure` et `table` admettent un argument optionnel, 
qui indique les placements *acceptés* pour la figure ou le tableau. 
Cet argument est composé des symboles suivants :

- `h` (pour *here*, ici) qui désigne l'emplacement courant dans le texte ;
- `t` (pour *top*, en haut) qui désigne le haut de la page courante ;
- `b` (pour *bottom*, en bas) qui désigne le bas de la page courante ;
- `p` (pour page) qui désigne une page dédiée pour la figure ou la table ;
- `!` afin d'indiquer à LaTeX de ne pas tenir compte des limites imposées 
  sur le nombre de flottants par page (voir la question 
  "[](/3_composition/flottants/positionnement/modifier_le_nombre_de_flottants_par_page)").

Voici un exemple de code où l'utilisateur souhaite avoir sa figure placée 
de préférence en haut de page ou sur une page dédiée, sans être trop limité
par les contraintes de nombre de flottants par page :

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
Bien que le texte précède la figure dans le code source, cette dernière
va se positionner au dessus de notre texte dans le document final,
respectant ainsi notre demande de positionnement \texttt{tp!} de ce flottant.
\begin{figure}[tp!]           % L'argument détaillé ci-dessus
\centering                    % Pour centrer la figure
\framebox{\Huge AAAAAAaaaaaaaaaaahh !}
\caption{Beaucoup de bruit pour rien}
\end{figure}
\end{document}
```

Suivant les différents placements possibles, LaTeX s'arrange pour satisfaire
la demande (l'ordre des lettres `h`, `t`, `b` ou `p` n'a pas d'importance). 
L'algorithme de placement des flottants est très compliqué : la réalité
 ne reflète pas exactement ce qui est décrit ci-dessus.


## Avec l'extension <ctanpkg:float>

L'extension <ctanpkg:float> propose une option de placement supplémentaire, 
`H`, qui *force* le placement du flottant à l'endroit où il est inséré 
dans le source du document. Cette option est décrite à la question 
"[](/3_composition/flottants/positionnement/forcer_la_position_d_un_flottant2)".