---
myst:
  html_meta:
    keywords: LaTeX, composition, annexes, tables des matières,
              sommaire
---

# Comment faire si les numéros dépassent de la table des matières ?

LaTeX construit la table des matières, la liste des figures, des tableaux
et les éventuelles autres tables du même genre, sur la base d'une mise en page
définie dans la classe. Par conséquent, elles ne s'adaptent *pas* à la taille
des éléments qu'elles contiennent, comme elles le feraient si elles utilisaient
un environnement `tabular` ou équivalent.

Cette implémentation peut causer des problèmes, notamment quand le document 
comporte des imbrications profondes de sections ou des numéros de page 
très grands : les numéros en question ne rentrent tout simplement pas 
dans l'espace qui leur est alloué dans la classe.


## Avec des changements de style de la table des matières

La question 
"[](/3_composition/annexes/tables/changer_le_style_de_la_table_des_matieres)"
propose des méthodes qui répondent à ce besoin. Par exemple, avec l'utilisation
de l'extension <ctanpkg:tocloft> :

```{noedit}
\setlength\cftsectionnumwidth{4em}
```


## Avec la classe <ctanpkg:memoir>

La commande ci-dessus peut être utilisée dans les documents composés 
avec la classe <ctanpkg:memoir> (de Peter R. Wilson, l'auteur de 
<ctanpkg:tocloft>). Mais cette classe propose également un autre mécanisme 
pour atteindre cet objectif :

```{noedit}
\cftsetindents{⟨niveau⟩}{⟨indentation⟩}{⟨largeur⟩}
```

Dans le détail :

- `⟨niveau⟩` vaut `chapter`, `section` ou autre ;
- `⟨indentation⟩` spécifie la "marge" avant le début de l'entrée ;
- `⟨largeur⟩` est la largeur de la boîte dans laquelle le numéro sera inséré 
  (elle doit donc être suffisamment grande pour le plus grand numéro, 
  avec l'espacement nécessaire pour le séparer de ce qui le suit 
  dans la ligne).


:::{sources}
[Numbers too large in table of contents, etc.](faquk:FAQ-tocloftwrong)
:::