# 2025-02-25 Triage Log

Fairly quiet week with the exception of an improvement to the very often used Iter::next function which can now be inlined leading to a myriad of performance improvements.

Triage done by **@rylev**.
Revision range: [ce36a966..f5729cfe](https://perf.rust-lang.org/?start=ce36a966c79e109dabeef7a47fe68e5294c6d71e&end=f5729cfed3c45e061e8a443677fc1d5ef9277df7&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.2%, 1.0%]   | 37    |
| Regressions ❌ <br /> (secondary)  | 0.7%  | [0.2%, 8.6%]   | 54    |
| Improvements ✅ <br /> (primary)   | -0.5% | [-1.4%, -0.1%] | 88    |
| Improvements ✅ <br /> (secondary) | -0.6% | [-2.3%, -0.1%] | 87    |
| All ❌✅ (primary)                 | -0.2% | [-1.4%, 1.0%]  | 125   |


1 Regression, 1 Improvement, 7 Mixed; 2 of them in rollups
40 artifact comparisons made in total

#### Regressions

Remove `NtVis` and `NtTy` [#133436](https://github.com/rust-lang/rust/pull/133436) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=b87eda7fdf8034c52b3abef52b443b8573484eda&end=b6d3be4948e92fce0236cbbe22b55c55f6950269&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4% | [0.2%, 1.0%] | 18    |
| Regressions ❌ <br /> (secondary)  | 0.6% | [0.3%, 0.9%] | 11    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 0.4% | [0.2%, 1.0%] | 18    |
- [Necessary perf hit](https://github.com/rust-lang/rust/pull/133436#issuecomment-2502075751)


#### Improvements

librustdoc: Use `pulldown-cmark-escape` for HTML escaping [#137285](https://github.com/rust-lang/rust/pull/137285) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e0be1a02626abef2878cb7f4aaef7ae409477112&end=f43e549b88698568581a9d329c7582e3708ac187&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.6%, -0.2%] | 14    |
| Improvements ✅ <br /> (secondary) | -0.5% | [-1.5%, -0.1%] | 5     |
| All ❌✅ (primary)                 | -0.3% | [-0.6%, -0.2%] | 14    |


#### Mixed

improve cold_path() [#133852](https://github.com/rust-lang/rust/pull/133852) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=aaa861493456e8a10e552dd208f85486de772007&end=3b022d8ceea570db9730be34d964f0cc663a567f&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.1%, 0.9%]   | 7     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.7% | [-0.7%, -0.7%] | 1     |
| Improvements ✅ <br /> (secondary) | -     | -              | 0     |
| All ❌✅ (primary)                 | 0.2%  | [-0.7%, 0.9%]  | 8     |
- Expected perf regressions that were [deemed worth it](https://github.com/rust-lang/rust/pull/133852#issuecomment-2657312984)


Rollup of 9 pull requests [#137295](https://github.com/rust-lang/rust/pull/137295) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=4e1356b95972c1a52acb9f0dd078687132ec02be&end=6d3c050de81c8858e28b0e59cc9398d840edfbff&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 1.0%  | [1.0%, 1.0%]   | 1     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.3% | [-0.3%, -0.3%] | 1     |
| All ❌✅ (primary)                 | -     | -              | 0     |
- Perf results are too small for this to be worth investigating.


Emit `trunc nuw` for unchecked shifts and `to_immediate_scalar` [#137058](https://github.com/rust-lang/rust/pull/137058) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=eeb9035117dc85fa4abe8e2abb09285fd65b0263&end=c62239aeb3ba7781a6d7f7055523c1e8c22b409c&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 0.7%  | [0.4%, 1.3%]   | 16    |
| Improvements ✅ <br /> (primary)   | -0.5% | [-0.8%, -0.4%] | 4     |
| Improvements ✅ <br /> (secondary) | -0.1% | [-0.1%, -0.1%] | 1     |
| All ❌✅ (primary)                 | -0.5% | [-0.8%, -0.4%] | 4     |
- Usually small changes in stress tests don't necessarily lead to perf investigations.
- Asked the author for insight on whether this is worth investigating.


Simplify `slice::Iter::next` enough that it inlines [#136771](https://github.com/rust-lang/rust/pull/136771) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=28b83ee59698ae069f5355b8e03f976406f410f5&end=f04bbc60f8c353ee5ba0677bc583ac4a88b2c180&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.4%, 0.4%]   | 2     |
| Regressions ❌ <br /> (secondary)  | 8.8%  | [8.8%, 8.8%]   | 1     |
| Improvements ✅ <br /> (primary)   | -0.4% | [-1.4%, -0.1%] | 123   |
| Improvements ✅ <br /> (secondary) | -0.5% | [-2.3%, -0.1%] | 70    |
| All ❌✅ (primary)                 | -0.4% | [-1.4%, 0.4%]  | 125   |
- Perf improvements vastly outweigh the regressions


Update host LLVM to 20.1 on CI [#137189](https://github.com/rust-lang/rust/pull/137189) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=46420c96070b4c4bd8242f16d5806b8f26a57016&end=07697360aee0cebcb4e304236ba1884d8dde5469&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.1%  | [0.1%, 0.1%]   | 1     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.3% | [-0.3%, -0.2%] | 7     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.4%, -0.4%] | 1     |
| All ❌✅ (primary)                 | -0.2% | [-0.3%, 0.1%]  | 8     |
- This is actually quite small perf difference for an LLVM change


New attribute parsing infrastructure [#135726](https://github.com/rust-lang/rust/pull/135726) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=617aad8c2e8783f6df8e5d1f8bb1e4bcdc70aa7b&end=7d8c6e781d347e087c7d30ea393d7dcd725ed623&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.4%  | [0.2%, 0.8%]   | 38    |
| Regressions ❌ <br /> (secondary)  | 0.6%  | [0.3%, 1.3%]   | 43    |
| Improvements ✅ <br /> (primary)   | -4.1% | [-4.1%, -4.1%] | 1     |
| Improvements ✅ <br /> (secondary) | -0.7% | [-2.4%, -0.3%] | 8     |
| All ❌✅ (primary)                 | 0.3%  | [-4.1%, 0.8%]  | 39    |
- See [here](https://github.com/rust-lang/rust/pull/137610#issuecomment-2682489608) for explanation for why there was a perf regression here. 


Rollup of 11 pull requests [#137573](https://github.com/rust-lang/rust/pull/137573) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=7d8c6e781d347e087c7d30ea393d7dcd725ed623&end=f5729cfed3c45e061e8a443677fc1d5ef9277df7&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 0.5%  | [0.3%, 0.7%]   | 3     |
| Regressions ❌ <br /> (secondary)  | 1.0%  | [1.0%, 1.0%]   | 1     |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.4%, -0.4%] | 1     |
| All ❌✅ (primary)                 | 0.5%  | [0.3%, 0.7%]   | 3     |
- Results are too small to warrant an investigation.

