% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date.R
\name{date_leap_year}
\alias{date_leap_year}
\title{Is the year a leap year?}
\usage{
date_leap_year(x)
}
\arguments{
\item{x}{\verb{[Date / POSIXct / POSIXlt]}

A date or date-time to detect leap years in.}
}
\value{
A logical vector the same size as \code{x}. Returns \code{TRUE} if in a leap
year, \code{FALSE} if not in a leap year, and \code{NA} if \code{x} is \code{NA}.
}
\description{
\code{date_leap_year()} detects if the year is a leap year.
}
\examples{
x <- as.Date("2019-01-01")
x <- add_years(x, 0:5)
date_leap_year(x)

y <- as.POSIXct("2019-01-01", "America/New_York")
y <- add_years(y, 0:5)
date_leap_year(y)
}
