
// pybind 11 related includes
#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

namespace py = pybind11;


// Standard Handle
#include <Standard_Handle.hxx>

// user-defined inclusion per module before includes

// includes to resolve forward declarations
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom2d_BezierCurve.hxx>
#include <Geom2d_BSplineCurve.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom2d_BezierCurve.hxx>
#include <Geom2d_BSplineCurve.hxx>
#include <Adaptor3d_Curve.hxx>
#include <Adaptor3d_Surface.hxx>
#include <Geom2d_BezierCurve.hxx>
#include <Geom2d_BSplineCurve.hxx>

// module includes
#include <Adaptor2d_Curve2d.hxx>
#include <Adaptor2d_Line2d.hxx>
#include <Adaptor2d_OffsetCurve.hxx>

// template related includes


// user-defined pre
#include "OCP_specific.inc"

// user-defined inclusion per module

// Module definiiton
void register_Adaptor2d_enums(py::module &main_module) {


py::module m = main_module.def_submodule("Adaptor2d", R"#()#");

// add namespaces as submodules

// user-defined inclusion per module in the body

// enums

//Python trampoline classes

// pre-register typdefs+classes (topologically sorted)
    py::class_<Adaptor2d_Curve2d ,opencascade::handle<Adaptor2d_Curve2d>  , Standard_Transient >(m,"Adaptor2d_Curve2d",R"#(Root class for 2D curves on which geometric algorithms work. An adapted curve is an interface between the services provided by a curve, and those required of the curve by algorithms, which use it. A derived concrete class is provided: Geom2dAdaptor_Curve for a curve from the Geom2d package.Root class for 2D curves on which geometric algorithms work. An adapted curve is an interface between the services provided by a curve, and those required of the curve by algorithms, which use it. A derived concrete class is provided: Geom2dAdaptor_Curve for a curve from the Geom2d package.Root class for 2D curves on which geometric algorithms work. An adapted curve is an interface between the services provided by a curve, and those required of the curve by algorithms, which use it. A derived concrete class is provided: Geom2dAdaptor_Curve for a curve from the Geom2d package.)#");
    py::class_<Adaptor2d_Line2d ,opencascade::handle<Adaptor2d_Line2d>  , Adaptor2d_Curve2d >(m,"Adaptor2d_Line2d",R"#(Use by the TopolTool to trim a surface.Use by the TopolTool to trim a surface.)#");
    py::class_<Adaptor2d_OffsetCurve ,opencascade::handle<Adaptor2d_OffsetCurve>  , Adaptor2d_Curve2d >(m,"Adaptor2d_OffsetCurve",R"#(Defines an Offset curve (algorithmic 2d curve).Defines an Offset curve (algorithmic 2d curve).)#");

};

// user-defined post-inclusion per module

// user-defined post
