/* This file is for testing the cumulative include */
#ifndef __cplusplus
#	include <stdlib.h>
#else
#	include <cstdlib>
#endif
#include <libHX.h>
#include <libHX/endian.h>
#include <libHX/endian_float.h>

#define ZZ 64

int main(void)
{
	unsigned long long bmllong[HXbitmap_size(unsigned long long, 256)] = {0};
	unsigned long bmlong[HXbitmap_size(unsigned long, 256)] = {0};
	unsigned int bmint[HXbitmap_size(unsigned int, 256)] = {0};
	unsigned short bmshort[HXbitmap_size(unsigned short, 256)] = {0};
	unsigned char bmchar[HXbitmap_size(unsigned char, 256)] = {0};

	if (HX_init() <= 0)
		return EXIT_FAILURE;
	printf("sizeof bmllong:\t%" HX_SIZET_FMT "u, array_size: %" HX_SIZET_FMT "u\n",
	       sizeof(bmllong), ARRAY_SIZE(bmllong));
	printf("sizeof bmlong:\t%" HX_SIZET_FMT "u, array_size: %" HX_SIZET_FMT "u\n",
	       sizeof(bmlong), ARRAY_SIZE(bmlong));
	printf("sizeof bmint:\t%" HX_SIZET_FMT "u, array_size: %" HX_SIZET_FMT "u\n",
	       sizeof(bmint), ARRAY_SIZE(bmint));
	printf("sizeof bmshort:\t%" HX_SIZET_FMT "u, array_size: %" HX_SIZET_FMT "u\n",
	       sizeof(bmshort), ARRAY_SIZE(bmshort));
	printf("sizeof bmchar:\t%" HX_SIZET_FMT "u, array_size: %" HX_SIZET_FMT "u\n",
	       sizeof(bmchar), ARRAY_SIZE(bmchar));
	HXbitmap_set(bmllong, 255);
	HXbitmap_set(bmlong, 255);
	HXbitmap_set(bmint, 255);
	HXbitmap_set(bmshort, 255);
	HXbitmap_set(bmchar, 255);
	printf(HX_STRINGIFY(1234+2 +2) "," HX_STRINGIFY(ZZ) "\n");
	HX_exit();
	return EXIT_SUCCESS;
}
