; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -S -mtriple=amdgcn-amd-amdhsa -passes=instcombine %s | FileCheck %s

; Check that `select B, true, C` isn't optimized to `or B, C`,
; because the invalid addrspacecast %asc.shared introduces poison.
define i1 @not_fold_select(ptr addrspace(1) noundef %x) {
; CHECK-LABEL: define i1 @not_fold_select(
; CHECK-SAME: ptr addrspace(1) noundef [[X:%.*]]) {
; CHECK-NEXT:  [[ENTRY:.*:]]
; CHECK-NEXT:    [[TMP0:%.*]] = addrspacecast ptr addrspace(1) [[X]] to ptr
; CHECK-NEXT:    [[TMP1:%.*]] = tail call i1 @llvm.amdgcn.is.shared(ptr [[TMP0]])
; CHECK-NEXT:    [[TMP2:%.*]] = addrspacecast ptr addrspace(1) [[X]] to ptr addrspace(3)
; CHECK-NEXT:    [[TMP3:%.*]] = icmp eq ptr addrspace(3) [[TMP2]], null
; CHECK-NEXT:    [[NOT_IS_SHARED:%.*]] = xor i1 [[TMP1]], true
; CHECK-NEXT:    [[TMP4:%.*]] = select i1 [[NOT_IS_SHARED]], i1 true, i1 [[TMP3]]
; CHECK-NEXT:    ret i1 [[TMP4]]
;
  entry:
  %asc.flat = addrspacecast ptr addrspace(1) %x to ptr
  %is.shared = tail call i1 @llvm.amdgcn.is.shared(ptr %asc.flat)
  %asc.shared = addrspacecast ptr %asc.flat to ptr addrspace(3)
  %shared.addr = select i1 %is.shared, ptr addrspace(3) %asc.shared, ptr addrspace(3) null
  %result = icmp eq ptr addrspace(3) %shared.addr, null
  ret i1 %result
}
