; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -p loop-unroll -scev-cheap-expansion-budget=2 -S %s | FileCheck --check-prefix=BUDGET2 %s
; RUN: opt -p loop-unroll -scev-cheap-expansion-budget=3 -S %s | FileCheck --check-prefix=BUDGET3 %s

define i32 @test_expansion_cost_2(i32 %start, i32 %end) {
; BUDGET2-LABEL: define i32 @test_expansion_cost_2(
; BUDGET2-SAME: i32 [[START:%.*]], i32 [[END:%.*]]) {
; BUDGET2-NEXT:  [[ENTRY:.*]]:
; BUDGET2-NEXT:    [[SUB:%.*]] = add i32 [[END]], -1
; BUDGET2-NEXT:    br label %[[LOOP_HEADER:.*]]
; BUDGET2:       [[LOOP_HEADER]]:
; BUDGET2-NEXT:    [[IV:%.*]] = phi i32 [ [[START]], %[[ENTRY]] ], [ [[IV_NEXT:%.*]], %[[LOOP_LATCH:.*]] ]
; BUDGET2-NEXT:    [[C:%.*]] = icmp eq i32 [[IV]], [[SUB]]
; BUDGET2-NEXT:    br i1 [[C]], label %[[THEN:.*]], label %[[LOOP_LATCH]]
; BUDGET2:       [[THEN]]:
; BUDGET2-NEXT:    br label %[[LOOP_LATCH]]
; BUDGET2:       [[LOOP_LATCH]]:
; BUDGET2-NEXT:    [[IV_NEXT]] = add nsw i32 [[IV]], 1
; BUDGET2-NEXT:    [[EC:%.*]] = icmp eq i32 [[IV_NEXT]], [[END]]
; BUDGET2-NEXT:    br i1 [[EC]], label %[[EXIT:.*]], label %[[LOOP_HEADER]]
; BUDGET2:       [[EXIT]]:
; BUDGET2-NEXT:    ret i32 0
;
; BUDGET3-LABEL: define i32 @test_expansion_cost_2(
; BUDGET3-SAME: i32 [[START:%.*]], i32 [[END:%.*]]) {
; BUDGET3-NEXT:  [[ENTRY:.*]]:
; BUDGET3-NEXT:    [[SUB:%.*]] = add i32 [[END]], -1
; BUDGET3-NEXT:    [[TMP0:%.*]] = sub i32 [[SUB]], [[START]]
; BUDGET3-NEXT:    [[TMP1:%.*]] = icmp ne i32 [[TMP0]], 0
; BUDGET3-NEXT:    br i1 [[TMP1]], label %[[ENTRY_SPLIT:.*]], label %[[EXIT_PEEL_BEGIN:.*]]
; BUDGET3:       [[ENTRY_SPLIT]]:
; BUDGET3-NEXT:    br label %[[LOOP_HEADER:.*]]
; BUDGET3:       [[LOOP_HEADER]]:
; BUDGET3-NEXT:    [[IV:%.*]] = phi i32 [ [[START]], %[[ENTRY_SPLIT]] ], [ [[IV_NEXT:%.*]], %[[LOOP_LATCH:.*]] ]
; BUDGET3-NEXT:    [[C:%.*]] = icmp eq i32 [[IV]], [[SUB]]
; BUDGET3-NEXT:    br i1 [[C]], label %[[THEN:.*]], label %[[LOOP_LATCH]]
; BUDGET3:       [[THEN]]:
; BUDGET3-NEXT:    br label %[[LOOP_LATCH]]
; BUDGET3:       [[LOOP_LATCH]]:
; BUDGET3-NEXT:    [[IV_NEXT]] = add nsw i32 [[IV]], 1
; BUDGET3-NEXT:    [[TMP2:%.*]] = sub i32 [[END]], 1
; BUDGET3-NEXT:    [[EC:%.*]] = icmp eq i32 [[IV_NEXT]], [[TMP2]]
; BUDGET3-NEXT:    br i1 [[EC]], label %[[EXIT_PEEL_BEGIN_LOOPEXIT:.*]], label %[[LOOP_HEADER]], !llvm.loop [[LOOP0:![0-9]+]]
; BUDGET3:       [[EXIT_PEEL_BEGIN_LOOPEXIT]]:
; BUDGET3-NEXT:    [[DOTPH:%.*]] = phi i32 [ [[IV_NEXT]], %[[LOOP_LATCH]] ]
; BUDGET3-NEXT:    br label %[[EXIT_PEEL_BEGIN]]
; BUDGET3:       [[EXIT_PEEL_BEGIN]]:
; BUDGET3-NEXT:    [[TMP3:%.*]] = phi i32 [ [[START]], %[[ENTRY]] ], [ [[DOTPH]], %[[EXIT_PEEL_BEGIN_LOOPEXIT]] ]
; BUDGET3-NEXT:    br label %[[LOOP_HEADER_PEEL:.*]]
; BUDGET3:       [[LOOP_HEADER_PEEL]]:
; BUDGET3-NEXT:    [[C_PEEL:%.*]] = icmp eq i32 [[TMP3]], [[SUB]]
; BUDGET3-NEXT:    br i1 [[C_PEEL]], label %[[THEN_PEEL:.*]], label %[[LOOP_LATCH_PEEL:.*]]
; BUDGET3:       [[THEN_PEEL]]:
; BUDGET3-NEXT:    br label %[[LOOP_LATCH_PEEL]]
; BUDGET3:       [[LOOP_LATCH_PEEL]]:
; BUDGET3-NEXT:    [[IV_NEXT_PEEL:%.*]] = add nsw i32 [[TMP3]], 1
; BUDGET3-NEXT:    [[EC_PEEL:%.*]] = icmp eq i32 [[IV_NEXT_PEEL]], [[END]]
; BUDGET3-NEXT:    br i1 [[EC_PEEL]], label %[[EXIT_PEEL_NEXT:.*]], label %[[EXIT_PEEL_NEXT]]
; BUDGET3:       [[EXIT_PEEL_NEXT]]:
; BUDGET3-NEXT:    br label %[[LOOP_HEADER_PEEL_NEXT:.*]]
; BUDGET3:       [[LOOP_HEADER_PEEL_NEXT]]:
; BUDGET3-NEXT:    br label %[[EXIT:.*]]
; BUDGET3:       [[EXIT]]:
; BUDGET3-NEXT:    ret i32 0
;
entry:
  %sub = add i32 %end, -1
  br label %loop.header

loop.header:
  %iv = phi i32 [ %start, %entry ], [ %iv.next, %loop.latch ]
  %c = icmp eq i32 %iv, %sub
  br i1 %c, label %then, label %loop.latch

then:
  br label %loop.latch

loop.latch:
  %iv.next = add nsw i32 %iv, 1
  %ec = icmp eq i32 %iv.next, %end
  br i1 %ec, label %exit, label %loop.header

exit:
  ret i32 0
}
;.
; BUDGET3: [[LOOP0]] = distinct !{[[LOOP0]], [[META1:![0-9]+]]}
; BUDGET3: [[META1]] = !{!"llvm.loop.peeled.count", i32 1}
;.
